/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.create;

import com.gemstone.gemfire.LogWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.create.AbstractPartitionClause;
import sql.generic.ddl.create.DefaultPartitionClause;
import sql.generic.ddl.create.PartitionByColumnsClause;
import sql.generic.ddl.create.PartitionByExpressionClause;
import sql.generic.ddl.create.PartitionByFunctionClause;
import sql.generic.ddl.create.PartitionByListClause;
import sql.generic.ddl.create.PartitionByPrimaryKeyPartitionClause;
import sql.generic.ddl.create.PartitionByRangeClause;
import sql.generic.ddl.create.ReplicatedPartitionClause;
import util.TestException;

public class PartitionClauseGenerator {
    Random random;
    LogWriter log;

    public PartitionClauseGenerator(Random rand, LogWriter log) {
        this.random = rand;
        this.log = log;
    }

    public String getPartitionedClause(TableInfo table, String partitionMapping) {
        String[] strArray = partitionMapping.split(":");
        if (strArray.length <= 1) {
            this.processHardCodedPartitionClause(table, partitionMapping);
            return partitionMapping;
        }
        String tableName = strArray[0];
        String partition = strArray[1];
        if (partition.equalsIgnoreCase("random")) {
            return this.generateRandomPartitionClause(table);
        }
        if (partition.equalsIgnoreCase("replicate")) {
            return this.generateReplicatedPartitionClause(table);
        }
        try {
            int whichClause = Integer.parseInt(partition);
            return this.generatePartitionedClause(table, whichClause);
        }
        catch (NumberFormatException n) {
            throw new TestException("while parsing partion clause", (Throwable)n);
        }
    }

    private void processHardCodedPartitionClause(TableInfo table, String partitionMapping) {
        String part = partitionMapping.toUpperCase().trim();
        if (part.equalsIgnoreCase("")) {
            this.generatePartitionedClause(table, 0);
        } else if (part.contains("PRIMARY")) {
            List<ColumnInfo> pkCols = table.getPrimaryKey().getColumns();
            table.setPartitioningColumns(pkCols);
        } else if (!part.contains("REPLICATE")) {
            if (part.length() > 0) {
                this.log.info("rdrd" + part);
                int start = part.indexOf(40) + 1;
                int end = part.indexOf(")", start);
                String[] colStrs = part.substring(start, end).split(",");
                ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
                for (String c : colStrs) {
                    ColumnInfo col = table.getColumn(c.trim());
                    cols.add(col);
                }
                table.setPartitioningColumns(cols);
            } else {
                throw new TestException("Unknown DDL Extension");
            }
        }
        table.setPartitioningClause(partitionMapping);
        if (part.contains("COLOCATE")) {
            int idx = part.indexOf("COLOCATE");
            int start = part.indexOf("(", idx);
            int end = part.indexOf(")", idx);
            String parentTableName = part.substring(start, end);
            TableInfo parent = GenericBBHelper.getTableInfo(parentTableName);
            table.setColocatedParent(parent);
        }
    }

    public String generateRandomPartitionClause(TableInfo table) {
        return this.generatePartitionedClause(table, -1);
    }

    public String generateReplicatedPartitionClause(TableInfo table) {
        return this.generatePartitionedClause(table, AbstractPartitionClause.availablePartitionClause.length - 1);
    }

    protected String generatePartitionedClause(TableInfo table, int whichClause) {
        AbstractPartitionClause partitionClause = null;
        boolean clauseFound = false;
        block10: for (int k1 = 0; k1 < 10 && !clauseFound; ++k1) {
            int whichClauseIndex;
            if (whichClause == -1) {
                int r1 = SQLOldTest.withReplicatedTables ? 0 : 1;
                whichClauseIndex = this.random.nextInt(AbstractPartitionClause.availablePartitionClause.length - r1);
            } else {
                whichClauseIndex = whichClause;
            }
            this.log.info("Generating partition clause for " + table.getFullyQualifiedTableName() + ", whichClauseIndex=" + whichClauseIndex + ", retryCount=" + (k1 + 1));
            switch (whichClauseIndex) {
                case 0: {
                    partitionClause = new DefaultPartitionClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 1: {
                    partitionClause = new PartitionByPrimaryKeyPartitionClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 2: {
                    partitionClause = new PartitionByColumnsClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 3: {
                    partitionClause = new PartitionByListClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 4: {
                    partitionClause = new PartitionByRangeClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 5: {
                    partitionClause = new PartitionByFunctionClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 6: {
                    partitionClause = new PartitionByExpressionClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                case 7: {
                    partitionClause = new ReplicatedPartitionClause();
                    clauseFound = partitionClause.generatePartitionClause(table);
                    continue block10;
                }
                default: {
                    throw new TestException("Unknown partition Clause Index " + whichClauseIndex);
                }
            }
        }
        table.setPartitioningColumns(partitionClause.getPartitionColumns());
        table.setPartitioningClause(partitionClause.getParitionClause());
        return partitionClause.getParitionClause();
    }
}

