/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.procedures;

import hydra.Log;
import java.sql.ResultSet;
import sql.SQLHelper;
import sql.generic.SQLOldTest;
import sql.generic.ddl.procedures.GeneralProcedure;
import sql.generic.ddl.procedures.ProcedureExceptionHandler;
import sql.sqlutil.ResultSetHelper;

public abstract class DAProcedureTest
extends GeneralProcedure {
    protected int maxNumOfTries = 2;
    public String gfxdProcName;

    protected abstract boolean procCalledWithSG();

    @Override
    public void doDDLOp() {
        if (this.dConn != null && SQLOldTest.allowConcDDLDMLOps && !this.doOp()) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + this.gfxdProcName + ", abort this operation");
            return;
        }
        this.createDropProc();
    }

    @Override
    public void callProcedure() {
        if (!testServerGroupsInheritence && this.procCalledWithSG()) {
            return;
        }
        if (this.dConn != null) {
            if (SQLOldTest.allowConcDDLDMLOps && !this.doOp()) {
                Log.getLogWriter().info("Other threads are performing op on the procedure " + this.getProcName() + ", abort this operation");
                return;
            }
            this.exceptionHandler = new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.EXECUTE, false);
            this.callProcedureOnBothDB();
            if (SQLOldTest.allowConcDDLDMLOps) {
                this.zeroCounter();
            }
        } else {
            this.exceptionHandler = new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.EXECUTE, true);
            this.callProcedureGfxdOnly();
        }
    }

    protected void callProcedureOnBothDB() {
        Object[] inOut = new Object[5];
        boolean[] success = new boolean[1];
        ResultSet[] derbyRS = this.callDerbyProcedure(inOut, success);
        if (derbyRS == null && this.exceptionHandler.getExList().size() == 0) {
            return;
        }
        boolean[] successForHA = new boolean[1];
        Object[] gfxd = new Object[5];
        ResultSet[] gfxdRS = this.callGFEProcedure(gfxd, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            gfxdRS = this.callGFEProcedure(inOut, successForHA);
        }
        SQLHelper.handleMissedSQLException(this.exceptionHandler.getExList());
        if (gfxdRS == null && SQLOldTest.allowConcDDLDMLOps) {
            return;
        }
        this.compareResultSets(derbyRS, gfxdRS);
        this.verifyInOutParameters(inOut, gfxd);
    }

    protected void callProcedureGfxdOnly() {
        boolean[] successForHA = new boolean[1];
        Object[] gfxd = new Object[5];
        ResultSet[] gfxdRS = this.callGFEProcedure(gfxd, successForHA);
        while (!successForHA[0]) {
            Log.getLogWriter().info("failed to get result set from gfxd");
            this.callProcedureGfxdOnly();
        }
        if (gfxdRS == null && SQLOldTest.allowConcDDLDMLOps) {
            return;
        }
        ResultSetHelper.asList(gfxdRS[0], false);
    }
}

