/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.procedures;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.generic.SQLGenericBB;
import sql.generic.SQLOldTest;
import sql.generic.ddl.Executor;
import sql.generic.ddl.create.DDLStmtIF;
import sql.generic.ddl.procedures.ProcedureExceptionHandler;
import sql.generic.dmlstatements.GenericDMLHelper;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public abstract class GeneralProcedure
implements DDLStmtIF {
    Executor executor;
    Connection dConn;
    Connection gConn;
    public static boolean testServerGroupsInheritence = TestConfig.tab().booleanAt(SQLPrms.testServerGroupsInheritence, false);
    ProcedureExceptionHandler exceptionHandler;
    protected int loc = 0;
    protected int maxNumOfTries = 1;
    protected int resultSetCount;
    protected static boolean dropProc = SQLOldTest.dropProc;
    protected String ddlStmt = null;
    protected String derbyStmt = null;
    protected String derbyProcName = null;
    protected String procName = null;

    protected abstract String getProcName();

    protected abstract String getDerbyProcName();

    protected abstract String getDdlStmt();

    protected abstract String getDerbyDdlStmt();

    protected abstract CallableStatement getCallableStatement(Connection var1) throws SQLException;

    protected abstract CallableStatement getDerbyCallableStatement(Connection var1) throws SQLException;

    protected abstract int getOutputResultSetCount();

    protected abstract ResultSet[] getOutputValues(CallableStatement var1, Object[] var2) throws SQLException;

    protected abstract void verifyInOutParameters(Object[] var1, Object[] var2);

    protected abstract void populateCalledFunctionInfoInBB();

    public abstract void callProcedure();

    public void setExecutor(Executor executor, int loc) {
        this.executor = executor;
        this.dConn = executor.getDConn();
        this.gConn = executor.getGConn();
        this.loc = loc;
        this.ddlStmt = this.getDdlStmt();
        this.derbyStmt = this.getDerbyDdlStmt();
        this.derbyProcName = this.getDerbyProcName();
        this.procName = this.getProcName();
        this.populateCalledFunctionInfoInBB();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.dConn = executor.getDConn();
        this.gConn = executor.getGConn();
        this.ddlStmt = this.getDdlStmt();
        this.derbyStmt = this.getDerbyDdlStmt();
        this.derbyProcName = this.getDerbyProcName();
        this.procName = this.getProcName();
        this.populateCalledFunctionInfoInBB();
        Map procMap = (Map)SQLGenericBB.getBB().getSharedMap().get((Object)"FuncProcMap");
        if (procMap == null) {
            SQLGenericBB.getBB().getSharedMap().put((Object)"FuncProcMap", new HashMap());
        }
    }

    @Override
    public void createDDL() {
        this.createProcedures();
    }

    public void createProcedures() {
        SQLGenericBB.getBB().getSharedMap().put((Object)this.procName.toUpperCase(), (Object)this.loc);
        this.executor.executeOnBothDb(this.derbyStmt, this.ddlStmt, new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, false));
    }

    protected boolean doOp() {
        int doOp = this.getCounter();
        int count = 0;
        while (doOp != 1) {
            if (count > this.maxNumOfTries) {
                return false;
            }
            ++count;
            MasterController.sleepForMs((int)(100 * SQLOldTest.random.nextInt(30)));
            doOp = this.getCounter();
        }
        return true;
    }

    protected int getCounter() {
        int counter = (int)SQLGenericBB.getBB().getSharedCounters().incrementAndRead(SQLGenericBB.procedureCounter[this.loc]);
        return counter;
    }

    protected void zeroCounter() {
        SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.procedureCounter[this.loc]);
    }

    private void execute(String derbyStmt, String gemxdStmt) {
        if (this.dConn != null) {
            if (this.executor.executeOnBothDb(derbyStmt, gemxdStmt, new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, false)) == Executor.ExceptionAt.DERBY) {
                this.zeroCounter();
            } else {
                this.executor.executeOnGfxdOnly(gemxdStmt, new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.CREATE, false));
            }
        }
    }

    protected void createDropProc() {
        int choice = 3;
        int op = SQLOldTest.random.nextInt(choice);
        if ((op == 0 || op == 1) && dropProc) {
            String dropStmt = "drop procedure " + this.getProcName();
            this.execute(dropStmt, dropStmt);
        }
        if (op == 1 || op == 2) {
            this.execute(this.derbyStmt, this.ddlStmt);
        }
        if (this.dConn != null) {
            this.zeroCounter();
        }
    }

    protected boolean compareResultSets(ResultSet[] derbyRS, ResultSet[] gfeRS) {
        boolean success = true;
        if (derbyRS.length != gfeRS.length) {
            throw new TestException("got different number of resultSets: there are" + derbyRS.length + "result sets from derby and " + gfeRS.length + "result sets from gfe");
        }
        for (int i = 0; i < derbyRS.length; ++i) {
            success = this.compareResultSets(derbyRS[i], gfeRS[i]);
            if (success) continue;
            return success;
        }
        return success;
    }

    protected boolean compareResultSets(ResultSet derbyRS, ResultSet gfeRS) {
        try {
            if (derbyRS != null) {
                Log.getLogWriter().info("taking metadata of derby " + derbyRS.getMetaData());
            }
            if (gfeRS != null) {
                Log.getLogWriter().info("taking metadata of gemxd  " + gfeRS.getMetaData());
            }
        }
        catch (SQLException se) {
            Log.getLogWriter().info("error while reading metadata");
        }
        return ResultSetHelper.compareResultSets(derbyRS, gfeRS);
    }

    protected void processRS(ResultSet[] rs) {
        for (int i = 0; i < rs.length; ++i) {
            List<Struct> list = ResultSetHelper.asList(rs[i], false);
            if (!(list == null & SQLOldTest.isHATest)) continue;
            return;
        }
    }

    protected ResultSet[] callDerbyProcedure(Object[] inOut, boolean[] success) {
        success[0] = true;
        try {
            return this.callProcedure(this.dConn, inOut);
        }
        catch (SQLException se) {
            if (!this.exceptionHandler.handleDerbyException(this.dConn, se)) {
                success[0] = false;
                return null;
            }
            return null;
        }
    }

    protected ResultSet[] callGFEProcedure(Object[] inOut, boolean[] success) {
        success[0] = true;
        try {
            return this.callProcedure(this.gConn, inOut);
        }
        catch (SQLException se) {
            success[0] = this.exceptionHandler.handleGfxdExceptionOnly(se);
            return null;
        }
    }

    protected ResultSet[] callProcedure(Connection conn, Object[] inOut) throws SQLException {
        ResultSet[] rs = new ResultSet[this.getOutputResultSetCount()];
        CallableStatement cs = null;
        cs = GenericDMLHelper.isDerby(conn) ? this.getDerbyCallableStatement(conn) : this.getCallableStatement(conn);
        cs.execute();
        rs = this.getOutputValues(cs, inOut);
        SQLWarning warning = cs.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rs;
    }

    protected ResultSet[] getOutputResultset(CallableStatement cs, int resultSetCount) throws SQLException {
        ResultSet[] rs = new ResultSet[resultSetCount];
        if (resultSetCount == 0) {
            return null;
        }
        if (resultSetCount > 0) {
            rs[0] = cs.getResultSet();
            int i = 1;
            while (cs.getMoreResults(2)) {
                Log.getLogWriter().info("has more results");
                rs[i] = cs.getResultSet();
                ++i;
            }
        }
        return rs;
    }
}

