/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.procedures;

import hydra.Log;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import sql.SQLHelper;
import sql.SQLTest;
import sql.generic.ddl.GenericExceptionHandler;

public class ProcedureExceptionHandler
implements GenericExceptionHandler {
    ArrayList<SQLException> exList = new ArrayList();
    Action action;
    boolean concurrent;

    public ArrayList<SQLException> getExList() {
        return this.exList;
    }

    public ProcedureExceptionHandler(Action action, boolean concurrent) {
        this.action = action;
        this.concurrent = concurrent;
    }

    @Override
    public boolean handleDerbyException(Connection derby, SQLException se) {
        if (!SQLHelper.checkDerbyException(derby, se)) {
            return false;
        }
        SQLHelper.handleDerbySQLException(se, this.exList);
        return true;
    }

    @Override
    public void afterDerbyExecution() {
    }

    @Override
    public void afterGemxdExecution() {
    }

    @Override
    public boolean handleGfxdException(SQLException se) {
        SQLHelper.handleGFGFXDException(se, this.exList);
        return true;
    }

    @Override
    public boolean handleGfxdExceptionOnly(SQLException se) {
        if (this.action == Action.CREATE) {
            return this.handleGfxdExceptionCreateOnly(se);
        }
        if (this.concurrent) {
            return this.handleGfxdExceptionExecuteConcurrentOnly(se);
        }
        return this.handleGfxdExceptionExecuteOnly(se);
    }

    public boolean handleGfxdExceptionCreateOnly(SQLException se) {
        if (se.getSQLState().equals("42Y55") || se.getSQLState().equals("42X94")) {
            Log.getLogWriter().info("expected procedrue does not exist exception, continuing test");
        } else if (se.getSQLState().equals("X0Y68")) {
            Log.getLogWriter().info("expected procedrue already exist exception, continuing test");
        } else if (se.getSQLState().equals("42507") && SQLTest.testSecurity) {
            Log.getLogWriter().info("expected authorization exception, continuing test");
        } else {
            SQLHelper.handleSQLException(se);
        }
        return true;
    }

    private boolean handleGfxdExceptionExecuteConcurrentOnly(SQLException se) {
        if (se.getSQLState().equals("42Y03")) {
            Log.getLogWriter().info("got expected exception, continuing test");
            return false;
        }
        if (se.getSQLState().equals("38000")) {
            Log.getLogWriter().info("got expected exception, continuing test");
            return false;
        }
        if (se.getSQLState().equals("X0Z01") && SQLTest.isHATest) {
            Log.getLogWriter().info("got expected exception, continuing test");
            return false;
        }
        if (se.getSQLState().equals("42504") && SQLTest.testSecurity) {
            Log.getLogWriter().info("expected authorization exception, continuing test");
            return false;
        }
        if (se.getSQLState().equals("X0Z02") && SQLTest.hasTx) {
            Log.getLogWriter().info("expected conflict exception, continuing test");
            return false;
        }
        SQLHelper.handleSQLException(se);
        return true;
    }

    private boolean handleGfxdExceptionExecuteOnly(SQLException se) {
        if (se.getSQLState().equals("X0Z01")) {
            return false;
        }
        SQLHelper.handleGFGFXDException(se, this.exList);
        return true;
    }

    @Override
    public boolean handleGfxdWarningsOnly(SQLWarning warnings) {
        return true;
    }

    public static enum Action {
        CREATE,
        EXECUTE;

    }
}

