/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.procedures;

import hydra.Log;
import hydra.RemoteTestModule;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sql.SQLHelper;
import sql.generic.SQLGenericBB;
import sql.generic.SQLOldTest;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.Executor;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.procedures.GeneralProcedure;
import sql.generic.ddl.procedures.ProcedureExceptionHandler;

public abstract class ProcedureTest
extends GeneralProcedure {
    private long lastDDLOpTime = 0L;
    private int waitPeriod = 3;
    private String lastProcOpTime = "lastProcOpTime";
    boolean modifyPartitionKey = false;

    @Override
    protected abstract int getOutputResultSetCount();

    protected abstract HashMap<TableInfo, ColumnInfo> getModifiedColumns();

    @Override
    public void setExecutor(Executor executor, int loc) {
        this.executor = executor;
        this.dConn = executor.getDConn();
        this.gConn = executor.getGConn();
        this.loc = loc;
        this.modifyPartitionKey = this.modifyPartitionKey();
        this.procName = this.getProcName();
        this.ddlStmt = this.getDdlStmt();
        this.derbyStmt = this.getDerbyDdlStmt();
        this.populateCalledFunctionInfoInBB();
    }

    private boolean modifiesData() {
        return this.ddlStmt.toLowerCase().contains(" modifies ");
    }

    @Override
    protected int getCounter() {
        if (!dropProc) {
            return 1;
        }
        int counter = (int)SQLGenericBB.getBB().getSharedCounters().incrementAndRead(SQLGenericBB.procedureCounter[this.loc]);
        return counter;
    }

    @Override
    public void doDDLOp() {
        if (!this.executeCreateProcedure()) {
            return;
        }
        this.createDropProc();
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK") && SQLOldTest.limitConcDDLOps) {
            long now = System.currentTimeMillis();
            SQLGenericBB.getBB().getSharedMap().put((Object)this.lastProcOpTime, (Object)now);
            this.lastDDLOpTime = now;
            SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.perfLimitedProcDDL);
        }
    }

    @Override
    protected String getDerbyDdlStmt() {
        return this.getDdlStmt();
    }

    @Override
    protected CallableStatement getDerbyCallableStatement(Connection conn) throws SQLException {
        return this.getCallableStatement(conn);
    }

    @Override
    public void callProcedure() {
        boolean[] success = new boolean[1];
        Object[] inOut = new Object[2];
        if (this.modifyPartitionKey || SQLOldTest.isHATest && this.modifiesData()) {
            return;
        }
        if (this.dConn != null) {
            this.exceptionHandler = new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.EXECUTE, false);
            if (this.modifiesData()) {
                this.callModifyProcedures(inOut);
            } else {
                this.callNonModifyProcedures(inOut);
            }
        } else {
            this.exceptionHandler = new ProcedureExceptionHandler(ProcedureExceptionHandler.Action.EXECUTE, true);
            ResultSet[] rs = this.callGFEProcedure(inOut, success);
            if (success[0]) {
                this.processRS(rs);
            }
        }
    }

    protected void callModifyProcedures(Object[] inOut) {
        if (this.dConn != null && !this.doOp()) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + this.procName + ", abort this operation");
            return;
        }
        int count = 0;
        boolean[] success = new boolean[1];
        this.callDerbyProcedure(inOut, success);
        while (!success[0]) {
            if (count >= this.maxNumOfTries) {
                Log.getLogWriter().info("could not call the derby procedure due to issues, abort this operation");
                this.zeroCounter();
                return;
            }
            this.exceptionHandler.getExList().clear();
            ++count;
            this.callDerbyProcedure(inOut, success);
        }
        boolean[] successForHA = new boolean[1];
        Object[] gfxd = new Object[2];
        this.callGFEProcedure(gfxd, successForHA);
        while (!successForHA[0]) {
            this.callGFEProcedure(inOut, successForHA);
        }
        SQLHelper.handleMissedSQLException(this.exceptionHandler.getExList());
        this.verifyInOutParameters(inOut, gfxd);
        if (this.dConn != null) {
            this.zeroCounter();
        }
    }

    protected void callNonModifyProcedures(Object[] inOut) {
        if (this.dConn != null && !this.doOp()) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + this.procName + ", abort this operation");
            return;
        }
        Log.getLogWriter().info("Lock is acquired on " + this.procName + " by Thread :" + SqlUtilityHelper.tid());
        Object[] gfxdInOut = new Object[2];
        boolean[] success = new boolean[1];
        Log.getLogWriter().info("calling derby proc");
        ResultSet[] derbyRS = this.callDerbyProcedure(inOut, success);
        if (derbyRS == null && this.exceptionHandler.exList.size() == 0) {
            this.zeroCounter();
            return;
        }
        Log.getLogWriter().info("calling gfxd proc");
        ResultSet[] gfeRS = this.callGFEProcedure(gfxdInOut, success);
        while (!success[0]) {
            gfeRS = this.callGFEProcedure(gfxdInOut, success);
        }
        SQLHelper.handleMissedSQLException(this.exceptionHandler.exList);
        if (derbyRS == null) {
            this.zeroCounter();
            return;
        }
        this.compareResultSets(derbyRS, gfeRS);
        this.verifyInOutParameters(inOut, gfxdInOut);
        if (this.dConn != null) {
            this.zeroCounter();
        }
    }

    private boolean executeCreateProcedure() {
        if (!RemoteTestModule.getCurrentThread().getCurrentTask().getTaskTypeString().equalsIgnoreCase("INITTASK")) {
            if (!SQLOldTest.allowConcDDLDMLOps) {
                Log.getLogWriter().info("This test does not run with concurrent ddl with dml ops, abort the op");
                return false;
            }
            if (SQLOldTest.limitConcDDLOps) {
                if (!this.perfDDLOp()) {
                    Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl right now, abort the op");
                    return false;
                }
                Long lastUpdateTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastProcOpTime);
                if (lastUpdateTime != null) {
                    long now = System.currentTimeMillis();
                    this.lastDDLOpTime = lastUpdateTime;
                    if (now - this.lastDDLOpTime < (long)(this.waitPeriod * 60 * 1000)) {
                        SQLGenericBB.getBB().getSharedCounters().zero(SQLGenericBB.perfLimitedProcDDL);
                        Log.getLogWriter().info("Does not meet criteria to perform concurrent ddl abort");
                        return false;
                    }
                }
            }
            Log.getLogWriter().info("performing conuccrent procedure op in main task");
        }
        if (this.dConn != null && !this.doOp()) {
            Log.getLogWriter().info("Other threads are performing op on the procedure " + this.procName + ", abort this operation");
            return false;
        }
        return true;
    }

    private boolean perfDDLOp() {
        long now;
        if (this.lastDDLOpTime == 0L) {
            Long lastUpdateTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastProcOpTime);
            if (lastUpdateTime == null) {
                return this.checkBBForDDLOp();
            }
            this.lastDDLOpTime = lastUpdateTime;
        }
        if ((now = System.currentTimeMillis()) - this.lastDDLOpTime < (long)(this.waitPeriod * 60 * 1000)) {
            return false;
        }
        this.lastDDLOpTime = (Long)SQLGenericBB.getBB().getSharedMap().get((Object)this.lastProcOpTime);
        if (now - this.lastDDLOpTime < (long)(this.waitPeriod * 60 * 1000)) {
            return false;
        }
        return this.checkBBForDDLOp();
    }

    private boolean checkBBForDDLOp() {
        int perfLimitedConcDDL = (int)SQLGenericBB.getBB().getSharedCounters().incrementAndRead(SQLGenericBB.perfLimitedProcDDL);
        return perfLimitedConcDDL == 1;
    }

    public boolean modifyPartitionKey() {
        HashMap<TableInfo, ColumnInfo> columns = this.getModifiedColumns();
        if (columns == null) {
            return false;
        }
        Iterator<Map.Entry<TableInfo, ColumnInfo>> i$ = columns.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<TableInfo, ColumnInfo> row = i$.next();
            TableInfo table = row.getKey();
            ColumnInfo column = row.getValue();
            return table.getPartitioningColumns().contains(column);
        }
        return false;
    }

    @Override
    protected String getDerbyProcName() {
        return this.procName;
    }
}

