/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.ddl.procedures;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.TableInfo;
import sql.generic.ddl.procedures.ProcedureTest;
import util.TestException;

public class TestInOutParamsProcedure
extends ProcedureTest {
    @Override
    protected CallableStatement getCallableStatement(Connection conn) throws SQLException {
        CallableStatement cs = conn.prepareCall("{call " + this.procName + " (?, ?, ?)}");
        cs.registerOutParameter(2, 3);
        cs.registerOutParameter(3, 4);
        cs.setInt(1, SqlUtilityHelper.tid());
        cs.setInt(3, SqlUtilityHelper.tid());
        return cs;
    }

    @Override
    protected String getDdlStmt() {
        return "create procedure trade.testInOutParam(DP1 Integer, OUT DP2 DECIMAL (30, 20), INOUT DP3 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME 'sql.generic.ddl.procedures.ProcedureBody.testInOutParam'";
    }

    @Override
    protected int getOutputResultSetCount() {
        return 2;
    }

    @Override
    protected ResultSet[] getOutputValues(CallableStatement cs, Object[] inOut) throws SQLException {
        ResultSet[] rs = this.getOutputResultset(cs, this.getOutputResultSetCount());
        inOut[0] = cs.getBigDecimal(2);
        inOut[1] = new Integer(cs.getInt(3));
        return rs;
    }

    @Override
    protected String getProcName() {
        return "trade.testInOutParam";
    }

    @Override
    protected void verifyInOutParameters(Object[] inOut, Object[] gfxdInOut) {
        if (gfxdInOut[0] == null && inOut[0] == null) {
            Log.getLogWriter().info("No max cash found, possible no data inserted by this thread or data deleted");
        } else if (gfxdInOut[0] != null && inOut[0] != null) {
            if (!gfxdInOut[0].getClass().equals(BigDecimal.class)) {
                throw new TestException("supposed to get BigDecimal but got " + gfxdInOut[0].getClass());
            }
            if (((BigDecimal)inOut[0]).subtract((BigDecimal)gfxdInOut[0]).longValue() != 0L) {
                throw new TestException("Got different out parameter value, derby is " + ((BigDecimal)inOut[0]).longValue() + " gfxd is " + ((BigDecimal)gfxdInOut[0]).longValue());
            }
            Log.getLogWriter().info("maxCash is " + ((BigDecimal)inOut[0]).longValue());
        } else {
            throw new TestException("Only one outparam has data, derby maxCash is " + inOut[0] + "gemfirexd maxCash is " + gfxdInOut[0]);
        }
        if (!gfxdInOut[1].getClass().equals(Integer.class)) {
            throw new TestException("supposed to get Integer but got " + gfxdInOut[1].getClass());
        }
        if (((Integer)inOut[1]).intValue() != ((Integer)gfxdInOut[1]).intValue()) {
            throw new TestException("Got different out parameter value, derby is " + (Integer)inOut[1] + " gfxd is " + (Integer)gfxdInOut[1]);
        }
    }

    @Override
    protected HashMap<TableInfo, ColumnInfo> getModifiedColumns() {
        return null;
    }

    @Override
    protected void populateCalledFunctionInfoInBB() {
    }
}

