/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sql.datagen.DataGeneratorHelper;
import sql.generic.SqlUtilityHelper;
import sql.generic.dmlstatements.DBRow;
import sql.generic.dmlstatements.DMLExecutor;
import sql.generic.dmlstatements.DMLOperation;
import sql.generic.dmlstatements.DMLPreparedStatement;
import sql.generic.dmlstatements.GenerateColumnValueOnExpression;
import sql.generic.dmlstatements.GenericDMLHelper;
import sql.generic.dmlstatements.Operation;
import sql.generic.dmlstatements.PrepareStatementSetter;
import util.TestException;
import util.TestHelper;

public abstract class AbstractDMLOperation
implements DMLOperation {
    public static final String DML_COLUMN_PATTERN = "::[a-zA-Z0-9_. \\[\\](<>)$]*::";
    protected String statement;
    private String preparedStmt;
    private DMLPreparedStatement dmlPreparedStatement = new DMLPreparedStatement();
    protected DMLExecutor executor;
    private DBRow preparedColumnMap;
    Map<String, DBRow> dataPopulatedForTheTable;
    public List<String> columnConsumedInStmt;
    public boolean performOperation = false;
    public boolean executable = true;
    public String preparedStmtForLogging = "";
    protected String tableName = "";
    private boolean executeOperation = true;
    Operation operation;

    public AbstractDMLOperation(DMLExecutor executor, String statement, Operation operation) {
        Log.getLogWriter().info("Parsing [" + statement + "]");
        this.statement = statement;
        this.executor = executor;
        this.operation = operation;
        this.preparedStmt = statement;
        this.fetchDataInMapFromDB();
        if (this.executable) {
            this.generateData(SqlUtilityHelper.getMatchedPattern(this.getStatement(), DML_COLUMN_PATTERN));
            this.preparedColumnMap = new DBRow();
            this.dataPopulatedForTheTable = new HashMap<String, DBRow>();
            this.columnConsumedInStmt = new ArrayList<String>();
        }
    }

    public AbstractDMLOperation(DMLExecutor executor, String statement, DBRow preparedColumnMap, Map<String, DBRow> dataPopulatedForTheTable, Operation operation) {
        Log.getLogWriter().info("Parsing [" + statement + "]");
        this.statement = statement;
        this.executor = executor;
        this.preparedStmt = statement;
        this.preparedColumnMap = preparedColumnMap;
        this.columnConsumedInStmt = new ArrayList<String>();
        this.dataPopulatedForTheTable = dataPopulatedForTheTable;
        this.fetchDataInMapFromDB();
        if (this.executable) {
            this.generateData(SqlUtilityHelper.getMatchedPattern(this.getStatement(), DML_COLUMN_PATTERN));
        }
        this.operation = operation;
        this.setTableNameFromStatement();
    }

    public void fetchDataInMapFromDB() {
        List<String> columnList = SqlUtilityHelper.getMatchedPattern(this.statement, DML_COLUMN_PATTERN);
        Object dbrow = null;
        String tableName = " ";
        for (String column : columnList) {
            tableName = SqlUtilityHelper.getTableName(column);
            if (this.dataPopulatedForTheTable.containsKey(tableName)) continue;
            try {
                DBRow dataMap = this.executor.getRandomRowForDml(tableName);
                if (dataMap != null) {
                    this.dataPopulatedForTheTable.put(tableName, dataMap);
                    continue;
                }
                this.executable = false;
            }
            catch (Exception e) {
                throw new TestException("Exception occurred as not able to get Random Row For DML For tablename : " + tableName + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    public abstract void generateData(List<String> var1);

    @Override
    public String getStatement() {
        return this.statement.toLowerCase();
    }

    public String getPreparedStmt() {
        return this.preparedStmt;
    }

    @Override
    public DMLPreparedStatement getDMLPreparedStatement() {
        return this.dmlPreparedStatement;
    }

    public List<String> getColumnList() {
        return SqlUtilityHelper.getMatchedPattern(this.getStatement(), DML_COLUMN_PATTERN);
    }

    @Override
    public void createPrepareStatement(Connection conn) throws SQLException {
        this.generateActualPrepareStatement();
        if (GenericDMLHelper.isDerby(conn) && this.operation == Operation.PUT) {
            this.preparedStmt = this.preparedStmt.replace("PUT", "INSERT");
        }
        Log.getLogWriter().info((GenericDMLHelper.isDerby(conn) ? "Derby - " : "Gemxd - ") + "Creating prepare Statement " + this.preparedStmt);
        this.preparedStmtForLogging = this.preparedStmt;
        PreparedStatement stmt = conn.prepareStatement(this.getPreparedStmt());
        Log.getLogWriter().info((GenericDMLHelper.isDerby(conn) ? "Derby - " : "Gemxd - ") + "Created prepare Statement " + this.preparedStmt);
        this.preparedStmtForLogging = " ";
        boolean i = true;
        PrepareStatementSetter ps = new PrepareStatementSetter(stmt);
        for (String columnName : this.getColumnList()) {
            DBRow.Column column = this.preparedColumnMap.find(columnName);
            if (column.getValue() instanceof List) {
                this.setListValuesInPrepareStatement(ps, column, (List)column.getValue());
                continue;
            }
            this.preparedStmtForLogging = this.preparedStmtForLogging + " " + SqlUtilityHelper.getColumnName(column.getName(), false).toUpperCase() + ":" + column.getValue() + ",";
            ps.setValues(column.getValue(), column.getType());
        }
        this.preparedStmtForLogging = this.preparedStmtForLogging + "  [ " + this.preparedStmt.substring(0, this.preparedStmt.length()) + " ]";
        this.setPreparedStmt(conn, stmt);
    }

    @Override
    public String getPreparedStmtForLogging() {
        return this.preparedStmtForLogging;
    }

    private void setPreparedStmt(Connection conn, PreparedStatement stmt) {
        try {
            if (conn.getMetaData().getDriverName().toLowerCase().contains("derby")) {
                this.dmlPreparedStatement.setDerbyPreparedStmt(stmt);
                return;
            }
            this.dmlPreparedStatement.setGemXDPreparedStmt(stmt);
        }
        catch (SQLException se) {
            throw new TestException("unable to set prepare statement in database " + se.getSQLState() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public DMLPreparedStatement getPreparedStmt(Connection conn) {
        return this.getDMLPreparedStatement();
    }

    protected void setListValuesInPrepareStatement(PrepareStatementSetter stmt, DBRow.Column column, List<DBRow> values) {
        for (DBRow row : values) {
            this.preparedStmtForLogging = this.preparedStmtForLogging + " " + SqlUtilityHelper.getColumnName(column.getName(), false).toUpperCase() + ":" + row.find(SqlUtilityHelper.getColumnName(column.getName(), true)).getValue() + ",";
            stmt.setValues(row.find(SqlUtilityHelper.getColumnName(column.getName(), true)).getValue(), column.getType());
        }
    }

    public void getColumnValuesFromDataBase(List<String> columnList) {
        for (String column : columnList) {
            DBRow dbRow = this.dataPopulatedForTheTable.get(SqlUtilityHelper.getTableName(column));
            DBRow.Column dbColumn = dbRow.find(SqlUtilityHelper.getColumnName(column, true));
            if (this.preparedColumnMap.find(column) == null && dbRow.find(column) == null) {
                GenerateColumnValueOnExpression columnValue = new GenerateColumnValueOnExpression(dbRow, this.executor, this.getPreparedStmt());
                this.preparedColumnMap.addColumn(column, dbColumn.getType(), columnValue.getColumnValue(column));
                this.preparedStmt = columnValue.getModifiedPrepareStatement();
                continue;
            }
            this.preparedColumnMap.addColumn(column, dbColumn.getType(), dbColumn.getValue());
        }
    }

    public void getRowFromDataGeneratorAndLoadColumnValues(List<String> columnList) {
        String tableName = SqlUtilityHelper.getTableName(columnList.get(0));
        Map<String, Object> columnValuesfromDataGenerator = DataGeneratorHelper.getNewRow(tableName);
        for (String column : columnList) {
            DBRow dbRow = this.dataPopulatedForTheTable.get(SqlUtilityHelper.getTableName(column));
            DBRow.Column dbColumn = dbRow.find(column);
            if (this.preparedColumnMap.find(column.toLowerCase()) != null) continue;
            this.preparedColumnMap.addColumn(column, dbColumn.getType(), column.equals(tableName + ".tid") ? Integer.valueOf(GenericDMLHelper.getMyTid()) : columnValuesfromDataGenerator.get(dbColumn.getShortName().toUpperCase()));
        }
    }

    @Override
    public void execute() {
        if (this.executeOperation) {
            this.executor.executeStatement(this);
            this.executor.commitAll();
        }
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        return this.statement;
    }

    @Override
    public void generateActualPrepareStatement() {
        this.preparedStmt = this.preparedStmt.replaceAll(DML_COLUMN_PATTERN, "?");
    }

    @Override
    public boolean getExecutable() {
        return this.executable;
    }

    abstract void setTableNameFromStatement();

    @Override
    public String getTableNameForOperation() {
        return this.tableName;
    }
}

