/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import sql.generic.SqlUtilityHelper;

public class DBRow {
    private List<Column> columns = new LinkedList<Column>();
    private Map<String, Column> columnMap = new HashMap<String, Column>();
    String tableName;

    public DBRow(String tableName) {
        this.tableName = tableName + ".";
    }

    public DBRow() {
        this.tableName = "";
    }

    public void addColumn(String name, int type, Object value) {
        if (!name.contains(this.tableName)) {
            name = this.tableName + name;
        }
        Column column = new Column(name, type, value);
        this.columns.add(column);
        this.columnMap.put(name, column);
    }

    public Collection<Column> getColumns() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public Column find(String column) {
        if (!column.contains(this.tableName)) {
            column = this.tableName + column;
        }
        return this.columnMap.get(column);
    }

    public static class Column {
        private String name;
        private String shortName;
        private int type;
        private Object value;
        private int specialType;

        public Column(String name, int type, Object value) {
            this.name = name;
            if (name != null) {
                this.shortName = SqlUtilityHelper.getColumnName(name, false);
            }
            this.type = type;
            this.value = value;
        }

        public Column(String name, int type, Object value, int specialType) {
            this.name = name;
            if (name != null) {
                this.shortName = SqlUtilityHelper.getColumnName(name, false);
            }
            this.type = type;
            this.value = value;
            this.specialType = specialType;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public Object getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }

        public int getSpecialType() {
            return this.specialType;
        }
    }
}

