/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import sql.generic.dmlstatements.DMLOperation;
import sql.generic.dmlstatements.GenericDMLHelper;

public class DMLOperationWrapper {
    private DMLOperation operation;
    private Connection conn;
    public static final int MSG_START = 0;
    public static final int MSG_END = 1;

    public DMLOperationWrapper(DMLOperation operation, Connection conn) {
        this.operation = operation;
        this.conn = conn;
    }

    public PreparedStatement getPreparedStatement() throws SQLException {
        this.operation.createPrepareStatement(this.conn);
        if (this.isDerby()) {
            return this.operation.getDMLPreparedStatement().getDerbyPreparedStmt();
        }
        return this.operation.getDMLPreparedStatement().getGemXDPreparedStmt();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public DMLOperation getOperation() {
        return this.operation;
    }

    public void executionMsg(int message) {
        String database = this.isDerby() ? "Derby - " : "Gemxd - ";
        switch (message) {
            case 0: {
                Log.getLogWriter().info(database + "Started execution of " + this.operation.getOperation().getValue() + this.operation.getPreparedStmtForLogging());
                break;
            }
            case 1: {
                Log.getLogWriter().info(database + "completed execution of " + this.operation.getOperation().getValue() + this.operation.getPreparedStmtForLogging());
            }
        }
    }

    public boolean isDerby() {
        return GenericDMLHelper.isDerby(this.conn);
    }
}

