/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import java.util.List;
import sql.generic.SqlUtilityHelper;
import sql.generic.dmlstatements.DBRow;
import sql.generic.dmlstatements.DMLExecutor;
import sql.generic.dmlstatements.GenerateInExpression;
import sql.generic.dmlstatements.GenerateLikeExpression;
import sql.generic.dmlstatements.GenericDMLHelper;

public class GenerateColumnValueOnExpression {
    private DBRow row;
    private DBRow.Column dbColumn;
    protected DMLExecutor executor;
    String prepareStatement;

    public GenerateColumnValueOnExpression(DBRow row, DMLExecutor executor, String stmt) {
        this.row = row;
        this.executor = executor;
        this.prepareStatement = stmt;
    }

    public Object getColumnValue(String column) {
        GenerateInExpression inExpr;
        List<DBRow> values;
        this.dbColumn = this.row.find(SqlUtilityHelper.getColumnName(column, true));
        List<DBRow> columnValue = this.dbColumn.getValue();
        if (column.contains("<") || column.contains("!=")) {
            columnValue = this.getLesserColumnValue(column, this.dbColumn.getValue(), this.dbColumn.getType()).getValue();
        } else if (column.contains(">")) {
            columnValue = this.getGreaterColumnValue(column, this.dbColumn.getValue(), this.dbColumn.getType()).getValue();
        } else if (column.toLowerCase().contains("substr")) {
            columnValue = new GenerateLikeExpression(column, this.row).getLikeExpression();
        } else if (column.contains("[") && (values = (inExpr = new GenerateInExpression(column, this.row, this.executor, this.prepareStatement)).getInExpressionValues()) != null && values.size() > 0) {
            this.prepareStatement = inExpr.getModifiedPrepareStatement();
            columnValue = values;
        }
        return columnValue;
    }

    public String getModifiedPrepareStatement() {
        return this.prepareStatement;
    }

    protected DBRow.Column getGreaterColumnValue(String columnName, Object value, int type) {
        return this.getLesserOrGreaterColumnValue(columnName, value, " > ", type);
    }

    protected DBRow.Column getLesserColumnValue(String columnName, Object value, int type) {
        return this.getLesserOrGreaterColumnValue(columnName, value, " < ", type);
    }

    protected DBRow.Column getLesserOrGreaterColumnValue(String columnName, Object value, String symbol, int type) {
        return this.executor.getRandomColumnForDML(GenericDMLHelper.getQuery(columnName, symbol), value, type);
    }
}

