/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import java.util.List;
import sql.generic.SqlUtilityHelper;
import sql.generic.dmlstatements.DBRow;
import sql.generic.dmlstatements.DMLExecutor;
import sql.generic.dmlstatements.GenericDMLHelper;

public class GenerateInExpression {
    private String columnName;
    private DBRow row;
    private DMLExecutor executor;
    String prepareStatement;

    public GenerateInExpression(String columnName, DBRow row, DMLExecutor executor, String stmt) {
        this.columnName = columnName;
        this.row = row;
        this.executor = executor;
        this.prepareStatement = stmt;
    }

    public List<DBRow> getInExpressionValues() {
        int totalColumnsInExpression = this.getNumberOfValuesToGenerate();
        String query = GenericDMLHelper.getQuery(this.getInColumnName(), ">");
        List<DBRow> rowUsedForInPredicate = this.executor.getRandomRowsForDml(query, this.row.find(this.getInColumnName()).getValue(), this.row.find(this.getInColumnName()).getType(), totalColumnsInExpression, SqlUtilityHelper.getTableName(this.columnName));
        this.createPrepareStatementForIn(rowUsedForInPredicate.size(), totalColumnsInExpression);
        return rowUsedForInPredicate;
    }

    public boolean isInColumnName() {
        return this.columnName.contains("[");
    }

    private void createPrepareStatementForIn(int rows, int actualColumns) {
        String column = this.columnName.toUpperCase().trim().replace("[", "\\[");
        column = column.replace("]", "\\]");
        String pattternToReplace = "::[ ]*(" + column + ")[ ]*::";
        if (rows != 0) {
            this.prepareStatement = this.prepareStatement.replaceAll(pattternToReplace, this.getReplacementString(rows));
        }
    }

    public String getModifiedPrepareStatement() {
        return this.prepareStatement;
    }

    private String getReplacementString(int rows) {
        int count = 0;
        String PARAMETER = " ? ,";
        String replacementString = new String();
        while (count++ < rows) {
            replacementString = replacementString + " ? ,";
        }
        return replacementString.substring(0, replacementString.length() - 1);
    }

    private String getInColumnName() {
        return SqlUtilityHelper.getColumnName(this.columnName, true);
    }

    private int getNumberOfValuesToGenerate() {
        String[] values = this.columnName.split("[\\[\\]]");
        return Integer.parseInt(values[1].trim());
    }
}

