/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import sql.generic.SQLGenericPrms;
import sql.generic.SQLOldTest;
import sql.generic.dmlstatements.DBRow;
import sql.generic.dmlstatements.DMLExecutor;
import sql.generic.dmlstatements.DMLOperation;
import sql.generic.dmlstatements.DeleteOperation;
import sql.generic.dmlstatements.GenericDMLExecutor;
import sql.generic.dmlstatements.InsertOperation;
import sql.generic.dmlstatements.Operation;
import sql.generic.dmlstatements.SelectOperation;
import sql.generic.dmlstatements.UpdateOperation;
import util.TestException;

public class GenericDML {
    public static final Random rand = SQLOldTest.random;
    private DBRow preparedColumnMap = new DBRow();
    Map<String, DBRow> dataPopulatedForTheTable = new HashMap<String, DBRow>();
    HashMap<String, DBRow.Column> columnConsumedInStmt = new HashMap();
    private DMLExecutor genericDMLExecutor;
    private List<DMLOperation> operationsList;

    public GenericDML(List<String> dmlStatements, Connection dConn, Connection gConn) throws Exception {
        this(dmlStatements, new GenericDMLExecutor(dConn, gConn));
    }

    public GenericDML(List<String> dmlStatements, DMLExecutor executor) throws Exception {
        this.genericDMLExecutor = executor;
        this.operationsList = this.prepareOperationsForStatements(dmlStatements);
    }

    public List<DMLOperation> prepareOperationsForStatements(List<String> dmlStatements) throws Exception {
        LinkedList<DMLOperation> operations = new LinkedList<DMLOperation>();
        for (String stmt : dmlStatements) {
            DMLOperation operationForStatement = this.getOperationForStatement(stmt);
            if (operationForStatement == null) continue;
            operations.add(operationForStatement);
        }
        return operations;
    }

    public DMLOperation getOperationForStatement(String stmt) throws Exception {
        if (!this.performOperation(stmt = this.convertCase(stmt))) {
            Log.getLogWriter().info("skipping the operation " + stmt);
            return null;
        }
        if (stmt.startsWith(Operation.INSERT.getValue())) {
            return new InsertOperation(this.genericDMLExecutor, stmt, this.preparedColumnMap, this.dataPopulatedForTheTable, Operation.INSERT);
        }
        if (stmt.startsWith(Operation.PUT.getValue())) {
            return new InsertOperation(this.genericDMLExecutor, stmt, this.preparedColumnMap, this.dataPopulatedForTheTable, Operation.PUT);
        }
        if (stmt.startsWith(Operation.UPDATE.getValue())) {
            return new UpdateOperation(this.genericDMLExecutor, stmt, this.preparedColumnMap, this.dataPopulatedForTheTable);
        }
        if (stmt.startsWith(Operation.SELECT.getValue())) {
            return new SelectOperation(this.genericDMLExecutor, stmt, this.preparedColumnMap, this.dataPopulatedForTheTable);
        }
        if (stmt.startsWith(Operation.DELETE.getValue())) {
            return new DeleteOperation(this.genericDMLExecutor, stmt, this.preparedColumnMap, this.dataPopulatedForTheTable);
        }
        throw new Exception("Not a valid statement, statement should be INSERT/UPDATE/DELETE or SELECT. Stmt is:" + stmt);
    }

    private String convertCase(String stmt) {
        String StmtFinal = stmt.toUpperCase().trim();
        if (!stmt.contains("'")) {
            return StmtFinal;
        }
        int endIndex = stmt.lastIndexOf("'");
        int nextIndex = 0;
        int startIndex = 0;
        while (nextIndex < endIndex) {
            startIndex = nextIndex + stmt.substring(nextIndex).indexOf("'") + 1;
            nextIndex = startIndex + stmt.substring(startIndex).indexOf("'") + 1;
            StmtFinal = StmtFinal.replace(StmtFinal.substring(startIndex, nextIndex), stmt.substring(startIndex, nextIndex));
        }
        return StmtFinal;
    }

    private boolean performOperation(String stmt) throws Exception {
        if (SQLGenericPrms.getDMLOperations() == null) {
            return true;
        }
        if (stmt.startsWith(Operation.INSERT.getValue()) && SQLGenericPrms.getDMLOperations().contains(Operation.INSERT.getValue().toLowerCase())) {
            return true;
        }
        if (stmt.startsWith(Operation.PUT.getValue()) && SQLGenericPrms.getDMLOperations().contains(Operation.PUT.getValue().toLowerCase())) {
            return true;
        }
        if (stmt.startsWith(Operation.UPDATE.getValue()) && SQLGenericPrms.getDMLOperations().contains(Operation.UPDATE.getValue().toLowerCase())) {
            return true;
        }
        if (stmt.startsWith(Operation.SELECT.getValue()) && SQLGenericPrms.getDMLOperations().contains(Operation.SELECT.getValue().toLowerCase())) {
            return true;
        }
        return stmt.startsWith(Operation.DELETE.getValue()) && SQLGenericPrms.getDMLOperations().contains(Operation.DELETE.getValue().toLowerCase());
    }

    public void execute() throws TestException {
        this.genericDMLExecutor.executeStatements(this.operationsList);
    }
}

