/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import hydra.MasterController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import sql.SQLHelper;
import sql.generic.SQLOldTest;
import sql.generic.dmlstatements.DBRow;
import sql.generic.dmlstatements.DMLExecutor;
import sql.generic.dmlstatements.DMLOperation;
import sql.generic.dmlstatements.DMLOperationWrapper;
import sql.generic.dmlstatements.GenericDML;
import sql.generic.dmlstatements.GenericDMLHelper;
import sql.generic.dmlstatements.Operation;
import sql.generic.dmlstatements.PrepareStatementSetter;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class GenericDMLExecutor
implements DMLExecutor {
    private Connection dConn;
    private Connection gConn;
    private boolean verificationWithDerby;
    protected static int maxNumOfTries = 1;
    protected static int retrySleepMs = 100;
    boolean success;
    boolean skipVerification;

    public GenericDMLExecutor(Connection dConn, Connection gConn) {
        this.dConn = dConn;
        this.gConn = gConn;
        this.verificationWithDerby = dConn != null;
    }

    public GenericDMLExecutor(Connection gConn) {
        this.dConn = null;
        this.gConn = gConn;
        this.verificationWithDerby = false;
    }

    @Override
    public void executeStatements(List<DMLOperation> operationsList) throws TestException {
        for (DMLOperation operation : operationsList) {
            if (!operation.getExecutable()) continue;
            operation.execute();
        }
    }

    @Override
    public void query(DMLOperation operation) {
        ResultSet discRS = null;
        ResultSet gfeRS = null;
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        DMLOperationWrapper wrapper = null;
        SQLException derbyException = null;
        SQLException gemxdException = null;
        if (this.verificationWithDerby) {
            try {
                wrapper = new DMLOperationWrapper(operation, this.dConn);
                discRS = this.executeQuery(wrapper);
                if (discRS == null) {
                    Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                    Log.getLogWriter().info("Could not finish the op in derby, will abort this operation in derby");
                }
            }
            catch (SQLException se) {
                derbyException = se;
                SQLHelper.handleDerbySQLException(se, exceptionList);
            }
            try {
                try {
                    wrapper = new DMLOperationWrapper(operation, this.gConn);
                }
                catch (TestException te) {
                    Log.getLogWriter().info("Received Test Exception :" + te.getMessage() + te.getCause());
                    return;
                }
                gfeRS = this.executeQuery(wrapper);
                if (gfeRS == null) {
                    if (SQLOldTest.isHATest) {
                        Log.getLogWriter().info("Testing HA and did not get GFXD result set");
                        return;
                    }
                    if (SQLOldTest.setCriticalHeap) {
                        Log.getLogWriter().info("got XCL54 and does not get query result");
                        return;
                    }
                    throw new TestException("Not able to get gfe result set after retry");
                }
            }
            catch (SQLException se) {
                gemxdException = se;
                SQLHelper.handleGFGFXDException(se, exceptionList);
            }
            if (gemxdException == null && derbyException != null && derbyException.getSQLState().equals("22003")) {
                Log.getLogWriter().info("Received " + derbyException.getErrorCode() + derbyException.getMessage() + " in Derby. Continuing test ");
                return;
            }
            if (derbyException != null) {
                SQLHelper.handleDerbySQLException(derbyException, exceptionList);
            }
            if (gemxdException != null) {
                SQLHelper.handleGFGFXDException(gemxdException, exceptionList);
            }
            SQLHelper.handleMissedSQLException(exceptionList);
            if (discRS == null || gfeRS == null) {
                return;
            }
            boolean success = ResultSetHelper.compareResultSets(discRS, gfeRS);
            if (!success) {
                Log.getLogWriter().info("Not able to compare results due to derby server error");
            }
        } else {
            try {
                try {
                    wrapper = new DMLOperationWrapper(operation, this.gConn);
                }
                catch (TestException te) {
                    Log.getLogWriter().info("Received Test Exception :" + te.getMessage() + te.getCause());
                    return;
                }
                gfeRS = this.executeQuery(wrapper);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("42502") && SQLOldTest.testSecurity) {
                    Log.getLogWriter().info("Got expected no SELECT permission, continuing test");
                    return;
                }
                SQLHelper.handleSQLException(se);
            }
            if (gfeRS != null) {
                ResultSetHelper.asList(gfeRS, false);
            } else if (SQLOldTest.isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else if (SQLOldTest.setCriticalHeap) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
            } else {
                throw new TestException("gfxd query returns null and not a HA test");
            }
        }
    }

    private ResultSet executeQuery(DMLOperationWrapper dmlOperationWrapper) throws SQLException {
        boolean[] success = new boolean[1];
        int count = 0;
        ResultSet rs = null;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                if (dmlOperationWrapper.isDerby()) {
                    Log.getLogWriter().info("Could not get the lock to finisht the op in derby, abort this operation");
                }
                return null;
            }
            ++count;
            MasterController.sleepForMs((int)GenericDML.rand.nextInt(retrySleepMs));
            rs = this.executeQuery(dmlOperationWrapper, success);
        }
        return rs;
    }

    private ResultSet executeQuery(DMLOperationWrapper dmlOperationWrapper, boolean[] success) throws SQLException {
        ResultSet rs = null;
        success[0] = true;
        try {
            dmlOperationWrapper.executionMsg(0);
            rs = dmlOperationWrapper.getPreparedStatement().executeQuery();
            dmlOperationWrapper.executionMsg(1);
            return rs;
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(dmlOperationWrapper.getConnection(), se)) {
                success[0] = false;
            } else if (!SQLHelper.checkGFXDException(dmlOperationWrapper.getConnection(), se)) {
                success[0] = false;
            } else {
                throw se;
            }
            return null;
        }
    }

    @Override
    public void executeStatement(DMLOperation operation) {
        ArrayList<SQLException> exceptionList = new ArrayList<SQLException>();
        this.success = true;
        this.skipVerification = false;
        int derbyCount = 0;
        int gfeCount = 0;
        DMLOperationWrapper gfxdWrapper = null;
        DMLOperationWrapper derbyWrapper = null;
        if (this.verificationWithDerby) {
            derbyWrapper = new DMLOperationWrapper(operation, this.dConn);
            derbyCount = this.executeStatement(derbyWrapper, exceptionList);
            int count = 0;
            while (!this.success) {
                if (count >= maxNumOfTries) {
                    Log.getLogWriter().info("Could not finish the delete op in derby, will abort this operation in derby");
                    return;
                }
                MasterController.sleepForMs((int)GenericDML.rand.nextInt(retrySleepMs));
                ++count;
                exceptionList.clear();
                derbyCount = this.executeStatement(derbyWrapper, exceptionList);
                Log.getLogWriter().info("after retrying operation in  derby statement size of exception list is" + exceptionList.size() + "success is " + this.success + "count " + derbyCount);
            }
            gfxdWrapper = new DMLOperationWrapper(operation, this.gConn);
            gfeCount = this.executeStatement(gfxdWrapper, exceptionList);
            if (derbyCount != gfeCount && !this.skipVerification) {
                Log.getLogWriter().info("derby has different row count then gemfirexdderby deleted " + derbyCount + " gemfirexd deleted " + gfeCount);
                throw new TestException("gemfirexd deleted different row count than derby ");
            }
            if (!this.skipVerification) {
                SQLHelper.handleMissedSQLException(exceptionList);
            }
        } else {
            gfxdWrapper = new DMLOperationWrapper(operation, this.gConn);
            this.executeStatementWOVerification(gfxdWrapper, exceptionList);
        }
    }

    protected int executeStatement(DMLOperationWrapper wrapper, List<SQLException> exList) {
        int count = 0;
        this.success = true;
        this.skipVerification = false;
        try {
            count = this.executeStatement(wrapper);
        }
        catch (SQLException se) {
            Log.getLogWriter().info(" got sql exception  " + se.getMessage());
            if (!wrapper.isDerby()) {
                Log.getLogWriter().info("handling gfxd exception ");
                if (wrapper.getOperation().getOperation() == Operation.UPDATE && se.getSQLState().equals("0A000") && GenericDMLHelper.updateOnPk(wrapper.getOperation().getPreparedStmtForLogging())) {
                    this.skipVerification = true;
                } else {
                    SQLHelper.handleGFGFXDException(se, exList);
                }
                this.rollbackAll();
            }
            if (!SQLHelper.checkDerbyException(wrapper.getConnection(), se)) {
                Log.getLogWriter().info("not a derby exception " + se.getMessage());
                this.success = false;
            }
            Log.getLogWriter().info("handling derby  " + se.getMessage());
            SQLHelper.handleDerbySQLException(se, exList);
        }
        return count;
    }

    protected int executeStatementWOVerification(DMLOperationWrapper wrapper, List<SQLException> exList) {
        int rowCount = 0;
        try {
            rowCount = this.executeStatement(wrapper);
        }
        catch (SQLException se) {
            if ((se.getSQLState().equals("42500") || se.getSQLState().equals("42502")) && SQLOldTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            } else if ("23505".equals(se.getSQLState())) {
                Log.getLogWriter().info("Got the expected exception due to unique constraint check");
            } else if ("23503".equals(se.getSQLState())) {
                Log.getLogWriter().info("Got the expected exception due to unique constraint check");
            } else if (se.getSQLState().equals("42502") && SQLOldTest.testSecurity) {
                Log.getLogWriter().info("Got the expected exception for authorization, continuing tests");
            } else if (SQLOldTest.alterTableDropColumn && se.getSQLState().equals("42X14")) {
                Log.getLogWriter().info("Got expected column not found exception in update, continuing test");
            } else if (se.getSQLState().equals("0A000") && GenericDMLHelper.updateOnPk(wrapper.getOperation().getPreparedStmtForLogging())) {
                Log.getLogWriter().info("Got expected feature not supported exception in update, continuing test");
            } else if (se.getSQLState().equals("23513")) {
                Log.getLogWriter().info("detected check constraint violation during update, continuing test");
            } else {
                SQLHelper.handleSQLException(se);
            }
            this.rollbackAll();
        }
        return rowCount;
    }

    protected int executeStatement(DMLOperationWrapper wrapper) throws SQLException {
        this.success = true;
        int rowCount = 0;
        Log.getLogWriter().info("now stmt is " + wrapper.getOperation().getPreparedStmtForLogging());
        PreparedStatement stmt = wrapper.getPreparedStatement();
        wrapper.executionMsg(0);
        rowCount = stmt.executeUpdate();
        Log.getLogWriter().info("after  stmt is " + wrapper.getOperation().getPreparedStmtForLogging());
        wrapper.executionMsg(1);
        SQLWarning warning = stmt.getWarnings();
        if (warning != null) {
            SQLHelper.printSQLWarning(warning);
        }
        return rowCount;
    }

    @Override
    public DBRow.Column getRandomColumnForDML(String query, Object value, int type) {
        try {
            PreparedStatement stmt = this.gConn.prepareStatement(query, 1004, 1007);
            PrepareStatementSetter ps = new PrepareStatementSetter(stmt);
            ps.setValues(value, type);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                rs.last();
                int randomRow = GenericDML.rand.nextInt(rs.getRow());
                rs.absolute(randomRow == 0 ? 1 : randomRow);
                return new DBRow.Column(rs.getMetaData().getColumnName(1), rs.getMetaData().getColumnType(1), rs.getObject(1));
            }
            return new DBRow.Column(null, 0, value);
        }
        catch (SQLException se) {
            throw new TestException(" Error while retrieving a row from database " + se.getSQLState() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public DBRow getRandomRowForDml(String tableName) {
        String query = "select * from  " + tableName + " where  tid = " + GenericDMLHelper.getMyTid();
        try {
            ResultSet rs = this.gConn.prepareStatement(query, 1004, 1007).executeQuery();
            if (rs.next()) {
                rs.last();
                int randomRow = GenericDML.rand.nextInt(rs.getRow());
                rs.absolute(randomRow == 0 ? 1 : randomRow);
                DBRow dbRow = new DBRow(tableName);
                for (int column = 1; column <= rs.getMetaData().getColumnCount(); ++column) {
                    dbRow.addColumn(rs.getMetaData().getColumnName(column).toLowerCase(), rs.getMetaData().getColumnType(column), rs.getObject(rs.getMetaData().getColumnName(column)));
                }
                return dbRow;
            }
            Log.getLogWriter().info(" Not a single row found in table :" + tableName + "with tid" + GenericDMLHelper.getMyTid() + " for query " + query + "resultset is " + rs);
            return null;
        }
        catch (SQLSyntaxErrorException se) {
            Log.getLogWriter().info(" syntax issue : " + se.getMessage() + " Executed DML : " + query);
            return null;
        }
        catch (SQLException se) {
            if (se instanceof SQLException && !SQLHelper.checkGFXDException(this.gConn, se)) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("Got expected Exception, continue the test...");
                return null;
            }
            throw new TestException(" Error while retrieving a row from database " + se.getSQLState() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public List<DBRow> getRandomRowsForDml(String query, Object value, int type, int rows, String tableName) {
        int currentRow = 0;
        LinkedList<DBRow> finalRows = new LinkedList<DBRow>();
        try {
            PreparedStatement stmt = this.gConn.prepareStatement(query);
            PrepareStatementSetter ps = new PrepareStatementSetter(stmt);
            ps.setValues(value, type);
            ResultSet rs = stmt.executeQuery();
            while (rs.next() && currentRow++ < rows) {
                DBRow dbRow = new DBRow(tableName);
                for (int column = 1; column <= rs.getMetaData().getColumnCount(); ++column) {
                    dbRow.addColumn(rs.getMetaData().getColumnName(column).toLowerCase(), rs.getMetaData().getColumnType(column), rs.getObject(rs.getMetaData().getColumnName(column)));
                }
                finalRows.add(dbRow);
            }
            return finalRows;
        }
        catch (SQLException se) {
            throw new TestException(" Error while retrieving a row from database " + se.getSQLState() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    @Override
    public void commitAll() {
        if (this.verificationWithDerby) {
            this.commitDerby();
        }
        this.commitGfxd();
    }

    public void rollbackAll() {
        if (this.verificationWithDerby) {
            this.rollbackDerby();
        }
        this.rollbackGfxd();
    }

    public void commitDerby() {
        try {
            Log.getLogWriter().info(" Derby - Commit  started ");
            this.dConn.commit();
            Log.getLogWriter().info(" Derby - Commit  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while commiting the derby database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void commitGfxd() {
        try {
            Log.getLogWriter().info(" Gfxd - Commit  started ");
            this.gConn.commit();
            Log.getLogWriter().info(" Gfxd - Commit  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while commiting the Gfxd database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void rollbackDerby() {
        try {
            Log.getLogWriter().info(" Derby - Rollback  started ");
            this.dConn.rollback();
            Log.getLogWriter().info(" Derby - Rollback  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while doing rollback derby database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }

    public void rollbackGfxd() {
        try {
            Log.getLogWriter().info(" Gfxd - Rollback  started ");
            this.gConn.rollback();
            Log.getLogWriter().info(" Gfxd - Rollback  Completed ");
        }
        catch (SQLException se) {
            throw new TestException(" Error while doing rollback Gfxd database  sqlState : " + se.getSQLState() + " error message : " + se.getMessage() + TestHelper.getStackTrace((Throwable)se));
        }
    }
}

