/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import hydra.RemoteTestModule;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import sql.generic.GenericBBHelper;
import sql.generic.SQLOldTest;
import sql.generic.SqlUtilityHelper;
import sql.generic.ddl.ColumnInfo;
import sql.generic.ddl.TableInfo;
import sql.wan.WanTest;
import util.TestException;

public class GenericDMLHelper {
    public static String getQuery(String columnName, String symbol) {
        String tableName = SqlUtilityHelper.getTableName(columnName);
        String columnNameinTable = SqlUtilityHelper.getColumnName(columnName, true);
        String query = "select " + columnNameinTable + " from " + tableName + " where " + columnNameinTable + symbol + " ?" + " and tid = " + GenericDMLHelper.getMyTid() + " order by " + columnNameinTable + " desc";
        return query;
    }

    protected static int getMyTid() {
        if (SQLOldTest.testWanUniqueness) {
            return WanTest.myWanSite;
        }
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        return myTid;
    }

    public static boolean isDerby(Connection conn) {
        try {
            return conn.getMetaData().getDriverName().toLowerCase().contains("derby");
        }
        catch (SQLException se) {
            throw new TestException(" can not get driver information from connection object" + se.getMessage());
        }
    }

    public static boolean updateOnPk(String stmt) {
        Log.getLogWriter().info(" in  updateOnPk " + stmt);
        if (!stmt.contains("UPDATE ")) {
            return false;
        }
        int start = stmt.toUpperCase().indexOf(" SET ");
        int end = stmt.toUpperCase().indexOf(" WHERE ");
        String tableName = stmt.substring(stmt.toUpperCase().indexOf("UPDATE ") + 7, start);
        if (end < start) {
            end = stmt.length();
        }
        Log.getLogWriter().info("table Name is " + tableName + "fetched from index " + (stmt.toUpperCase().indexOf("UPDATE ") + 7) + " start index " + start);
        Log.getLogWriter().info(" subString is " + stmt.substring(start, end) + " with start " + start + " end " + end);
        String stmtToCheck = stmt.substring(start, end);
        TableInfo info = GenericBBHelper.getTableInfo(tableName);
        List<ColumnInfo> partitioningColumns = info.getPartitioningColumns();
        for (ColumnInfo column : partitioningColumns) {
            Log.getLogWriter().info("checking column " + column.getColumnName());
            if (!stmtToCheck.contains(column.getColumnName().toUpperCase())) continue;
            return true;
        }
        return true;
    }
}

