/*
 * Decompiled with CFR 0.152.
 */
package sql.generic.dmlstatements;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import util.TestException;
import util.TestHelper;

public class PrepareStatementSetter {
    protected PreparedStatement stmt;
    int columnIndex;

    PrepareStatementSetter(PreparedStatement stmt) {
        this.stmt = stmt;
        this.columnIndex = 1;
    }

    PrepareStatementSetter(PreparedStatement stmt, int columnIndex) {
        this.stmt = stmt;
        this.columnIndex = columnIndex;
    }

    public void setValues(Object value, int columnType) {
        try {
            switch (columnType) {
                case 2003: {
                    this.stmt.setArray(this.columnIndex++, (Array)value);
                    break;
                }
                case -5: {
                    this.stmt.setLong(this.columnIndex++, (Long)value);
                    break;
                }
                case -2: {
                    break;
                }
                case -7: {
                    this.stmt.setBoolean(this.columnIndex++, (Boolean)value);
                    break;
                }
                case 2004: {
                    this.stmt.setBlob(this.columnIndex++, (Blob)value);
                    break;
                }
                case 16: {
                    this.stmt.setBoolean(this.columnIndex++, (Boolean)value);
                    break;
                }
                case 1: {
                    this.stmt.setString(this.columnIndex++, (String)value);
                    break;
                }
                case 2005: {
                    this.stmt.setClob(this.columnIndex++, (Clob)value);
                    break;
                }
                case 91: {
                    this.stmt.setDate(this.columnIndex++, (Date)value);
                    break;
                }
                case 3: {
                    this.stmt.setBigDecimal(this.columnIndex++, (BigDecimal)value);
                    break;
                }
                case 8: {
                    this.stmt.setDouble(this.columnIndex++, (Double)value);
                    break;
                }
                case 6: {
                    this.stmt.setFloat(this.columnIndex++, ((Float)value).floatValue());
                    break;
                }
                case 4: {
                    this.stmt.setInt(this.columnIndex++, (Integer)value);
                    break;
                }
                case -16: {
                    this.stmt.setString(this.columnIndex++, (String)value);
                    break;
                }
                case -4: {
                    this.stmt.setBytes(this.columnIndex++, (byte[])value);
                    break;
                }
                case -1: {
                    this.stmt.setString(this.columnIndex++, (String)value);
                    break;
                }
                case 2: {
                    this.stmt.setBigDecimal(this.columnIndex++, (BigDecimal)value);
                    break;
                }
                case -9: 
                case 7: {
                    this.stmt.setFloat(this.columnIndex++, ((Float)value).floatValue());
                    break;
                }
                case 5: {
                    this.stmt.setShort(this.columnIndex++, (Short)value);
                    break;
                }
                case 92: {
                    this.stmt.setTime(this.columnIndex++, (Time)value);
                    break;
                }
                case 93: {
                    this.stmt.setTimestamp(this.columnIndex++, (Timestamp)value);
                    break;
                }
                case -3: {
                    this.stmt.setBytes(this.columnIndex++, (byte[])value);
                    break;
                }
                case 12: {
                    this.stmt.setString(this.columnIndex++, (String)value);
                    break;
                }
                default: {
                    Log.getLogWriter().info("This dataType is yet not supported : " + columnType);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TestException("Error occurred while trying to set data type to Statement, Data Type : " + columnType + " at columnIndex : " + this.columnIndex + " " + e.getMessage() + TestHelper.getStackTrace((Throwable)e));
        }
    }

    public PreparedStatement getStatement() {
        return this.stmt;
    }
}

