/*
 * Decompiled with CFR 0.152.
 */
package sql.hadoopHA;

import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import hdfs.HDFSPrms;
import hdfs.HDFSUtilBB;
import hydra.ConfigPrms;
import hydra.HadoopDescription;
import hydra.HadoopHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.NetworkHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.HDFSStoreHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Random;
import sql.SQLPrms;
import sql.SQLTest;
import sql.dmlStatements.DMLStmtIF;
import sql.hadoopHA.HadoopHAPrms;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class HadoopHATest
extends SQLTest {
    public static final Random random = TestConfig.getInstance().getParameters().getRandGen();

    public static synchronized void HydraTask_initializeGFXD() {
        if (sqlTest == null) {
            sqlTest = new HadoopHATest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        }
        ((HadoopHATest)sqlTest).initialize();
    }

    public static synchronized void HydraTask_initializeFabricServer() {
        if (sqlTest == null) {
            sqlTest = new HadoopHATest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
        }
        ((HadoopHATest)sqlTest).initialize();
    }

    public static void HydraTask_createHDFSStore() {
        ((HadoopHATest)sqlTest).createHDFSStore();
    }

    private void createHDFSStore() {
        Connection conn = this.getGFEConnection();
        String createHDFSStoreStmt = HDFSStoreHelper.getHDFSStoreDDL(GfxdConfigPrms.getHDFSStoreConfig());
        Log.getLogWriter().info("Creating hdfs store: " + createHDFSStoreStmt);
        try {
            Statement s = conn.createStatement();
            s.execute(createHDFSStoreStmt);
            s.close();
            this.closeGFEConnection(conn);
        }
        catch (Throwable t) {
            HadoopHATest.handleException(t, HadoopHAPrms.expectExceptions());
            Log.getLogWriter().info("createHDFSStore() caught expected exception: " + TestHelper.getStackTrace((Throwable)t) + " continuing test");
        }
    }

    public static void HydraTask_doDMLOp() {
        ((HadoopHATest)sqlTest).doDMLOp();
    }

    @Override
    protected void doDMLOp() {
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        try {
            this.doDMLOp(dConn, gConn);
        }
        catch (TestException te) {
            long recycleInProgress = HDFSUtilBB.getBB().getSharedCounters().read(HDFSUtilBB.recycleInProgress);
            boolean allowExceptions = recycleInProgress > 0L;
            HadoopHATest.handleException(te, allowExceptions);
            Log.getLogWriter().info("doDMLOp caught expected exception: " + TestHelper.getStackTrace((Throwable)te) + " continuing test");
        }
        if (dConn != null) {
            this.closeDiscConnection(dConn);
        }
        this.closeGFEConnection(gConn);
        Log.getLogWriter().info("done dmlOp");
    }

    @Override
    protected void doDMLOp(Connection dConn, Connection gConn) {
        Log.getLogWriter().info("doDMLOp-performing dmlOp, myTid is " + this.getMyTid());
        int table = dmlTables[random.nextInt(dmlTables.length - 1)];
        DMLStmtIF dmlStmt = dmlFactory.createDMLStmt(table);
        int numOfOp = random.nextInt(5) + 1;
        int size = 1;
        String operation = TestConfig.tab().stringAt(SQLPrms.dmlOperations);
        if (operation.equals("insert")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                dmlStmt.insert(dConn, gConn, size);
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("put")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                dmlStmt.put(dConn, gConn, size);
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("update")) {
            for (int i = 0; i < numOfOp; ++i) {
                if (setCriticalHeap) {
                    this.resetCanceledFlag();
                }
                dmlStmt.update(dConn, gConn, size);
                this.commit(dConn);
                this.commit(gConn);
            }
        } else if (operation.equals("delete")) {
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            dmlStmt.delete(dConn, gConn);
        } else if (operation.equals("query")) {
            if (setCriticalHeap) {
                this.resetCanceledFlag();
            }
            dmlStmt.query(dConn, gConn);
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        this.commit(dConn);
        this.commit(gConn);
    }

    public static void handleException(Throwable t, boolean allowHDFSExceptions) {
        Throwable hdfsio;
        boolean allowableException = false;
        SQLException se = null;
        Throwable cause = TestHelper.findCause((Throwable)t, SQLException.class);
        if (cause != null && (se = (SQLException)cause).getSQLState().equalsIgnoreCase("X0Z30") && (hdfsio = TestHelper.findCause((Throwable)se, HDFSIOException.class)) != null) {
            allowableException = true;
        }
        if (t.getMessage().contains("java.sql.SQLException(X0Z30)") && t.getMessage().contains("Caused by: com.gemstone.gemfire.cache.hdfs.HDFSIOException")) {
            allowableException = true;
        }
        if (!allowHDFSExceptions || !allowableException) {
            throw new TestException("caught unexpected Exception: " + t + " " + TestHelper.getStackTrace((Throwable)t) + " allowHDFSExceptions = " + allowHDFSExceptions + " and allowableException = " + allowableException);
        }
    }

    public static void stopDataNode() {
        String target = HadoopHATest.getTargetHost();
        int waitTimeSec = HDFSPrms.hadoopStopWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.stopDataNode sleeping for " + waitTimeSec + " seconds before stopping data node on " + target);
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
        HadoopHelper.stopDataNode((String)ConfigPrms.getHadoopConfig(), (String)target);
    }

    public static void dropAndRestoreConnection() {
        String src = HadoopHATest.getDataStoreHost();
        String target = HadoopHATest.getTargetHost();
        int waitTimeSec = HDFSPrms.hadoopStopWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.dropConnections sleeping for " + waitTimeSec + " seconds before dropping network connection");
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
        HadoopHATest.dropConnection(src, target);
        waitTimeSec = HDFSPrms.hadoopStartWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.dropConnections sleeping for " + waitTimeSec + " seconds before restoring network connection");
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
        HadoopHATest.restoreConnection(src, target);
        waitTimeSec = HDFSPrms.hadoopReturnWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.dropConnections sleeping for " + waitTimeSec + " seconds before returning (allow namenode time to exit safe mode)");
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
    }

    public static void dropConnection() {
        MasterController.sleepForMs((int)(HDFSPrms.hadoopStopWaitSec() * 1000));
        String src = HadoopHATest.getDataStoreHost();
        String target = HadoopHATest.getTargetHost();
        HadoopHATest.dropConnection(src, target);
        int waitTimeSec = HDFSPrms.hadoopReturnWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.dropConnections sleeping for " + waitTimeSec + " seconds");
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
    }

    public static void dropConnection(String src, String target) {
        HDFSUtilBB.getBB().getSharedCounters().increment(HDFSUtilBB.recycleInProgress);
        NetworkHelper.printConnectionState();
        NetworkHelper.dropConnectionTwoWay((String)src, (String)target);
        NetworkHelper.printConnectionState();
    }

    public static void restoreConnection() {
        MasterController.sleepForMs((int)(HDFSPrms.hadoopStartWaitSec() * 1000));
        String src = HadoopHATest.getDataStoreHost();
        String target = HadoopHATest.getTargetHost();
        HadoopHATest.restoreConnection(src, target);
        int waitTimeSec = HDFSPrms.hadoopReturnWaitSec();
        if (waitTimeSec > 0) {
            Log.getLogWriter().info("HadoopHATest.dropConnections sleeping for " + waitTimeSec + " seconds");
            MasterController.sleepForMs((int)(waitTimeSec * 1000));
        }
        HDFSUtilBB.getBB().getSharedCounters().zero(HDFSUtilBB.recycleInProgress);
    }

    public static void restoreConnection(String src, String target) {
        NetworkHelper.printConnectionState();
        try {
            NetworkHelper.restoreConnectionTwoWay((String)src, (String)target);
        }
        catch (IllegalStateException e) {
            Log.getLogWriter().info("Caught " + e + " indicating that connections are already restored");
        }
        NetworkHelper.printConnectionState();
    }

    private static String getDataStoreHost() {
        String dataStoreDescription = HadoopHAPrms.gemfirexdHostDescription();
        return HadoopHATest.getDataStoreHost(dataStoreDescription);
    }

    private static String getDataStoreHost(String dataStoreDescription) {
        return TestConfig.getInstance().getHostDescription(dataStoreDescription).getHostName();
    }

    private static String getTargetHost() {
        String description = HadoopHAPrms.hdfsComponentDescription().toLowerCase();
        String targetHost = null;
        targetHost = description.startsWith("datastore") ? HadoopHATest.getDataStoreHost(description) : HadoopHATest.getHadoopHost();
        return targetHost;
    }

    private static String getHadoopHost() {
        String hdfsNodeDescription = HadoopHAPrms.hdfsComponentDescription();
        HadoopDescription hd = HadoopHelper.getHadoopDescription((String)ConfigPrms.getHadoopConfig());
        List ndList = null;
        if (HadoopHAPrms.hdfsComponentDescription().equalsIgnoreCase("namenode")) {
            ndList = hd.getNameNodeDescriptions();
        } else if (HadoopHAPrms.hdfsComponentDescription().equalsIgnoreCase("datanode")) {
            ndList = hd.getDataNodeDescriptions();
        }
        if (ndList.size() < 1) {
            throw new TestException("No name nodes configured, check local.conf to ensure HDFS nodes are configured");
        }
        return ((HadoopDescription.NodeDescription)ndList.get(0)).getHostName();
    }
}

