/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs;

import hydra.ClientVmInfo;
import hydra.GsRandom;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.gemfirexd.GfxdConfigPrms;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sql.SQLBB;
import sql.SQLHelper;
import sql.hdfs.AlterHdfsStoreBB;
import sql.hdfs.AlterHdfsStorePrms;
import sql.hdfs.HDFSSqlTest;
import util.PRObserver;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class AlterHDFSTest
extends HDFSSqlTest {
    public static AlterHDFSTest alterHdfsInstance;
    protected int secondsToRun = AlterHdfsStorePrms.getSecondsToRun();
    protected static List<AlterHdfsStoreEntry> alterHdfsStoreEntries;

    public static synchronized void HydraTask_alterHdfsStore() {
        if (alterHdfsInstance == null) {
            alterHdfsInstance = new AlterHDFSTest();
        }
        alterHdfsInstance.alterHdfsStore();
    }

    protected void alterHdfsStore() {
        Connection conn = this.getGFEConnection();
        this.alterHdfsStore(conn);
        this.closeGFEConnection(conn);
    }

    private void alterHdfsStore(Connection conn) {
        this.alterHdfsStore(conn, AlterHdfsStorePrms.getAlterType());
    }

    private void alterHdfsStore(AlterType alterType) {
        Connection conn = this.getGFEConnection();
        this.alterHdfsStore(conn, alterType);
        this.closeGFEConnection(conn);
    }

    private void alterHdfsStore(Connection conn, AlterType alterType) {
        block20: {
            StringBuffer attrs = new StringBuffer();
            for (AlterHdfsStoreEntry entry : alterHdfsStoreEntries) {
                if (!entry.getAlterType().equals((Object)alterType)) continue;
                attrs.append(" SET " + entry.getAttributeName() + " " + entry.getNewValue());
                if (entry.getTimeUnit() == null) continue;
                attrs.append(" " + (Object)((Object)entry.getTimeUnit()));
            }
            List<String> hdfsTables = AlterHDFSTest.getHdfsTables();
            ArrayList<Thread> workerThreads = new ArrayList<Thread>();
            boolean launchProcedure = AlterHdfsStorePrms.getLaunchProcedure();
            if (launchProcedure) {
                for (String table : hdfsTables) {
                    switch (alterType) {
                        case HDFS_AEQ: {
                            workerThreads.add(sqlTest.flushQueuesHDFS(table));
                            break;
                        }
                        case RW_BUCKET_ORGANIZER: {
                            workerThreads.add(sqlTest.forceCompactionHDFS(table));
                            break;
                        }
                        case WO_BUCKET_ORGANIZER: {
                            workerThreads.add(sqlTest.forceWriteOnlyFileRollover(table, -1));
                            break;
                        }
                        case COMPACTION_MANAGER: {
                            workerThreads.add(sqlTest.forceCompactionHDFS(table));
                            break;
                        }
                    }
                }
            }
            String storeName = GfxdConfigPrms.getHDFSStoreConfig();
            String alterHdfsStoreDDL = "ALTER HDFSSTORE " + storeName + attrs.toString();
            try {
                Statement stmt = conn.createStatement();
                Log.getLogWriter().info("about to alter HDFSSTORE :  " + alterHdfsStoreDDL);
                stmt.execute(alterHdfsStoreDDL);
                Log.getLogWriter().info("altered HDFSSTORE :  " + alterHdfsStoreDDL);
            }
            catch (SQLException sqle) {
                SQLHelper.handleSQLException(sqle);
            }
            if (launchProcedure) {
                for (Thread wthread : workerThreads) {
                    try {
                        wthread.join(maxResultWaitSec - 60);
                    }
                    catch (InterruptedException e) {
                        throw new TestException("System Procedure to conflict with " + (Object)((Object)alterType) + " caught " + e + " " + TestHelper.getStackTrace((Throwable)e));
                    }
                }
            }
            String selectStmt = "select * from SYS.SYSHDFSSTORES where NAME='" + storeName.toUpperCase() + "'";
            Log.getLogWriter().info("query string = " + selectStmt);
            try {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(selectStmt);
                if (rs.next()) {
                    Log.getLogWriter().info(this.ResultSetRowToString(rs));
                    for (AlterHdfsStoreEntry entry : alterHdfsStoreEntries) {
                        if (!entry.getAlterType().equals((Object)alterType)) continue;
                        Log.getLogWriter().info("Processing entry " + entry.toString());
                        String columnName = entry.getColumnName();
                        Object expected = entry.getNewValue();
                        Object found = rs.getObject(columnName);
                        Log.getLogWriter().info("For " + columnName + " found = " + found);
                        if (!expected.equals(found)) {
                            Log.getLogWriter().info("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                            throw new TestException("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                        }
                        Log.getLogWriter().info("SYS.SYSHDFSSTORES." + columnName + " returned expected value of " + found);
                    }
                    break block20;
                }
                throw new TestException("No results returned from " + selectStmt.toString());
            }
            catch (SQLException sqle) {
                SQLHelper.handleSQLException(sqle);
            }
        }
    }

    private void restoreDefaults(Connection conn) {
        block8: {
            StringBuffer attrs = new StringBuffer();
            for (AlterHdfsStoreEntry entry : alterHdfsStoreEntries) {
                if (!entry.getAlterType().equals((Object)AlterType.DEFAULT)) continue;
                attrs.append(" SET " + entry.getAttributeName() + " " + entry.getDefaultValue());
                if (entry.getTimeUnit() == null) continue;
                attrs.append(" " + (Object)((Object)entry.getTimeUnit()));
            }
            String storeName = GfxdConfigPrms.getHDFSStoreConfig();
            String alterHdfsStoreDDL = "ALTER HDFSSTORE " + storeName + attrs.toString();
            try {
                Statement stmt = conn.createStatement();
                Log.getLogWriter().info("about to alter HDFSSTORE :  " + alterHdfsStoreDDL);
                stmt.execute(alterHdfsStoreDDL);
                Log.getLogWriter().info("altered HDFSSTORE :  " + alterHdfsStoreDDL);
            }
            catch (SQLException sqle) {
                SQLHelper.handleSQLException(sqle);
            }
            String selectStmt = "select * from SYS.SYSHDFSSTORES where NAME='" + storeName.toUpperCase() + "'";
            Log.getLogWriter().info("query string = " + selectStmt);
            try {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(selectStmt);
                if (rs.next()) {
                    Log.getLogWriter().info(this.ResultSetRowToString(rs));
                    for (AlterHdfsStoreEntry entry : alterHdfsStoreEntries) {
                        if (!entry.getAlterType().equals((Object)AlterType.DEFAULT)) continue;
                        Log.getLogWriter().info("Processing entry " + entry.toString());
                        String columnName = entry.getColumnName();
                        Object expected = entry.getNewValue();
                        Object found = rs.getObject(columnName);
                        Log.getLogWriter().info("For " + columnName + " found = " + found);
                        if (!expected.equals(found)) {
                            Log.getLogWriter().info("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                            throw new TestException("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                        }
                        Log.getLogWriter().info("SYS.SYSHDFSSTORES." + columnName + " returned expected value of " + found);
                    }
                    break block8;
                }
                throw new TestException("No results returned from " + selectStmt.toString());
            }
            catch (SQLException sqle) {
                SQLHelper.handleSQLException(sqle);
            }
        }
    }

    private String ResultSetRowToString(ResultSet rs) {
        StringBuffer aStr = new StringBuffer();
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            aStr.append(rsmd.getTableName(1) + " has " + numColumns + " columns\n");
            for (int i = 1; i < numColumns; ++i) {
                aStr.append("  " + rsmd.getColumnLabel(i) + " : " + rs.getObject(i) + "\n");
            }
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
        return aStr.toString();
    }

    private String ResultSetToString(ResultSet rs) {
        StringBuffer aStr = new StringBuffer();
        try {
            int row = 1;
            while (rs.next()) {
                aStr.append("\nRow #" + row + " : ");
                aStr.append(this.ResultSetRowToString(rs));
                ++row;
            }
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
        return aStr.toString();
    }

    protected static void logExecutionNumber() {
        long executionNumber = AlterHdfsStoreBB.getBB().getSharedCounters().incrementAndRead(AlterHdfsStoreBB.ExecutionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + executionNumber);
    }

    public void checkForLastIteration() {
        AlterHDFSTest.checkForLastIteration(this.secondsToRun);
    }

    public static void checkForLastIteration(int numSeconds) {
        long taskStartTime = 0L;
        String bbKey = "TaskStartTime";
        Object anObj = AlterHdfsStoreBB.getBB().getSharedMap().get((Object)"TaskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            AlterHdfsStoreBB.getBB().getSharedMap().put((Object)"TaskStartTime", (Object)new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(numSeconds * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            AlterHdfsStoreBB.getBB().getSharedCounters().increment(AlterHdfsStoreBB.TimeToStop);
        } else {
            Log.getLogWriter().info("Running for " + numSeconds + " seconds; time remaining is " + ((long)numSeconds - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    public static synchronized void HydraTask_concAlterHdfsStore() {
        if (alterHdfsInstance == null) {
            alterHdfsInstance = new AlterHDFSTest();
        }
        alterHdfsInstance.concAlterHdfsStore();
    }

    protected void concAlterHdfsStore() {
        Connection conn = this.getGFEConnection();
        this.concAlterHdfsStore(conn);
        this.closeGFEConnection(conn);
    }

    protected void concAlterHdfsStore(Connection conn) {
        AlterType alterType;
        boolean leadMember = false;
        long readyToBegin = AlterHdfsStoreBB.getBB().getSharedCounters().incrementAndRead(AlterHdfsStoreBB.readyToBegin);
        if (readyToBegin == 1L) {
            Log.getLogWriter().info("This thread is the alterHdfsStore leader");
            leadMember = true;
            AlterHDFSTest.logExecutionNumber();
            this.checkForLastIteration();
            alterType = AlterType.HDFS_AEQ;
        } else if (readyToBegin == 2L) {
            Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
            alterType = AlterType.RW_BUCKET_ORGANIZER;
            if (hdfsExtnMap.get(tables[0].toUpperCase() + "WRITEONLY") != null) {
                alterType = AlterType.WO_BUCKET_ORGANIZER;
            }
        } else {
            alterType = AlterType.COMPACTION_MANAGER;
        }
        int numThreads = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        TestHelper.waitForCounter((Blackboard)AlterHdfsStoreBB.getBB(), (String)"AlterHdfsStoreBB.readyToBegin", (int)AlterHdfsStoreBB.readyToBegin, (long)numThreads, (boolean)true, (long)-1L, (long)5000L);
        long counter = AlterHdfsStoreBB.getBB().getSharedCounters().read(AlterHdfsStoreBB.TimeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num executions is " + AlterHdfsStoreBB.getBB().getSharedCounters().read(AlterHdfsStoreBB.ExecutionNumber));
        }
        Log.getLogWriter().info("All " + numThreads + " threads at sync point (readyToBegin) alterHdfsStore");
        AlterHdfsStoreBB.getBB().getSharedCounters().zero(AlterHdfsStoreBB.finishedValidation);
        AlterHdfsStoreBB.clearAlteredAttributes();
        List vmList = null;
        if (leadMember && isHATest) {
            Log.getLogWriter().info("Asynchronously recycling datastore while multiple members alterHdfsStore attributes");
            int numToKill = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
            Object[] tmpArr = StopStartVMs.getOtherVMs((int)numToKill, (String)"store");
            vmList = (List)tmpArr[0];
            List stopModeList = (List)tmpArr[1];
            for (ClientVmInfo client : vmList) {
                PRObserver.initialize((int)client.getVmid());
            }
            if (vmList.size() != 0) {
                StopStartVMs.stopStartAsync((List)vmList, (List)stopModeList);
            }
        }
        this.alterHdfsStore(alterType);
        this.recordAlteredAttributes(alterType);
        AlterHdfsStoreBB.getBB().getSharedCounters().incrementAndRead(AlterHdfsStoreBB.completedOps);
        TestHelper.waitForCounter((Blackboard)AlterHdfsStoreBB.getBB(), (String)"AlterHdfsStoreBB.completedOps", (int)AlterHdfsStoreBB.completedOps, (long)numThreads, (boolean)true, (long)-1L, (long)5000L);
        Log.getLogWriter().info("All " + numThreads + " threads at completedOps sync point (after) alterHdfsStore");
        AlterHdfsStoreBB.getBB().getSharedCounters().zero(AlterHdfsStoreBB.readyToBegin);
        if (leadMember && isHATest) {
            int numOfPRs = (int)SQLBB.getBB().getSharedCounters().read(SQLBB.numOfPRs);
            PRObserver.waitForRebalRecov((Object)vmList, (int)1, (int)numOfPRs, null, null, (boolean)false);
        }
        this.validateAlteredAttributes(conn);
        AlterHdfsStoreBB.getBB().getSharedCounters().incrementAndRead(AlterHdfsStoreBB.finishedValidation);
        TestHelper.waitForCounter((Blackboard)AlterHdfsStoreBB.getBB(), (String)"AlterHdfsStoreBB.finishedValidation", (int)AlterHdfsStoreBB.finishedValidation, (long)numThreads, (boolean)true, (long)-1L, (long)5000L);
        Log.getLogWriter().info("All " + numThreads + " threads at completedOps sync point (after) alterHdfsStore");
        AlterHdfsStoreBB.getBB().getSharedCounters().zero(AlterHdfsStoreBB.completedOps);
    }

    protected void recordAlteredAttributes(AlterType alterType) {
        for (AlterHdfsStoreEntry entry : alterHdfsStoreEntries) {
            if (!entry.getAlterType().equals((Object)alterType)) continue;
            AlterHdfsStoreBB.addAlteredAttribute(entry.getColumnName(), entry.getNewValue());
        }
    }

    protected void validateAlteredAttributes(Connection conn) {
        block5: {
            Map attrMap = AlterHdfsStoreBB.getAlteredAttributes();
            String storeName = GfxdConfigPrms.getHDFSStoreConfig();
            String selectStmt = "select * from SYS.SYSHDFSSTORES where NAME='" + storeName.toUpperCase() + "'";
            Log.getLogWriter().info("query string = " + selectStmt);
            try {
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(selectStmt);
                if (rs.next()) {
                    Log.getLogWriter().info(this.ResultSetRowToString(rs));
                    for (String columnName : attrMap.keySet()) {
                        Object expected = attrMap.get(columnName);
                        Object found = rs.getObject(columnName);
                        Log.getLogWriter().info("For " + columnName + " found = " + found);
                        if (!expected.equals(found)) {
                            Log.getLogWriter().info("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                            throw new TestException("Expected SYS.SYSHDFSSTORES(" + columnName + ") = " + expected + ", but found " + found);
                        }
                        Log.getLogWriter().info("SYS.SYSHDFSSTORES." + columnName + " returned expected value of " + found);
                    }
                    break block5;
                }
                throw new TestException("No results returned from " + selectStmt.toString());
            }
            catch (SQLException sqle) {
                SQLHelper.handleSQLException(sqle);
            }
        }
    }

    static {
        alterHdfsStoreEntries = new ArrayList<AlterHdfsStoreEntry>();
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("PURGEINTERVAL", "PURGEINTERVALMINS", AlterType.DEFAULT, new Integer(720), null, new Integer(720), SQLTimeUnit.MINUTES));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACTIONINTERVAL", "MAJORCOMPACTIONINTERVALMINS", AlterType.DEFAULT, new Integer(720), null, new Integer(720), SQLTimeUnit.MINUTES));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXINPUTFILECOUNT", "MAXINPUTFILECOUNT", AlterType.DEFAULT, new Integer(10), null, new Integer(10), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXINPUTFILESIZE", "MAXINPUTFILESIZE", AlterType.DEFAULT, new Integer(512), null, new Integer(512), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MININPUTFILECOUNT", "MININPUTFILECOUNT", AlterType.DEFAULT, new Integer(4), null, new Integer(4), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXWRITEONLYFILESIZE", "MAXWRITEONLYFILESIZE", AlterType.DEFAULT, new Integer(256), null, new Integer(256), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("WRITEONLYFILEROLLOVERINTERVAL", "WRITEONLYFILEROLLOVERINTERVALSECS", AlterType.DEFAULT, new Integer(3600), null, new Integer(3600), SQLTimeUnit.SECONDS));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHSIZE", "BATCHSIZE", AlterType.DEFAULT, new Integer(32), null, new Integer(32), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHTIMEINTERVAL", "BATCHTIMEINTERVALMILLIS", AlterType.DEFAULT, new Integer(60000), null, new Integer(60000), SQLTimeUnit.MILLISECONDS));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MINORCOMPACT", "MINORCOMPACT", AlterType.DEFAULT, Boolean.TRUE, null, Boolean.TRUE, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACT", "MAJORCOMPACT", AlterType.DEFAULT, Boolean.TRUE, null, Boolean.TRUE, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MINORCOMPACTIONTHREADS", "MINORCOMPACTIONTHREADS", AlterType.DEFAULT, new Integer(10), null, new Integer(10), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACTIONTHREADS", "MAJORCOMPACTIONTHREADS", AlterType.DEFAULT, new Integer(2), null, new Integer(2), null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("PURGEINTERVAL", "PURGEINTERVALMINS", AlterType.RW_BUCKET_ORGANIZER, new Integer(720), new ValueRange(5, 900), 3, SQLTimeUnit.MINUTES));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACTIONINTERVAL", "MAJORCOMPACTIONINTERVALMINS", AlterType.RW_BUCKET_ORGANIZER, new Integer(720), new ValueRange(5, 900), 3, SQLTimeUnit.MINUTES));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXINPUTFILECOUNT", "MAXINPUTFILECOUNT", AlterType.RW_BUCKET_ORGANIZER, new Integer(10), new ValueRange(10, 20), 20, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXINPUTFILESIZE", "MAXINPUTFILESIZE", AlterType.RW_BUCKET_ORGANIZER, new Integer(512), new ValueRange(32, 1024), 32, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MININPUTFILECOUNT", "MININPUTFILECOUNT", AlterType.RW_BUCKET_ORGANIZER, new Integer(4), new ValueRange(1, 9), 3, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAXWRITEONLYFILESIZE", "MAXWRITEONLYFILESIZE", AlterType.WO_BUCKET_ORGANIZER, new Integer(256), new ValueRange(32, 1024), 32, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("WRITEONLYFILEROLLOVERINTERVAL", "WRITEONLYFILEROLLOVERINTERVALSECS", AlterType.WO_BUCKET_ORGANIZER, new Integer(3600), new ValueRange(60, 7200), 60, SQLTimeUnit.SECONDS));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHSIZE", "BATCHSIZE", AlterType.HDFS_AEQ, new Integer(32), new ValueRange(1, 1024), 256, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHTIMEINTERVAL", "BATCHTIMEINTERVALMILLIS", AlterType.HDFS_AEQ, new Integer(60000), new ValueRange(5, 600000), 120000, SQLTimeUnit.MILLISECONDS));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MINORCOMPACT", "MINORCOMPACT", AlterType.COMPACTION_MANAGER_DISABLE_MINOR, Boolean.TRUE, null, Boolean.FALSE, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHSIZE", "BATCHSIZE", AlterType.COMPACTION_MANAGER_DISABLE_MINOR, new Integer(32), new ValueRange(1, 1024), 512, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("BATCHTIMEINTERVAL", "BATCHTIMEINTERVALMILLIS", AlterType.COMPACTION_MANAGER_DISABLE_MINOR, new Integer(60000), new ValueRange(5, 600000), 180000, SQLTimeUnit.MILLISECONDS));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACT", "MAJORCOMPACT", AlterType.COMPACTION_MANAGER_DISABLE_MAJOR, Boolean.TRUE, null, Boolean.FALSE, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MINORCOMPACTIONTHREADS", "MINORCOMPACTIONTHREADS", AlterType.COMPACTION_MANAGER, new Integer(10), new ValueRange(1, 20), 20, null));
        alterHdfsStoreEntries.add(new AlterHdfsStoreEntry("MAJORCOMPACTIONTHREADS", "MAJORCOMPACTIONTHREADS", AlterType.COMPACTION_MANAGER, new Integer(2), new ValueRange(1, 10), 5, null));
    }

    private static class AlterHdfsStoreEntry {
        String attributeName;
        String columnName;
        AlterType alterType;
        ValueRange valueRange;
        Object defaultValue;
        Object newValue;
        SQLTimeUnit timeUnit;

        public AlterHdfsStoreEntry(String attributeName, String columnName, AlterType alterType, Object defaultValue, ValueRange valueRange, Object newValue, SQLTimeUnit timeUnit) {
            this.attributeName = attributeName;
            this.columnName = columnName;
            this.alterType = alterType;
            this.defaultValue = defaultValue;
            this.valueRange = valueRange;
            this.newValue = newValue;
            this.timeUnit = timeUnit;
        }

        public String toString() {
            StringBuffer aStr = new StringBuffer();
            aStr.append("AlterHdfsStoreEntry: \n");
            aStr.append("   attributeName: " + this.attributeName + "\n");
            aStr.append("   columnName: " + this.columnName + "\n");
            aStr.append("   alterType: " + (Object)((Object)this.alterType) + "\n");
            aStr.append("   defaultValue: " + this.defaultValue + "\n");
            aStr.append("   newValue: " + this.newValue + "\n");
            aStr.append("   timeUnit: " + (Object)((Object)this.timeUnit) + "\n");
            return aStr.toString();
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public AlterType getAlterType() {
            return this.alterType;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public SQLTimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Object setNewValue() {
            if (this.alterType.equals((Object)AlterType.DEFAULT)) {
                Object val = this.defaultValue;
            } else if (this.defaultValue instanceof Boolean) {
                Boolean val = new Boolean(HDFSSqlTest.random.nextBoolean());
            } else {
                Object val = this.valueRange.getNewValue();
            }
            this.newValue = this.getNewValue();
            return this.newValue;
        }
    }

    public static enum AlterType {
        DEFAULT,
        RW_BUCKET_ORGANIZER,
        WO_BUCKET_ORGANIZER,
        HDFS_AEQ,
        COMPACTION_MANAGER_DISABLE_MINOR,
        COMPACTION_MANAGER_DISABLE_MAJOR,
        COMPACTION_MANAGER;


        public static AlterType getRandom() {
            return AlterType.values()[HDFSSqlTest.random.nextInt(AlterType.values().length - 1)];
        }
    }

    public static enum SQLTimeUnit {
        MILLISECONDS,
        SECONDS,
        MINUTES,
        HOURS,
        DAYS;

    }

    private static class ValueRange {
        Object low;
        Object high;

        public ValueRange(Object low, Object high) {
            this.low = low;
            this.high = high;
        }

        public Object getNewValue() {
            if (!(this.low instanceof Integer)) {
                throw new TestException("Unexpected object type " + this.low.getClass().getName() + " encountered by " + this.getClass().getName());
            }
            int min = (Integer)this.low;
            int max = (Integer)this.high;
            Integer newValue = new Integer(((GsRandom)HDFSSqlTest.random).nextInt(min, max));
            return newValue;
        }

        public String toString() {
            return "low = " + this.low + " high = " + this.high;
        }
    }
}

