/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.CustomEvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HoplogListenerForRegion;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.Hoplog;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HoplogListener;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdEvictionCriteria;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.DumpHDFSData;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HadoopDescription;
import hydra.HadoopHelper;
import hydra.HostDescription;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.HDFSStoreDescription;
import hydra.gemfirexd.HDFSStoreHelper;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.hdfs.EvictionObserver;
import sql.hdfs.HDFSSqlBB;
import sql.hdfs.HDFSSqlTestVersionHelper;
import sql.hdfs.HDFSTestPrms;
import sql.sqlutil.ResultSetHelper;
import util.TestException;
import util.TestHelper;

public class HDFSSqlTest
extends SQLTest {
    public static final Random random = TestConfig.getInstance().getParameters().getRandGen();
    private AtomicBoolean isHdfsStoreCreated = new AtomicBoolean(false);
    private AtomicBoolean isEvictionObserverCreated = new AtomicBoolean(false);
    public static boolean hasIdentityColumn = TestConfig.tab().booleanAt(SQLPrms.setIdentityColumn, false);
    public static final String STORENAME = "STORENAME";
    public static final String EVICTION_CRITERIA = "EVICTIONCRITERIA";
    public static final String EVICT_INCOMING = "EVICTINCOMING";
    public static final String STARTTIME = "STARTTIME";
    public static final String FREQUENCY = "FREQUENCY";
    public static final String CASCADE = "CASCADE";
    public static final String WRITEONLY = "WRITEONLY";

    public static synchronized void HydraTask_initCompactionListener() {
        HoplogListener compactionListener = new HoplogListener(){

            public void hoplogDeleted(String regionFolder, int bucketId, Hoplog ... oplogs) throws IOException {
            }

            public void hoplogCreated(String regionFolder, int bucketId, Hoplog ... oplogs) throws IOException {
            }

            public void compactionCompleted(String region, int bucket, boolean isMajor) {
                Log.getLogWriter().info("HoplogListener-compactionCompleted-region=" + region + " bucket=" + bucket + " isMajor=" + isMajor);
                if (isMajor) {
                    long majorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().incrementAndRead(HDFSSqlBB.majorCompactionCnt);
                    Log.getLogWriter().info("HoplogListener-compactionCompleted-majorCompactionCnt=" + majorCompactionCnt);
                } else {
                    long minorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().incrementAndRead(HDFSSqlBB.minorCompactionCnt);
                    Log.getLogWriter().info("HoplogListener-compactionCompleted-minorCompactionCnt=" + minorCompactionCnt);
                }
            }
        };
        for (String table : tables) {
            Log.getLogWriter().info("HydraTask_initCompactionListener-HoplogListener-setting tables-table=" + table);
            String tableName = StringUtil.SQLToUpperCase((String)table);
            Log.getLogWriter().info("HydraTask_initCompactionListener-HoplogListener-tableName=" + tableName);
            Region aRegion = Misc.getRegionForTable((String)tableName, (boolean)true);
            HoplogListenerForRegion listenerManager = ((LocalRegion)aRegion).getHoplogListener();
            listenerManager.addListener(compactionListener);
        }
    }

    public static void HydraTask_waitForCompaction() {
        long minorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().read(HDFSSqlBB.minorCompactionCnt);
        long majorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().read(HDFSSqlBB.majorCompactionCnt);
        Log.getLogWriter().info("HydraTask_waitForCompaction-(before wait)-minorCompactionCnt=" + minorCompactionCnt + " majorCompactionCnt=" + majorCompactionCnt);
        TestHelper.waitForCounter((Blackboard)HDFSSqlBB.getBB(), (String)"HDFSSqlBB.minorCompactionCnt", (int)HDFSSqlBB.minorCompactionCnt, (long)HDFSTestPrms.getDesiredMinorCompactions(), (boolean)false, (long)-1L);
        TestHelper.waitForCounter((Blackboard)HDFSSqlBB.getBB(), (String)"HDFSSqlBB.majorCompactionCnt", (int)HDFSSqlBB.majorCompactionCnt, (long)HDFSTestPrms.getDesiredMajorCompactions(), (boolean)false, (long)-1L);
        minorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().read(HDFSSqlBB.minorCompactionCnt);
        majorCompactionCnt = HDFSSqlBB.getBB().getSharedCounters().read(HDFSSqlBB.majorCompactionCnt);
        if (minorCompactionCnt >= (long)HDFSTestPrms.getDesiredMinorCompactions() && majorCompactionCnt >= (long)HDFSTestPrms.getDesiredMajorCompactions()) {
            throw new StopSchedulingOrder("It's time to stop the test, Minor Compaction Count is " + minorCompactionCnt + " and Major Compaction Count is " + majorCompactionCnt);
        }
    }

    private Statistics getCompressionStat(String statFullName) {
        Statistics[] stats;
        Log.getLogWriter().info("getCompressionStat statFullName=" + statFullName);
        DistributedSystem statFactory = DistributedSystemHelper.getDistributedSystem();
        while (statFactory == null) {
            statFactory = DistributedSystemHelper.getDistributedSystem();
        }
        Statistics rtnStats = null;
        for (Statistics aStat : stats = statFactory.findStatisticsByTextId(statFullName)) {
            Log.getLogWriter().info("getCompressionStat aStat.getType().getName()=" + aStat.getType().getName());
            if (!aStat.getType().getName().equals("HDFSRegionStatistics")) continue;
            rtnStats = aStat;
        }
        return rtnStats;
    }

    public synchronized void createHdfsStore() {
        try {
            if (!this.isHdfsStoreCreated.get() || isWanTest) {
                Connection conn = this.getGFEConnection();
                this.createHdfsStore(conn);
                this.closeGFEConnection(conn);
                this.isHdfsStoreCreated.set(true);
            }
        }
        catch (SQLException sqle) {
            Log.getLogWriter().info("HydraTask_createHDFSStoresFor49414-SQLException caught.");
            SQLHelper.handleSQLException(sqle);
        }
    }

    public void createHdfsStore(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        List<String> hdfsStoreDDLs = useRandomConfHdfsStore ? this.getHDFSStoreRandomDDL() : HDFSStoreHelper.getHDFSStoreDDL();
        for (String hdfsStoreDDL : hdfsStoreDDLs) {
            if (isWanTest) {
                HDFSStoreDescription hdfsStoreDesc = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
                String homeDir = hdfsStoreDesc.getHomeDir();
                hdfsStoreDDL = hdfsStoreDDL.replace(homeDir, homeDir + this.getMyWanSite());
            }
            Log.getLogWriter().info("about to create HDFSSTORE :  " + hdfsStoreDDL);
            stmt.execute(hdfsStoreDDL);
            Log.getLogWriter().info("created HDFSSTORE :  " + hdfsStoreDDL);
        }
    }

    public static void HydraTask_createHDFSStoreWithWrongGFXDSecurity() {
        hdfsSqlTest.createHDFSStoreWithWrongGFXDSecurity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createHDFSStoreWithWrongGFXDSecurity() {
        boolean correctExceptionWasThrown;
        block8: {
            correctExceptionWasThrown = false;
            Connection conn = this.getGFEConnection();
            try {
                this.createHdfsStore(conn);
            }
            catch (Exception e) {
                if (e.getCause() instanceof HDFSIOException) {
                    correctExceptionWasThrown = true;
                    break block8;
                }
                for (Throwable causedBy = e.getCause(); causedBy != null; causedBy = causedBy.getCause()) {
                    if (!(causedBy instanceof HDFSIOException)) continue;
                    correctExceptionWasThrown = true;
                    break;
                }
            }
            finally {
                this.closeGFEConnection(conn);
            }
        }
        if (!correctExceptionWasThrown) {
            throw new TestException("ERROR! The wrong exception was thrown - this test was supposed to throw a HDFSIOException.");
        }
        Log.getLogWriter().info("The correct Exception, HDFSIOException was found.");
    }

    private List<String> getHDFSStoreRandomDDL() {
        StringBuffer config = new StringBuffer();
        HDFSStoreDescription hdfsStoreDesc = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
        int batchSize = random.nextInt(5) + 5;
        int batchTimeInterval = random.nextInt(5000) + 1000;
        int maxQueueMem = random.nextInt(50) + 100;
        boolean queuePersist = random.nextBoolean();
        boolean disksynchronous = random.nextBoolean();
        boolean autoCompaction = HDFSTestPrms.isCompactionTest() ? true : random.nextBoolean();
        boolean autoMajorCompaction = HDFSTestPrms.isCompactionTest() ? true : random.nextBoolean();
        int maxInputFileSizeMb = random.nextInt(500) + 500;
        int minInputFileCount = random.nextInt(2) + 2;
        int maxInputFileCount = random.nextInt(10) + 10;
        int maxConcurrency = random.nextInt(20) + 1;
        int majorCompactionInterval = random.nextInt(300) + 200;
        int majorCompactionConcurrency = random.nextInt(10) + 1;
        int blockCacheSize = random.nextInt(5) + 5;
        int purgeInterval = random.nextInt(10) + 500;
        String hdfsClientConfigFile = "'./file1'";
        if (random.nextBoolean()) {
            config.append(" MAXQUEUEMEMORY ").append(maxQueueMem);
        }
        if (random.nextBoolean()) {
            config.append(" QUEUEPERSISTENT ").append(queuePersist);
        }
        if (random.nextBoolean()) {
            config.append(" DISKSYNCHRONOUS ").append(disksynchronous);
        }
        if (random.nextBoolean()) {
            config.append(" MINORCOMPACT ").append(autoCompaction);
            if (autoCompaction) {
                if (random.nextBoolean()) {
                    config.append(" BATCHSIZE ").append(batchSize);
                }
                if (random.nextBoolean()) {
                    config = HDFSSqlTestVersionHelper.appendBatchInterval(config, batchTimeInterval);
                }
            } else {
                config.append(" BATCHSIZE ").append(50);
                config = HDFSSqlTestVersionHelper.appendBatchInterval(config, 60000);
            }
        } else {
            if (random.nextBoolean()) {
                config.append(" BATCHSIZE ").append(batchSize);
            }
            if (random.nextBoolean()) {
                config = HDFSSqlTestVersionHelper.appendBatchInterval(config, batchTimeInterval);
            }
        }
        if (random.nextBoolean()) {
            config.append(" MAJORCOMPACT ").append(autoMajorCompaction);
        }
        if (random.nextBoolean()) {
            config.append(" MAXINPUTFILESIZE ").append(maxInputFileSizeMb);
        }
        if (random.nextBoolean()) {
            config.append(" MININPUTFILECOUNT ").append(minInputFileCount);
            config.append(" MAXINPUTFILECOUNT ").append(maxInputFileCount);
        }
        if (random.nextBoolean()) {
            config.append(" MINORCOMPACTIONTHREADS ").append(maxConcurrency);
        }
        if (HDFSTestPrms.isCompactionTest()) {
            config = HDFSSqlTestVersionHelper.appendMajorCompactionInterval(config, hdfsStoreDesc.getMajorCompactionInterval());
        } else if (random.nextBoolean()) {
            config = HDFSSqlTestVersionHelper.appendMajorCompactionInterval(config, majorCompactionInterval);
        }
        if (random.nextBoolean()) {
            config.append(" MAJORCOMPACTIONTHREADS ").append(majorCompactionConcurrency);
        }
        if (random.nextBoolean() || hdfsMrJob) {
            config.append(" MAXWRITEONLYFILESIZE ").append(1024);
        }
        if (random.nextBoolean() || hdfsMrJob) {
            config = HDFSSqlTestVersionHelper.appendWriteOnlyFileRolloverInterval(config, 1);
        }
        if (random.nextBoolean()) {
            config.append(" BLOCKCACHESIZE ").append(blockCacheSize);
        }
        if (random.nextBoolean()) {
            config.append(" CLIENTCONFIGFILE ").append(hdfsClientConfigFile);
        }
        if (random.nextBoolean()) {
            config = HDFSSqlTestVersionHelper.appendPurgeInterval(config, purgeInterval);
        }
        HadoopDescription hadoopDesc = HadoopHelper.getHadoopDescription((String)ConfigPrms.getHadoopConfig());
        ArrayList<String> storeDDL = new ArrayList<String>();
        Collection hsds = GfxdTestConfig.getInstance().getHDFSStoreDescriptions().values();
        for (HDFSStoreDescription hsd : hsds) {
            StringBuffer buff = new StringBuffer();
            buff.append("CREATE HDFSSTORE ").append(hsd.getName()).append(" NAMENODE ").append("'" + hadoopDesc.getNameNodeURL() + "'").append(" HOMEDIR ").append("'" + hsd.getHomeDir() + "'").append(" DISKSTORENAME ").append(hsd.getDiskStoreDescription().getName()).append(config.toString());
            storeDDL.add(buff.toString());
        }
        return storeDDL;
    }

    public synchronized void setHDFSEvictionObserver() {
        String[] tableNames;
        if (this.isEvictionObserverCreated.get()) {
            return;
        }
        this.isEvictionObserverCreated.set(true);
        for (String tableName : tableNames = tables) {
            Region r = Misc.getGemFireCache().getRegion("/" + tableName.toUpperCase().replace(".", "/"));
            if (r == null) continue;
            CustomEvictionAttributes evictionAtt = r.getAttributes().getCustomEvictionAttributes();
            if (evictionAtt != null) {
                GfxdEvictionCriteria criteria = (GfxdEvictionCriteria)evictionAtt.getCriteria();
                criteria.setObserver((GfxdEvictionCriteria.Observer)new EvictionObserver());
                Log.getLogWriter().info("EvictionObserver is configured for region " + r.getFullPath());
                continue;
            }
            Log.getLogWriter().info("EvictionObserver is not configured for region " + r.getFullPath() + " as CustomEvictionAttributes=" + evictionAtt);
        }
    }

    public synchronized void dropHdfsStore() {
        Connection conn = this.getGFEConnection();
        this.dropHdfsStore(conn);
        this.closeGFEConnection(conn);
    }

    private void dropHdfsStore(Connection conn) {
        try {
            String storeName = GfxdConfigPrms.getHDFSStoreConfig();
            String ifExists = random.nextBoolean() ? "IF EXISTS " : "";
            String dropStoreDDL = "DROP HDFSSTORE " + ifExists + storeName;
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info("about to drop HDFSSTORE :  " + dropStoreDDL);
            stmt.execute(dropStoreDDL);
            Log.getLogWriter().info("dropped HDFSSTORE :  " + dropStoreDDL);
        }
        catch (SQLException sqle) {
            SQLHelper.handleSQLException(sqle);
        }
    }

    public void verifyHdfsOperationData() {
        Connection gConn = this.getGFEConnection();
        this.verifyHdfsData(gConn, true);
        this.closeGFEConnection(gConn);
    }

    public void verifyHdfsNonOperationData() {
        Connection gConn = this.getGFEConnection();
        this.verifyHdfsData(gConn, false);
        this.closeGFEConnection(gConn);
    }

    protected void verifyHdfsData(Connection gConn, boolean justOperationalData) {
        Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        Log.getLogWriter().info("verifyHdfsData-Waiting for Eviction started.");
        while (!this.checkTablesRowsEvicted(gConn, hdfsExtnMap)) {
            int waitForSecs = 50;
            int sleepMs = waitForSecs * 1000;
            Log.getLogWriter().info("verifyHdfsData-Waiting for Eviction to finish, sleep for  " + waitForSecs + " seconds");
            MasterController.sleepForMs((int)sleepMs);
        }
        MasterController.sleepForMs((int)20000);
        Log.getLogWriter().info("verifyHdfsData-Waiting for Eviction finished.");
        boolean throwException = false;
        StringBuffer exceptionStr = new StringBuffer();
        for (String table : tables) {
            String hdfsSchemaTable = table.toUpperCase();
            String operationalDataStr = justOperationalData ? "operation data" : "non-operation data";
            String hasHdfsStore = (String)hdfsExtnMap.get(hdfsSchemaTable + STORENAME);
            if (hasHdfsStore == null || !justOperationalData && hdfsExtnMap.get(hdfsSchemaTable + WRITEONLY) != null && hdfsExtnMap.get(hdfsSchemaTable + EVICTION_CRITERIA) != null) {
                Log.getLogWriter().info("verifyHdfsData-Skiping " + operationalDataStr + (!justOperationalData && hdfsExtnMap.get(hdfsSchemaTable + WRITEONLY) != null && hdfsExtnMap.get(hdfsSchemaTable + EVICTION_CRITERIA) != null ? "validation as writeonly hdfs store with eviction is configured for table " : " validation as no hdfs store is configured for table ") + hdfsSchemaTable);
                continue;
            }
            Log.getLogWriter().info("verifyHdfsData-Started " + operationalDataStr + " validation for table " + hdfsSchemaTable);
            String[] dml = this.getQueryDml(hdfsSchemaTable, hdfsExtnMap, justOperationalData, false);
            String queryHdfsOpsData = dml[0];
            String queryOpsFullData = dml[1];
            try {
                this.compareResults(gConn, queryOpsFullData, queryHdfsOpsData, hdfsSchemaTable + "_fulldataset", hdfsSchemaTable);
            }
            catch (TestException te) {
                Log.getLogWriter().info("verifyHdfsData-Do not throw Exception yet - until all tables are verified");
                throwException = true;
                exceptionStr.append(te.getMessage() + "\n");
            }
            String evictionCriteria = (String)hdfsExtnMap.get(hdfsSchemaTable + EVICTION_CRITERIA);
            if (evictionCriteria == null) continue;
            Log.getLogWriter().info("verifyHdfsData using negative test query, " + operationalDataStr + " validation for table " + hdfsSchemaTable);
            dml = this.getQueryDml(hdfsSchemaTable, hdfsExtnMap, justOperationalData, true);
            queryHdfsOpsData = dml[0];
            queryOpsFullData = dml[1];
            try {
                this.compareResults(gConn, queryOpsFullData, queryHdfsOpsData, hdfsSchemaTable + SQLTest.DUPLICATE_TABLE_SUFFIX, hdfsSchemaTable);
            }
            catch (TestException te) {
                Log.getLogWriter().info("verifyHdfsData-Do not throw Exception yet - until all tables are verified");
                throwException = true;
                exceptionStr.append(te.getMessage() + "\n");
            }
        }
        if (throwException) {
            throw new TestException("Verify results failed: " + exceptionStr);
        }
    }

    private boolean checkTablesRowsEvicted(Connection gconn, Map<String, String> hdfsExtnMap) {
        boolean evicted = true;
        for (String tableName : tables) {
            String evictionCriteria = hdfsExtnMap.get(tableName.toUpperCase() + EVICTION_CRITERIA);
            if (evictionCriteria == null) continue;
            try {
                Statement s = gconn.createStatement();
                String selectstmt = "SELECT COUNT(*) FROM  " + tableName + " -- GEMFIREXD-PROPERTIES queryHDFS=false \n where ( " + evictionCriteria + " ) ";
                Log.getLogWriter().info("Executing " + selectstmt);
                ResultSet rs = s.executeQuery(selectstmt);
                if (rs.next()) {
                    if (rs.getInt(1) != 0) {
                        evicted = false;
                    }
                } else {
                    throw new TestException("Test issue - now expected to reach here.");
                }
                Log.getLogWriter().info("Total rows waiting for eviction in table " + tableName + " are " + rs.getInt(1));
            }
            catch (Exception e) {
                throw new TestException("Error  while executing displayTotalRowsinTable on  " + tableName + e.getStackTrace().toString() + e.getMessage());
            }
        }
        return evicted;
    }

    private String[] getQueryDml(String hdfsSchemaTable, Map<String, String> hdfsExtnMap, boolean justOperationalData, boolean negativeQuery) {
        String selectQueryStringForIdentityColumnCheck;
        String[] dmls = new String[2];
        String fullDataSchemaTable = hdfsSchemaTable + SQLTest.DUPLICATE_TABLE_SUFFIX.toUpperCase();
        String evictionCriteria = hdfsExtnMap.get(hdfsSchemaTable + EVICTION_CRITERIA);
        String string = hasIdentityColumn ? (hdfsSchemaTable.equalsIgnoreCase("trade.securities") ? "select sec_id, symbol, price, exchange, tid from " : (hdfsSchemaTable.equalsIgnoreCase("trade.customers") ? "select cid, cust_name, since, addr, tid from " : "SELECT * FROM ")) : (selectQueryStringForIdentityColumnCheck = "SELECT * FROM ");
        if (evictionCriteria == null) {
            if (justOperationalData) {
                dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=false";
                dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable;
            } else {
                dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=true";
                dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable;
            }
        } else {
            String reversedCriteria = this.getReversedSqlPredicate(evictionCriteria);
            if (!negativeQuery) {
                if (justOperationalData) {
                    dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=false";
                    dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable + " WHERE ( " + reversedCriteria + " ) ";
                } else {
                    dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=true \n WHERE ( " + evictionCriteria + " ) ";
                    dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable + " WHERE ( " + evictionCriteria + " ) ";
                }
            } else if (justOperationalData) {
                dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=false \n WHERE ( " + evictionCriteria + " ) ";
                dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable + " WHERE ( " + evictionCriteria + " ) AND ( " + reversedCriteria + " ) ";
            } else {
                dmls[0] = selectQueryStringForIdentityColumnCheck + hdfsSchemaTable + " -- GEMFIREXD-PROPERTIES queryHDFS=true \n WHERE ( " + reversedCriteria + " ) ";
                dmls[1] = selectQueryStringForIdentityColumnCheck + fullDataSchemaTable + " WHERE ( " + reversedCriteria + " ) ";
            }
        }
        return dmls;
    }

    @Override
    protected void compareResults(Connection gConn, String fullQuery, String hdfsQuery, String table1, String table2) throws TestException {
        List<Struct> fullList = this.getResultSet(gConn, fullQuery);
        List<Struct> hdfsList = this.getResultSet(gConn, hdfsQuery);
        if (hdfsMrJob) {
            HDFSSqlTest.compareMRResultSets(fullList, hdfsList, table1, table2);
        } else if (fullList.size() == hdfsList.size() && SQLTest.populateWithbatch) {
            Log.getLogWriter().info("size of fulldata set is " + fullList.size() + " size of hdfsList is " + hdfsList.size());
        } else {
            ResultSetHelper.compareResultSets(fullList, hdfsList, table1, table2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMR() {
        String[] strArr;
        Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        String[] tables = SQLPrms.getTableNames();
        int mapReduceDelaySec = HDFSTestPrms.getMapReduceDelaySec();
        Log.getLogWriter().info("Waiting for mapReduceDelaySec (" + mapReduceDelaySec + ")");
        MasterController.sleepForMs((int)(mapReduceDelaySec * 1000));
        Log.getLogWriter().info("Done waiting for mapReduceDelaySec (" + mapReduceDelaySec + ")");
        if (hdfsExtnMap.get(tables[0].toUpperCase() + WRITEONLY) != null) {
            if (HDFSTestPrms.useRandomConfig()) {
                Log.getLogWriter().info("Wait 2 Mins for FileRollover...");
                try {
                    Thread.sleep(120000L);
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception Received while waiting for FileRollover" + e.getMessage());
                }
            } else {
                HDFSSqlTestVersionHelper.waitForWriteOnlyFileRollover(HDFSSqlTest.getHdfsTables());
            }
        }
        this.DisplayHdfsFileStruct();
        for (String tableName : strArr = SQLPrms.getTableNames()) {
            try {
                this.executeMrJob(tableName.toUpperCase());
            }
            finally {
                HadoopDescription hdd = HadoopHelper.getHadoopDescription((String)ConfigPrms.getHadoopConfig());
                String host = RemoteTestModule.getMyHost();
                if (hdd.getSecurityAuthentication().equals("kerberos")) {
                    HadoopHelper.executeKdestroyCommand((String)host, (int)120);
                }
            }
        }
    }

    private boolean checkForEvictionComplete(Map<String, String> hdfsExtnMap) {
        SharedCounters counters = HDFSSqlBB.getBB().getSharedCounters();
        int expected = 0;
        int evictionCount = 0;
        StringBuffer buf = new StringBuffer();
        for (String table : tables) {
            String frequency = hdfsExtnMap.get(table.toUpperCase() + FREQUENCY);
            if (frequency == null) continue;
            ++expected;
            int j = (int)counters.read(HDFSSqlBB.evictionCount);
            evictionCount += j;
            buf.append("Eviction count for " + table + " is " + j);
        }
        Log.getLogWriter().info("checkForEvictionComplete - expected=" + expected + " evictionCount=" + evictionCount + " \n" + buf.toString());
        return expected == evictionCount;
    }

    private void alterTableSetEvictionStartTime(Connection gConn, Map<String, String> hdfsExtnMap) {
        HDFSSqlBB.getBB().getSharedCounters().zero(HDFSSqlBB.evictionCount);
        for (String table : tables) {
            String format;
            String frequency = hdfsExtnMap.get(table.toUpperCase() + FREQUENCY);
            if (frequency == null) continue;
            long timeMill = Misc.getGemFireCache().cacheTimeMillis();
            if (random.nextInt(100) < 10) {
                timeMill -= 600000L;
                Log.getLogWriter().info("Setting starttime to 10 mins earlier than current time");
            } else if (random.nextInt(100) < 10) {
                timeMill += 30000L;
                Log.getLogWriter().info("Setting starttime to 30 sec later than current time");
            }
            int w = random.nextInt(3);
            String string = w == 0 ? "yyyy-MM-dd HH:mm:ss" : (format = w == 1 ? "HH:mm:ss" : "yyyy-MM-dd");
            String lit = w == 0 ? "TS" : (w == 1 ? "T" : "D");
            SimpleDateFormat gmtFormat = new SimpleDateFormat(format);
            gmtFormat.setTimeZone(TimeZone.getTimeZone("GMT+00"));
            String timeStr = lit + " '" + gmtFormat.format(new Date(timeMill)) + "'";
            int freq = random.nextInt(10) + 1;
            String sql = "ALTER TABLE " + table + " SET EVICTION FREQUENCY " + freq + " SECONDS START " + timeStr;
            Log.getLogWriter().info("Time converted from '" + new Date(timeMill) + "' to " + timeStr);
            try {
                Log.getLogWriter().info("executing alter table to set eviction start time " + sql);
                Statement statement = gConn.createStatement();
                statement.execute(sql);
                statement.close();
                Log.getLogWriter().info("executed alter table to set eviction start time : " + sql);
            }
            catch (SQLException se) {
                SQLHelper.handleSQLException(se);
            }
        }
    }

    private Timestamp getTimeStampfromGfxd(Connection gConn) {
        String selectStmt = "select current_timestamp  from  SYS.SYSTABLES";
        Timestamp ts = new Timestamp(new Date().getTime());
        try {
            Statement stmt = gConn.createStatement();
            ResultSet rs = stmt.executeQuery(selectStmt);
            if (rs.next()) {
                ts = rs.getTimestamp(1);
            }
        }
        catch (Exception e) {
            throw new TestException("Error in getTimeStampfromGfxd" + e.getMessage());
        }
        return ts;
    }

    public String getReversedSqlPredicate(String sqlPredicate) {
        return "NOT ( " + sqlPredicate + ")";
    }

    public void verifyTotalRowsinTables() {
        String[] tableName = SQLPrms.getTableNames();
        Connection conn = this.getGFEConnection();
        Map map = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        try {
            Statement statement = conn.createStatement();
            for (int i = 0; i < tableName.length; ++i) {
                String val = (String)map.get(tableName[i].toUpperCase() + STORENAME);
                if (val == null) continue;
                Log.getLogWriter().info("VALIDATING TOTAL ROWS IN  " + tableName[i]);
                ResultSet rs = statement.executeQuery("SELECT COUNT(*)  FROM " + tableName[i] + " -- GEMFIREXD-PROPERTIES queryHDFS=true");
                if (rs.next() && rs.getInt(1) > 0) {
                    throw new TestException("selectTotalRowsFromTables failed for table  " + tableName[i] + ", expected 0 but found " + rs.getInt(1));
                }
                Log.getLogWriter().info("total lines read from table " + tableName[i] + " are " + rs.getInt(1));
                Log.getLogWriter().info("VALIDATING TOTAL ROWS ON  " + tableName[i] + " COMPLETED. TOTAL ROWS FETCHED " + rs.getInt(1));
                rs.close();
            }
            statement.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(conn);
    }

    public void displayTotalRowsinTable(String tableName) {
        Connection conn = this.getGFEConnection();
        try {
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT COUNT(*)  FROM " + tableName);
            if (rs.next()) {
                Log.getLogWriter().info("total lines read from table " + tableName + " are " + rs.getInt(1));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
        this.closeGFEConnection(conn);
    }

    public void verifyHdfsDataUsingMR() {
        String[] strArr = SQLPrms.getTableNames();
        Boolean throwException = false;
        StringBuffer exceptionStr = new StringBuffer();
        for (String tableName : strArr) {
            try {
                this.compareMRwithDuplicateTables(tableName);
            }
            catch (TestException te) {
                Log.getLogWriter().info("verifyHdfsDataUsingMR-Do not throw Exception yet - until all tables are verified");
                throwException = true;
                exceptionStr.append(te.getMessage() + "\n");
            }
        }
        if (throwException.booleanValue()) {
            throw new TestException("verifyHdfsDataUsingMR  Failed \n" + exceptionStr);
        }
    }

    public static void HydraTask_waitForWriteOnlyFileRolloverInterval() {
        HDFSStoreDescription hsd = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
        int rolloverInterval = hsd.getWriteOnlyFileRolloverInterval();
        Log.getLogWriter().info("Sleeping for " + rolloverInterval + " seconds to allow for writeOnlyFileRolloverInterval to expire");
        MasterController.sleepForMs((int)(rolloverInterval * 1000));
        Log.getLogWriter().info("Done sleeping for " + rolloverInterval + " seconds to allow for writeOnlyFileRolloverInterval to expire");
    }

    protected String getLocatorEndpoints() {
        List endpoints = NetworkServerHelper.getNetworkLocatorEndpoints();
        StringBuffer endpointString = new StringBuffer();
        endpointString.append(endpoints.get(0));
        for (int i = 1; i < endpoints.size(); ++i) {
            if (i == 1) {
                endpointString.append("/;secondary-locators=");
            } else {
                endpointString.append(",");
            }
            endpointString.append(endpoints.get(i));
        }
        return endpointString.toString();
    }

    public void executeMrJob(String tableName) {
        String mapReduceClassName = (String)((Map)SQLBB.getBB().getSharedMap().get((Object)"mapReduceClasses")).get(tableName);
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        HadoopDescription hdd = HadoopHelper.getHadoopDescription((String)hadoopConfig);
        String confDir = hdd.getResourceManagerDescription().getConfDir();
        HDFSStoreDescription hsd = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
        String homeDir = hsd.getHomeDir();
        String sep = File.separator;
        int vmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String host = RemoteTestModule.getMyHost();
        HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
        Log.getLogWriter().info("all the basic parameters are configured by now");
        String jtests = System.getProperty("JTESTS");
        String MRJarPath = jtests + sep + ".." + sep + "extraJars" + sep + "mapreduce.jar";
        String gemfirexdJarPath = jtests + sep + ".." + sep + ".." + sep + "product-gfxd" + sep + "lib" + sep + "gemfirexd.jar";
        String gemfirexdClientJarPath = jtests + sep + ".." + sep + ".." + sep + "product-gfxd" + sep + "lib" + sep + "gemfirexd-client.jar";
        String hbaseJarPath = jtests + sep + ".." + sep + ".." + sep + "product" + sep + "lib" + sep + "hbase-0.94.4-gemfire*.jar";
        String url = "jdbc:gemfirexd://" + this.getLocatorEndpoints();
        hbaseJarPath = ProcessMgr.fgexec((String[])new String[]{"sh", "-c", "ls -lrt " + hbaseJarPath + "|" + "awk '{print $9} ' "}, (int)100);
        Log.getLogWriter().info("hbase jar file name is " + hbaseJarPath);
        String cmd = "env CLASSPATH=" + System.getProperty("java.class.path") + " ";
        cmd = cmd + "env HADOOP_CLASSPATH=" + System.getProperty("java.class.path") + " ";
        cmd = cmd + hdd.getHadoopDist() + sep + "bin" + sep + "yarn ";
        cmd = cmd + "--config " + confDir + " ";
        cmd = cmd + "jar " + MRJarPath + " ";
        cmd = cmd + mapReduceClassName + " ";
        cmd = cmd + " -libjars  " + MRJarPath + "," + gemfirexdJarPath + "," + hbaseJarPath + "," + gemfirexdClientJarPath + " ";
        cmd = cmd + homeDir + " ";
        cmd = cmd + url + " ";
        String logfn = hd.getUserDir() + sep + "vm_" + vmid + "_" + clientName + "_" + host + "_" + mapReduceClassName + "_" + tableName + "_" + System.currentTimeMillis() + ".log";
        if (hdd.isSecure()) {
            String userKinit = "/export/gcm/where/java/hadoop/hadoop-secure-keytabs/gfxd-secure.keytab gfxd-secure@GEMSTONE.COM";
            HadoopHelper.executeKinitCommand((String)host, (String)userKinit, (int)120);
        }
        int pid = ProcessMgr.bgexec((String)(cmd + tableName), (String)hd.getUserDir(), (String)logfn);
        try {
            RemoteTestModule.Master.recordHDFSPIDNoDumps(hd, pid, false);
        }
        catch (RemoteException e) {
            String s = "Failed to record PID: " + pid;
            throw new HydraRuntimeException(s, (Exception)e);
        }
        int maxWaitSec = (int)TestConfig.tab().longAt(Prms.maxResultWaitSec);
        if (!ProcessMgr.waitForDeath((String)host, (int)pid, (int)maxWaitSec)) {
            String s = "Waited more than " + maxWaitSec + " seconds for MapReduce Job";
            throw new HydraTimeoutException(s);
        }
        try {
            RemoteTestModule.Master.removeHDFSPIDNoDumps(hd, pid, false);
        }
        catch (RemoteException e) {
            Log.getLogWriter().info("execMapReduceJob caught " + e + ": " + TestHelper.getStackTrace((Throwable)e));
            String s = "Failed to remove PID: " + pid;
            throw new HydraRuntimeException(s, (Exception)e);
        }
        Log.getLogWriter().info("Completed MapReduce job  on host " + host + " using command: " + cmd + ", see " + logfn + " for output");
    }

    public void DisplayHdfsFileStruct() {
        String hadoopConfig = ConfigPrms.getHadoopConfig();
        HadoopDescription hdd = HadoopHelper.getHadoopDescription((String)hadoopConfig);
        HDFSStoreDescription hsd = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
        String homeDir = hsd.getHomeDir();
        String sep = File.separator;
        int vmid = RemoteTestModule.getMyVmid();
        String clientName = RemoteTestModule.getMyClientName();
        String host = RemoteTestModule.getMyHost();
        HostDescription hd = TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
        String dirLogfn = hd.getUserDir() + sep + "vm_" + vmid + "_" + clientName + "_" + host + "_" + "DirStructure" + "_" + System.currentTimeMillis() + ".log";
        Log.getLogWriter().info("Hdfs data Structure before Running MR jobs is listed in File: " + homeDir + "/" + dirLogfn);
        if (hdd.isSecure()) {
            String userKinit = "/export/gcm/where/java/hadoop/hadoop-secure-keytabs/gfxd-secure.keytab gfxd-secure@GEMSTONE.COM";
            HadoopHelper.executeKinitCommand((String)host, (String)userKinit, (int)120);
        }
        HadoopHelper.runHadoopCommand((String)hadoopConfig, (String)("fs -ls -R " + homeDir + "/"), (String)dirLogfn);
        if (hdd.getSecurityAuthentication().equals("kerberos")) {
            HadoopHelper.executeKdestroyCommand((String)host, (int)120);
        }
    }

    public void setMapReduceClassName() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (HDFSTestPrms.useMapRedVersion1()) {
            map.put("TRADE.CUSTOMERS", "sql.hdfs.mapreduce.TradeCustomersHdfsDataVerifier");
            map.put("TRADE.BUYORDERS", "sql.hdfs.mapreduce.TradeBuyOrdersHdfsDataVerifier");
            map.put("TRADE.SELLORDERS", "sql.hdfs.mapreduce.TradeSellOrdersHdfsDataVerifier");
            map.put("TRADE.PORTFOLIO", "sql.hdfs.mapreduce.TradePortfolioHdfsDataVerifier");
            map.put("TRADE.NETWORTH", "sql.hdfs.mapreduce.TradeNetworthHdfsDataVerifier");
            map.put("TRADE.TRADES", "sql.hdfs.mapreduce.TradeHdfsDataVerifier");
            map.put("TRADE.SECURITIES", "sql.hdfs.mapreduce.TradeSecurityHdfsDataVerifier");
            map.put("TRADE.TXHISTORY", "sql.hdfs.mapreduce.TradeTxHistoryHdfsDataVerifier");
        } else {
            map.put("TRADE.CUSTOMERS", "sql.hdfs.mapreduce.TradeCustomersHdfsDataVerifierV2");
            map.put("TRADE.BUYORDERS", "sql.hdfs.mapreduce.TradeBuyOrdersHdfsDataVerifierV2");
            map.put("TRADE.SELLORDERS", "sql.hdfs.mapreduce.TradeSellOrdersHdfsDataVerifierV2");
            map.put("TRADE.PORTFOLIO", "sql.hdfs.mapreduce.TradePortfolioHdfsDataVerifierV2");
            map.put("TRADE.NETWORTH", "sql.hdfs.mapreduce.TradeNetworthHdfsDataVerifierV2");
            map.put("TRADE.TRADES", "sql.hdfs.mapreduce.TradeHdfsDataVerifierV2");
            map.put("TRADE.SECURITIES", "sql.hdfs.mapreduce.TradeSecurityHdfsDataVerifierV2");
            map.put("TRADE.TXHISTORY", "sql.hdfs.mapreduce.TradeTxHistoryHdfsDataVerifierV2");
        }
        SQLBB.getBB().getSharedMap().put((Object)"mapReduceClasses", map);
    }

    public void compareMRwithDuplicateTables(String tableName) {
        String queryFullData = "SELECT * FROM " + tableName + SQLTest.DUPLICATE_TABLE_SUFFIX;
        String queryMRData = "SELECT * FROM " + tableName + SQLTest.MR_TABLE_SUFFIX;
        this.compareResults(this.getGFEConnection(), queryMRData, queryFullData, tableName + SQLTest.MR_TABLE_SUFFIX, tableName + SQLTest.DUPLICATE_TABLE_SUFFIX);
        Map hdfsExtnMap = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        String evictionCriteria = (String)hdfsExtnMap.get(tableName.toUpperCase() + EVICTION_CRITERIA);
        if (evictionCriteria != null && hdfsExtnMap.get(tableName.toUpperCase() + STORENAME) != null) {
            queryFullData = "SELECT *  FROM " + tableName + " where " + evictionCriteria;
            Log.getLogWriter().info(" verify that Data is evicted to Hdfs and no matching row found in operational data");
            Connection gConn = this.getGFEConnection();
            List<Struct> rs = this.getResultSet(gConn, queryFullData);
            if (rs.size() > 0) {
                throw new TestException("Following rows are not evicted from " + tableName + "  \n" + rs);
            }
            Log.getLogWriter().info("Query returned " + rs.size() + " rows. All the Data matching eviction Crriteria is evicted to Hdfs");
            Log.getLogWriter().info("comparing the sqlf operational data with fulldataset ");
            String querysqlfData = "SELECT *  FROM " + tableName + " where " + this.getReversedSqlPredicate(evictionCriteria);
            queryFullData = "SELECT *  FROM " + tableName + SQLTest.DUPLICATE_TABLE_SUFFIX + " where " + this.getReversedSqlPredicate(evictionCriteria);
            List<Struct> rs1 = this.getResultSet(gConn, querysqlfData);
            List<Struct> rs2 = this.getResultSet(gConn, queryFullData);
            ResultSetHelper.compareResultSets(rs2, rs1);
        }
    }

    public static void compareMRResultSets(List<Struct> MrResultSet, List<Struct> GFEResultSet, String Mr, String Gfe) {
        Log.getLogWriter().info("size of resultSet from " + Mr + " is " + MrResultSet.size());
        Log.getLogWriter().info("size of resultSet from " + Gfe + " is " + GFEResultSet.size());
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < MrResultSet.size(); ++i) {
            GFEResultSet.remove(MrResultSet.get(i));
        }
        if (GFEResultSet.size() > 0) {
            String errMsg = "The following " + GFEResultSet.size() + " records were missing in the " + Mr + ":\n" + ResultSetHelper.listToString(GFEResultSet);
            Log.getLogWriter().info(errMsg + "\n Total records available in " + Mr + ": are \n " + ResultSetHelper.listToString(MrResultSet));
            throw new TestException(errMsg);
        }
        Log.getLogWriter().info("Verified that all the latest  GFE data for table " + Gfe + " is available in HDFS");
    }

    public void alterEvictionFrequency() {
        Map m = (Map)SQLBB.getBB().getSharedMap().get((Object)"hdfsExtnParams");
        this.alterTableSetEvictionStartTime(this.getGFEConnection(), m);
    }

    public static void dumpHDFSTable(String wanId) {
        String[] tables;
        HDFSStoreDescription hdfsStoreDesc = HDFSStoreHelper.getHDFSStoreDescription(GfxdConfigPrms.getHDFSStoreConfig());
        HadoopDescription hadoopDesc = HadoopHelper.getHadoopDescription((String)ConfigPrms.getHadoopConfig());
        String[] params = new String[4];
        params[0] = hadoopDesc.getNameNodeURL();
        params[1] = hdfsStoreDesc.getHomeDir() + wanId;
        params[3] = "";
        String[] arr$ = tables = new String[]{"TRADE.CUSTOMERS", "TRADE.BUYORDERS", "TRADE.SELLORDERS", "TRADE.PORTFOLIO", "TRADE.NETWORTH", "TRADE.TRADES", "TRADE.SECURITIES", "TRADE.TXHISTORY", "TRADE.COMPANIES", "EMP.EMPLOYEES"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String table;
            params[2] = table = arr$[i$];
            Log.getLogWriter().info("Calling DumpHDFSData: " + params[0] + "; " + params[1] + "; " + params[2] + "; " + params[3]);
            try {
                DumpHDFSData.main((String[])params);
                continue;
            }
            catch (IOException e) {
                Log.getLogWriter().info("dumpHDFSTable exeception caught " + e + ": " + TestHelper.getStackTrace((Throwable)e));
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                Log.getLogWriter().info("dumpHDFSTable exeception caught " + e + ": " + TestHelper.getStackTrace((Throwable)e));
                e.printStackTrace();
                continue;
            }
            catch (SQLException e) {
                Log.getLogWriter().info("dumpHDFSTable exeception caught " + e + ": " + TestHelper.getStackTrace((Throwable)e));
                e.printStackTrace();
            }
        }
    }
}

