/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import hydra.Log;
import java.io.Serializable;
import sql.SQLBB;

public class TriggerQueryObserver
extends GemFireXDQueryObserverAdapter
implements Serializable {
    public void beforeRowTrigger(LanguageConnectionContext lcc, ExecRow execRow, ExecRow newRow) {
        SQLBB.getBB().getSharedCounters().incrementAndRead(SQLBB.triggerInvocationCounter);
    }

    public void afterRowTrigger(TriggerDescriptor trigD, GenericParameterValueSet gpv) {
        String data = " ";
        try {
            String[] columns = trigD.getTableDescriptor().getColumnNamesArray();
            for (int i = 0; i < gpv.getParameterCount(); ++i) {
                if (columns[i].equalsIgnoreCase("companyinfo")) continue;
                data = data + columns[i] + ": " + gpv.getParameter(i) + " ";
            }
        }
        catch (StandardException e) {
            Log.getLogWriter().info("error from TriggerQueryObserver- " + e.getMessage());
        }
        Log.getLogWriter().info(trigD.toString() + " invoked with " + data + " completed successfully");
        long numOfInvocation = SQLBB.getBB().getSharedCounters().decrementAndRead(SQLBB.triggerInvocationCounter);
    }
}

