/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeBuyOrdersHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeBuyOrdersHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeBuyOrdersHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeBuyOrdersRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeBuyOrdersOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeBuyOrdersHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeBuyOrdersHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeBuyOrdersOutputObject {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal bid;
        Timestamp orderTime;

        public TradeBuyOrdersOutputObject(int oid, int cid, int sid, int qty, int tid, String status, BigDecimal bid, Timestamp orderTime) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.status = status;
            this.bid = bid;
            this.orderTime = orderTime;
        }

        public TradeBuyOrdersOutputObject(TradeBuyOrdersRow row) {
            this.oid = row.oid;
            this.cid = row.cid;
            this.sid = row.sid;
            this.tid = row.tid;
            this.qty = row.qty;
            this.status = row.status;
            this.bid = row.bid;
            this.orderTime = row.orderTime;
        }

        public void setOid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.oid);
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setStatus(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.status);
        }

        public void setBid(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.bid);
        }

        public void setOrderTime(int i, PreparedStatement ps) throws SQLException {
            ps.setTimestamp(i, this.orderTime);
        }
    }

    public static class TradeBuyOrdersRow
    implements Writable {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal bid;
        Timestamp orderTime;

        public TradeBuyOrdersRow() {
        }

        public TradeBuyOrdersRow(int oid, int cid, int sid, int tid, int qty, String status, BigDecimal bid, Timestamp orderTime) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.status = status;
            this.bid = bid;
            this.orderTime = orderTime;
        }

        public int getOid() {
            return this.oid;
        }

        public void setOid(int oid) {
            this.oid = oid;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public BigDecimal getBid() {
            return this.bid;
        }

        public void setBid(BigDecimal bid) {
            this.bid = bid;
        }

        public Timestamp getOrderTime() {
            return this.orderTime;
        }

        public void setOrderTime(Timestamp orderTime) {
            this.orderTime = orderTime;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing BuyOrders oid: " + this.oid + " cid: " + this.cid + " sid: " + this.sid + " qty: " + this.qty + " status: " + this.status + " bid: " + this.bid.toPlainString() + " orderTime: " + this.orderTime.getTime() + "tid: " + this.tid);
            out.writeInt(this.oid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.tid);
            out.writeInt(this.qty);
            out.writeUTF(this.status);
            out.writeUTF(this.bid.toPlainString());
            out.writeLong(this.orderTime.getTime());
        }

        public void readFields(DataInput in) throws IOException {
            this.oid = in.readInt();
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.tid = in.readInt();
            this.qty = in.readInt();
            this.status = in.readUTF();
            this.bid = new BigDecimal(in.readUTF());
            this.orderTime = new Timestamp(in.readLong());
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeBuyOrdersRow, Key, TradeBuyOrdersOutputObject> {
        public void reduce(Text key, Iterator<TradeBuyOrdersRow> values, OutputCollector<Key, TradeBuyOrdersOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeBuyOrdersRow buyorder = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)buyorder.getOid()));
                    output.collect((Object)k, (Object)new TradeBuyOrdersOutputObject(buyorder));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeBuyOrdersRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeBuyOrdersRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int oid = rs.getInt("oid");
                    output.collect((Object)new Text(Integer.toString(oid)), (Object)new TradeBuyOrdersRow(oid, rs.getInt("cid"), rs.getInt("sid"), rs.getInt("tid"), rs.getInt("qty"), rs.getString("status"), rs.getBigDecimal("bid"), rs.getTimestamp("ordertime")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

