/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeCustomersHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeCustomersHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeCustomersHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeCustomersRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeCustomerOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeCustomersHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeCustomersHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeCustomerOutputObject {
        int cid;
        int tid;
        String cust_name;
        String addr;
        Date since;

        public TradeCustomerOutputObject(int cid, int tid, String cname, String addr, Date since) {
            this.cid = cid;
            this.tid = tid;
            this.cust_name = cname;
            this.addr = addr;
            this.since = since;
        }

        public TradeCustomerOutputObject(TradeCustomersRow row) {
            this.cid = row.cid;
            this.tid = row.tid;
            this.cust_name = row.cname;
            this.addr = row.addr;
            this.since = row.since;
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setCust_name(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.cust_name);
        }

        public void setAddr(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.addr);
        }

        public void setSince(int i, PreparedStatement ps) throws SQLException {
            ps.setDate(i, this.since);
        }
    }

    public static class TradeCustomersRow
    implements Writable {
        int cid;
        int tid;
        String cname;
        String addr;
        Date since;

        public TradeCustomersRow() {
        }

        public TradeCustomersRow(int cid, int tid, String cname, String addr, Date since) {
            this.cname = cname;
            this.cid = cid;
            this.tid = tid;
            this.addr = addr;
            this.since = since;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public String getCname() {
            return this.cname;
        }

        public void setCname(String cname) {
            this.cname = cname;
        }

        public String getAddr() {
            return this.addr;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        public Date getSince() {
            return this.since;
        }

        public void setSince(Date since) {
            this.since = since;
        }

        public void write(DataOutput out) throws IOException {
            if (this.cname == null || this.cname.equals("")) {
                this.cname = " ";
            }
            System.out.println("writing Customer cid: " + this.cid + " tid: " + this.tid + " since: " + this.since.getTime() + " cname: " + this.cname + " addr: " + this.addr);
            out.writeInt(this.cid);
            out.writeInt(this.tid);
            out.writeLong(this.since.getTime());
            out.writeUTF(this.cname);
            out.writeUTF(this.addr);
        }

        public void readFields(DataInput in) throws IOException {
            this.cid = in.readInt();
            this.tid = in.readInt();
            this.since = new Date(in.readLong());
            this.cname = in.readUTF();
            this.addr = in.readUTF();
            this.cname = this.cname.equals(" ") ? null : this.cname;
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeCustomersRow, Key, TradeCustomerOutputObject> {
        public void reduce(Text key, Iterator<TradeCustomersRow> values, OutputCollector<Key, TradeCustomerOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeCustomersRow customer = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)customer.getCid()));
                    output.collect((Object)k, (Object)new TradeCustomerOutputObject(customer));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeCustomersRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeCustomersRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int cid = rs.getInt("cid");
                    output.collect((Object)new Text(Integer.toString(cid)), (Object)new TradeCustomersRow(cid, rs.getInt("tid"), rs.getString("cust_name"), rs.getString("addr"), rs.getDate("since")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

