/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeNetworthHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeSecurityHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeSecurityHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeNetworthRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeNetworthOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeSecurityHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeNetworthHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeNetworthOutputObject {
        int cid;
        int tid;
        int loanLimit;
        BigDecimal cash;
        BigDecimal securities;
        BigDecimal availLoan;

        public TradeNetworthOutputObject() {
        }

        public TradeNetworthOutputObject(int cid, int tid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan) {
            this.cid = cid;
            this.tid = tid;
            this.cash = cash;
            this.securities = securities;
            this.loanLimit = loanLimit;
            this.availLoan = availLoan;
        }

        public TradeNetworthOutputObject(TradeNetworthRow row) {
            this.cid = row.cid;
            this.tid = row.tid;
            this.cash = row.cash;
            this.securities = row.securities;
            this.loanLimit = row.loanLimit;
            this.availLoan = row.availLoan;
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setCash(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.cash);
        }

        public void setSecurities(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.securities);
        }

        public void setLoanLimit(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.loanLimit);
        }

        public void setAvailLoan(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.availLoan);
        }
    }

    public static class TradeNetworthRow
    implements Writable {
        int cid;
        int tid;
        int loanLimit;
        BigDecimal cash;
        BigDecimal securities;
        BigDecimal availLoan;

        public TradeNetworthRow() {
        }

        public TradeNetworthRow(int cid, int tid, BigDecimal cash, BigDecimal securities, int loanLimit, BigDecimal availLoan) {
            this.cid = cid;
            this.tid = tid;
            this.cash = cash;
            this.securities = securities;
            this.loanLimit = loanLimit;
            this.availLoan = availLoan;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public BigDecimal getCash() {
            return this.cash;
        }

        public void setCash(BigDecimal cash) {
            this.cash = cash;
        }

        public BigDecimal getSecurities() {
            return this.securities;
        }

        public void setSecurities(BigDecimal securities) {
            this.securities = securities;
        }

        public int getLoanLimit() {
            return this.loanLimit;
        }

        public void setLoanLimit(int loanLimit) {
            this.loanLimit = loanLimit;
        }

        public BigDecimal getAvailLoan() {
            return this.availLoan;
        }

        public void setAvailLoan(BigDecimal availLoan) {
            this.availLoan = availLoan;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Networth cid: " + this.cid + " tid: " + this.tid + " cash: " + this.cash.toPlainString() + " securities: " + this.securities.toPlainString() + " loanLimit: " + this.loanLimit + " availLoan: " + this.availLoan.toPlainString());
            out.writeInt(this.cid);
            out.writeInt(this.tid);
            out.writeUTF(this.cash.toPlainString());
            out.writeUTF(this.securities.toPlainString());
            out.writeInt(this.loanLimit);
            out.writeUTF(this.availLoan.toPlainString());
        }

        public void readFields(DataInput in) throws IOException {
            this.cid = in.readInt();
            this.tid = in.readInt();
            this.cash = new BigDecimal(in.readUTF());
            this.securities = new BigDecimal(in.readUTF());
            this.loanLimit = in.readInt();
            this.availLoan = new BigDecimal(in.readUTF());
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeNetworthRow, Key, TradeNetworthOutputObject> {
        public void reduce(Text key, Iterator<TradeNetworthRow> values, OutputCollector<Key, TradeNetworthOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeNetworthRow networth = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)networth.getCid()));
                    output.collect((Object)k, (Object)new TradeNetworthOutputObject(networth));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeNetworthRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeNetworthRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int cid = rs.getInt("cid");
                    output.collect((Object)new Text(Integer.toString(cid)), (Object)new TradeNetworthRow(cid, rs.getInt("tid"), rs.getBigDecimal("cash"), rs.getBigDecimal("securities"), rs.getInt("loanlimit"), rs.getBigDecimal("availloan")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

