/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradePortfolioHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradePortfolioHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradePortfolioHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradePortfolioRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradePortfolioOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradePortfolioHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradePortfolioHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradePortfolioOutputObject {
        int cid;
        int sid;
        int tid;
        int qty;
        int availQty;
        BigDecimal subTotal;

        public TradePortfolioOutputObject(int cid, int sid, int tid, int qty, int availQty, BigDecimal subTotal) {
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.availQty = availQty;
            this.subTotal = subTotal;
        }

        public TradePortfolioOutputObject(TradePortfolioRow row) {
            this.cid = row.cid;
            this.sid = row.sid;
            this.tid = row.tid;
            this.qty = row.qty;
            this.availQty = row.availQty;
            this.subTotal = row.subTotal;
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setAvailQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.availQty);
        }

        public void setSubTotal(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.subTotal);
        }
    }

    public static class TradePortfolioRow
    implements Writable {
        int cid;
        int sid;
        int tid;
        int qty;
        int availQty;
        BigDecimal subTotal;

        public TradePortfolioRow() {
        }

        public TradePortfolioRow(int cid, int sid, int tid, int qty, int availQty, BigDecimal subTotal) {
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.availQty = availQty;
            this.subTotal = subTotal;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public int getAvailQty() {
            return this.availQty;
        }

        public void setAvailQty(int availQty) {
            this.availQty = availQty;
        }

        public BigDecimal getSubTotal() {
            return this.subTotal;
        }

        public void setSubTotal(BigDecimal subTotal) {
            this.subTotal = subTotal;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Portfolio cid: " + this.cid + " sid: " + this.sid + " qty: " + this.qty + " availQty: " + this.availQty + " subTotal: " + this.subTotal.toPlainString() + " tid: " + this.tid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.tid);
            out.writeInt(this.qty);
            out.writeInt(this.availQty);
            out.writeUTF(this.subTotal.toPlainString());
        }

        public void readFields(DataInput in) throws IOException {
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.tid = in.readInt();
            this.qty = in.readInt();
            this.availQty = in.readInt();
            this.subTotal = new BigDecimal(in.readUTF());
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradePortfolioRow, Key, TradePortfolioOutputObject> {
        public void reduce(Text key, Iterator<TradePortfolioRow> values, OutputCollector<Key, TradePortfolioOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradePortfolioRow portfolio = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)(portfolio.getSid() + portfolio.getCid())));
                    output.collect((Object)k, (Object)new TradePortfolioOutputObject(portfolio));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradePortfolioRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradePortfolioRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int sid = rs.getInt("sid");
                    int cid = rs.getInt("cid");
                    output.collect((Object)new Text(Integer.toString(sid) + Integer.toString(cid)), (Object)new TradePortfolioRow(cid, sid, rs.getInt("tid"), rs.getInt("qty"), rs.getInt("availQty"), rs.getBigDecimal("subTotal")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

