/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.hadoop.mapreduce.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradePortfolioHdfsDataVerifierV2
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        Configuration conf = this.getConf();
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradePortfolioHdfsDataVerifierV2.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        Job job = Job.getInstance((Configuration)conf, (String)"TradePortfolioHdfsDataVerifierV2");
        job.setJobName("TradePortfolioHdfsDataVerifierV2");
        job.setInputFormatClass(RowInputFormat.class);
        job.setOutputFormatClass(RowOutputFormat.class);
        job.setMapperClass(HdfsDataMapper.class);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(TradePortfolioRow.class);
        job.setReducerClass(HdfsDataReducer.class);
        job.setOutputKeyClass(Key.class);
        job.setOutputValueClass(TradePortfolioOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        return job.waitForCompletion(false) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradePortfolioHdfsDataVerifierV2.main() invoked with " + args);
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new TradePortfolioHdfsDataVerifierV2(), (String[])args);
        System.exit(rc);
    }

    public static class TradePortfolioOutputObject {
        int cid;
        int sid;
        int tid;
        int qty;
        int availQty;
        BigDecimal subTotal;

        public TradePortfolioOutputObject(int cid, int sid, int tid, int qty, int availQty, BigDecimal subTotal) {
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.availQty = availQty;
            this.subTotal = subTotal;
        }

        public TradePortfolioOutputObject(TradePortfolioRow row) {
            this.cid = row.cid;
            this.sid = row.sid;
            this.tid = row.tid;
            this.qty = row.qty;
            this.availQty = row.availQty;
            this.subTotal = row.subTotal;
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setAvailQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.availQty);
        }

        public void setSubTotal(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.subTotal);
        }
    }

    public static class TradePortfolioRow
    implements Writable {
        int cid;
        int sid;
        int tid;
        int qty;
        int availQty;
        BigDecimal subTotal;

        public TradePortfolioRow() {
        }

        public TradePortfolioRow(int cid, int sid, int tid, int qty, int availQty, BigDecimal subTotal) {
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.availQty = availQty;
            this.subTotal = subTotal;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public int getAvailQty() {
            return this.availQty;
        }

        public void setAvailQty(int availQty) {
            this.availQty = availQty;
        }

        public BigDecimal getSubTotal() {
            return this.subTotal;
        }

        public void setSubTotal(BigDecimal subTotal) {
            this.subTotal = subTotal;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Portfolio cid: " + this.cid + " sid: " + this.sid + " qty: " + this.qty + " availQty: " + this.availQty + " subTotal: " + this.subTotal.toPlainString() + " tid: " + this.tid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.tid);
            out.writeInt(this.qty);
            out.writeInt(this.availQty);
            out.writeUTF(this.subTotal.toPlainString());
        }

        public void readFields(DataInput in) throws IOException {
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.tid = in.readInt();
            this.qty = in.readInt();
            this.availQty = in.readInt();
            this.subTotal = new BigDecimal(in.readUTF());
        }
    }

    public static class HdfsDataReducer
    extends Reducer<Key, TradePortfolioRow, Key, TradePortfolioOutputObject> {
        public void reduce(Key key, Iterable<TradePortfolioRow> values, Reducer.Context context) throws IOException, InterruptedException {
            try {
                for (TradePortfolioRow portfolio : values) {
                    context.write((Object)key, (Object)new TradePortfolioOutputObject(portfolio));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends Mapper<Key, Row, Key, TradePortfolioRow> {
        public void map(Key key, Row value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int sid = rs.getInt("sid");
                    int cid = rs.getInt("cid");
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)(sid + cid)));
                    context.write((Object)k, (Object)new TradePortfolioRow(cid, sid, rs.getInt("tid"), rs.getInt("qty"), rs.getInt("availQty"), rs.getBigDecimal("subTotal")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

