/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeSecurityHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeSecurityHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeSecurityHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeSecurityRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeSecurityOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeSecurityHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeSecurityHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeSecurityOutputObject {
        int sec_id;
        int tid;
        String symbol;
        String exchange;
        BigDecimal price;

        public TradeSecurityOutputObject(int secId, int tid, String symbol, String exchange, BigDecimal price) {
            this.sec_id = secId;
            this.tid = tid;
            this.symbol = symbol;
            this.exchange = exchange;
            this.price = price;
        }

        public TradeSecurityOutputObject(TradeSecurityRow row) {
            this.sec_id = row.secId;
            this.tid = row.tid;
            this.symbol = row.symbol;
            this.exchange = row.exchange;
            this.price = row.price;
        }

        public void setSec_id(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sec_id);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setSymbol(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.symbol);
        }

        public void setExchange(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.exchange);
        }

        public void setPrice(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.price);
        }
    }

    public static class TradeSecurityRow
    implements Writable {
        int secId;
        int tid;
        String symbol;
        String exchange;
        BigDecimal price;

        public TradeSecurityRow() {
        }

        public TradeSecurityRow(int secId, int tid, String symbol, String exchange, BigDecimal price) {
            this.secId = secId;
            this.tid = tid;
            this.symbol = symbol;
            this.exchange = exchange;
            this.price = price;
        }

        public int getSecId() {
            return this.secId;
        }

        public void setSecId(int secId) {
            this.secId = secId;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getExchange() {
            return this.exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Securities sid: " + this.secId + " price: " + this.price.toPlainString() + " symbol: " + this.symbol + " exchange: " + this.exchange + "tid: " + this.tid);
            out.writeInt(this.secId);
            out.writeInt(this.tid);
            out.writeUTF(this.price.toPlainString());
            out.writeUTF(this.symbol);
            out.writeUTF(this.exchange);
        }

        public void readFields(DataInput in) throws IOException {
            this.secId = in.readInt();
            this.tid = in.readInt();
            this.price = new BigDecimal(in.readUTF());
            this.symbol = in.readUTF();
            this.exchange = in.readUTF();
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeSecurityRow, Key, TradeSecurityOutputObject> {
        public void reduce(Text key, Iterator<TradeSecurityRow> values, OutputCollector<Key, TradeSecurityOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeSecurityRow trade = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)trade.getSecId()));
                    output.collect((Object)k, (Object)new TradeSecurityOutputObject(trade));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeSecurityRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeSecurityRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int secId = rs.getInt("sec_id");
                    output.collect((Object)new Text(Integer.toString(secId)), (Object)new TradeSecurityRow(secId, rs.getInt("tid"), rs.getString("symbol"), rs.getString("exchange"), rs.getBigDecimal("price")));
                }
            }
            catch (SQLException se) {
                throw new IOException(se);
            }
        }
    }
}

