/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeSellOrdersHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeSellOrdersHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeSellOrdersHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeSellOrdersRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeSellOrdersOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeSellOrdersHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeSellOrdersHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeSellOrdersOutputObject {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal ask;
        Timestamp orderTime;

        public TradeSellOrdersOutputObject(int oid, int cid, int sid, int qty, String status, BigDecimal ask, Timestamp orderTime, int tid) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.qty = qty;
            this.status = status;
            this.ask = ask;
            this.orderTime = orderTime;
            this.tid = tid;
        }

        public TradeSellOrdersOutputObject(TradeSellOrdersRow row) {
            this.oid = row.oid;
            this.cid = row.cid;
            this.sid = row.sid;
            this.qty = row.qty;
            this.status = row.status;
            this.ask = row.ask;
            this.orderTime = row.orderTime;
            this.tid = row.tid;
        }

        public void setOid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.oid);
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setStatus(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.status);
        }

        public void setAsk(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.ask);
        }

        public void setOrder_Time(int i, PreparedStatement ps) throws SQLException {
            ps.setTimestamp(i, this.orderTime);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }
    }

    public static class TradeSellOrdersRow
    implements Writable {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal ask;
        Timestamp orderTime;

        public TradeSellOrdersRow() {
        }

        public TradeSellOrdersRow(int oid, int cid, int sid, int qty, String status, BigDecimal ask, Timestamp orderTime, int tid) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.qty = qty;
            this.status = status;
            this.ask = ask;
            this.orderTime = orderTime;
            this.tid = tid;
        }

        public int getOid() {
            return this.oid;
        }

        public void setOid(int oid) {
            this.oid = oid;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public BigDecimal getAsk() {
            return this.ask;
        }

        public void setAsk(BigDecimal ask) {
            this.ask = ask;
        }

        public Timestamp getOrderTime() {
            return this.orderTime;
        }

        public void setOrderTime(Timestamp orderTime) {
            this.orderTime = orderTime;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Sellorders oid: " + this.oid + " cid: " + this.cid + " sid: " + this.sid + " qty: " + this.qty + " status: " + this.status + " ask: " + this.ask.toPlainString() + " orderTime: " + this.orderTime.getTime() + " tid: " + this.tid);
            out.writeInt(this.oid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.qty);
            out.writeUTF(this.status);
            out.writeUTF(this.ask.toPlainString());
            out.writeLong(this.orderTime.getTime());
            out.writeInt(this.tid);
        }

        public void readFields(DataInput in) throws IOException {
            this.oid = in.readInt();
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.qty = in.readInt();
            this.status = in.readUTF();
            this.ask = new BigDecimal(in.readUTF());
            this.orderTime = new Timestamp(in.readLong());
            this.tid = in.readInt();
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeSellOrdersRow, Key, TradeSellOrdersOutputObject> {
        public void reduce(Text key, Iterator<TradeSellOrdersRow> values, OutputCollector<Key, TradeSellOrdersOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeSellOrdersRow sellorder = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)sellorder.getOid()));
                    output.collect((Object)k, (Object)new TradeSellOrdersOutputObject(sellorder));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeSellOrdersRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeSellOrdersRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int oid = rs.getInt("oid");
                    output.collect((Object)new Text(Integer.toString(oid)), (Object)new TradeSellOrdersRow(oid, rs.getInt("cid"), rs.getInt("sid"), rs.getInt("qty"), rs.getString("status"), rs.getBigDecimal("ask"), rs.getTimestamp("order_time"), rs.getInt("tid")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

