/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.hadoop.mapreduce.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeSellOrdersHdfsDataVerifierV2
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        Configuration conf = this.getConf();
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeSellOrdersHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        Job job = Job.getInstance((Configuration)conf, (String)"TradeSellOrdersHdfsDataVerifierV2");
        job.setJobName("TradeSellOrdersHdfsDataVerifierV2");
        job.setInputFormatClass(RowInputFormat.class);
        job.setOutputFormatClass(RowOutputFormat.class);
        job.setMapperClass(HdfsDataMapper.class);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(TradeSellOrdersRow.class);
        job.setReducerClass(HdfsDataReducer.class);
        job.setOutputKeyClass(Key.class);
        job.setOutputValueClass(TradeSellOrdersOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        return job.waitForCompletion(false) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeSellOrdersHdfsDataVerifierV2.main() invoked with " + args);
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new TradeSellOrdersHdfsDataVerifierV2(), (String[])args);
        System.exit(rc);
    }

    public static class TradeSellOrdersOutputObject {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal ask;
        Timestamp orderTime;

        public TradeSellOrdersOutputObject(int oid, int cid, int sid, int qty, String status, BigDecimal ask, Timestamp orderTime, int tid) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.qty = qty;
            this.status = status;
            this.ask = ask;
            this.orderTime = orderTime;
            this.tid = tid;
        }

        public TradeSellOrdersOutputObject(TradeSellOrdersRow row) {
            this.oid = row.oid;
            this.cid = row.cid;
            this.sid = row.sid;
            this.qty = row.qty;
            this.status = row.status;
            this.ask = row.ask;
            this.orderTime = row.orderTime;
            this.tid = row.tid;
        }

        public void setOid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.oid);
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setStatus(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.status);
        }

        public void setAsk(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.ask);
        }

        public void setOrder_Time(int i, PreparedStatement ps) throws SQLException {
            ps.setTimestamp(i, this.orderTime);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }
    }

    public static class TradeSellOrdersRow
    implements Writable {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String status;
        BigDecimal ask;
        Timestamp orderTime;

        public TradeSellOrdersRow() {
        }

        public TradeSellOrdersRow(int oid, int cid, int sid, int qty, String status, BigDecimal ask, Timestamp orderTime, int tid) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.qty = qty;
            this.status = status;
            this.ask = ask;
            this.orderTime = orderTime;
            this.tid = tid;
        }

        public int getOid() {
            return this.oid;
        }

        public void setOid(int oid) {
            this.oid = oid;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public BigDecimal getAsk() {
            return this.ask;
        }

        public void setAsk(BigDecimal ask) {
            this.ask = ask;
        }

        public Timestamp getOrderTime() {
            return this.orderTime;
        }

        public void setOrderTime(Timestamp orderTime) {
            this.orderTime = orderTime;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Sellorders oid: " + this.oid + " cid: " + this.cid + " sid: " + this.sid + " qty: " + this.qty + " status: " + this.status + " ask: " + this.ask.toPlainString() + " orderTime: " + this.orderTime.getTime() + " tid: " + this.tid);
            out.writeInt(this.oid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.qty);
            out.writeUTF(this.status);
            out.writeUTF(this.ask.toPlainString());
            out.writeLong(this.orderTime.getTime());
            out.writeInt(this.tid);
        }

        public void readFields(DataInput in) throws IOException {
            this.oid = in.readInt();
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.qty = in.readInt();
            this.status = in.readUTF();
            this.ask = new BigDecimal(in.readUTF());
            this.orderTime = new Timestamp(in.readLong());
            this.tid = in.readInt();
        }
    }

    public static class HdfsDataReducer
    extends Reducer<Key, TradeSellOrdersRow, Key, TradeSellOrdersOutputObject> {
        public void reduce(Key key, Iterable<TradeSellOrdersRow> values, Reducer.Context context) throws IOException, InterruptedException {
            try {
                for (TradeSellOrdersRow sellorder : values) {
                    context.write((Object)key, (Object)new TradeSellOrdersOutputObject(sellorder));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends Mapper<Key, Row, Key, TradeSellOrdersRow> {
        public void map(Key key, Row value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int oid = rs.getInt("oid");
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)oid));
                    context.write((Object)k, (Object)new TradeSellOrdersRow(oid, rs.getInt("cid"), rs.getInt("sid"), rs.getInt("qty"), rs.getString("status"), rs.getBigDecimal("ask"), rs.getTimestamp("order_time"), rs.getInt("tid")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

