/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradeTxHistoryHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradeTxHistoryHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradeTxHistoryHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradeTxHistoryRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeTxHistoryOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradeTxHistoryHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradeTxHistoryHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeTxHistoryOutputObject {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String type;
        BigDecimal price;
        Timestamp orderTime;

        public TradeTxHistoryOutputObject(int oid, int cid, int sid, int qty, int tid, String type, BigDecimal price, Timestamp orderTime) {
            Timestamp ts = new Timestamp(1000L);
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.type = type;
            this.price = price;
            this.orderTime = orderTime;
        }

        public TradeTxHistoryOutputObject(TradeTxHistoryRow row) {
            this.oid = row.oid;
            this.cid = row.cid;
            this.sid = row.sid;
            this.tid = row.tid;
            this.qty = row.qty;
            this.type = row.type;
            this.price = row.price;
            this.orderTime = row.orderTime;
        }

        public void setOid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.oid);
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setSid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.sid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setQty(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.qty);
        }

        public void setType(int i, PreparedStatement ps) throws SQLException {
            ps.setString(i, this.type);
        }

        public void setPrice(int i, PreparedStatement ps) throws SQLException {
            ps.setBigDecimal(i, this.price);
        }

        public void setOrderTime(int i, PreparedStatement ps) throws SQLException {
            ps.setTimestamp(i, this.orderTime);
        }
    }

    public static class TradeTxHistoryRow
    implements Writable {
        int oid;
        int cid;
        int sid;
        int qty;
        int tid;
        String type;
        BigDecimal price;
        Timestamp orderTime;

        public TradeTxHistoryRow() {
        }

        public TradeTxHistoryRow(int oid, int cid, int sid, int tid, int qty, String type, BigDecimal price, Timestamp orderTime) {
            this.oid = oid;
            this.cid = cid;
            this.sid = sid;
            this.tid = tid;
            this.qty = qty;
            this.type = type;
            this.price = price;
            this.orderTime = orderTime;
        }

        public int getOid() {
            return this.oid;
        }

        public void setOid(int oid) {
            this.oid = oid;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int sid) {
            this.sid = sid;
        }

        public int getQty() {
            return this.qty;
        }

        public void setQty(int qty) {
            this.qty = qty;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public Timestamp getOrderTime() {
            return this.orderTime;
        }

        public void setOrderTime(Timestamp orderTime) {
            this.orderTime = orderTime;
        }

        public void write(DataOutput out) throws IOException {
            if (this.orderTime == null) {
                this.orderTime = new Timestamp(1000L);
            }
            if (this.type == null || this.type.equals("")) {
                this.type = " ";
            }
            System.out.println("writing Txhistory oid: " + this.oid + " cid: " + this.cid + " sid: " + this.sid + " tid: " + this.tid + " qty: " + this.qty + " type: " + this.type + " price: " + this.price.toPlainString() + " orderTime: " + this.orderTime);
            out.writeInt(this.oid);
            out.writeInt(this.cid);
            out.writeInt(this.sid);
            out.writeInt(this.tid);
            out.writeInt(this.qty);
            out.writeUTF(this.type);
            out.writeUTF(this.price.toPlainString());
            out.writeLong(this.orderTime.getTime());
        }

        public void readFields(DataInput in) throws IOException {
            this.oid = in.readInt();
            this.cid = in.readInt();
            this.sid = in.readInt();
            this.tid = in.readInt();
            this.qty = in.readInt();
            this.type = in.readUTF();
            this.price = new BigDecimal(in.readUTF());
            this.orderTime = new Timestamp(in.readLong());
            this.type = this.type.equals(" ") ? null : this.type;
            this.orderTime = this.orderTime.equals(new Timestamp(1000L)) ? null : this.orderTime;
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradeTxHistoryRow, Key, TradeTxHistoryOutputObject> {
        public void reduce(Text key, Iterator<TradeTxHistoryRow> values, OutputCollector<Key, TradeTxHistoryOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradeTxHistoryRow history = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)("Key" + history.getCid() + history.getSid() + history.getTid() + history.getQty())));
                    output.collect((Object)k, (Object)new TradeTxHistoryOutputObject(history));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradeTxHistoryRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradeTxHistoryRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    String text = "Key" + rs.getInt("cid") + rs.getInt("sid") + rs.getInt("tid") + rs.getInt("qty");
                    output.collect((Object)new Text(text), (Object)new TradeTxHistoryRow(rs.getInt("oid"), rs.getInt("cid"), rs.getInt("sid"), rs.getInt("tid"), rs.getInt("qty"), rs.getString("type"), rs.getBigDecimal("price"), rs.getTimestamp("ordertime")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

