/*
 * Decompiled with CFR 0.152.
 */
package sql.hdfs.mapreduce;

import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.gemfirexd.hadoop.mapred.RowInputFormat;
import com.pivotal.gemfirexd.hadoop.mapred.RowOutputFormat;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TradesHdfsDataVerifier
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        GfxdDataSerializable.initTypes();
        JobConf conf = new JobConf(this.getConf());
        conf.setJobName("TradesHdfsDataVerifier");
        String hdfsHomeDir = args[0];
        String url = args[1];
        String tableName = args[2];
        System.out.println("TradesHdfsDataVerifier.run() invoked with  hdfsHomeDir = " + hdfsHomeDir + " url = " + url + " tableName = " + tableName);
        conf.set("gfxd.input.homedir", hdfsHomeDir);
        conf.set("gfxd.input.tablename", tableName);
        conf.setBoolean("gfxd.input.checkpointmode", false);
        conf.setInputFormat(RowInputFormat.class);
        conf.setMapperClass(HdfsDataMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMapOutputValueClass(TradesRow.class);
        conf.setReducerClass(HdfsDataReducer.class);
        conf.set("gfxd.output.tablename", tableName + "_HDFS");
        conf.set("gfxd.output.dburl", url);
        conf.setOutputFormat(RowOutputFormat.class);
        conf.setOutputKeyClass(Key.class);
        conf.setOutputValueClass(TradeOutputObject.class);
        StringBuffer aStr = new StringBuffer();
        aStr.append("HOME_DIR = " + conf.get("gfxd.input.homedir") + " ");
        aStr.append("INPUT_TABLE = " + conf.get("gfxd.input.tablename") + " ");
        aStr.append("OUTPUT_TABLE = " + conf.get("gfxd.output.tablename") + " ");
        aStr.append("OUTPUT_URL = " + conf.get("gfxd.output.dburl") + " ");
        System.out.println("VerifyHdfsData running with the following conf: " + aStr.toString());
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path("" + System.currentTimeMillis()));
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TradesHdfsDataVerifier.main() invoked with " + args);
        int rc = ToolRunner.run((Tool)new TradesHdfsDataVerifier(), (String[])args);
        System.exit(rc);
    }

    public static class TradeOutputObject {
        int cid;
        int tid;
        int eid;
        Date tradeDate;

        public TradeOutputObject(int cid, int tid, int eid, Date tradeDate) {
            this.cid = cid;
            this.tid = tid;
            this.eid = eid;
            this.tradeDate = tradeDate;
        }

        public TradeOutputObject(TradesRow row) {
            this.cid = row.cid;
            this.tid = row.tid;
            this.eid = row.eid;
            this.tradeDate = row.tradeDate;
        }

        public void setCid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.cid);
        }

        public void setTid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.tid);
        }

        public void setEid(int i, PreparedStatement ps) throws SQLException {
            ps.setInt(i, this.eid);
        }

        public void setTradeDate(int i, PreparedStatement ps) throws SQLException {
            ps.setDate(i, this.tradeDate);
        }
    }

    public static class TradesRow
    implements Writable {
        int cid;
        int tid;
        int eid;
        Date tradeDate;

        public TradesRow() {
        }

        public TradesRow(int cid, int tid, int eid, Date tradeDate) {
            this.cid = cid;
            this.tid = tid;
            this.eid = eid;
            this.tradeDate = tradeDate;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int cid) {
            this.cid = cid;
        }

        public int getTid() {
            return this.tid;
        }

        public void setTid(int tid) {
            this.tid = tid;
        }

        public int getEid() {
            return this.eid;
        }

        public void setEid(int eid) {
            this.eid = eid;
        }

        public Date getTradeDate() {
            return this.tradeDate;
        }

        public void setTradeDate(Date tradeDate) {
            this.tradeDate = tradeDate;
        }

        public void write(DataOutput out) throws IOException {
            System.out.println("writing Trades cid:" + this.cid + " tid: " + this.tid + " eid: " + this.eid + " tradeDate: " + this.tradeDate.getTime());
            out.writeInt(this.cid);
            out.writeInt(this.tid);
            out.writeInt(this.eid);
            out.writeLong(this.tradeDate.getTime());
        }

        public void readFields(DataInput in) throws IOException {
            this.cid = in.readInt();
            this.tid = in.readInt();
            this.eid = in.readInt();
            this.tradeDate = new Date(in.readLong());
        }
    }

    public static class HdfsDataReducer
    extends MapReduceBase
    implements Reducer<Text, TradesRow, Key, TradeOutputObject> {
        public void reduce(Text key, Iterator<TradesRow> values, OutputCollector<Key, TradeOutputObject> output, Reporter reporter) throws IOException {
            try {
                while (values.hasNext()) {
                    TradesRow trade = values.next();
                    Key k = new Key();
                    k.setKey(CacheServerHelper.serialize((Object)trade.getTid()));
                    output.collect((Object)k, (Object)new TradeOutputObject(trade));
                }
            }
            catch (Exception e) {
                System.out.println("error in reducer " + e.getMessage());
                throw new IOException(e);
            }
        }
    }

    public static class HdfsDataMapper
    extends MapReduceBase
    implements Mapper<Key, Row, Text, TradesRow> {
        public void map(Key key, Row value, OutputCollector<Text, TradesRow> output, Reporter reporter) throws IOException {
            try {
                if (!value.getEventType().equals((Object)Event.Type.AFTER_DELETE)) {
                    ResultSet rs = value.getRowAsResultSet();
                    int tid = rs.getInt("tid");
                    output.collect((Object)new Text(Integer.toString(tid)), (Object)new TradesRow(rs.getInt("cid"), tid, rs.getInt("eid"), rs.getDate("tradeDate")));
                }
            }
            catch (SQLException se) {
                System.err.println("mapper -  -Error logging result set" + se);
                throw new IOException(se);
            }
        }
    }
}

