/*
 * Decompiled with CFR 0.152.
 */
package sql.joinStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.AbstractJoinStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class CustPortfSoJoinStmt
extends AbstractJoinStmt {
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and c.tid=? order by ask", "select f.cid, cust_name, f.sid, so.sid, f.qty, subTotal, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and status=? and f.tid = ? order by ask", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, oid, order_time, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and subTotal >10000 and c.cid>? and f.tid = ? order by order_time", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, order_time, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and so.cid<? and ask >? and ask <? and f.tid = ? order by so.qty desc, subtotal", "select * from trade.customers c LEFT OUTER JOIN trade.portfolio f LEFT OUTER JOIN trade.sellorders so on f.cid = so.cid on c.cid= f.cid where f.tid = ? ", "select * from (trade.customers c LEFT JOIN trade.portfolio f on c.cid= f.cid) LEFT JOIN trade.sellorders so on f.cid = so.cid where f.tid = ? order by so.cid, so.oid"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid order by ask", "select f.cid, cust_name, f.sid, so.sid, f.qty, subTotal, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and status=?  order by ask", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, oid, order_time, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and subTotal >10000 and f.cid>? order by order_time", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, order_time, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and so.cid<? and ask >? and ask <? order by so.qty desc, subtotal", "select * from trade.customers c LEFT OUTER JOIN trade.portfolio f LEFT OUTER JOIN trade.sellorders so on f.cid = so.cid on c.cid= f.cid where so.sid < 100 and so.qty > 500"};
    protected static String[] uniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and c.tid=? order by ask", "select f.cid, cust_name, f.sid, so.sid, f.qty, subTotal, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and status=? and f.tid = ? order by ask", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, oid, order_time, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and subTotal >10000 and c.cid>? and f.tid = ? order by order_time", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, order_time, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and so.cid<? and ask >? and ask <? and f.tid = ? order by so.qty desc, subtotal", "select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n LEFT OUTER JOIN trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n LEFT OUTER JOIN trade.sellorders so on f.cid = so.cid on c.cid= f.cid where f.tid = ? ", "select * from (trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n LEFT JOIN trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n on c.cid= f.cid) LEFT JOIN trade.sellorders so on f.cid = so.cid where f.tid = ? order by so.cid, so.oid"};
    protected static String[] nonUniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid order by ask", "select f.cid, cust_name, f.sid, so.sid, f.qty, subTotal, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and status=?  order by ask", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, oid, order_time, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and subTotal >10000 and f.cid>? order by order_time", "select f.cid, cust_name, f.sid, so.sid, so.qty, subTotal, order_time, ask from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.sellorders so where c.cid= f.cid and f.sid = so.sid and c.cid = so.cid and so.cid<? and ask >? and ask <? order by so.qty desc, subtotal", "select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n LEFT OUTER JOIN trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n LEFT OUTER JOIN trade.sellorders so on f.cid = so.cid on c.cid= f.cid where so.sid < 100 and so.qty > 500"};
    protected static boolean isColocated = CustPortfSoJoinStmt.checkColocation();
    String[] statuses = new String[]{"cancelled", "open", "filled"};

    @Override
    public void query(Connection dConn, Connection gConn) {
        int cid = dConn != null ? AbstractDMLStmt.getCid(dConn) : AbstractDMLStmt.getCid(gConn);
        int maxAsk = 100;
        BigDecimal ask1 = new BigDecimal(Integer.toString(rand.nextInt(maxAsk / 2)));
        BigDecimal ask2 = ask1.add(new BigDecimal(Integer.toString(rand.nextInt(maxAsk / 2))));
        String status = this.statuses[rand.nextInt(this.statuses.length)];
        int tid = AbstractDMLStmt.getMyTid();
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                ResultSet derbyRS = CustPortfSoJoinStmt.getUniqQuery(dConn, whichQuery, cid, ask1, ask2, status, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustPortfSoJoinStmt.getUniqQuery(gConn, whichQuery, cid, ask1, ask2, status, tid);
                if (gfeRS == null && !isColocated) {
                    Log.getLogWriter().info("tables are not colocated so not able to verify results");
                    return;
                }
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                ResultSet derbyRS = CustPortfSoJoinStmt.getNonUniqQuery(dConn, whichQuery, cid, ask1, ask2, status, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustPortfSoJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, ask1, ask2, status, tid);
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            ResultSet gfeRS = CustPortfSoJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, ask1, ask2, status, tid);
            ResultSetHelper.asList(gfeRS, false);
        }
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal ask1, BigDecimal ask2, String status, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustPortfSoJoinStmt.getUniqQuery(conn, whichQuery, cid, ask1, ask2, status, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                return rs;
            }
            ++count;
            rs = CustPortfSoJoinStmt.getUniqQuery(conn, whichQuery, cid, ask1, ask2, status, tid, success);
        }
        return rs;
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal ask1, BigDecimal ask2, String status, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + uniqSelectHdfs[whichQuery] : " QUERY: " + uniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(uniqSelectHdfs[whichQuery]) : conn.prepareStatement(uniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying CustPortSO  with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying CustPortSO  with STATUS:" + status + ",TID:" + tid + query);
                    stmt.setString(1, status);
                    stmt.setInt(2, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying CustPortSO  with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying CustPortSO  with CID:" + cid + ",1_PRICE:" + ask1 + ",2_PRICE:" + ask2 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, ask1);
                    stmt.setBigDecimal(3, ask2);
                    stmt.setInt(4, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with LEFT OUTER JOIN  TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 5: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with LEFT JOIN TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && testServerGroup && !isColocated) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected non colocated exception, continuing tests.");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal ask1, BigDecimal ask2, String status, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustPortfSoJoinStmt.getNonUniqQuery(conn, whichQuery, cid, ask1, ask2, status, tid, success);
        while (!success[0]) {
            rs = CustPortfSoJoinStmt.getNonUniqQuery(conn, whichQuery, cid, ask1, ask2, status, tid, success);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal ask1, BigDecimal ask2, String status, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + nonUniqSelectHdfs[whichQuery] : " QUERY: " + nonUniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(nonUniqSelectHdfs[whichQuery]) : conn.prepareStatement(nonUniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with no data " + query);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with STATUS:" + status + query);
                    stmt.setString(1, status);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with CID:" + cid + query);
                    stmt.setInt(1, cid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with CID:" + cid + ",1_PRICE:" + ask1 + ",2_PRICE:" + ask2 + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, ask1);
                    stmt.setBigDecimal(3, ask2);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "Querying CustPortSO with LEFT OUTER JOIN " + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && testServerGroup && !isColocated) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected non colocated exception, continuing tests.");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static boolean checkColocation() {
        if (testServerGroup) {
            int i;
            boolean isCustPortoCol = false;
            boolean isPortoSoCol = false;
            boolean isCustSoCol = false;
            String custSG = (String)map.get((Object)"customersSG");
            String soSG = (String)map.get((Object)"sellordersSG");
            String portoSG = (String)map.get((Object)"portfolioSG");
            String schemaSG = (String)map.get((Object)tradeSchemaSG);
            String[] custSGArr = custSG.split(",");
            String[] soSGArr = soSG.split(",");
            String[] portoSGArr = portoSG.split(",");
            String[] schemaSGArr = schemaSG.split(",");
            ArrayList portoSGList = new ArrayList();
            ArrayList soSGList = new ArrayList();
            ArrayList custSGList = new ArrayList();
            ArrayList<String> schemaSGList = new ArrayList<String>();
            for (i = 0; i < schemaSGArr.length; ++i) {
                schemaSGList.add(schemaSGArr[i]);
            }
            if (portoSG.equals("default")) {
                portoSGList.remove("default");
                portoSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < portoSGArr.length; ++i) {
                    portoSGList.add(portoSGArr[i]);
                }
            }
            if (soSG.equals("default")) {
                soSGList.remove("default");
                soSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < soSGArr.length; ++i) {
                    soSGList.add(soSGArr[i]);
                }
            }
            if (custSG.equals("default")) {
                custSGList.remove("default");
                custSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < custSGArr.length; ++i) {
                    custSGList.add(custSGArr[i]);
                }
            }
            ArrayList custParti = (ArrayList)map.get((Object)"customersPartition");
            ArrayList soParti = (ArrayList)map.get((Object)"sellordersPartition");
            ArrayList portoParti = (ArrayList)map.get((Object)"portfolioPartition");
            if (custParti.size() > 0 && soParti.size() > 0 && portoParti.size() > 0) {
                if (custSG.equals(portoSG) && portoSG.equals(soSG) && soParti.size() == 1 && ((String)soParti.get(0)).equals("cid") && portoParti.size() == 1 && ((String)portoParti.get(0)).equals("cid") && custParti.size() == 1 && ((String)custParti.get(0)).equals("cid") && ((String)map.get((Object)"custPartitionOn")).equals("range") && ((String)map.get((Object)"soPartitionOn")).equals("range") && (((String)map.get((Object)"portfPartitionOn")).equals("deafult") || ((String)map.get((Object)"portfPartitionOn")).equals("range"))) {
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                }
            } else if (custParti.size() == 0 && soParti.size() > 0 && portoParti.size() > 0) {
                if (custSGList.contains("default")) {
                    isCustPortoCol = true;
                    isCustSoCol = true;
                } else {
                    if (custSGList.contains(portoSGList)) {
                        isCustPortoCol = true;
                    }
                    if (custSGList.contains(soSGList)) {
                        isCustSoCol = true;
                    }
                }
                if (!soSG.equals(portoSG)) {
                    isPortoSoCol = false;
                } else if (soParti.size() == 1 && ((String)soParti.get(0)).equals("cid") && portoParti.size() == 1 && ((String)portoParti.get(0)).equals("cid") && ((String)map.get((Object)"soPartitionOn")).equals("range") && ((String)map.get((Object)"portfPartitionOn")).equals("range")) {
                    isPortoSoCol = true;
                }
            } else if (soParti.size() == 0 && custParti.size() > 0 && portoParti.size() > 0) {
                if (custSGList.contains("default")) {
                    isPortoSoCol = true;
                    isCustSoCol = true;
                } else {
                    if (soSGList.contains(portoSGList)) {
                        isPortoSoCol = true;
                    }
                    if (soSGList.contains(custSGList)) {
                        isCustSoCol = true;
                    }
                }
                if (!custSG.equals(portoSG)) {
                    isCustPortoCol = false;
                } else if (custParti.size() == 1 && ((String)custParti.get(0)).equals("cid") && portoParti.size() == 1 && ((String)portoParti.get(0)).equals("cid") && (((String)map.get((Object)"portfPartitionOn")).equals("deafult") || ((String)map.get((Object)"custPartitionOn")).equals("range") && ((String)map.get((Object)"portfPartitionOn")).equals("range"))) {
                    isCustPortoCol = true;
                }
            } else if (portoParti.size() == 0 && soParti.size() > 0 && custParti.size() > 0) {
                if (portoSGList.contains("default")) {
                    isCustPortoCol = true;
                    isPortoSoCol = true;
                } else {
                    if (portoSGList.contains(soSGList)) {
                        isPortoSoCol = true;
                    }
                    if (portoSGList.contains(custSGList)) {
                        isCustPortoCol = true;
                    }
                }
                if (custSG.equals(soSG) && custParti.size() == 1 && ((String)custParti.get(0)).equals("cid") && soParti.size() == 1 && ((String)soParti.get(0)).equals("cid") && ((String)map.get((Object)"custPartitionOn")).equals("range") && ((String)map.get((Object)"soPartitionOn")).equals("range")) {
                    isCustSoCol = true;
                }
            } else if (portoParti.size() > 0 && soParti.size() == 0 && custParti.size() == 0) {
                if ((soSGList.contains(portoSGList) || soSGList.contains("default")) && (custSGList.contains(portoSGList) || custSGList.contains("default"))) {
                    isPortoSoCol = true;
                    isCustSoCol = true;
                    isCustPortoCol = true;
                }
            } else if (portoParti.size() == 0 && soParti.size() > 0 && custParti.size() == 0) {
                if ((portoSGList.contains(soSGList) || portoSGList.contains("default")) && (custSGList.contains(soSGList) || custSGList.contains("default"))) {
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                }
            } else if (portoParti.size() == 0 && soParti.size() == 0 && custParti.size() > 0) {
                if ((portoSGList.contains(custSGList) || portoSGList.contains("default")) && (soSGList.contains(custSGList) || soSGList.contains("default"))) {
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                }
            } else if (!(custSGList.contains("default") || soSGList.contains("default") || portoSGList.contains("default"))) {
                for (int i2 = 0; i2 < portoSGArr.length; ++i2) {
                    if (!custSGList.contains(portoSGArr[i2]) || !soSGList.contains(portoSGArr[i2])) continue;
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                    break;
                }
            } else if (custSGList.contains("default") && !soSGList.contains("default") && !portoSGList.contains("default")) {
                for (int i3 = 0; i3 < portoSGArr.length; ++i3) {
                    if (!soSGList.contains(portoSGArr[i3])) continue;
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                    break;
                }
            } else if (!custSGList.contains("default") && soSGList.contains("default") && !portoSGList.contains("default")) {
                for (int i4 = 0; i4 < portoSGArr.length; ++i4) {
                    if (!custSGList.contains(portoSGArr[i4])) continue;
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                    break;
                }
            } else if (!custSGList.contains("default") && !soSGList.contains("default") && portoSGList.contains("default")) {
                for (int i5 = 0; i5 < soSGArr.length; ++i5) {
                    if (!custSGList.contains(soSGArr[i5])) continue;
                    isCustPortoCol = true;
                    isCustSoCol = true;
                    isPortoSoCol = true;
                    break;
                }
            } else {
                isCustPortoCol = true;
                isCustSoCol = true;
                isPortoSoCol = true;
            }
            if (isCustPortoCol && isPortoSoCol && isCustSoCol) {
                Log.getLogWriter().info("Customers, portfolio and sellorders tables are colocated");
                return true;
            }
            Log.getLogWriter().info("Customers, portfolio and sellorders tables are not colocated");
            return false;
        }
        return true;
    }
}

