/*
 * Decompiled with CFR 0.152.
 */
package sql.joinStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.AbstractJoinStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class CustomersNetworthJoinStmt
extends AbstractJoinStmt {
    protected static boolean isColocated = CustomersNetworthJoinStmt.checkColocation();
    protected static boolean[] useDisk = new boolean[]{false};
    public static final String SQL_DRIVER_NAME = "gemfirexd";
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c, trade.networth n where n.cid = c.cid and n.tid = ?", "select n.cid, cust_name, n.securities, n.cash from trade.customers c, trade.networth n where  n.cid = c.cid and n.tid = ? and c.cid >?", "select n.cid, cust_name, since, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c, trade.networth n where n.cid = c.cid and (securities >=? or c.cid <=?) and since >? and c.tid = ?", "select c.cid, addr, since, cust_name, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c, trade.networth n where n.cid = c.cid and (n.cid >? or since <?) and (cash>(loanLimit-availLoan) or loanLimit=? or loanLimit-availLoan<?) and c.tid = ?", "select c.cid, n.cid from trade.customers c left join trade.networth n on c.cid = n.cid where c.tid = ?"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c, trade.networth n where n.cid = c.cid ", "select n.cid, cust_name, n.securities, n.cash from trade.customers c, trade.networth n where  n.cid = c.cid and c.cid >?", "select n.cid, cust_name, since, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c, trade.networth n where n.cid = c.cid and (securities >=? or c.cid <=?) and since >? ", "select c.cid, addr, since, cust_name, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c, trade.networth n where n.cid = c.cid and (n.cid >? or since <?) and (cash>(loanLimit-availLoan) or loanLimit=? or loanLimit-availLoan<?) "};
    protected static String[] uniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where n.cid = c.cid and n.tid = ?", "select n.cid, cust_name, n.securities, n.cash from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where  n.cid = c.cid and n.tid = ? and c.cid >?", "select n.cid, cust_name, since, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where n.cid = c.cid and (securities >=? or c.cid <=?) and since >? and c.tid = ?", "select c.cid, addr, since, cust_name, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where n.cid = c.cid and (n.cid >? or since <?) and (cash>(loanLimit-availLoan) or loanLimit=? or loanLimit-availLoan<?) and c.tid = ?", "select c.cid, n.cid from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n left join trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n on c.cid = n.cid where c.tid = ?"};
    protected static String[] nonUniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where n.cid = c.cid ", "select n.cid, cust_name, n.securities, n.cash from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where  n.cid = c.cid and c.cid >?", "select n.cid, cust_name, since, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where n.cid = c.cid and (securities >=? or c.cid <=?) and since >? ", "select c.cid, addr, since, cust_name, securities, cash, (loanLimit-availLoan) as loanAmount from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.networth n -- GEMFIREXD-PROPERTIES queryHDFS=true \n where n.cid = c.cid and (n.cid >? or since <?) and (cash>(loanLimit-availLoan) or loanLimit=? or loanLimit-availLoan<?) "};

    @Override
    public void query(Connection dConn, Connection gConn) {
        int cid = dConn != null ? AbstractDMLStmt.getCid(dConn) : AbstractDMLStmt.getCid(gConn);
        Date since = this.getSince();
        BigDecimal cash = new BigDecimal(Integer.toString(rand.nextInt(10000)));
        BigDecimal sec = new BigDecimal(Integer.toString(rand.nextInt(10000)));
        int loanLimit = 10000;
        BigDecimal loanAmount = new BigDecimal(Integer.toString(rand.nextInt(10000)));
        int tid = AbstractDMLStmt.getMyTid();
        Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                ResultSet derbyRS = CustomersNetworthJoinStmt.getUniqQuery(dConn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustomersNetworthJoinStmt.getUniqQuery(gConn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid);
                if (gfeRS == null && !isColocated) {
                    Log.getLogWriter().info("tables are not colocated so not able to verify results");
                    return;
                }
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                ResultSet derbyRS = CustomersNetworthJoinStmt.getNonUniqQuery(dConn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustomersNetworthJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid);
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null) {
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            }
        } else {
            int whichQuery = rand.nextInt(nonUniqSelect.length);
            ResultSet gfeRS = CustomersNetworthJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid);
            if (gfeRS == null & useDisk[0]) {
                Log.getLogWriter().info("not able to get the results set due to size is too large");
                CustomersNetworthJoinStmt.useDisk[0] = false;
                return;
            }
            ResultSetHelper.asList(gfeRS, false);
        }
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, Date since, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustomersNetworthJoinStmt.getUniqQuery(conn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                return rs;
            }
            ++count;
            rs = CustomersNetworthJoinStmt.getUniqQuery(conn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid, success);
        }
        return rs;
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, Date since, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + uniqSelectHdfs[whichQuery] : " QUERY: " + uniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(uniqSelectHdfs[whichQuery]) : conn.prepareStatement(uniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying CustomerNetworth with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying CustomerNetworth with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    stmt.setInt(2, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying CustomerNetworth with SECURITIES:" + sec + ",CID:" + cid + ",SINCE:" + since + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, sec);
                    stmt.setInt(2, cid);
                    stmt.setDate(3, since);
                    stmt.setInt(4, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying CustomerNetworth with CID:" + cid + ",SINCE:" + since + ",LOANLIMIT:" + loanLimit + ",LOANAMOUT:" + loanAmount + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setDate(2, since);
                    stmt.setInt(3, loanLimit);
                    stmt.setBigDecimal(4, loanAmount);
                    stmt.setInt(5, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "Querying CustomerNetworth with SECURITIES:" + sec + ",CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && testServerGroup && !isColocated) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected non colocated exception, continuing tests.");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, Date since, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustomersNetworthJoinStmt.getNonUniqQuery(conn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid, success);
        while (!success[0]) {
            rs = CustomersNetworthJoinStmt.getNonUniqQuery(conn, whichQuery, cid, since, cash, sec, loanLimit, loanAmount, tid, success);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, Date since, BigDecimal cash, BigDecimal sec, int loanLimit, BigDecimal loanAmount, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + nonUniqSelectHdfs[whichQuery] : " QUERY: " + nonUniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(nonUniqSelectHdfs[whichQuery]) : conn.prepareStatement(nonUniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + " Querying CustomerNetworth with none" + query);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + " Querying CustomerNetworth with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + " Querying CustomerNetworth with SECURITIES:" + sec + ",CID:" + cid + ",SINCE:" + since + ",TID:" + tid + query);
                    stmt.setBigDecimal(1, sec);
                    stmt.setInt(2, cid);
                    stmt.setDate(3, since);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + " Querying CustomerNetworth with CID:" + cid + ",SINCE:" + since + ",LOANLIMIT:" + loanLimit + ",LOANAMOUNT:" + loanAmount + ",TID:" + "" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setDate(2, since);
                    stmt.setInt(3, loanLimit);
                    stmt.setBigDecimal(4, loanAmount);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && se.getMessage().matches(".*disk.*")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the unsupported exception, need to remove this once bug#40348 is fixed, continuing test");
                CustomersNetworthJoinStmt.useDisk[0] = true;
                return null;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static boolean checkColocation() {
        if (testServerGroup) {
            int i;
            boolean isCustNetworthCol = false;
            String custSG = (String)map.get((Object)"customersSG");
            String netSG = (String)map.get((Object)"networthSG");
            String schemaSG = (String)map.get((Object)tradeSchemaSG);
            String[] custSGArr = custSG.split(",");
            String[] netSGArr = netSG.split(",");
            String[] schemaSGArr = schemaSG.split(",");
            ArrayList custSGList = new ArrayList();
            ArrayList netSGList = new ArrayList();
            ArrayList<String> schemaSGList = new ArrayList<String>();
            for (i = 0; i < schemaSGArr.length; ++i) {
                schemaSGList.add(schemaSGArr[i]);
            }
            if (netSG.equals("default")) {
                netSGList.remove("default");
                netSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < netSGArr.length; ++i) {
                    netSGList.add(netSGArr[i]);
                }
            }
            if (custSG.equals("default")) {
                custSGList.remove("default");
                custSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < custSGArr.length; ++i) {
                    custSGList.add(custSGArr[i]);
                }
            }
            ArrayList custParti = (ArrayList)map.get((Object)"customersPartition");
            ArrayList netParti = (ArrayList)map.get((Object)"networthPartition");
            if (custParti.size() > 0 && netParti.size() > 0) {
                if (!netSG.equals(custSG)) {
                    isCustNetworthCol = false;
                } else if (custParti.size() == 1 && ((String)custParti.get(0)).equals("cid") && netParti.size() == 1 && ((String)netParti.get(0)).equals("cid") && (((String)map.get((Object)"netPartitionOn")).equals("default") || ((String)map.get((Object)"custPartitionOn")).equals(map.get((Object)"netPartitionOn")))) {
                    isCustNetworthCol = true;
                }
            } else if (custParti.size() == 0 && netParti.size() > 0) {
                if (custSGList.contains("default")) {
                    isCustNetworthCol = true;
                } else if (custSGList.contains(netSGList)) {
                    isCustNetworthCol = true;
                }
            } else if (netParti.size() == 0 && custParti.size() > 0) {
                if (netSGList.contains("default")) {
                    isCustNetworthCol = true;
                } else if (netSGList.contains(custSGList)) {
                    isCustNetworthCol = true;
                }
            } else {
                for (int i2 = 0; i2 < netSGArr.length; ++i2) {
                    if (!custSGList.contains(netSGArr[i2])) continue;
                    isCustNetworthCol = true;
                    break;
                }
                if (custSGList.contains("default") || netSGList.contains("default")) {
                    isCustNetworthCol = true;
                }
            }
            if (isCustNetworthCol) {
                Log.getLogWriter().info("Customers and networth tables are colocated");
                return true;
            }
            Log.getLogWriter().info("Customers and networth tables are not colocated");
            return false;
        }
        return true;
    }
}

