/*
 * Decompiled with CFR 0.152.
 */
package sql.joinStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.AbstractJoinStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class CustomersSecuritiesPortfolioJoinStmt
extends AbstractJoinStmt {
    protected static String[] uniqSelect = new String[]{"select * from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and f.tid = ?", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and f.cid >? and f.tid = ? ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and f.cid<? and(qty=availQty or price > ?) and f.tid = ?", "select f.cid, cust_name, sid, symbol, exchange, price, subtotal  from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and c.cid >? and (subtotal >10000 or (price >= ? and price <= ?)) and f.tid = ?"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and f.cid >? ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and f.cid<? and(qty=availQty or price > ?) ", "select f.cid, cust_name, sid, symbol, exchange, price, subtotal from trade.customers c, trade.securities s, trade.portfolio f where c.cid= f.cid and sec_id = f.sid and c.cid >? and (subtotal >10000 or (price >= ? and price <= ?))"};
    protected static String[] uniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n , trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and f.tid = ?", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and f.cid >? and f.tid = ? ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and f.cid<? and(qty=availQty or price > ?) and f.tid = ?", "select f.cid, cust_name, sid, symbol, exchange, price, subtotal  from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and c.cid >? and (subtotal >10000 or (price >= ? and price <= ?)) and f.tid = ?"};
    protected static String[] nonUniqSelectHdfs = new String[]{"select * from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and f.cid >? ", "select f.cid, cust_name, sid, symbol, exchange, price, qty from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and f.cid<? and(qty=availQty or price > ?) ", "select f.cid, cust_name, sid, symbol, exchange, price, subtotal from trade.customers c -- GEMFIREXD-PROPERTIES queryHDFS=true \n, trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where c.cid= f.cid and sec_id = f.sid and c.cid >? and (subtotal >10000 or (price >= ? and price <= ?))"};
    protected static boolean isColocated = CustomersSecuritiesPortfolioJoinStmt.checkColocation();
    protected static boolean[] useDisk = new boolean[]{false};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        int cid = dConn != null ? AbstractDMLStmt.getCid(dConn) : AbstractDMLStmt.getCid(gConn);
        int maxPrice = 100;
        BigDecimal price1 = new BigDecimal(Integer.toString(rand.nextInt(maxPrice / 2)));
        BigDecimal price2 = price1.add(new BigDecimal(Integer.toString(rand.nextInt(maxPrice / 2))));
        int tid = AbstractDMLStmt.getMyTid();
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                ResultSet derbyRS = CustomersSecuritiesPortfolioJoinStmt.getUniqQuery(dConn, whichQuery, cid, price1, price2, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustomersSecuritiesPortfolioJoinStmt.getUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
                if (gfeRS == null && !isColocated) {
                    Log.getLogWriter().info("tables are not colocated so not able to verify results");
                    return;
                }
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
                return;
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                ResultSet derbyRS = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(dConn, whichQuery, cid, price1, price2, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            }
            return;
        }
        int whichQuery = rand.nextInt(nonUniqSelect.length);
        ResultSet gfeRS = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
        boolean[] blArray = useDisk;
        synchronized (useDisk) {
            gfeRS = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
            if (gfeRS == null & useDisk[0]) {
                Log.getLogWriter().info("not able to get the results set due to size is too large");
                CustomersSecuritiesPortfolioJoinStmt.useDisk[0] = false;
                // ** MonitorExit[var11_15] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var11_15] (shouldn't be in output)
            ResultSetHelper.asList(gfeRS, false);
            return;
        }
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustomersSecuritiesPortfolioJoinStmt.getUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                return rs;
            }
            ++count;
            rs = CustomersSecuritiesPortfolioJoinStmt.getUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        }
        return rs;
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + uniqSelectHdfs[whichQuery] : " QUERY: " + uniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(uniqSelectHdfs[whichQuery]) : conn.prepareStatement(uniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesPortfolio with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesPortfolio with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesPortfolio with CID:" + cid + ",PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesPortfolio with CID:" + cid + ",1_PRICE:" + price1 + ",2_PRICE:" + price2 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setBigDecimal(3, price2);
                    stmt.setInt(4, tid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            SQLHelper.printSQLException(se);
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && testServerGroup && !isColocated) {
                Log.getLogWriter().info("got the expected non colocated exception, continuing tests.");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        while (!success[0]) {
            rs = CustomersSecuritiesPortfolioJoinStmt.getNonUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + nonUniqSelectHdfs[whichQuery] : " QUERY: " + nonUniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(nonUniqSelectHdfs[whichQuery]) : conn.prepareStatement(nonUniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesNetworth with no data " + query);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesNetworth with CID:" + cid + query);
                    stmt.setInt(1, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesNetworth with CID:" + cid + ",PRICE:" + price1 + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying CustomerSecuritiesNetworth with CID:" + cid + ",1_PRICE:" + price1 + ",2_PRICE:" + price2 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setBigDecimal(3, price2);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && se.getMessage().matches(".*disk.*")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the unsupported exception, need to remove this once bug#40348 is fixed, continuing test");
                CustomersSecuritiesPortfolioJoinStmt.useDisk[0] = true;
                return null;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static boolean checkColocation() {
        if (testServerGroup) {
            int i;
            boolean isCustPortoCol = false;
            boolean isSecPortoCol = false;
            boolean isCustSecCol = false;
            String custSG = (String)map.get((Object)"customersSG");
            String secSG = (String)map.get((Object)"securitiesSG");
            String portoSG = (String)map.get((Object)"portfolioSG");
            String schemaSG = (String)map.get((Object)tradeSchemaSG);
            String[] custSGArr = custSG.split(",");
            String[] secSGArr = secSG.split(",");
            String[] portoSGArr = portoSG.split(",");
            String[] schemaSGArr = schemaSG.split(",");
            ArrayList portoSGList = new ArrayList();
            ArrayList secSGList = new ArrayList();
            ArrayList custSGList = new ArrayList();
            ArrayList<String> schemaSGList = new ArrayList<String>();
            for (i = 0; i < schemaSGArr.length; ++i) {
                schemaSGList.add(schemaSGArr[i]);
            }
            if (portoSG.equals("default")) {
                portoSGList.remove("default");
                portoSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < portoSGArr.length; ++i) {
                    portoSGList.add(portoSGArr[i]);
                }
            }
            if (secSG.equals("default")) {
                secSGList.remove("default");
                secSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < secSGArr.length; ++i) {
                    secSGList.add(secSGArr[i]);
                }
            }
            if (custSG.equals("default")) {
                custSGList.remove("default");
                custSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < custSGArr.length; ++i) {
                    custSGList.add(custSGArr[i]);
                }
            }
            ArrayList custParti = (ArrayList)map.get((Object)"customersPartition");
            ArrayList secParti = (ArrayList)map.get((Object)"securitiesPartition");
            ArrayList portoParti = (ArrayList)map.get((Object)"portfolioPartition");
            if (custParti.size() <= 0 || secParti.size() <= 0 || portoParti.size() <= 0) {
                if (custParti.size() == 0 && secParti.size() > 0 && portoParti.size() > 0) {
                    if (custSGList.contains("default")) {
                        isCustPortoCol = true;
                        isCustSecCol = true;
                    } else {
                        if (custSGList.contains(portoSGList)) {
                            isCustPortoCol = true;
                        }
                        if (custSGList.contains(secSGList)) {
                            isCustSecCol = true;
                        }
                    }
                    if (!secSG.equals(portoSG)) {
                        isSecPortoCol = false;
                    } else if (secParti.size() == 1 && secParti.get(0).equals("sec_id") && portoParti.size() == 1 && portoParti.get(0).equals("sid") && ((String)map.get((Object)"portfPartitionOn")).equals("deafult")) {
                        isSecPortoCol = true;
                    }
                } else if (secParti.size() == 0 && custParti.size() > 0 && portoParti.size() > 0) {
                    if (secSGList.contains("default")) {
                        isSecPortoCol = true;
                        isCustSecCol = true;
                    } else {
                        if (secSGList.contains(portoSGList)) {
                            isSecPortoCol = true;
                        }
                        if (secSGList.contains(custSGList)) {
                            isCustSecCol = true;
                        }
                    }
                    if (!custSG.equals(portoSG)) {
                        isCustPortoCol = false;
                    } else if (custParti.size() == 1 && custParti.get(0).equals("cid") && portoParti.size() == 1 && portoParti.get(0).equals("cid") && (((String)map.get((Object)"portfPartitionOn")).equals("deafult") || ((String)map.get((Object)"custPartitionOn")).equals("range") && ((String)map.get((Object)"portfPartitionOn")).equals("range"))) {
                        isCustPortoCol = true;
                    }
                } else if (portoParti.size() == 0 && secParti.size() > 0 && custParti.size() > 0) {
                    isCustSecCol = false;
                } else if (portoParti.size() > 0 && secParti.size() == 0 && custParti.size() == 0) {
                    if ((secSGList.contains(portoSGList) || secSGList.contains("default")) && (custSGList.contains(portoSGList) || custSGList.contains("default"))) {
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                    }
                } else if (portoParti.size() == 0 && secParti.size() > 0 && custParti.size() == 0) {
                    if ((portoSGList.contains(secSGList) || portoSGList.contains("default")) && (custSGList.contains(secSGList) || custSGList.contains("default"))) {
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                    }
                } else if (portoParti.size() == 0 && secParti.size() == 0 && custParti.size() > 0) {
                    if ((portoSGList.contains(custSGList) || portoSGList.contains("default")) && (secSGList.contains(custSGList) || secSGList.contains("default"))) {
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                    }
                } else if (!(custSGList.contains("default") || secSGList.contains("default") || portoSGList.contains("default"))) {
                    for (int i2 = 0; i2 < portoSGArr.length; ++i2) {
                        if (!custSGList.contains(portoSGArr[i2]) || !secSGList.contains(portoSGArr[i2])) continue;
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                        break;
                    }
                } else if (custSGList.contains("default") && !secSGList.contains("default") && !portoSGList.contains("default")) {
                    for (int i3 = 0; i3 < portoSGArr.length; ++i3) {
                        if (!secSGList.contains(portoSGArr[i3])) continue;
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                        break;
                    }
                } else if (!custSGList.contains("default") && secSGList.contains("default") && !portoSGList.contains("default")) {
                    for (int i4 = 0; i4 < portoSGArr.length; ++i4) {
                        if (!custSGList.contains(portoSGArr[i4])) continue;
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                        break;
                    }
                } else if (!custSGList.contains("default") && !secSGList.contains("default") && portoSGList.contains("default")) {
                    for (int i5 = 0; i5 < secSGArr.length; ++i5) {
                        if (!custSGList.contains(secSGArr[i5])) continue;
                        isSecPortoCol = true;
                        isCustSecCol = true;
                        isCustPortoCol = true;
                        break;
                    }
                } else {
                    isSecPortoCol = true;
                    isCustSecCol = true;
                    isCustPortoCol = true;
                }
            }
            Log.getLogWriter().info("custParti.size() is " + custParti.size());
            Log.getLogWriter().info("secParti.size() is " + secParti.size());
            Log.getLogWriter().info("portoParti.size() is " + portoParti.size());
            Log.getLogWriter().info("custSGList is " + custSGList.toString());
            Log.getLogWriter().info("secSGList is " + secSGList.toString());
            Log.getLogWriter().info("portoSGList is " + portoSGList.toString());
            if (isCustPortoCol && isSecPortoCol && isCustSecCol) {
                Log.getLogWriter().info("Customers, Securities and portfolio tables are colocated");
                return true;
            }
            Log.getLogWriter().info("Customers, Securities and portfolio tables are not colocated");
            return false;
        }
        return true;
    }
}

