/*
 * Decompiled with CFR 0.152.
 */
package sql.joinStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import sql.SQLHelper;
import sql.joinStatements.AbstractJoinStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class MultiTablesJoinStmt
extends AbstractJoinStmt {
    protected static String[] uniqSelect = new String[]{"select * from trade.securities n, trade.myJoinView v where n.sec_id = v.port_sid and n.tid=?"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.securities n, trade.myJoinView v where n.sec_id = v.port_sid "};
    protected static boolean[] useDisk = new boolean[]{false};
    protected static int maxNumOfTries = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        int tid = this.getMyTid();
        int whichQuery = testUniqueKeys ? rand.nextInt(uniqSelect.length) : rand.nextInt(nonUniqSelect.length);
        if (dConn != null) {
            ResultSet derbyRS = MultiTablesJoinStmt.getUniqQuery(dConn, whichQuery, tid);
            if (derbyRS == null) {
                Log.getLogWriter().info("could not get the derby result set after retry, abort this query");
                return;
            }
            List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
            if (derbyList == null) {
                Log.getLogWriter().info("could not get derby results");
                return;
            }
            ResultSet gfxdRS = MultiTablesJoinStmt.getUniqQuery(gConn, whichQuery, tid);
            List<Struct> gfxdList = ResultSetHelper.asList(gfxdRS, false);
            if (gfxdList == null) {
                Log.getLogWriter().info("could not get gfxd results");
                return;
            }
            ResultSetHelper.compareResultSets(derbyList, gfxdList);
            return;
        }
        boolean[] blArray = useDisk;
        synchronized (useDisk) {
            ResultSet gfxdRS = MultiTablesJoinStmt.getNonUniqQuery(gConn, whichQuery);
            if (gfxdRS != null) {
                ResultSetHelper.asList(gfxdRS, false);
            } else if (isHATest) {
                Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
            } else {
                if (!useDisk[0]) throw new TestException("gfxd query returns null and not a HA test");
                Log.getLogWriter().info("not able to get the results set due to size is too large");
                MultiTablesJoinStmt.useDisk[0] = false;
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = MultiTablesJoinStmt.getUniqQuery(conn, whichQuery, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                return rs;
            }
            ++count;
            rs = MultiTablesJoinStmt.getUniqQuery(conn, whichQuery, tid, success);
        }
        return rs;
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            Log.getLogWriter().info(database + "Querying SecuritiesMyJoinView with TID:" + tid + uniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(uniqSelect[whichQuery]);
            stmt.setInt(1, tid);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected node went down exception, continuing test");
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = MultiTablesJoinStmt.getNonUniqQuery(conn, whichQuery, success);
        while (!success[0]) {
            rs = MultiTablesJoinStmt.getNonUniqQuery(conn, whichQuery, success);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            Log.getLogWriter().info(database + "Querying SecuritiesMyJoinView with no data " + nonUniqSelect[whichQuery]);
            PreparedStatement stmt = conn.prepareStatement(nonUniqSelect[whichQuery]);
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("X0Z01") && isHATest) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected node went down exception, continuing test");
                success[0] = false;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public void createViewsForJoin(Connection conn) {
        String sql = "create view trade.myJoinView (cid, name, port_sid, qty, subTotal, ask) as select f.cid, cust_name, f.sid, f.qty, subTotal, ask from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid= f.cid and c.cid = so.cid and f.tid = so.tid and f.sid = so.sid and subTotal >10000";
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info(sql);
            stmt.execute(sql);
            conn.commit();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }
}

