/*
 * Decompiled with CFR 0.152.
 */
package sql.joinStatements;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.dmlStatements.AbstractDMLStmt;
import sql.joinStatements.AbstractJoinStmt;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class SecuritiesPortfolioJoinStmt
extends AbstractJoinStmt {
    protected static String[] uniqSelect = new String[]{"select * from trade.securities s, trade.portfolio f where sec_id = f.sid and f.tid = ?", "select cid, sid, symbol, price, qty from trade.securities s, trade.portfolio f where sec_id = f.sid and cid >? and f.tid = ? ", "select cid, sid, symbol, exchange, qty, price from trade.securities s, trade.portfolio f where sec_id = f.sid and cid<? and(qty=availQty or price > ?) and f.tid = ?", "select cid, sid, symbol, exchange, price, subtotal from trade.securities s, trade.portfolio f where sec_id = f.sid and cid >? and (subtotal >10000 or (price >= ? and price <= ?)) and f.tid = ?"};
    protected static String[] nonUniqSelect = new String[]{"select * from trade.securities s, trade.portfolio f where sec_id = f.sid ", "select cid, sid, symbol, price, qty from trade.securities s, trade.portfolio f where sec_id = f.sid and cid >? ", "select cid, sid, symbol, exchange, qty, price from trade.securities s, trade.portfolio f where sec_id = f.sid and cid<? and(qty=availQty or price > ?) ", "select cid, sid, symbol, exchange, price, subtotal from trade.securities s, trade.portfolio f where sec_id = f.sid and cid >? and (subtotal >10000 or (price >= ? and price <= ?)) "};
    protected static String[] uniqSelectHdfs = new String[]{"select * from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid and f.tid = ?", "select cid, sid, symbol, price, qty from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid and cid >? and f.tid = ? ", "select cid, sid, symbol, exchange, qty, price from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid and cid<? and(qty=availQty or price > ?) and f.tid = ?", "select cid, sid, symbol, exchange, price, subtotal from trade.securities s, trade.portfolio f -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid and cid >? and (subtotal >10000 or (price >= ? and price <= ?)) and f.tid = ?"};
    protected static String[] nonUniqSelectHdfs = new String[]{"select * from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid ", "select cid, sid, symbol, price, qty from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where sec_id = f.sid and cid >? ", "select cid, sid, symbol, exchange, qty, price from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n where sec_id = f.sid and cid<? and(qty=availQty or price > ?) ", "select cid, sid, symbol, exchange, price, subtotal from trade.securities s, trade.portfolio f  -- GEMFIREXD-PROPERTIES queryHDFS=true \n  where sec_id = f.sid and cid >? and (subtotal >10000 or (price >= ? and price <= ?)) "};
    protected static boolean isColocated = SecuritiesPortfolioJoinStmt.checkColocation();
    protected static boolean[] useDisk = new boolean[]{false};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void query(Connection dConn, Connection gConn) {
        int cid = dConn != null ? AbstractDMLStmt.getCid(dConn) : AbstractDMLStmt.getCid(gConn);
        int maxPrice = 100;
        BigDecimal price1 = new BigDecimal(Integer.toString(rand.nextInt(maxPrice / 2)));
        BigDecimal price2 = price1.add(new BigDecimal(Integer.toString(rand.nextInt(maxPrice / 2))));
        int tid = AbstractDMLStmt.getMyTid();
        if (dConn != null) {
            if (testUniqueKeys) {
                int whichQuery = rand.nextInt(uniqSelect.length);
                ResultSet derbyRS = SecuritiesPortfolioJoinStmt.getUniqQuery(dConn, whichQuery, cid, price1, price2, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = SecuritiesPortfolioJoinStmt.getUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
                if (gfeRS == null && !isColocated) {
                    Log.getLogWriter().info("tables are not colocated so not able to verify results");
                    return;
                }
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
                return;
            } else {
                int whichQuery = rand.nextInt(nonUniqSelect.length);
                ResultSet derbyRS = SecuritiesPortfolioJoinStmt.getNonUniqQuery(dConn, whichQuery, cid, price1, price2, tid);
                if (derbyRS == null) {
                    Log.getLogWriter().info("Did not execute this query");
                    return;
                }
                List<Struct> derbyList = ResultSetHelper.asList(derbyRS, true);
                if (derbyList == null) {
                    Log.getLogWriter().info("Not able to convert derby resultSet to a list");
                    return;
                }
                ResultSet gfeRS = SecuritiesPortfolioJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
                List<Struct> gfeList = ResultSetHelper.asList(gfeRS, false);
                if (gfeList == null && isHATest) {
                    Log.getLogWriter().info("could not get gfxd results set due to HA");
                    return;
                }
                ResultSetHelper.compareResultSets(derbyList, gfeList);
            }
            return;
        }
        int whichQuery = rand.nextInt(nonUniqSelect.length);
        boolean[] blArray = useDisk;
        synchronized (useDisk) {
            ResultSet gfeRS = SecuritiesPortfolioJoinStmt.getNonUniqQuery(gConn, whichQuery, cid, price1, price2, tid);
            if (gfeRS == null & useDisk[0]) {
                Log.getLogWriter().info("not able to get the results set due to size is too large");
                SecuritiesPortfolioJoinStmt.useDisk[0] = false;
                // ** MonitorExit[var11_15] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var11_15] (shouldn't be in output)
            ResultSetHelper.asList(gfeRS, false);
            return;
        }
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = SecuritiesPortfolioJoinStmt.getUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        int count = 0;
        while (!success[0]) {
            if (count >= maxNumOfTries) {
                Log.getLogWriter().info("Could not get the lock to finish update in derby, abort this operation");
                return rs;
            }
            ++count;
            rs = SecuritiesPortfolioJoinStmt.getUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        }
        return rs;
    }

    public static ResultSet getUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + uniqSelectHdfs[whichQuery] : " QUERY: " + uniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(uniqSelectHdfs[whichQuery]) : conn.prepareStatement(uniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setInt(2, tid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + ",PRICE:" + price1 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setInt(3, tid);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + ",1_PRICE:" + price1 + ",2_PRICE:" + price2 + ",TID:" + tid + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setBigDecimal(3, price2);
                    stmt.setInt(4, tid);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with LEFT OUTER JOIN TID:" + tid + query);
                    stmt.setInt(1, tid);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && testServerGroup && !isColocated) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the expected non colocated exception, continuing tests.");
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid) {
        boolean[] success = new boolean[1];
        ResultSet rs = null;
        rs = SecuritiesPortfolioJoinStmt.getNonUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        while (!success[0]) {
            rs = SecuritiesPortfolioJoinStmt.getNonUniqQuery(conn, whichQuery, cid, price1, price2, tid, success);
        }
        return rs;
    }

    public static ResultSet getNonUniqQuery(Connection conn, int whichQuery, int cid, BigDecimal price1, BigDecimal price2, int tid, boolean[] success) {
        ResultSet rs = null;
        success[0] = true;
        try {
            Boolean hasHdfs = TestConfig.tab().booleanAt(SQLPrms.hasHDFS, false);
            String database = SQLHelper.isDerbyConn(conn) ? "Derby - " : "gemfirexd - ";
            String query = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? " QUERY: " + nonUniqSelectHdfs[whichQuery] : " QUERY: " + nonUniqSelect[whichQuery];
            PreparedStatement stmt = !SQLHelper.isDerbyConn(conn) && hasHdfs != false ? conn.prepareStatement(nonUniqSelectHdfs[whichQuery]) : conn.prepareStatement(nonUniqSelect[whichQuery]);
            switch (whichQuery) {
                case 0: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with no data" + query);
                    break;
                }
                case 1: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + query);
                    stmt.setInt(1, cid);
                    break;
                }
                case 2: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + ",PRICE:" + price1 + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    break;
                }
                case 3: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with CID:" + cid + ",1_PRICE:" + price1 + ",2_PRICE:" + price2 + query);
                    stmt.setInt(1, cid);
                    stmt.setBigDecimal(2, price1);
                    stmt.setBigDecimal(3, price2);
                    break;
                }
                case 4: {
                    Log.getLogWriter().info(database + "Querying SecuritiesPortfolio with LEFT OUTER JOIN " + query);
                    break;
                }
                default: {
                    throw new TestException("incorrect select statement, should not happen");
                }
            }
            rs = stmt.executeQuery();
        }
        catch (SQLException se) {
            if (!SQLHelper.checkDerbyException(conn, se)) {
                success[0] = false;
            }
            if (se.getSQLState().equals("0A000") && se.getMessage().matches(".*disk.*")) {
                SQLHelper.printSQLException(se);
                Log.getLogWriter().info("got the unsupported exception, need to remove this once bug#40348 is fixed, continuing test");
                SecuritiesPortfolioJoinStmt.useDisk[0] = true;
                return null;
            }
            SQLHelper.handleSQLException(se);
        }
        return rs;
    }

    protected static boolean checkColocation() {
        if (testServerGroup) {
            int i;
            boolean isSecPortfCol = false;
            String secSG = (String)map.get((Object)"securitiesSG");
            String portfSG = (String)map.get((Object)"portfolioSG");
            String schemaSG = (String)map.get((Object)tradeSchemaSG);
            String[] secSGArr = secSG.split(",");
            String[] portfSGArr = portfSG.split(",");
            String[] schemaSGArr = schemaSG.split(",");
            ArrayList secSGList = new ArrayList();
            ArrayList portfSGList = new ArrayList();
            ArrayList<String> schemaSGList = new ArrayList<String>();
            for (i = 0; i < schemaSGArr.length; ++i) {
                schemaSGList.add(schemaSGArr[i]);
            }
            if (portfSG.equals("default")) {
                portfSGList.remove("default");
                portfSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < portfSGArr.length; ++i) {
                    portfSGList.add(portfSGArr[i]);
                }
            }
            if (secSG.equals("default")) {
                secSGList.remove("default");
                secSGList.addAll(schemaSGList);
            } else {
                for (i = 0; i < secSGArr.length; ++i) {
                    secSGList.add(secSGArr[i]);
                }
            }
            ArrayList secParti = (ArrayList)map.get((Object)"securitiesPartition");
            ArrayList portfParti = (ArrayList)map.get((Object)"portfolioPartition");
            if (secParti.size() > 0 && portfParti.size() > 0) {
                if (!portfSG.equals(secSG)) {
                    isSecPortfCol = false;
                } else if (secParti.size() == 1 && secParti.get(0).equals("sec_id") && portfParti.size() == 1 && portfParti.get(0).equals("sid") && ((String)map.get((Object)"portfPartitionOn")).equals("default")) {
                    isSecPortfCol = true;
                }
            } else if (secParti.size() == 0 && portfParti.size() > 0) {
                if (secSGList.contains("default")) {
                    isSecPortfCol = true;
                } else if (secSGList.contains(portfSGList)) {
                    isSecPortfCol = true;
                }
            } else if (portfParti.size() == 0 && secParti.size() > 0) {
                if (portfSGList.contains("default")) {
                    isSecPortfCol = true;
                } else if (portfSGList.contains(secSGList)) {
                    isSecPortfCol = true;
                }
            } else {
                for (int i2 = 0; i2 < portfSGArr.length; ++i2) {
                    if (!secSGList.contains(portfSGArr[i2])) continue;
                    isSecPortfCol = true;
                    break;
                }
                if (secSGList.contains("default") || portfSGList.contains("default")) {
                    isSecPortfCol = true;
                }
            }
            if (isSecPortfCol) {
                Log.getLogWriter().info("portfolio and securities tables are colocated");
                return true;
            }
            Log.getLogWriter().info("portfolio and securities tables are not colocated");
            return false;
        }
        return true;
    }
}

