/*
 * Decompiled with CFR 0.152.
 */
package sql.joins;

import hydra.Log;
import hydra.RemoteTestModule;
import java.sql.Connection;
import sql.SQLTest;
import sql.joinStatements.MultiTablesJoinStmt;
import util.PRObserver;

public class JoinTest
extends SQLTest {
    public static JoinTest joinTest = null;

    public static synchronized void HydraTask_initialize() {
        if (joinTest == null) {
            joinTest = new JoinTest();
            sqlTest = new SQLTest();
            PRObserver.installObserverHook();
            PRObserver.initialize((int)RemoteTestModule.getMyVmid());
            joinTest.initialize();
        }
    }

    public static void HydraTask_createViewsForJoin() {
        joinTest.createViews();
    }

    public static void HydraTask_queryOnJoinOp() {
        joinTest.queryOnJoinOp();
    }

    @Override
    protected void queryOnJoinOp() {
        if (random.nextBoolean()) {
            super.queryOnJoinOp();
            return;
        }
        Log.getLogWriter().info("performing queryOnJoin for multitables, myTid is " + this.getMyTid());
        Connection dConn = null;
        if (hasDerbyServer) {
            dConn = this.getDiscConnection();
        }
        Connection gConn = this.getGFEConnection();
        if (setCriticalHeap) {
            this.resetCanceledFlag();
        }
        if (setTx && isHATest) {
            this.resetNodeFailureFlag();
        }
        if (setTx && testEviction) {
            this.resetEvictionConflictFlag();
        }
        new MultiTablesJoinStmt().query(dConn, gConn);
    }

    protected void createViews() {
        if (hasDerbyServer) {
            Connection dConn = this.getDiscConnection();
            new MultiTablesJoinStmt().createViewsForJoin(dConn);
        }
        Connection conn = this.getGFEConnection();
        new MultiTablesJoinStmt().createViewsForJoin(conn);
        this.closeGFEConnection(conn);
    }
}

