/*
 * Decompiled with CFR 0.152.
 */
package sql.loader;

import com.pivotal.gemfirexd.callbacks.RowLoader;
import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import sql.ClientDiscDBManager;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import util.TestException;

public class BuyOrdersLoader
implements RowLoader {
    private Connection dConn;
    private Object[] params = new Object[1];
    private boolean testSecurity = SQLTest.testSecurity;

    public BuyOrdersLoader() {
        if (!SQLTest.hasDerbyServer) {
            return;
        }
        int retries = 5;
        while (true) {
            try {
                if (!this.testSecurity) {
                    this.dConn = ClientDiscDBManager.getConnection();
                    break;
                }
                this.dConn = ClientDiscDBManager.getSuperUserConnection();
            }
            catch (SQLException ex) {
                if (!"08003".equals(ex.getSQLState()) || retries-- <= 0) {
                    throw new TestException("failed while getting a connection", (Throwable)ex);
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public static BuyOrdersLoader createRowLoader() {
        return new BuyOrdersLoader();
    }

    public Object getRow(String schemaName, String tableName, Object[] primarykey) throws SQLException {
        if (this.params != null && this.params.length > 0 && this.params[0] != null && ((String)this.params[0]).contains("createRandomRow")) {
            return this.getCreatedRow(primarykey);
        }
        Log.getLogWriter().info("in BuyOrderLoader getValuForColumns");
        String select = "select * from trade.buyorders where oid = ?";
        Object row = null;
        try {
            Log.getLogWriter().info("primary key is " + primarykey[0]);
            PreparedStatement ps = this.dConn.prepareStatement(select);
            ps.setInt(1, (Integer)primarykey[0]);
            ResultSet rs = ps.executeQuery();
            return rs;
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            return row;
        }
    }

    private Object getCreatedRow(Object[] primaryKey) {
        int initMaxQty = 2000;
        int maxTids = 20;
        Object[] row = new Object[]{primaryKey[0], SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeCustomersPrimary)) + 1, SQLTest.random.nextInt((int)SQLBB.getBB().getSharedCounters().read(SQLBB.tradeSecuritiesPrimary)) + 1, SQLTest.random.nextInt(initMaxQty), new BigDecimal(Double.toString((double)(SQLTest.random.nextInt(10000) + 1) * 0.01)), new Timestamp(System.currentTimeMillis()), "open", SQLTest.random.nextInt(maxTids)};
        Log.getLogWriter().info("loader getCreatedrow creates the following row, oid " + row[0] + " cid " + row[1] + " sid " + row[2] + " qty " + row[3] + " bid " + row[4] + " ordertime " + row[5] + " status " + row[6] + " tid " + row[7]);
        return row;
    }

    public void init(String initStr) throws SQLException {
        this.params[0] = initStr;
    }
}

