/*
 * Decompiled with CFR 0.152.
 */
package sql.mbeans;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.SharedLock;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLTest;
import sql.mbeans.MBeanTest;
import util.TestException;

public class MBeanHelper
extends SQLTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number runQueryAndPrintValue(String sql) {
        Log.getLogWriter().info("Trying to Execute Query : " + sql);
        Connection conn = null;
        try {
            conn = this.getGFEConnection();
            Statement ps = conn.createStatement();
            ResultSet rs = ps.executeQuery(sql);
            while (rs.next()) {
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    Log.getLogWriter().info("Param " + rs.getMetaData().getColumnName(i) + " : " + rs.getObject(i));
                }
            }
        }
        catch (SQLException e) {
            Log.getLogWriter().error((Throwable)e);
        }
        finally {
            if (conn != null) {
                this.closeGFEConnection(conn);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runQueryAndGetValue(String sql, MBeanTest.OutputType outputType) {
        Log.getLogWriter().info("Trying to Execute Query : " + sql + ", Expecting output to be in " + (Object)((Object)outputType));
        Connection conn = null;
        try {
            conn = this.getGFEConnection();
            Statement ps = conn.createStatement();
            ResultSet rs = ps.executeQuery(sql);
            if (rs.next()) {
                if (outputType.isLong()) {
                    Long l = rs.getLong(1);
                    return l;
                }
                if (outputType.isInt()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
                if (outputType.isFloat()) {
                    Float f = Float.valueOf(rs.getFloat(1));
                    return f;
                }
                if (outputType.isString()) {
                    String string = rs.getString(1);
                    return string;
                }
                Object value = rs.getObject(1);
                Log.getLogWriter().info(rs.getMetaData().getColumnName(1) + " type is " + value.getClass() + ", value : " + value);
            }
        }
        catch (SQLException e) {
            Log.getLogWriter().error("Error while executing query : " + sql, (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.closeGFEConnection(conn);
            }
        }
        return 0;
    }

    public static void matchValues(AttributeList list, Map<String, Object> expectedMap) {
        for (Map.Entry<String, Object> entry : expectedMap.entrySet()) {
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                Attribute attr = (Attribute)list.get(i);
                if (!attr.getName().equals(entry.getKey())) continue;
                found = true;
                Log.getLogWriter().info(entry.getKey() + "--> JMX : " + attr.getValue() + " BB : " + entry.getValue());
                if (attr.getValue().equals(entry.getValue())) continue;
                MBeanHelper.printAndSaveError("Attribute", null, attr, entry.getValue());
            }
            if (found) continue;
            throw new TestException("Error attribute " + entry.getKey() + " not found");
        }
    }

    public static void ensureNonZero(AttributeList list, String[] expectedAttrs) {
        for (String entry : expectedAttrs) {
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                Attribute attr = (Attribute)list.get(i);
                if (!attr.getName().equals(entry)) continue;
                found = true;
                Log.getLogWriter().info(entry + "--> JMX : " + attr.getValue());
                Object value = attr.getValue();
                boolean isZero = true;
                if (value == null) {
                    isZero = true;
                    continue;
                }
                if (value instanceof Number) {
                    Number intVal;
                    if (value instanceof Integer) {
                        intVal = (Integer)value;
                        isZero = (Integer)intVal == 0;
                    }
                    if (value instanceof Long) {
                        intVal = (Long)value;
                        isZero = (Long)intVal == 0L;
                    } else if (value instanceof Float) {
                        Float falotVal = (Float)value;
                        isZero = falotVal.floatValue() == 0.0f;
                    } else if (value instanceof Double) {
                        Double doubleVal = (Double)value;
                        isZero = doubleVal == 0.0;
                    }
                    if (!isZero) continue;
                    MBeanHelper.saveError("Attribute " + attr.getName() + " is expected non-Zero " + " actual value " + attr.getValue() + " class " + attr.getValue().getClass());
                    continue;
                }
                MBeanHelper.saveError("Attribute " + attr.getName() + " is expected number " + " actual value " + attr.getValue() + " class " + attr.getValue().getClass());
            }
            if (found) continue;
            throw new TestException("Error attribute " + entry + " not found");
        }
    }

    public static void printAndSaveError(String prefix, String tableName, Attribute attribute, Object expected) {
        MBeanHelper.saveError(prefix + " " + attribute.getName() + " did not match " + (tableName != null ? " for " + tableName : "") + ", Expected Value :  " + expected + " and Actual Value  : " + attribute.getValue());
    }

    public static void printActualAndExpectedForAttribute(String messageSuffix, Attribute attribute, Number expected) {
        Log.getLogWriter().info(messageSuffix + " " + attribute.getName() + ", " + "Expected Value :  " + expected + " and Actual Value  : " + attribute.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveError(String error) {
        String clientName = RemoteTestModule.getMyClientName();
        int pid = RemoteTestModule.MyPid;
        String threadName = Thread.currentThread().getName();
        StringBuilder newError = new StringBuilder("from client");
        newError.append(" ").append(clientName).append(" PID=").append(pid).append(" on thread ").append(threadName).append(" : ").append(error);
        Log.getLogWriter().error("saveError - Start newError=" + newError);
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            ArrayList<String> errorList = (ArrayList<String>)SQLBB.getBB().getSharedMap().get((Object)"DATA_ERROR");
            if (errorList == null) {
                errorList = new ArrayList<String>();
            }
            newError.append("\n");
            errorList.add(newError.toString());
            SQLBB.getBB().getSharedMap().put((Object)"DATA_ERROR", errorList);
        }
        finally {
            lock.unlock();
        }
    }

    public void compareValues(AttributeList list, Map<String, Number> expectedMap, boolean considerExpectedCanBeGreater) {
        for (Map.Entry<String, Number> entry : expectedMap.entrySet()) {
            boolean found = false;
            for (int i = 0; i < list.size(); ++i) {
                Attribute attr = (Attribute)list.get(i);
                if (!attr.getName().equals(entry.getKey())) continue;
                found = true;
                Log.getLogWriter().info(entry.getKey() + "--> JMX : " + attr.getValue() + " BB : " + entry.getValue());
                if (!(considerExpectedCanBeGreater ? ((Number)attr.getValue()).longValue() > entry.getValue().longValue() : !attr.getValue().toString().equals(entry.getValue().toString()))) continue;
                MBeanHelper.printAndSaveError("Attribute", null, attr, entry.getValue());
            }
            if (found) continue;
            throw new TestException("Error attribute " + entry.getKey() + " not found");
        }
    }

    public Object getTotalRegions() {
        Connection conn = this.getGFEConnection();
        ResultSet rs = null;
        int max = 0;
        try {
            rs = conn.createStatement().executeQuery("select count(TABLENAME) from sys.SYSTABLES where TABLETYPE='T'");
            while (rs.next()) {
                max = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            throw new TestException("Failed", (Throwable)se);
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTotalTxCommits() {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        int count = 0;
        try {
            lock.lock();
            for (Map.Entry e : SQLBB.getBB().getSharedMap().getMap().entrySet()) {
                Integer cInt;
                Map.Entry entry = e;
                String key = (String)entry.getKey();
                if (!key.startsWith("COMMITS_") || (cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)key)) == null) continue;
                count += cInt.intValue();
            }
            Integer n = count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static String quoteIfNeeded(String stringToCheck) {
        return stringToCheck != null && stringToCheck.indexOf(34) != -1 ? ObjectName.quote(stringToCheck) : stringToCheck;
    }

    public static String makeCompliantName(String value) {
        return MBeanJMXAdapter.makeCompliantName((String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTotalTxRollbacks() {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        int count = 0;
        try {
            lock.lock();
            for (Map.Entry e : SQLBB.getBB().getSharedMap().getMap().entrySet()) {
                Integer cInt;
                Map.Entry entry = e;
                String key = (String)entry.getKey();
                if (!key.startsWith("ROLLBACKS_") || (cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)key)) == null) continue;
                count += cInt.intValue();
            }
            Integer n = count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public static boolean isLocator() {
        return GemFireStore.getBootedInstance().getMyVMKind().isLocator();
    }

    public static void printConnectionStats(Statistics statistics) {
        StatisticDescriptor[] descrs;
        for (StatisticDescriptor descr : descrs = statistics.getType().getStatistics()) {
            Log.getLogWriter().info(descr.getName() + " = " + statistics.get(descr));
        }
    }
}

