/*
 * Decompiled with CFR 0.152.
 */
package sql.mbeans;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerNestedConnectionStats;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import hydra.ClientVmInfo;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PortHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.LocatorBlackboard;
import hydra.gemfirexd.NetworkServerHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import sql.SQLBB;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.ddlStatements.IndexDDLStmt;
import sql.mbeans.MBeanHelper;
import sql.mbeans.MBeanPrms;
import sql.mbeans.MBeanTestConstants;
import sql.mbeans.MBeanTradeSellOrdersDMLStmt;
import sql.mbeans.MBeanTransactionBB;
import sql.mbeans.listener.CallBackListener;
import sql.sqlutil.GFXDStructImpl;
import sql.sqlutil.ResultSetHelper;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;

public class MBeanTest
extends SQLTest {
    private static final String TABLE_SERVER_GROUP = "TABLE_SERVER_GROUP";
    protected static MBeanTest mbeanTest;
    private HydraThreadLocal connectorTL = new HydraThreadLocal();
    private AtomicInteger connectorRetries = new AtomicInteger(0);
    public static final String JMX_URL_FORMAT = "service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/jmxrmi";
    private static final String SELLORDER_INSERT = "insert into {0} values (?,?,?,?,?,?,?,?)";
    private static final String SELLORDER_PUT = "put into {0} values (?,?,?,?,?,?,?,?)";
    private static final String SELLORDER_UPDATE = "update {0} set qty=? where oid=?";
    private static final String SELLORDER_DELETE = "DELETE FROM {0} WHERE qty=? AND oid=?";
    private static final int MAX_RETRIES;
    private static String COUNTER_SELLORDER_INSERTS;
    private static String COUNTER_SELLORDER_UPDATES;
    private static String COUNTER_SELLORDER_DELETES;
    private static String COUNTER_SELLORDER_SELECTS;
    private static String COUNTER_SELLORDER_KEYSIZE;
    private static String COUNTER_SELLORDER_ENTRYSIZE;
    private static String COUNTER_SELLORDER_NO_OF_ROWS;
    private static String COUNTER_SELLORDER_COMMITS;
    private static String COUNTER_SELLORDER_ROLLBACKS;
    private static String COUNTER_MBEAN_PROC_CALLS;
    private static String COUNTER_MBEAN_PROC_CALLS_EDGE;
    private static String COUNTER_MBEAN_STATEMENT;
    private static String COUNTER_NS_CLIENT;
    private static String COUNTER_NS_PEER;
    private static String COUNTER_NS_NESTED;
    private static String COUNTER_NS_INTERNAL;
    private static String COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS;
    private static String COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS_EDGE;
    private static String COUNTER_MBEAN_PROC_CALLS_PREFIX;
    private static String COUNTER_MBEAN_STATEMENT_PREFIX;
    private static String COUNTER_MBEAN_PROC_PROGRESS_PREFIX;
    private static String MEMBERS_MAPPING;
    private static String THIS_MEMBERID;
    private static String MANAGER_RUNNING;
    private static String MANAGER_READERS;
    private static String MANAGER_WRITERS;
    public static String distributedRegionONTemplate;
    public static String regionONTemplate;
    public static String memberONTemplate;
    public static String tableONTemplate;
    public static String statementONTemplate;
    public static String aggrMemberONTemplate;
    public static String aggrTableONTemplate;
    public static String aggrStatementONTemplate;
    public static final String DEFAULT_SERVER_GROUP = "DEFAULT";
    public static final String TABLE_COUNTER = "TABLE_COUNTER";
    public static final String CREATE_TABLE_TEMPLATE = "create table emp.MYTABLE_{0} (eid int not null constraint MYTABLE_{0}_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))";
    public static final String CREATE_TABLE_TEMPLATE_2 = "create table emp.MYTABLE_{0} (eid int not null constraint MYTABLE_{0}_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9), COUNTRY_ISO_CODE CHAR(2) CONSTRAINT COUNTRIES_FK REFERENCES COUNTRIES (COUNTRY_ISO_CODE) )";
    public static final String DROP_TABLE_TEMPLATE = "drop table emp.MYTABLE_{0}";
    public static final String TABLE_NAME_TEMPLATE = "EMP.MYTABLE_{0}";
    public static final String PULSE_CREATE_TABLE_TEMAPLATE = "create table {0} (oid int not null constraint orders_pk_{1} primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint portf_fk_{1} foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch_{1} check (status in ('cancelled', 'open', 'filled')))";
    public static final String CONN_COMMIT_TAG = "CONN_COMMIT";
    public static final String SELECT_QUERY_TAG = "SELECT_QUERY";
    public static final String RENAME_INDEX = "RENAME_INDEX";
    public static final String CREATE_INDEX = "CREATE_INDEX";
    public static final String DROP_INDEX = "DROP_INDEX";
    protected static final String INDEX_MAP = "INDEX_MAP";
    private MBeanHelper mbeanHelper = new MBeanHelper();
    String[] regions = new String[]{"/TRADE/PORTFOLIO", "/TRADE/SELLORDERS"};
    private Properties TheFabricServerProperties;
    private boolean useLocks = false;
    public static String[] actions;
    public static String[] regionList;
    public static String[] tableList;
    private static FabricServerHelper.Endpoint TheLocatorEndpoint;
    static String longRunningProcedure;

    public static void mBeanTestInitialize() {
        mbeanTest = new MBeanTest();
        String clientName = RemoteTestModule.getMyClientName();
        Log.getLogWriter().info("just to check Client Name is :" + clientName);
        COUNTER_SELLORDER_INSERTS = "SELLORDER_INSERTS_" + clientName;
        COUNTER_SELLORDER_UPDATES = "SELLORDER_UPDATES_" + clientName;
        COUNTER_SELLORDER_DELETES = "SELLORDER_DELETES_" + clientName;
        COUNTER_SELLORDER_SELECTS = "SELLORDER_SELECTS_" + clientName;
        COUNTER_SELLORDER_KEYSIZE = "SELLORDER_KEYSIZE_" + clientName;
        COUNTER_SELLORDER_ENTRYSIZE = "SELLORDER_ENTRYSIZE_" + clientName;
        COUNTER_SELLORDER_NO_OF_ROWS = "SELLORDER_NO_OF_ROW_" + clientName;
        COUNTER_NS_CLIENT = "COUNTER_NS_CLIENT_" + clientName;
        COUNTER_NS_PEER = "COUNTER_NS_PEER_" + clientName;
        COUNTER_NS_NESTED = "COUNTER_NS_NESTED_" + clientName;
        COUNTER_NS_INTERNAL = "COUNTER_NS_INTERNAL_" + clientName;
        COUNTER_SELLORDER_COMMITS = "COMMITS_" + clientName + "_TX(S";
        COUNTER_SELLORDER_ROLLBACKS = "ROLLBACKS_" + clientName + "_TXCOMMITS";
        COUNTER_MBEAN_PROC_CALLS = COUNTER_MBEAN_PROC_CALLS_PREFIX + clientName;
        COUNTER_MBEAN_STATEMENT = COUNTER_MBEAN_STATEMENT_PREFIX + clientName;
        COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS = COUNTER_MBEAN_PROC_PROGRESS_PREFIX + clientName;
        THIS_MEMBERID = "MEMBERID_" + clientName;
        mbeanTest.saveCounter(COUNTER_SELLORDER_INSERTS, 0);
        mbeanTest.saveCounter(COUNTER_SELLORDER_UPDATES, 0);
        mbeanTest.saveCounter(COUNTER_SELLORDER_DELETES, 0);
        mbeanTest.saveCounter(COUNTER_SELLORDER_SELECTS, new HashMap());
        mbeanTest.saveCounter(INDEX_MAP, new HashMap());
        mbeanTest.saveCounter(COUNTER_MBEAN_STATEMENT, new HashMap());
        mbeanTest.saveCounter(COUNTER_SELLORDER_KEYSIZE, Float.valueOf(0.0f));
        mbeanTest.saveCounter(COUNTER_SELLORDER_ENTRYSIZE, Float.valueOf(0.0f));
        mbeanTest.saveCounter(COUNTER_SELLORDER_NO_OF_ROWS, 0L);
        mbeanTest.saveCounter(COUNTER_SELLORDER_COMMITS, 0);
        mbeanTest.saveCounter(COUNTER_SELLORDER_ROLLBACKS, 0);
        mbeanTest.saveCounter(COUNTER_MBEAN_PROC_CALLS, 0);
        mbeanTest.saveCounter(COUNTER_MBEAN_PROC_CALLS_EDGE, 0);
        mbeanTest.saveCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS, 0);
        mbeanTest.saveCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS_EDGE, 0);
        mbeanTest.saveCounter(TABLE_SERVER_GROUP, new HashMap());
        mbeanTest.saveCounter(COUNTER_NS_CLIENT, new NetworkServerConnectionStats("Client", 0L, 0L, 0L, 0L, 0L, 0L, 0L));
        mbeanTest.saveCounter(COUNTER_NS_PEER, new NetworkServerConnectionStats("Peer", 0L, 0L, 0L, 0L, 0L, 0L, 0L));
        mbeanTest.saveCounter(COUNTER_NS_NESTED, new NetworkServerNestedConnectionStats("Nested", 0L, 0L, 0L));
        mbeanTest.saveCounter(COUNTER_NS_INTERNAL, new NetworkServerNestedConnectionStats("Internal", 0L, 0L, 0L));
        Log.getLogWriter().info("Reset all counters for client " + clientName);
        mbeanTest.addListener(new CallBackListener(){

            @Override
            public String getName() {
                return MBeanTest.RENAME_INDEX;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Object ... params) {
                String oldIndexName = (String)params[0];
                String indexName = (String)params[0];
                SharedLock lock = SQLBB.getBB().getSharedLock();
                try {
                    lock.lock();
                    Map indexMap = (Map)SQLBB.getBB().getSharedMap().get((Object)MBeanTest.INDEX_MAP);
                    indexMap.put(indexName, indexMap.get(oldIndexName));
                    indexMap.remove(oldIndexName);
                }
                finally {
                    lock.unlock();
                }
            }
        });
        mbeanTest.addListener(new CallBackListener(){

            @Override
            public String getName() {
                return MBeanTest.DROP_INDEX;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Object ... params) {
                String indexName = (String)params[0];
                try {
                    lock.lock();
                    Map indexMap = (Map)SQLBB.getBB().getSharedMap().get((Object)MBeanTest.INDEX_MAP);
                    indexMap.remove(indexName);
                    Log.getLogWriter().info("#dropIndex Index removed " + indexName);
                }
                finally {
                    lock.unlock();
                }
            }
        });
        mbeanTest.addListener(new CallBackListener(){

            @Override
            public String getName() {
                return MBeanTest.CREATE_INDEX;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(Object ... params) {
                String indexName = (String)params[0];
                String tableName = (String)params[1];
                try {
                    lock.lock();
                    Map indexMap = (Map)SQLBB.getBB().getSharedMap().get((Object)MBeanTest.INDEX_MAP);
                    Log.getLogWriter().info("#createIndex Index created  " + indexName + " on table " + tableName);
                    indexMap.put(indexName, tableName);
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBBOnOpenConnction() {
        boolean isManagerRunning;
        boolean bl = isManagerRunning = this.getCounter(MANAGER_RUNNING) > 0;
        if (isManagerRunning) {
            SharedLock lock = SQLBB.getBB().getSharedLock();
            try {
                lock.lock();
                NetworkServerConnectionStats connStat = (NetworkServerConnectionStats)SQLBB.getBB().getSharedMap().get((Object)COUNTER_NS_PEER);
                connStat.updateNetworkServerConnectionStats(connStat.getConnectionsOpened() + 1L, connStat.getConnectionsClosed(), connStat.getConnectionsAttempted() + 1L, connStat.getConnectionsFailed(), connStat.getConnectionLifeTime(), connStat.getConnectionsOpen(), connStat.getConnectionsIdle() + 1L);
                SQLBB.getBB().getSharedMap().put((Object)COUNTER_NS_PEER, (Object)connStat);
                Log.getLogWriter().info("Shared Map Updated after connection create for " + COUNTER_NS_PEER + ", value : " + connStat.toString());
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void HydraTask_createGFEDB() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createGFEDB2();
    }

    public static void HydraTask_doHA() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.doHA();
    }

    public static void HydraTask_execTest() {
        String test;
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        if ("execStmt".equals(test = MBeanPrms.getTests())) {
            mbeanTest.execStmt();
        } else if ("pulseCounter".equals(test)) {
            mbeanTest.pulseCounter();
        }
    }

    public static void HydraTask_execTestUnderLock() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.pulseCounterUnderLock();
    }

    public static void HydraTask_callSQLProcs() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.callSQLProcs();
    }

    public static void HydraTask_createDropTable() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createDropTable();
    }

    public static void HydraTask_startManager() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.startManager();
    }

    public static void HydraTask_printCounters() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.printCounters();
    }

    public static void HydraTask_prepareTest() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.prepareTest();
    }

    public static void HydraTask_verifyAggregateValues() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.verifyAggregateValues();
    }

    public static void HydraTask_verifyTableMBeanValues() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.verifyTableMBeanValues();
    }

    public static void HydraTask_validateMemberView() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.validateMemberView();
    }

    public static void HydraTask_populateDataToBlackBoard() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.populateDataToBB();
    }

    public static void HydraTask_restartManager() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.restartManager();
    }

    public static void HydraTask_restartManagerVM() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.restartManagerVM();
    }

    public static void HydraTask_startLocatorWithManagerRole() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.startLocatorWithManagerRole(true);
    }

    public static void HydraTask_createMultipleTables() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createMultipleTables();
    }

    public static void HydraTask_pulseStabilityTest() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.pulseStabilityTest();
    }

    public static void HydraTask_createDropIndex() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createDropIndexTest();
    }

    public static void HydraTask_alterTableTest() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.alterTableTest();
    }

    public static void HydraTask_waitForMBeanUpdater() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.waitForMBeanUpdater();
    }

    public static void HydraTask_validateAggregatedMemberMBean() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.validateAggregatedMemberMBean();
    }

    public static synchronized void HydraTask_dropRandomTable() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.dropRandomTable();
    }

    private void dropRandomTable() {
    }

    public static synchronized void HydraTask_alterRandomTable() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.alterRandomTable();
    }

    private void alterRandomTable() {
    }

    public static synchronized void HydraTask_ddlRandomTable() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.ddlRandomTable();
    }

    public static void HydraTask_checkForError() {
        MBeanTest.checkForErrors();
    }

    private void ddlRandomTable() {
    }

    private void createMultipleTables() {
        Connection conn = this.getGFEConnection();
        int tableNum = 0;
        try {
            for (int i = 0; i < 100; ++i) {
                tableNum = this.incrementCounter(TABLE_COUNTER);
                String createTable = PULSE_CREATE_TABLE_TEMAPLATE.replace("{0}", "trade.sellorders_" + tableNum);
                createTable = createTable.replace("{1}", "" + tableNum);
                Log.getLogWriter().info("Creating table <" + createTable + ">");
                conn.createStatement().executeUpdate(createTable);
            }
            this.closeGFEConnection(conn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            throw new TestException("createDropTable Failed", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBBOnCloseConnection() {
        boolean isManagerRunning;
        boolean bl = isManagerRunning = this.getCounter(MANAGER_RUNNING) > 0;
        if (isManagerRunning) {
            SharedLock lock = SQLBB.getBB().getSharedLock();
            try {
                lock.lock();
                NetworkServerConnectionStats connStat = (NetworkServerConnectionStats)SQLBB.getBB().getSharedMap().get((Object)COUNTER_NS_PEER);
                connStat.updateNetworkServerConnectionStats(connStat.getConnectionsOpened(), connStat.getConnectionsClosed() + 1L, connStat.getConnectionsAttempted(), connStat.getConnectionsFailed(), connStat.getConnectionLifeTime(), connStat.getConnectionsOpen(), connStat.getConnectionsIdle() - 1L);
                SQLBB.getBB().getSharedMap().put((Object)COUNTER_NS_PEER, (Object)connStat);
                Log.getLogWriter().info("Shared Map Updated after connection close for " + COUNTER_NS_PEER + ", value : " + connStat.toString());
            }
            finally {
                lock.unlock();
            }
        }
    }

    private List<ClientVmInfo> getVmsExcludeShuttingDown() {
        List vmList = StopStartVMs.getAllVMs();
        String vm_shutting_down = (String)SQLBB.getBB().getSharedMap().getMap().get("VM_SHUTTING_DOWN");
        ClientVmInfo toRemoveVM = null;
        if (vm_shutting_down != null || "NULL".equals(vm_shutting_down)) {
            for (ClientVmInfo vm : vmList) {
                if (!vm.getClientName().equals(vm_shutting_down)) continue;
                toRemoveVM = vm;
            }
        }
        if (toRemoveVM != null) {
            boolean removed = vmList.remove(toRemoveVM);
            Log.getLogWriter().info("Removing vminfoRecord for vm " + toRemoveVM.getClientName() + "VID=" + toRemoveVM.getVmid() + " as it is shutting down : " + removed);
        }
        return vmList;
    }

    private void createDropTable() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("Incrementing counter for TABLE_COUNTER");
        int tableNum = this.incrementCounter(TABLE_COUNTER);
        Log.getLogWriter().info("Next Table Number is " + tableNum);
        boolean managerReadLocked = false;
        try {
            String table = CREATE_TABLE_TEMPLATE;
            String createTable = table.replace("{0}", "" + tableNum);
            String serverGroupString = "";
            ArrayList<String> serverGroupList = new ArrayList<String>();
            boolean onServerGroups = HydraUtil.getRandomBoolean();
            String tableName = TABLE_NAME_TEMPLATE.replace("{0}", "" + tableNum);
            Log.getLogWriter().info("Table Name to create : " + tableName);
            if (!isEdge) {
                if (onServerGroups) {
                    String sg = (String)HydraUtil.getRandomElement(this.getServerGroupsArray());
                    Log.getLogWriter().info("Server group for table : " + sg);
                    while (DEFAULT_SERVER_GROUP.equals(sg)) {
                        sg = (String)HydraUtil.getRandomElement(this.getServerGroupsArray());
                    }
                    serverGroupList.add(sg);
                    serverGroupString = " SERVER GROUPS (" + sg + ")";
                    createTable = createTable + serverGroupString;
                    Log.getLogWriter().info("sql for create table so far : " + createTable);
                    this.saveTableToServerGroupMapping(tableName, Collections.singletonList(sg));
                } else {
                    serverGroupList.add(DEFAULT_SERVER_GROUP);
                }
            }
            createTable = createTable + this.appendPersistentToTableDefinition();
            Log.getLogWriter().info("sql for create table so far : " + createTable);
            createTable = createTable + this.appendPartitionToTableDefinition();
            Log.getLogWriter().info("sql for create table so far : " + createTable);
            boolean tableCreated = false;
            try {
                Log.getLogWriter().info("Creating table <" + createTable + ">");
                conn.createStatement().executeUpdate(createTable);
                tableCreated = true;
                Log.getLogWriter().info("Created table <" + createTable + ">");
            }
            catch (SQLException e) {
                tableCreated = false;
            }
            if (tableCreated) {
                this.sleepForDataUpdaterJMX();
                this.lockReadManager();
                List<ClientVmInfo> vmList = this.getVmsExcludeShuttingDown();
                MBeanServerConnection mbeanServer = this.connectJMXConnector();
                managerReadLocked = true;
                this.checkTableMBean(mbeanServer, true, vmList, tableName, serverGroupList, true, true);
                String dropTable = DROP_TABLE_TEMPLATE.replace("{0}", "" + tableNum);
                Log.getLogWriter().info("Dropping table <" + dropTable + ">");
                conn.createStatement().executeUpdate(dropTable);
                Log.getLogWriter().info("Dropped table <" + dropTable + ">");
                this.sleepForDataUpdaterJMX();
                this.checkTableMBean(mbeanServer, false, vmList, tableName, serverGroupList, true, true);
            } else {
                Log.getLogWriter().info("SQLException while creating table skipping this iteration #CrDpTableFailed " + tableName);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)se));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (TestException e) {
            throw new TestException("createDropTable\n" + TestHelper.getStackTrace((Throwable)e));
        }
        finally {
            if (managerReadLocked) {
                this.unLockReadManager();
            }
        }
        Log.getLogWriter().info("createDropTable : OK ");
    }

    private void sleepForDataUpdaterJMX() {
        HydraUtil.sleepForDataUpdaterJMX((long)15L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateRefTable() {
        Log.getLogWriter().info("Trying to create ref country table...");
        String sql = "CREATE TABLE COUNTRIES(COUNTRY VARCHAR(26) NOT NULL CONSTRAINT COUNTRIES_UNQ_NM Unique, COUNTRY_ISO_CODE CHAR(2) NOT NULL CONSTRAINT COUNTRIES_PK PRIMARY KEY,REGION VARCHAR(26), CONSTRAINT COUNTRIES_UC CHECK (country_ISO_code = upper(country_ISO_code) )) PARTITION BY PRIMARY KEY";
        Connection conn = this.getGFEConnection();
        try {
            conn.createStatement().executeUpdate(sql);
        }
        catch (SQLException e) {
            if (!e.getMessage().contains("already exists")) {
                Log.getLogWriter().error("Error occurred while creating COUNTRIES table for ref, it may be already exist, Error : " + e.getMessage());
            }
        }
        finally {
            this.closeGFEConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateDiskStore() {
        Log.getLogWriter().info("Trying to create disk store...");
        String sql = "CREATE DISKSTORE OVERFLOWDISKSTORE";
        Connection conn = this.getGFEConnection();
        try {
            conn.createStatement().executeUpdate(sql);
        }
        catch (SQLException e) {
            if (!e.getMessage().contains("already exists")) {
                Log.getLogWriter().error("Error occurred while creating diskstore for ref, it may be already exist, Error : " + e.getMessage());
            }
        }
        finally {
            this.closeGFEConnection(conn);
        }
    }

    private String appendColocateToTableDefinition(String table) {
        String colocated = "";
        if (table.equals(CREATE_TABLE_TEMPLATE_2)) {
            colocated = (String)HydraUtil.getRandomElement((Object[])new String[]{" COLOCATE WITH (COUNTRIES)", " "});
        }
        return colocated;
    }

    private String appendEvicitionToTableDefinition() {
        String eviction = (String)HydraUtil.getRandomElement((Object[])new String[]{" EVICTION BY CRITERIA (EID < 300000) EVICTION FREQUENCY 180 SECONDS ", " EVICTION BY LRUMEMSIZE 1000 EVICTACTION DESTROY", " EVICTION BY LRUCOUNT 2 EVICTACTION OVERFLOW 'OverflowDiskStore'", " "});
        return eviction;
    }

    private String appendPartitionToTableDefinition() {
        String partition = (String)HydraUtil.getRandomElement((Object[])new String[]{"  PARTITION BY PRIMARY KEY REDUNDANCY 1 ", "  PARTITION BY COLUMN (SINCE) ", "  PARTITION BY RANGE (SINCE) ( VALUES BETWEEN '2010-01-01' AND '2010-04-01',   VALUES BETWEEN '2010-04-01' AND '2010-07-01', VALUES BETWEEN '2010-07-01' AND '2010-10-01',VALUES BETWEEN '2010-10-01' AND '2011-01-01')", " PARTITION BY LIST (SSN) ( VALUES ('PDX', 'LAX'), VALUES ('AMS', 'DUB'), VALUES ('DTW', 'ORL'))", "  PARTITION BY (MONTH(SINCE))"});
        return partition;
    }

    private String appendPersistentToTableDefinition() {
        String persistent = (String)HydraUtil.getRandomElement((Object[])new String[]{"  PERSISTENT ASYNCHRONOUS", "  PERSISTENT SYNCHRONOUS", "  PERSISTENT"});
        return persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableToServerGroupMapping(String tableName, List<String> sg) {
        Log.getLogWriter().info("Saving Counter for Server Group : tableName : " + tableName + " and ServerGroup : " + sg);
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            Map map = (Map)SQLBB.getBB().getSharedMap().get((Object)TABLE_SERVER_GROUP);
            map.put(tableName, sg);
            Log.getLogWriter().info("Map to save for Table Server group : " + map);
            SQLBB.getBB().getSharedMap().put((Object)TABLE_SERVER_GROUP, (Object)map);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableAttribute(String tableName, Map<String, Object> tableAttrMap) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            SQLBB.getBB().getSharedMap().put((Object)tableName, tableAttrMap);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getTableAttribute(String tableName) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            Map map = (Map)SQLBB.getBB().getSharedMap().get((Object)tableName);
            return map;
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, String> getAllIndex() {
        return (Map)SQLBB.getBB().getSharedMap().get((Object)INDEX_MAP);
    }

    private List<String> getAllIndex(String tableName) {
        ArrayList<String> indexForTable = new ArrayList<String>();
        Map indexMap = (Map)SQLBB.getBB().getSharedMap().get((Object)INDEX_MAP);
        if (indexMap != null) {
            for (Map.Entry entry : indexMap.entrySet()) {
                if (!tableName.equalsIgnoreCase((String)entry.getValue())) continue;
                indexForTable.add((String)entry.getKey());
            }
        }
        return indexForTable;
    }

    protected void createGFEDB2() {
        Properties info = this.getGemFireProperties();
        info.setProperty("host-data", "true");
        Log.getLogWriter().info("Connecting with properties: " + info);
        String groups = this.getServerGroups();
        if (groups != null) {
            info.setProperty("server-groups", groups);
        }
        this.startGFXDDB(info);
    }

    private void validateMemberView() {
        ClientVmInfo vmInfo = new ClientVmInfo(Integer.valueOf(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost());
        ArrayList<ClientVmInfo> vmInfoList = new ArrayList<ClientVmInfo>();
        vmInfoList.add(vmInfo);
        this.checkMemberViewFromManager(true, vmInfoList);
        this.checkAggrTableViewFromManager(true, vmInfoList);
        Log.getLogWriter().info("validateMemberView : OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDataToBB() {
        HydraUtil.sleepForReplicationJMX();
        ArrayList<ClientVmInfo> vmInfoList = new ArrayList<ClientVmInfo>();
        ClientVmInfo vmInfo = new ClientVmInfo(Integer.valueOf(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost());
        vmInfoList.add(vmInfo);
        ArrayList<String> defaultGrp = new ArrayList<String>();
        defaultGrp.add(DEFAULT_SERVER_GROUP);
        MBeanServerConnection mbeanServer = null;
        try {
            this.lockReadManager();
            mbeanServer = this.connectJMXConnector();
            for (String table : tableList) {
                try {
                    this.populateTableMBean(mbeanServer, true, vmInfoList, table, defaultGrp);
                }
                catch (MalformedObjectNameException e) {
                    throw new TestException("Error while populating tableMBeans into BB\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (NullPointerException e) {
                    throw new TestException("Error while populating tableMBeans into BB\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (IOException e) {
                    throw new TestException("Error while populating tableMBeans into BB\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (AttributeNotFoundException e) {
                    throw new TestException("Error while populating tableMBeans into BB\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (TestException e) {
                    throw new TestException("Error while populating tableMBeans into BB\n" + TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
        finally {
            this.closeJMXConnector();
            this.unLockReadManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTableMBeanValues() {
        SharedLock lock = MBeanCloseTaskBB.getBB().getSharedLock();
        try {
            HydraUtil.sleepForReplicationJMX();
            this.useLocks = false;
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            lock.lock();
            this.checkTableMBeans(mbeanServer, true);
            this.checkMemberMBeans(mbeanServer, true);
        }
        finally {
            lock.unlock();
            this.closeJMXConnector();
            this.unLockReadManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAggregateValues() {
        SharedLock lock = MBeanCloseTaskBB.getBB().getSharedLock();
        try {
            HydraUtil.sleepForReplicationJMX();
            this.useLocks = false;
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            this.checkProcCalls(mbeanServer);
            this.checkDSCounters(mbeanServer);
            lock.lock();
            this.checkTableMBeans(mbeanServer, true, true);
            this.checkMemberMBeans(mbeanServer, true, true);
        }
        finally {
            lock.unlock();
            this.closeJMXConnector();
            this.unLockReadManager();
        }
    }

    private void restartManager() {
        Log.getLogWriter().info("In restartManager");
        List vmList = StopStartVMs.getAllVMs();
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ManagementService service = ManagementService.getExistingManagementService((Cache)cache);
        this.saveCounter(MANAGER_RUNNING, 0);
        this.lockWriteManager();
        Log.getLogWriter().info("Waiting for all validation operation to finish ....");
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.sleepForReplicationJMX();
        Log.getLogWriter().info("Stopping manager ....");
        service.stopManager();
        Log.getLogWriter().info("Starting manager ....");
        service.startManager();
        Log.getLogWriter().info("Stared manager waiting for all mbeans to register....");
        this.unLockWriteManager();
        this.incrementCounter(MANAGER_RUNNING);
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.sleepForReplicationJMX();
        Log.getLogWriter().info("Stared manager completed....");
        this.checkMemberViewFromManager(true, vmList);
        this.checkAggrTableViewFromManager(true, vmList);
        Log.getLogWriter().info("restartManager completed successfully waiting for pending validations to complete....");
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.sleepForReplicationJMX();
        Log.getLogWriter().info("restartManager completed successfully : OK....");
    }

    private void restartManagerVM() {
        Log.getLogWriter().info("In restartManagerVM");
        List vmList = StopStartVMs.getAllVMs();
        ArrayList<ClientVmInfo> selectedVmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        String clientId = RemoteTestModule.getMyClientName();
        for (ClientVmInfo cInfo : vmList) {
            Log.getLogWriter().info("Considering Vm " + cInfo.getClientName());
            if (!cInfo.getClientName().contains("manager") || cInfo.getClientName().contains(clientId) || selectedVmList.size() >= 1) continue;
            selectedVmList.add(cInfo);
            SQLBB.getBB().getSharedMap().put((Object)"VM_SHUTTING_DOWN", (Object)cInfo.getClientName());
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        this.lockWriteManager();
        this.saveCounter(MANAGER_RUNNING, 0);
        this.incrementCounter("VM_SHUTDOWN");
        HydraUtil.logInfo((String)("Shutting down client : " + selectedVmList));
        StopStartVMs.stopVMs(selectedVmList, stopModeList);
        this.unLockWriteManager();
        HydraUtil.logInfo((String)(selectedVmList + " clients were Shutdown"));
        HydraUtil.sleepForReplicationJMX();
        StopStartVMs.startVMs(selectedVmList);
        SQLBB.getBB().getSharedMap().put((Object)"VM_SHUTTING_DOWN", (Object)"NULL");
        HydraUtil.logInfo((String)("Restarted VMS : " + HydraUtil.ObjectToString(selectedVmList)));
        this.connectorTL.set(null);
        HydraUtil.sleepForReplicationJMX();
        this.checkMemberViewFromManager(true, vmList);
        this.checkAggrTableViewFromManager(true, vmList);
        this.saveCounter("VM_SHUTDOWN", 0);
        Log.getLogWriter().info("In doHA : restartManagerVM");
    }

    private void prepareTest() {
        this.useLocks = MBeanPrms.useManagerLocks();
        Log.getLogWriter().info("Managerlock use : " + this.useLocks);
        if (MBeanPrms.isWANTest()) {
            String clientName = RemoteTestModule.getMyClientName();
            String[] array = clientName.split("_");
            String dsName = "ds_" + array[1];
            Log.getLogWriter().info("Client " + clientName + ", WanSite " + array[1] + ", dsName : " + dsName);
            SQLBB.getBB().getSharedMap().put((Object)("CLIENT_DS_" + RemoteTestModule.getMyClientName()), (Object)dsName);
        }
        Log.getLogWriter().info("Putting member details on bb for " + THIS_MEMBERID + " is " + ManagementUtil.getMemberID());
        SQLBB.getBB().getSharedMap().put((Object)THIS_MEMBERID, (Object)ManagementUtil.getMemberID());
        this.saveMemberMapping();
        Log.getLogWriter().info("Member isStore : " + GemFireStore.getBootedInstance().getMyVMKind().isStore());
        Log.getLogWriter().info("Member isAccessor : " + GemFireStore.getBootedInstance().getMyVMKind().isAccessor());
        Log.getLogWriter().info("Member isAccesorOrStore : " + GemFireStore.getBootedInstance().getMyVMKind().isAccessorOrStore());
        Log.getLogWriter().info("Member isLocator : " + GemFireStore.getBootedInstance().getMyVMKind().isLocator());
        Log.getLogWriter().info("Member isAdmin : " + GemFireStore.getBootedInstance().getMyVMKind().isAdmin());
        Log.getLogWriter().info("Member isAgent : " + GemFireStore.getBootedInstance().getMyVMKind().isAgent());
        Log.getLogWriter().info("isEdge : " + isEdge);
        if (isEdge && GemFireStore.getBootedInstance().getMyVMKind().isLocator()) {
            return;
        }
        Connection conn = this.getGFEConnection();
        ResultSet rs = null;
        int max = 0;
        try {
            rs = conn.createStatement().executeQuery("select max(oid) from trade.sellorders");
            while (rs.next()) {
                max = rs.getInt(1);
            }
            rs.close();
            Log.getLogWriter().info("New Order Id is " + max);
            this.saveCounter("SELLORDER_OID", max);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
            throw new TestException("Failed", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMemberMapping() {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            HashMap<String, String> membersMap = (HashMap<String, String>)SQLBB.getBB().getSharedMap().get((Object)MEMBERS_MAPPING);
            if (membersMap == null) {
                membersMap = new HashMap<String, String>();
            }
            membersMap.put(ManagementUtil.getMemberID(), RemoteTestModule.getMyClientName());
            SQLBB.getBB().getSharedMap().put((Object)MEMBERS_MAPPING, membersMap);
        }
        finally {
            lock.unlock();
        }
    }

    private void startManager() {
        Log.getLogWriter().info("Starting the fabric server jmx manager");
        Properties info = this.getGemFireProperties();
        info.setProperty("gemfire.jmx-manager", "true");
        info.setProperty("gemfire.jmx-manager-start", "true");
        int port = PortHelper.getRandomPort();
        info.setProperty("gemfire.jmx-manager-port", "" + port);
        String groups = this.getServerGroups();
        if (groups != null) {
            info.setProperty("server-groups", groups);
        }
        Log.getLogWriter().info("Connecting with properties: " + info);
        this.startGFXDDB(info);
        SQLBB.getBB().getSharedMap().put((Object)"JMX_PORT", (Object)port);
        SQLBB.getBB().getSharedMap().put((Object)"QUERY_NODE", (Object)ManagementUtil.getMemberID());
        Log.getLogWriter().info("Started the fabric server jmx manager");
        this.incrementCounter(MANAGER_RUNNING);
    }

    private void execStmt() {
        ResultSet rs = null;
        PreparedStatement statement = null;
        try {
            Connection conn = this.getGFEConnection();
            String stmt = MBeanPrms.getStatements();
            statement = conn.prepareStatement(stmt);
            Log.getLogWriter().info("Executing statment : " + stmt);
            int tid = RemoteTestModule.getCurrentThread().getThreadId();
            statement.setInt(1, tid);
            statement.execute();
            rs = statement.getResultSet();
            this.incrementCounter("STMT_" + stmt);
            Log.getLogWriter().info("Executed count  : " + this.getCounter("STMT_" + stmt));
            this.closeRS(rs);
            this.closeStatement(statement);
        }
        catch (SQLException e) {
            try {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to execute statement\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (Throwable throwable) {
                this.closeRS(rs);
                this.closeStatement(statement);
                throw throwable;
            }
        }
    }

    private void closeStatement(PreparedStatement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void closeRS(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pulseCounter() {
        try {
            this.transaction("trade.sellorders");
        }
        catch (SQLTransactionRollbackException e) {
            if (MBeanPrms.isHATest() && this.getCounter("VM_SHUTDOWN") > 0) {
                Log.getLogWriter().info("SQLTransactionRollbackException possibly due to concurrent vm shutdown");
                return;
            }
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
        }
        try {
            HydraUtil.sleepForReplicationJMX();
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            if (isEdge) {
                Log.getLogWriter().info("member is edge, so no need to verify mbean here");
                return;
            }
            if (mbeanServer == null && this.isThisManagerVM()) {
                Log.getLogWriter().info("Skipping verification as manager is restarting ...");
                return;
            }
            if (mbeanServer == null) {
                throw new TestException("mbeanServer is null");
            }
            this.checkMemberCounters(mbeanServer);
            this.checkRegionCounter(mbeanServer);
            this.checkGfxdMBeans(mbeanServer, false);
        }
        finally {
            this.closeJMXConnector();
            this.unLockReadManager();
        }
    }

    private void pulseStabilityTest() {
        try {
            int tablesCreated = this.getCounter(TABLE_COUNTER);
            for (int i = 0; i < 5; ++i) {
                int randomIndex = HydraUtil.getnextNonZeroRandomInt((int)tablesCreated);
                String tableName = "trade.sellorders_" + randomIndex;
                this.transaction(tableName);
            }
        }
        catch (SQLTransactionRollbackException e) {
            if (MBeanPrms.isHATest() && this.getCounter("VM_SHUTDOWN") > 0) {
                Log.getLogWriter().info("SQLTransactionRollbackException possibly due to concurrent vm shutdown");
                return;
            }
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (SQLException e) {
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDropIndexTest() {
        Connection conn = this.getGFEConnection();
        try {
            conn.setAutoCommit(false);
            conn.setTransactionIsolation(1);
        }
        catch (SQLException e) {
            throw new TestException("Error while getting connection \n" + TestHelper.getStackTrace((Throwable)e));
        }
        this.setTableCols();
        IndexDDLStmt indexStmt = new IndexDDLStmt();
        indexStmt.addListener(new CallBackListener(){

            @Override
            public String getName() {
                return MBeanTest.CONN_COMMIT_TAG;
            }

            @Override
            public void execute(Object ... params) {
                MBeanTest.this.incrementCounter(COUNTER_SELLORDER_COMMITS);
            }
        });
        SharedLock sharedLock = MBeanIndexBB.getBB().getSharedLock();
        try {
            sharedLock.lock();
            indexStmt.doDDLOp(null, conn);
        }
        finally {
            sharedLock.unlock();
        }
        Log.getLogWriter().info("Index Map : " + (Map)SQLBB.getBB().getSharedMap().get((Object)INDEX_MAP));
    }

    private void alterTableTest() {
        block7: {
            Connection conn = this.getGFEConnection();
            String op = (String)HydraUtil.getRandomElement((Object[])new String[]{"add", "delete"});
            try {
                String tableName;
                ResultSet rs;
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(1);
                if ("delete".equals(op)) {
                    rs = conn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
                    while (rs.next()) {
                        tableName = rs.getString(1);
                        if (tableName.equalsIgnoreCase("txhistory") || tableName.equalsIgnoreCase("TRADES")) continue;
                        this.dropColumn(conn, tableName);
                    }
                }
                if (!"add".equals(op)) break block7;
                rs = conn.createStatement().executeQuery("select tablename from sys.systables where tabletype = 'T' and tableschemaname='TRADE'");
                while (rs.next()) {
                    tableName = rs.getString(1);
                    List<String> columnDef = this.getDropColumnsFromSharedMap(tableName);
                    if (columnDef == null || columnDef.size() <= 0) continue;
                    String addColumn = "alter table trade." + tableName + " add column " + columnDef.get(0);
                    columnDef.remove(0);
                    try {
                        conn.createStatement().execute(addColumn);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                    Log.getLogWriter().info("added the column " + columnDef + " to the table " + tableName);
                }
            }
            catch (SQLException e) {
                throw new TestException("Error while getting connection \n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    private void waitForMBeanUpdater() {
        Log.getLogWriter().info("Sleeping for 1.5 minutes so that table mbean updates all memAnalytics data");
        try {
            Thread.sleep(90000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Log.getLogWriter().info("Sleeping done");
    }

    private void dropColumn(Connection conn, String tableName) {
        try {
            Struct aColumn;
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet columns = meta.getColumns(null, "TRADE", tableName, null);
            List<Struct> columnList = ResultSetHelper.asList(columns, false);
            this.log().info("columns are " + ResultSetHelper.listToString(columnList));
            String columnType = null;
            String columnName = null;
            do {
                aColumn = columnList.get(random.nextInt(columnList.size()));
                columnType = (String)aColumn.get("TYPE_NAME");
            } while ((columnName = (String)aColumn.get("COLUMN_NAME")).equals("TID"));
            String dropColumn = "alter table trade." + tableName + " drop" + (random.nextBoolean() ? " column " : " ") + columnName + " RESTRICT ";
            Log.getLogWriter().info("in gfxd dropping the column " + columnName + " in table " + tableName);
            conn.createStatement().execute(dropColumn);
            List<String> droppedColumn = this.getDropColumnsFromSharedMap(tableName);
            if (droppedColumn == null) {
                droppedColumn = new ArrayList<String>();
                SQLBB.getBB().getSharedMap().put((Object)("dropColumn" + tableName), droppedColumn);
            }
            droppedColumn.add(columnName + " " + columnType);
        }
        catch (SQLException e) {
            Log.getLogWriter().warning("Error while droppin column.. ignoring it...");
        }
    }

    private List<String> getDropColumnsFromSharedMap(String tableName) {
        return (List)SQLBB.getBB().getSharedMap().get((Object)("dropColumn" + tableName));
    }

    private void transaction(String tableName) throws SQLException {
        Connection conn = this.getGFEConnection();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(1);
        String op = (String)HydraUtil.getRandomElement((Object[])new String[]{"insert", "delete", "update", "put", "select"});
        Log.getLogWriter().info("Trying to execute " + op + " on " + tableName);
        try {
            if ("insert".equals(op)) {
                this.doInsert(conn, tableName);
            } else if ("update".equals(op)) {
                this.doUpdate(conn, tableName);
            } else if ("delete".equals(op)) {
                this.doDelete(conn, tableName);
            } else if ("select".equals(op)) {
                this.doSelect(conn, tableName);
            } else if ("put".equals(op)) {
                this.doPut(conn, tableName);
            }
            if (HydraUtil.getRandomBoolean()) {
                conn.commit();
                this.incrementCounter(COUNTER_SELLORDER_COMMITS);
                Log.getLogWriter().info("Executed COMMITS  : " + this.getCounter(COUNTER_SELLORDER_COMMITS));
            } else {
                conn.rollback();
                this.incrementCounter(COUNTER_SELLORDER_ROLLBACKS);
                Log.getLogWriter().info("Executed ROLLBACKS  : " + this.getCounter(COUNTER_SELLORDER_ROLLBACKS));
            }
        }
        catch (SQLException e) {
            Log.getLogWriter().error("Error occurred while executing Op : " + op + ", This will no impact Test. Error : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSQLProcs() {
        try {
            this.doProcedureCall();
        }
        catch (SQLException e) {
            if (MBeanPrms.isHATest() && this.getCounter("VM_SHUTDOWN") > 0) {
                Log.getLogWriter().info("SQLExceptoin possibly due to concurrent shutdown");
                return;
            }
            Log.getLogWriter().info("SQLExceptoin possibly due to concurrent shutdown VM Count : " + this.getCounter("VM_SHUTDOWN") + " isHATest : " + MBeanPrms.isHATest());
            SQLHelper.printSQLException(e);
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        try {
            HydraUtil.sleepForReplicationJMX();
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            if (isEdge) {
                Log.getLogWriter().info("member is edge, so no need to verify mbean here");
                return;
            }
            if (mbeanServer == null && this.isThisManagerVM()) {
                Log.getLogWriter().info("Skipping verification as manager is restarting ...");
                return;
            }
            if (mbeanServer == null) {
                throw new TestException("mbeanServer is null");
            }
            this.checkProcCalls(mbeanServer);
        }
        finally {
            this.closeJMXConnector();
            this.unLockReadManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHA() {
        Log.getLogWriter().info("In doHA");
        List vmList = StopStartVMs.getAllVMs();
        ArrayList<ClientVmInfo> selectedVmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        String clientId = RemoteTestModule.getMyClientName();
        for (ClientVmInfo cInfo : vmList) {
            Log.getLogWriter().info("Considering Vm " + cInfo.getClientName());
            if (cInfo.getClientName().contains("manager") || cInfo.getClientName().contains(clientId) || selectedVmList.size() >= 1) continue;
            selectedVmList.add(cInfo);
            SQLBB.getBB().getSharedMap().put((Object)"VM_SHUTTING_DOWN", (Object)cInfo.getClientName());
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        HydraUtil.logInfo((String)("Shutting down client : " + selectedVmList));
        StopStartVMs.stopVMs(selectedVmList, stopModeList);
        this.incrementCounter("VM_SHUTDOWN");
        HydraUtil.logInfo((String)(selectedVmList + " clients were Shutdown"));
        HydraUtil.sleepForReplicationJMX();
        this.checkMemberViewFromManager(false, selectedVmList);
        StopStartVMs.startVMs(selectedVmList);
        SQLBB.getBB().getSharedMap().put((Object)"VM_SHUTTING_DOWN", (Object)"NULL");
        HydraUtil.logInfo((String)("Restarted VMS : " + HydraUtil.ObjectToString(selectedVmList)));
        HydraUtil.sleepForReplicationJMX();
        this.checkMemberViewFromManager(true, selectedVmList);
        this.saveCounter("VM_SHUTDOWN", 0);
        Log.getLogWriter().info("In doHA : OK");
    }

    private void checkAggrTableViewFromManager(boolean expectedBeans, List<ClientVmInfo> selectedVmList) {
        this.lockReadManager();
        MBeanServerConnection mbeanServer = this.connectJMXConnector();
        try {
            for (int i = 0; i < regionList.length; ++i) {
                String aggrTableONStr = aggrTableONTemplate.replace("{0}", tableList[i]);
                ObjectName aggrTableON = new ObjectName(aggrTableONStr);
                Log.getLogWriter().info("Querying for aggrTableON instance " + aggrTableON);
                try {
                    ObjectInstance instance = mbeanServer.getObjectInstance(aggrTableON);
                    Log.getLogWriter().info("Found instance " + aggrTableON + " Expected " + expectedBeans);
                    if (expectedBeans || instance == null) continue;
                    throw new TestException("Found aggreTable instance for " + tableList[i] + " when not expected ");
                }
                catch (InstanceNotFoundException e) {
                    if (!expectedBeans) continue;
                    MBeanTest.logMBeans(MessageFormat.format("GemFireXD:service=Table,type=Aggregate,table={0}", "*"), mbeanServer);
                    throw new TestException("checkAggrTableViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
        catch (IOException e) {
            throw new TestException("checkAggrTableViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("checkAggrTableViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("checkAggrTableViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
        }
        finally {
            this.unLockReadManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkMemberViewFromManager(boolean expectedBeans, List<ClientVmInfo> selectedVmList) {
        try {
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            for (ClientVmInfo info : selectedVmList) {
                try {
                    Set<DistributedMember> apiMemberSet;
                    String memberId = (String)SQLBB.getBB().getSharedMap().get((Object)("MEMBERID_" + info.getClientName()));
                    List<String> serverGroups = this.getServerGroupsArray(info.getClientName());
                    for (String serverGroup : serverGroups) {
                        this.checkMemberView(expectedBeans, mbeanServer, memberId, serverGroup);
                    }
                    int i = 0;
                    for (String region : regionList) {
                        block15: {
                            block14: {
                                String regionONStr = regionONTemplate.replace("{0}", region);
                                regionONStr = regionONStr.replace("{1}", memberId);
                                ObjectName regionON = new ObjectName(regionONStr);
                                Log.getLogWriter().info("Querying for region instance " + regionON);
                                try {
                                    ObjectInstance instance = mbeanServer.getObjectInstance(regionON);
                                    Log.getLogWriter().info("Found instance " + regionON + " Expected " + expectedBeans);
                                    if (!expectedBeans && instance != null) {
                                        throw new TestException("Found region table instance " + regionON + " when not expected ");
                                    }
                                }
                                catch (InstanceNotFoundException e) {
                                    if (!expectedBeans) break block14;
                                    MBeanTest.logMBeans(MessageFormat.format("GemFireXD:group={0},service=Table,type=Member,member={1},table={2}", "*", "*", "*"), mbeanServer);
                                    throw new TestException("checkMemberViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
                                }
                            }
                            String serverGroup = DEFAULT_SERVER_GROUP;
                            Log.getLogWriter().info("Checking table mbean for server-group " + serverGroup);
                            String tableONStr = tableONTemplate.replace("{0}", serverGroup);
                            tableONStr = tableONStr.replace("{1}", memberId);
                            tableONStr = tableONStr.replace("{2}", tableList[i]);
                            ObjectName tableON = new ObjectName(tableONStr);
                            Log.getLogWriter().info("Querying for instance " + tableON);
                            try {
                                ObjectInstance instance = mbeanServer.getObjectInstance(tableON);
                                Log.getLogWriter().info("Found instance " + tableON + " Expected " + expectedBeans);
                                if (!expectedBeans && instance != null) {
                                    throw new TestException("Found table instance " + tableON + " when not expected ");
                                }
                            }
                            catch (InstanceNotFoundException e) {
                                if (!expectedBeans) break block15;
                                MBeanTest.logMBeans(MessageFormat.format("GemFireXD:group={0},service=Table,type=Member,member={1},table={2}", "*", "*", "*"), mbeanServer);
                                throw new TestException("checkMemberViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
                            }
                        }
                        ++i;
                    }
                    this.validateStatementStatistics(expectedBeans, mbeanServer, memberId);
                    String[] members = this.getGfxdClusterMembers(mbeanServer);
                    if (members.length == (apiMemberSet = this.getMembersSet()).size()) continue;
                    MBeanHelper.saveError("Member set on cluster mbean is wrong jmx " + HydraUtil.ObjectToString((Object)members) + " API : " + HydraUtil.ObjectToString(apiMemberSet));
                    throw new TestException("Member set on cluster mbean is wrong jmx " + HydraUtil.ObjectToString((Object)members) + " API : " + HydraUtil.ObjectToString(apiMemberSet));
                }
                catch (Exception e) {
                    throw new TestException("checkMemberViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
                    return;
                }
            }
        }
        finally {
            this.unLockReadManager();
        }
    }

    private void checkMemberView(boolean expectedBeans, MBeanServerConnection mbeanServer, String memberId, String serverGroup) throws MalformedObjectNameException, IOException, TestException {
        block3: {
            Log.getLogWriter().info("Checking GFXDMemberMBean for server group " + serverGroup + " and memberId : " + memberId);
            String memberONstr = memberONTemplate.replace("{0}", serverGroup);
            memberONstr = memberONstr.replace("{1}", memberId);
            ObjectName memberON = new ObjectName(memberONstr);
            Log.getLogWriter().info("Querying for member instance " + memberON);
            try {
                ObjectInstance instance = mbeanServer.getObjectInstance(memberON);
                Log.getLogWriter().info("Found instance " + memberON + " Expected " + expectedBeans);
                if (!expectedBeans && instance != null) {
                    throw new TestException("Found member instance " + memberON + " when not expected ");
                }
            }
            catch (InstanceNotFoundException e) {
                if (!expectedBeans) break block3;
                MBeanTest.logMBeans(MessageFormat.format("GemFireXD:group={0},type=Member,member={1}", "*", "*"), mbeanServer);
                throw new TestException("checkMemberViewFromManager\n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    private void validateStatementStatistics(boolean expectedBeans, MBeanServerConnection mbeanServer, String memberId) throws MalformedObjectNameException, IOException, TestException {
        String statementONStr = statementONTemplate.replace("{0}", memberId);
        statementONStr = statementONStr.replace("{1}", "*");
        ObjectName statementON = new ObjectName(statementONStr);
        Set<ObjectName> set = mbeanServer.queryNames(statementON, null);
        Log.getLogWriter().info("Statement MBeans found " + HydraUtil.ObjectToString(set));
        if (expectedBeans) {
            if (set.size() == 0) {
                throw new TestException("Found 0 Statement Mbeans");
            }
        } else if (set.size() > 0) {
            throw new TestException("Found " + set.size() + " Statement Mbeans when expecting zero mbeans");
        }
    }

    static void logMBeans(String pattern, MBeanServerConnection mbeanServer) {
        try {
            Log.getLogWriter().info("EXISTING MBeans: " + mbeanServer.queryNames(MBeanJMXAdapter.getObjectName((String)pattern), null));
        }
        catch (IOException e) {
            Log.getLogWriter().info("Exception while querying EXISTING MBeans.", (Throwable)e);
        }
    }

    private void populateTableMBean(MBeanServerConnection mbeanServer, boolean expectedBeans, List<ClientVmInfo> selectedVmList, String tableName, List<String> serverGroups) throws MalformedObjectNameException, NullPointerException, IOException, AttributeNotFoundException, TestException {
        this.checkTableMBean(mbeanServer, expectedBeans, selectedVmList, tableName, serverGroups, true, false, false);
    }

    private void checkTableMBean(MBeanServerConnection mbeanServer, boolean expectedBeans, List<ClientVmInfo> selectedVmList, String tableName, List<String> serverGroups, boolean verifyMBean, boolean verifyAggregateMBean) throws MalformedObjectNameException, NullPointerException, IOException, AttributeNotFoundException, TestException {
        this.checkTableMBean(mbeanServer, expectedBeans, selectedVmList, tableName, serverGroups, false, verifyMBean, verifyAggregateMBean);
    }

    private void checkTableMBean(MBeanServerConnection mbeanServer, boolean expectedBeans, List<ClientVmInfo> selectedVmList, String tableName, List<String> serverGroups, boolean populateBB, boolean verifyMBean, boolean verifyAggregateMBean) throws MalformedObjectNameException, NullPointerException, IOException, AttributeNotFoundException, TestException {
        for (ClientVmInfo info : selectedVmList) {
            String memberId = (String)SQLBB.getBB().getSharedMap().get((Object)("MEMBERID_" + info.getClientName()));
            ArrayList<String> newServerGroups = new ArrayList<String>(serverGroups);
            newServerGroups.add(DEFAULT_SERVER_GROUP);
            for (String serverGroup : newServerGroups) {
                this.checkTableMBeanForGroup(mbeanServer, expectedBeans, tableName, populateBB, info, memberId, serverGroup, verifyMBean);
            }
        }
        if (populateBB) {
            return;
        }
        if (verifyAggregateMBean) {
            this.verifyAggregatedValueForTableMBean(mbeanServer, expectedBeans, tableName);
        }
    }

    private void verifyAggregatedValueForTableMBean(MBeanServerConnection mbeanServer, boolean expectedBeans, String tableName) throws MalformedObjectNameException, IOException, TestException {
        HydraUtil.sleepForReplicationJMX();
        String tableONStr = aggrTableONTemplate.replace("{0}", tableName);
        ObjectName tableON = new ObjectName(tableONStr);
        Log.getLogWriter().info("Querying for instance " + tableON);
        try {
            ObjectInstance instance = mbeanServer.getObjectInstance(tableON);
            Log.getLogWriter().info("Found instance " + tableON + " Expected " + expectedBeans);
            if (!expectedBeans && instance != null) {
                MBeanHelper.saveError("Found aggreTable instance " + tableON + " when not expected ");
            }
            if (expectedBeans) {
                if (instance == null) {
                    MBeanHelper.saveError("Did not Found aggreTable instance " + tableON + " when expected");
                    return;
                }
                String[] attrs = new String[]{"EntrySize", "NumberOfRows"};
                AttributeList list = mbeanServer.getAttributes(tableON, attrs);
                Log.getLogWriter().info("GFXD Aggregate Table Attributes " + HydraUtil.ObjectToString((Object)list));
                for (Object object : list) {
                    Attribute attribute = (Attribute)object;
                    Log.getLogWriter().info("Validating Aggregated attribute : " + attribute);
                    if ("NumberOfRows".equalsIgnoreCase(attribute.getName())) {
                        int count = this.executeAndGetNumber("select count(*) from " + tableName);
                        MBeanHelper.printActualAndExpectedForAttribute("Validating Aggregated Table Attributes for : ", attribute, count);
                        if ((long)count != (Long)attribute.getValue()) {
                            MBeanHelper.printAndSaveError("Aggregated Attribute", tableName, attribute, count);
                        }
                    }
                    if ("EntrySize".equalsIgnoreCase(attribute.getName()) && "trade.sellorders".equalsIgnoreCase(tableName)) {
                        Number expected = this.getAggregatedValuesForCounter("SELLORDER_ENTRYSIZE_", mbeanServer);
                        MBeanHelper.printActualAndExpectedForAttribute("Validating Aggregated Table Attributes for : ", attribute, expected);
                        if (Math.abs(expected.doubleValue() - ((Number)attribute.getValue()).doubleValue()) > 0.001) {
                            MBeanHelper.printAndSaveError("Aggregated Attribute", tableName, attribute, expected);
                        }
                    }
                    Log.getLogWriter().info("GFXD Aggregate Table Attribute " + attribute.getName() + " validated for " + tableName);
                }
            }
        }
        catch (InstanceNotFoundException e) {
            if (expectedBeans) {
                MBeanTest.logMBeans(MessageFormat.format("GemFireXD:service=Table,type=Aggregate,table={0}", "*"), mbeanServer);
                throw new TestException("checkAggregateTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
        catch (ReflectionException e) {
            throw new TestException("checkAggregateTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private Number getAggregatedValuesForCounter(String counter, MBeanServerConnection mbeanServer) {
        String[] members = null;
        try {
            members = this.getGfxdClusterMembers(mbeanServer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Number aggregatedValue = 0;
        for (String member : members) {
            String memberName = member.substring(member.indexOf(40) + 1, member.indexOf(":"));
            String clientName = (String)((Map)SQLBB.getBB().getSharedMap().get((Object)MEMBERS_MAPPING)).get(memberName);
            String counterName = counter + clientName;
            double doubleValue = this.getCounterNumber(counterName).doubleValue();
            aggregatedValue = ((Number)aggregatedValue).doubleValue() + doubleValue;
            Log.getLogWriter().info(counterName + " value for member : " + member + " is " + doubleValue);
        }
        return aggregatedValue;
    }

    private void checkTableMBeanForGroup(MBeanServerConnection mbeanServer, boolean expectedBeans, String tableName, boolean populateBB, ClientVmInfo info, String memberId, String serverGroup, boolean verifyMBean) throws MalformedObjectNameException, IOException, TestException, AttributeNotFoundException {
        Log.getLogWriter().info("validating table mbean for table : " + tableName + " for serverGroup : " + serverGroup + " for member : " + memberId);
        if (DEFAULT_SERVER_GROUP.equals(serverGroup)) {
            if (this.isTableAndMemberOfSameServerGroup(tableName, memberId) && !this.isTablePartOfServerGroup(tableName, DEFAULT_SERVER_GROUP)) {
                Log.getLogWriter().info("member and table both are part of same server group and table is not part of default server group");
                this.verifyTableMBeanShouldNotPresentInGroup(mbeanServer, tableName, memberId, DEFAULT_SERVER_GROUP);
            } else {
                Log.getLogWriter().info("member and table both are not part of same server group");
                this.verifyTableMBeanForGroup(mbeanServer, expectedBeans, tableName, populateBB, memberId, serverGroup, verifyMBean);
            }
        } else {
            if (this.isMemberPartOfGroup(info.getClientName(), serverGroup) && this.isTablePartOfServerGroup(tableName, serverGroup)) {
                Log.getLogWriter().info("member and table both are part of same server group : " + serverGroup);
                this.verifyTableMBeanForGroup(mbeanServer, expectedBeans, tableName, populateBB, memberId, serverGroup, verifyMBean);
                this.verifyTableMBeanShouldNotPresentInGroup(mbeanServer, tableName, memberId, DEFAULT_SERVER_GROUP);
            }
            if (!this.isMemberPartOfGroup(info.getClientName(), serverGroup) && this.isTablePartOfServerGroup(tableName, serverGroup)) {
                Log.getLogWriter().info("member is not part of server group and table is part of server group : " + serverGroup);
                this.verifyTableMBeanForGroup(mbeanServer, expectedBeans, tableName, populateBB, memberId, DEFAULT_SERVER_GROUP, verifyMBean);
                this.verifyTableMBeanShouldNotPresentInGroup(mbeanServer, tableName, memberId, serverGroup);
            }
            if (!this.isTablePartOfServerGroup(tableName, serverGroup)) {
                Log.getLogWriter().info("table is not part of server group : " + serverGroup);
                this.verifyTableMBeanShouldNotPresentInGroup(mbeanServer, tableName, memberId, serverGroup);
                this.verifyTableMBeanForGroup(mbeanServer, expectedBeans, tableName, populateBB, memberId, DEFAULT_SERVER_GROUP, verifyMBean);
            }
        }
    }

    private boolean isTableAndMemberOfSameServerGroup(String tableName, String memberId) {
        Log.getLogWriter().info("Trying to find if table and member from same server group, table : " + tableName + " and memberId : " + memberId);
        List<String> groups = this.getServerGroupsArray(memberId);
        Log.getLogWriter().info("Server Groups for member : " + memberId + " is " + groups);
        Map tableToServerGroupMapping = (Map)SQLBB.getBB().getSharedMap().get((Object)TABLE_SERVER_GROUP);
        Log.getLogWriter().info("Getting the server groups for tableName : " + tableName + " Map : " + tableToServerGroupMapping);
        List list = (List)tableToServerGroupMapping.get(tableName);
        Log.getLogWriter().info("Server Groups for table : " + tableName + " is " + list);
        if (list == null) {
            return groups.size() == 1 && groups.get(0).equals(DEFAULT_SERVER_GROUP);
        }
        for (String group : groups) {
            if (!list.contains(group)) continue;
            return true;
        }
        return false;
    }

    private void verifyTableMBeanShouldNotPresentInGroup(MBeanServerConnection mbeanServer, String tableName, String memberId, String serverGroup) throws MalformedObjectNameException, IOException {
        ObjectName tableON = this.getTableMBean(tableName, memberId, serverGroup);
        try {
            mbeanServer.getObjectInstance(tableON);
            MBeanHelper.saveError("Table MBean should not come for this server group, Server Group : " + serverGroup + ", and Table :" + tableName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private boolean isPrProxyTableMBean(String tableName, String serverGroup, String[] tableServerGroup, String memberName) {
        if (serverGroup.equals(DEFAULT_SERVER_GROUP)) {
            String[] memberServerGroup = this.getServerGroupsArray(memberName).toArray(new String[0]);
            if (tableServerGroup.length > 0) {
                boolean isTableGroupAndServerGroupMatch = false;
                block0: for (String tableG : tableServerGroup) {
                    for (String mg : memberServerGroup) {
                        if (mg.equals(DEFAULT_SERVER_GROUP) || !tableG.equals(mg)) continue;
                        isTableGroupAndServerGroupMatch = true;
                        continue block0;
                    }
                }
                Log.getLogWriter().info("#isPrProxyTableMBean : tableServerGroup " + HydraUtil.ObjectToString((Object)tableServerGroup));
                Log.getLogWriter().info("#isPrProxyTableMBean : memberServerGroup " + HydraUtil.ObjectToString((Object)memberServerGroup));
                Log.getLogWriter().info("#isPrProxyTableMBean : for table " + tableName + " servergrp " + serverGroup + " is " + !isTableGroupAndServerGroupMatch);
                return !isTableGroupAndServerGroupMatch;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTableMBeanForGroup(MBeanServerConnection mbeanServer, boolean expectedBeans, String tableName, boolean populateBB, String memberId, String serverGroup, boolean verifyMBean) throws MalformedObjectNameException, IOException, TestException, AttributeNotFoundException {
        Log.getLogWriter().info("Checking table mbean for table : " + tableName + " and server-group " + serverGroup + " for member " + memberId);
        ObjectName tableON = this.getTableMBean(tableName, memberId, serverGroup);
        try {
            ObjectInstance instance = mbeanServer.getObjectInstance(tableON);
            Log.getLogWriter().info("Found instance " + tableON + " Expected " + expectedBeans);
            if (!expectedBeans && instance != null) {
                throw new TestException("Found table instance " + tableON + " when not expected ");
            }
            AttributeList list = mbeanServer.getAttributes(tableON, MBeanTestConstants.TABLE_ATTRS);
            Log.getLogWriter().info("GFXD Table Attributes " + HydraUtil.ObjectToString((Object)list));
            HashMap<String, Object> attrMap = new HashMap();
            if (!populateBB) {
                attrMap = this.getTableAttribute(tableName);
            }
            Statistics[] stat = this.getTableStats(tableName.substring(tableName.indexOf(".") + 1, tableName.length()), true);
            for (Object object : list) {
                Attribute attribute = (Attribute)object;
                Log.getLogWriter().info("Validating Attribute : " + attribute);
                if (populateBB) {
                    Log.getLogWriter().info("Populating BB, so no validation will happen...");
                    attrMap.put(attribute.getName(), attribute.getValue());
                } else if (attrMap != null && !attrMap.isEmpty()) {
                    if (verifyMBean && attribute.getName().equalsIgnoreCase("Inserts")) {
                        if (stat.length > 0) {
                            this.validateTableIntAttr(tableName, mbeanServer, tableON, attribute, stat[0].get("creates").intValue());
                        }
                    } else if (verifyMBean && attribute.getName().equalsIgnoreCase("Updates")) {
                        if (stat.length > 0) {
                            this.validateTableIntAttr(tableName, mbeanServer, tableON, attribute, stat[0].get("puts").intValue());
                        }
                    } else if (verifyMBean && attribute.getName().equalsIgnoreCase("Deletes")) {
                        if (stat.length > 0) {
                            this.validateTableIntAttr(tableName, mbeanServer, tableON, attribute, stat[0].get("destroys").intValue());
                        }
                    } else {
                        List<String> doNotTestHere;
                        Log.getLogWriter().info("Validating Table Attributes for : " + attribute);
                        List<String> list2 = doNotTestHere = verifyMBean ? Arrays.asList("NumberOfRows", "EntrySize", "KeySize") : Arrays.asList("NumberOfRows", "EntrySize", "KeySize", "Inserts", "Updates", "Deletes");
                        if (attribute.getValue() instanceof String) {
                            if (!attrMap.get(attribute.getName()).equals(attribute.getValue())) {
                                MBeanHelper.saveError(attribute.getName() + " did not match for " + tableName);
                            }
                        } else if (attribute.getValue() == null && attrMap.get(attribute.getName()) != null) {
                            MBeanHelper.saveError(attribute.getName() + " did not match for " + tableName);
                        } else if (attribute.getValue() instanceof Object[]) {
                            Object[] expectedArray = (Object[])attrMap.get(attribute.getName());
                            Object[] actualArray = (Object[])attribute.getValue();
                            if ((expectedArray == null && actualArray != null || expectedArray != null && actualArray == null) && expectedArray.length != actualArray.length) {
                                MBeanHelper.saveError(attribute.getName() + " did not match for " + tableName);
                            }
                            List<Object> actualList = Arrays.asList(actualArray);
                            for (int i = 0; i < expectedArray.length; ++i) {
                                if (actualList.contains(expectedArray[i])) continue;
                                MBeanHelper.saveError(attribute.getName() + " did not match for " + tableName);
                            }
                        } else if (attribute.getValue() != null && !doNotTestHere.contains(attribute.getName())) {
                            Log.getLogWriter().info("Not Validating Table Attributes for : " + attribute.getName());
                            Log.getLogWriter().info("Table Attributes type is : " + attribute.getValue().getClass());
                            MBeanHelper.saveError("Did not verified : " + attribute.getName() + " for " + tableName);
                        }
                    }
                }
                this.verfiyAttributeForTableMBean(mbeanServer, tableName, memberId, verifyMBean, tableON, attribute);
            }
            if (populateBB) {
                Log.getLogWriter().info("Populating BB for tableName :" + tableName + "with attrMap : " + attrMap);
                this.saveTableAttribute(tableName, attrMap);
                return;
            }
            for (String m : MBeanTestConstants.TABLE_METHODS) {
                if (m.startsWith("listIndexInfo")) {
                    SharedLock sharedLock = MBeanIndexBB.getBB().getSharedLock();
                    try {
                        sharedLock.lock();
                        this.verifyListIndexInfo(mbeanServer, tableName, memberId, serverGroup, verifyMBean, tableON, m);
                        continue;
                    }
                    finally {
                        sharedLock.unlock();
                    }
                }
                Object result = mbeanServer.invoke(tableON, m, null, null);
                Log.getLogWriter().info("GFXD Table Op " + m + " : " + HydraUtil.ObjectToString((Object)result));
                if (result != null) {
                    Log.getLogWriter().info("GFXD Table Op " + m + " : " + result.getClass());
                }
                if (!MBeanPrms.isWANTest() || !m.equals("fetchMetadata")) continue;
                CompositeData data = (CompositeData)result;
                String gatewayEnabled = (String)data.get("gatewayEnabled");
                String gatewaySenders = (String)data.get("gatewaySenders");
                if (gatewayEnabled.equals("false")) {
                    throw new TestException("Expected gatewayEnabled=true");
                }
                if (gatewaySenders == null || "".equals(gatewaySenders)) {
                    throw new TestException("Expected gatewaySenders non-empty");
                }
                if (gatewaySenders.equals(this.getSenderId())) continue;
                throw new TestException("Expected gatewaySenders=" + this.getSenderId() + " found <" + gatewaySenders + ">");
            }
        }
        catch (InstanceNotFoundException e) {
            Log.getLogWriter().info("Trying to find mbean for : " + tableON + "where we are " + (expectedBeans ? "" : "not") + "expecting it");
            if (expectedBeans) {
                MBeanTest.logMBeans(MessageFormat.format("GemFireXD:group={0},service=Table,type=Member,member={1},table={2}", "*", "*", "*"), mbeanServer);
                throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
        catch (ReflectionException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MBeanException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void verfiyAttributeForTableMBean(MBeanServerConnection mbeanServer, String tableName, String memberId, boolean verifyMBean, ObjectName tableON, Attribute attribute) throws TestException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Log.getLogWriter().info("Verify MBean Value : " + verifyMBean);
        if (verifyMBean) {
            if (attribute.getName().equalsIgnoreCase("EntrySize")) {
                Number value = this.validateTableAttr(tableName, mbeanServer, tableON, attribute, "select entry_size from sys.memoryanalytics WHERE INDEX_NAME IS NULL AND TABLE_name = '" + tableName + "'  and ID like '%" + memberId + "%'", OutputType.FLOAT);
                if ("trade.sellorders".equalsIgnoreCase(tableName)) {
                    this.saveCounter(COUNTER_SELLORDER_ENTRYSIZE, value);
                }
            } else if (attribute.getName().equalsIgnoreCase("KeySize")) {
                Number value = this.validateTableAttr(tableName, mbeanServer, tableON, attribute, "select key_size from sys.memoryanalytics WHERE INDEX_NAME IS NULL AND TABLE_name = '" + tableName + "'  and ID like '%" + memberId + "%'", OutputType.FLOAT);
                if ("trade.sellorders".equalsIgnoreCase(tableName)) {
                    this.saveCounter(COUNTER_SELLORDER_KEYSIZE, value);
                }
            } else if (attribute.getName().equalsIgnoreCase("NumberOfRows")) {
                Number value = this.validateTableAttr(tableName, mbeanServer, tableON, attribute, "select count(*) from " + tableName + " WHERE DSID() like '%" + memberId + "%'", OutputType.INT);
                if ("trade.sellorders".equalsIgnoreCase(tableName)) {
                    this.saveCounter(COUNTER_SELLORDER_NO_OF_ROWS, value);
                }
            }
        }
    }

    private void verifyListIndexInfo(MBeanServerConnection mbeanServer, String tableName, String memberId, String serverGroup, boolean verifyMBean, ObjectName tableON, String m) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException {
        Log.getLogWriter().info("Expected Index List : " + this.getAllIndex(tableName));
        Object result = mbeanServer.invoke(tableON, m, null, null);
        Log.getLogWriter().info(" Result list index Info" + result + "");
        Log.getLogWriter().info("GFXD Table Op " + m + " : " + HydraUtil.ObjectToString((Object)result));
        Log.getLogWriter().info("GFXD Table Op " + m + " : " + result.getClass());
        CompositeData[] data = (CompositeData[])result;
        Log.getLogWriter().info(" composite data length: " + data.length);
        for (int i = 0; i < data.length; ++i) {
            Log.getLogWriter().info(" composite data : " + HydraUtil.ObjectToString((Object)data[i]) + "");
        }
        String[] array = tableName.split("\\.");
        Log.getLogWriter().info("#listIndexInfo schemaName " + array[0] + " tableName " + array[1]);
        this.mbeanHelper.runQueryAndPrintValue("select * from SYS.INDEXES where SCHEMANAME='" + array[0] + "' and TABLENAME='" + array[1] + "'");
        Number indexCount = (Number)this.mbeanHelper.runQueryAndGetValue("select COUNT(*) from SYS.INDEXES where SCHEMANAME='" + array[0] + "' and TABLENAME='" + array[1] + "'", OutputType.INT);
        String[] tableServerGroups = (String[])mbeanServer.getAttribute(tableON, "ServerGroups");
        String memberName = tableON.getKeyProperty("member");
        boolean isPartitionProxy = this.isPrProxyTableMBean(tableName, serverGroup, tableServerGroups, memberName);
        if (!isPartitionProxy) {
            Log.getLogWriter().info("Table is NOT partition proxy table hence matching indexinfo #listIndexInfo #isPartitionProxy");
            this.match("Index count does not match  for " + tableName, indexCount.intValue(), data.length);
        } else {
            Log.getLogWriter().info("Table is partition proxy table hence skipping matching indexinfo #listIndexInfo #isPartitionProxy");
        }
        if (data.length > 0 && verifyMBean) {
            result = mbeanServer.invoke(tableON, "listIndexStats", null, null);
            Log.getLogWriter().info(" Result list index Info" + result + "");
            Log.getLogWriter().info("GFXD Table Op listIndexStats : " + HydraUtil.ObjectToString((Object)result));
            Log.getLogWriter().info("GFXD Table Op listIndexStats : " + result.getClass());
            CompositeData[] stats = (CompositeData[])result;
            Log.getLogWriter().info(" index length: " + stats.length);
            for (int i = 0; i < stats.length; ++i) {
                Log.getLogWriter().info(" index stats : " + HydraUtil.ObjectToString((Object)stats[i]) + "");
                Number entrySize = (Number)stats[i].get("entrySize");
                String indexName = (String)stats[i].get("indexName");
                Number keySize = (Number)stats[i].get("keySize");
                Number rowCount = (Number)stats[i].get("rowCount");
                Number actualEntrySize = (Number)this.mbeanHelper.runQueryAndGetValue("select  ENTRY_SIZE from sys.memoryanalytics WHERE  TABLE_name = '" + tableName + "'  and ID like '%" + memberId + "%' AND INDEX_NAME='" + indexName + "'", OutputType.FLOAT);
                this.match("Validation failed for matching Index " + indexName + " on table " + tableName + " attribute ENTRY_SIZE", entrySize, actualEntrySize);
                Number actualKeySize = (Number)this.mbeanHelper.runQueryAndGetValue("select  KEY_SIZE from sys.memoryanalytics WHERE  TABLE_name = '" + tableName + "'  and ID like '%" + memberId + "%' AND INDEX_NAME='" + indexName + "'", OutputType.FLOAT);
                this.match("Validation failed for matching Index " + indexName + " on table " + tableName + " attribute KEY_SIZE", keySize, actualKeySize);
                Number actualRowCount = (Number)this.mbeanHelper.runQueryAndGetValue("select  NUM_ROWS from sys.memoryanalytics WHERE TABLE_name = '" + tableName + "'  and ID like '%" + memberId + "%' AND INDEX_NAME='" + indexName + "'", OutputType.LONG);
                this.match("Validation failed for matching Index " + indexName + " on table " + tableName + "  attribute ROW_COUNT", rowCount, actualRowCount);
                Log.getLogWriter().info("#listIndexStats IndexName <" + indexName + "> ES <" + entrySize + "> COUNT <" + rowCount + " KS <" + keySize + ">");
                Log.getLogWriter().info("#listIndexStatsFromMemAnalytics IndexName <" + indexName + "> ES <" + actualEntrySize + "> COUNT <" + actualRowCount + " KS <" + actualKeySize + ">");
            }
        }
    }

    private ObjectName getTableMBean(String tableName, String memberId, String serverGroup) throws MalformedObjectNameException {
        Log.getLogWriter().info("Checking table mbean for table " + tableName + " for server-group " + serverGroup + " for member " + memberId);
        String tableONStr = tableONTemplate.replace("{0}", serverGroup);
        tableONStr = tableONStr.replace("{1}", memberId);
        tableONStr = tableONStr.replace("{2}", tableName);
        ObjectName tableON = new ObjectName(tableONStr);
        Log.getLogWriter().info("Querying for instance " + tableON);
        return tableON;
    }

    private boolean isTablePartOfServerGroup(String tableName, String serverGroup) {
        Log.getLogWriter().info("Trying to find is table : " + tableName + " part of server group : " + serverGroup);
        Map tableToServerGroupMapping = (Map)SQLBB.getBB().getSharedMap().get((Object)TABLE_SERVER_GROUP);
        Log.getLogWriter().info("Getting the server groups for tableName : " + tableName + " map : " + tableToServerGroupMapping);
        List list = (List)tableToServerGroupMapping.get(tableName);
        Log.getLogWriter().info("Server groups for table : " + tableName + " is " + list);
        if (list != null) {
            return list.contains(serverGroup);
        }
        return list == null && DEFAULT_SERVER_GROUP.equals(serverGroup);
    }

    private Object getTableMBeanAttribute(MBeanServerConnection mbeanServer, ObjectName tableON, String attributeName) {
        try {
            return mbeanServer.getAttribute(tableON, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        return "NA";
    }

    private int executeAndGetNumber(String sql) {
        Connection conn = null;
        try {
            conn = this.getGFEConnection();
            ResultSet rs = conn.createStatement().executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            throw new TestException("checkTableMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        finally {
            if (conn != null) {
                this.closeGFEConnection(conn);
            }
        }
        return 0;
    }

    private Number validateTableAttr(String tableName, MBeanServerConnection mBeanServer, ObjectName name, Attribute attribute, String sql, OutputType type) throws TestException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.mbeanHelper.runQueryAndPrintValue(sql);
        Number expected = (Number)this.mbeanHelper.runQueryAndGetValue(sql, type);
        Number actual = (Number)mBeanServer.getAttribute(name, attribute.getName());
        if (!actual.toString().equals(expected.toString())) {
            MBeanHelper.saveError(attribute.getName() + " attribute did not match for " + tableName + " where expected = " + expected + " and actual : " + actual);
        } else {
            Log.getLogWriter().info(attribute.getName() + " attribute match for " + tableName + " where expected = " + expected + " and actual : " + actual);
        }
        return actual;
    }

    private void validateTableIntAttr(String tableName, MBeanServerConnection mBeanServer, ObjectName name, Attribute attribute, Number value) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        int actual = (Integer)mBeanServer.getAttribute(name, attribute.getName());
        if (actual - value.intValue() < 0) {
            MBeanHelper.saveError(attribute.getName() + " attribute did not match for " + tableName + " where expected = " + value + " and actuals : " + actual);
        } else {
            Log.getLogWriter().info(attribute.getName() + " attribute match for " + tableName + " where expected = " + value + " and actuals : " + actual);
        }
    }

    private Object getSenderId() {
        String clientName = RemoteTestModule.getMyClientName();
        String[] array = clientName.split("_");
        String dsName = "SENDER_" + array[1];
        dsName = "1".equals(array[1]) ? dsName + "_2" : dsName + "_1";
        Log.getLogWriter().info("Sender ID for this VM is " + dsName);
        return dsName;
    }

    private boolean isMemberPartOfGroup(String clientName, String serverGroup) {
        if (DEFAULT_SERVER_GROUP.equals(serverGroup)) {
            return true;
        }
        List<String> groups = this.getServerGroupsArray(clientName);
        for (String s : groups) {
            if (!s.equals(serverGroup) || s.equals(DEFAULT_SERVER_GROUP)) continue;
            return true;
        }
        Log.getLogWriter().info("VM " + clientName + " is not part of group " + serverGroup);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcedureCall() throws SQLException {
        int times = HydraUtil.getnextNonZeroRandomInt((int)10);
        Connection conn = this.getGFEConnection();
        String procName = (String)HydraUtil.getRandomElement((Object[])new String[]{"trade.show_customers(?)", "trade.longRunningProcedure(?)"});
        String sql = "CALL  " + procName + " ON ALL";
        CallableStatement cs = conn.prepareCall(sql);
        Log.getLogWriter().info("Executing proc sql " + sql);
        for (int i = 0; i < times; ++i) {
            try {
                Log.getLogWriter().info("Running Procedure : " + procName);
                int counter = isEdge ? this.incrementCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS_EDGE) : this.incrementCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS);
                cs.setInt(1, RemoteTestModule.getCurrentThread().getThreadId());
                cs.execute();
                counter = isEdge ? this.incrementCounter(COUNTER_MBEAN_PROC_CALLS_EDGE) : this.incrementCounter(COUNTER_MBEAN_PROC_CALLS);
                continue;
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("XCL54")) {
                    Log.getLogWriter().warning("Error occurred while executing query : " + sql + ", Low Memory Exception");
                    continue;
                }
                throw e;
            }
            finally {
                if (isEdge) {
                    this.decrementCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS_EDGE);
                } else {
                    this.decrementCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS);
                }
                Log.getLogWriter().info("Procedure Completed : " + procName);
            }
        }
        cs.close();
    }

    private void doUpdate(Connection conn, String tableName) throws SQLException {
        String updateStmt = SELLORDER_UPDATE.replace("{0}", tableName);
        PreparedStatement stmt = conn.prepareStatement(updateStmt);
        int qty = HydraUtil.getnextNonZeroRandomInt((int)100);
        int oid = HydraUtil.getnextNonZeroRandomInt((int)this.getCounter("SELLORDER_OID"));
        stmt.setInt(1, qty);
        stmt.setInt(2, oid);
        Log.getLogWriter().info("Updating qty for orderid=" + oid + " new qty " + qty);
        stmt.execute();
        stmt.close();
        this.incrementCounter(COUNTER_SELLORDER_UPDATES);
    }

    private void doDelete(Connection conn, String tableName) throws SQLException {
        String deleteStmt = SELLORDER_DELETE.replace("{0}", tableName);
        PreparedStatement stmt = conn.prepareStatement(deleteStmt);
        int qty = HydraUtil.getnextNonZeroRandomInt((int)100);
        int oid = HydraUtil.getnextNonZeroRandomInt((int)this.getCounter("SELLORDER_OID"));
        stmt.setInt(1, qty);
        stmt.setInt(2, oid);
        Log.getLogWriter().info("Deleting qty for orderid=" + oid + " new qty " + qty);
        stmt.execute();
        stmt.close();
        this.incrementCounter(COUNTER_SELLORDER_DELETES);
    }

    private void doSelect(Connection conn, String tableName) throws SQLException {
        MBeanTradeSellOrdersDMLStmt dmlStmt = new MBeanTradeSellOrdersDMLStmt();
        dmlStmt.addListener(new CallBackListener(){

            @Override
            public String getName() {
                return MBeanTest.SELECT_QUERY_TAG;
            }

            @Override
            public void execute(Object ... params) {
                String sql = (String)params[0];
                MBeanTest.this.getAndIncrementCounter(COUNTER_SELLORDER_SELECTS, sql);
            }
        });
        dmlStmt.query(conn);
    }

    private void doInsert(Connection conn, String tableName) throws SQLException {
        String status = (String)HydraUtil.getRandomElement((Object[])new String[]{"cancelled", "open", "filled"});
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        int size = 1;
        int[] cids = new int[size];
        int[] sids = new int[size];
        this.getCustomerAndPortFolio(conn, tid, size, cids, sids);
        String insetStmt = SELLORDER_INSERT.replace("{0}", tableName);
        Log.getLogWriter().info("Trying to execute : " + insetStmt);
        PreparedStatement stmt = conn.prepareStatement(insetStmt);
        for (int i = 0; i < size; ++i) {
            int cid = cids[i];
            int sid = sids[i];
            int oid = this.getOrderId(conn, cid, sid);
            int qty = HydraUtil.getnextNonZeroRandomInt((int)15);
            BigDecimal ask = new BigDecimal(TestConfig.tab().getRandGen().nextDouble());
            Timestamp order_time = new Timestamp(System.currentTimeMillis());
            stmt.setInt(1, oid);
            stmt.setInt(2, cid);
            stmt.setInt(3, sid);
            stmt.setInt(4, qty);
            stmt.setBigDecimal(5, ask);
            stmt.setTimestamp(6, order_time);
            stmt.setString(7, status);
            stmt.setInt(8, tid);
            int rowCount = stmt.executeUpdate();
            Log.getLogWriter().info("Params used for insert query : cid :" + cid + ", sid : " + sid + ", oid : " + oid + " and qty : " + qty);
            Log.getLogWriter().info("Rows Inserted for " + insetStmt + " is " + rowCount);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
            stmt.close();
            this.incrementCounter(COUNTER_SELLORDER_INSERTS);
        }
    }

    private void doPut(Connection conn, String tableName) throws SQLException {
        String status = (String)HydraUtil.getRandomElement((Object[])new String[]{"cancelled", "open", "filled"});
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        int size = 1;
        int[] cids = new int[size];
        int[] sids = new int[size];
        this.getCustomerAndPortFolio(conn, tid, size, cids, sids);
        String insetStmt = SELLORDER_PUT.replace("{0}", tableName);
        Log.getLogWriter().info("Trying to execute : " + insetStmt);
        PreparedStatement stmt = conn.prepareStatement(insetStmt);
        for (int i = 0; i < size; ++i) {
            int cid = cids[i];
            int sid = sids[i];
            int oid = this.getOrderId(conn, cid, sid);
            int qty = HydraUtil.getnextNonZeroRandomInt((int)15);
            BigDecimal ask = new BigDecimal(TestConfig.tab().getRandGen().nextDouble());
            Timestamp order_time = new Timestamp(System.currentTimeMillis());
            stmt.setInt(1, oid);
            stmt.setInt(2, cid);
            stmt.setInt(3, sid);
            stmt.setInt(4, qty);
            stmt.setBigDecimal(5, ask);
            stmt.setTimestamp(6, order_time);
            stmt.setString(7, status);
            stmt.setInt(8, tid);
            int rowCount = stmt.executeUpdate();
            Log.getLogWriter().info("Params used for put query : cid :" + cid + ", sid : " + sid + ", oid : " + oid + " and qty : " + qty);
            Log.getLogWriter().info("Rows Inserted for " + insetStmt + " is " + rowCount);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
            stmt.close();
            this.incrementCounter(COUNTER_SELLORDER_INSERTS);
        }
    }

    private int getOrderId(Connection conn, int cid, int sid) {
        int max = this.incrementCounter("SELLORDER_OID");
        Log.getLogWriter().info("New Order Id for cid,sid : (" + cid + "," + sid + ") is " + max);
        return max;
    }

    private void getCustomerAndPortFolio(Connection conn, int tid, int size, int[] cids, int[] sids) throws SQLException {
        ResultSet rs = null;
        GsRandom rand = TestConfig.tab().getRandGen();
        String sql = "select * from trade.portfolio where tid = " + tid;
        try {
            rs = conn.createStatement().executeQuery(sql);
            List<Struct> rsList = ResultSetHelper.asList(rs, ResultSetHelper.getStructType(rs), SQLHelper.isDerbyConn(conn));
            int rsSize = rsList.size();
            if (rsSize >= size) {
                int offset = rand.nextInt(rsSize - size);
                for (int i = 0; i < size; ++i) {
                    cids[i] = (Integer)((GFXDStructImpl)rsList.get(i + offset)).get("CID");
                    Log.getLogWriter().info("cid is " + cids[i]);
                    sids[i] = (Integer)((GFXDStructImpl)rsList.get(i + offset)).get("SID");
                    Log.getLogWriter().info("sid is " + sids[i]);
                }
            } else {
                for (int i = 0; i < rsSize; ++i) {
                    cids[i] = (Integer)((GFXDStructImpl)rsList.get(i)).get("CID");
                    sids[i] = (Integer)((GFXDStructImpl)rsList.get(i)).get("SID");
                }
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("XCL54")) {
                Log.getLogWriter().warning("Error occurred while executing query : " + sql + ", Low Memory Exception");
            }
            throw e;
        }
    }

    private void checkProcCalls(MBeanServerConnection mbeanServer) {
        try {
            ObjectName name = new ObjectName(MessageFormat.format("GemFireXD:group={0},type=Member,member={1}", isEdge ? DEFAULT_SERVER_GROUP : "CG", ManagementUtil.getMemberID()));
            Log.getLogWriter().info("Object Name : " + name);
            int timesProcCalled = isEdge ? this.getCounter(COUNTER_MBEAN_PROC_CALLS_EDGE) : this.getCounter(COUNTER_MBEAN_PROC_CALLS);
            int jmxcalls = (Integer)mbeanServer.getAttribute(name, "ProcedureCallsCompleted");
            int inProgress = (Integer)mbeanServer.getAttribute(name, "ProcedureCallsInProgress");
            InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
            FunctionStats functionStats = FunctionStats.getFunctionStats((String)"gfxd-DistributedProcedureCallFunction", (InternalDistributedSystem)ds);
            int statsCalls = functionStats.getFunctionExecutionsCompleted();
            int statCalls2 = functionStats.getFunctionExecutionsCompletedDN();
            int executionRunning = functionStats.getFunctionExecutionsRunning();
            Log.getLogWriter().info("ProcedureCallsInProgress : Expected : " + inProgress + ", Actual : " + executionRunning);
            if (!isEdge && timesProcCalled != jmxcalls && !MBeanPrms.isHATest()) {
                MBeanHelper.saveError("ProcedureCallsCompleted does not match actual value " + jmxcalls + " expected " + timesProcCalled + " statValue : " + statsCalls + " dnstatValue : " + statCalls2);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MBeanException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Not able to execute procedure\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void checkGfxdMBeans(MBeanServerConnection mbeanServer, boolean verifyMBeans, boolean verifyAggregatedMBeans) {
        this.checkStatementMBeans(mbeanServer);
        this.checkMemberMBeans(mbeanServer, verifyMBeans, verifyAggregatedMBeans);
        this.checkTableMBeans(mbeanServer, verifyMBeans, verifyAggregatedMBeans);
    }

    private void checkGfxdMBeans(MBeanServerConnection mbeanServer, boolean verifyAtEnd) {
        this.checkStatementMBeans(mbeanServer);
        this.checkMemberMBeans(mbeanServer, verifyAtEnd);
        this.checkTableMBeans(mbeanServer, verifyAtEnd);
    }

    private void checkMemberMBeans(MBeanServerConnection mbeanServer, boolean verifyAtEnd) {
        this.checkMemberMBeans(mbeanServer, verifyAtEnd, false);
    }

    private void checkMemberMBeans(MBeanServerConnection mbeanServer, boolean verifyMBeans, boolean verifyAggregatedMBean) {
        try {
            boolean isLocator;
            String[] members = this.getGfxdClusterMembers(mbeanServer);
            Log.getLogWriter().info("Member set JMX : " + HydraUtil.ObjectToString((Object)members));
            Log.getLogWriter().info("Member set API : " + this.getMembersSet());
            if (members.length != this.getMembersSet().size() && !MBeanPrms.isHATest()) {
                MBeanHelper.saveError("Member set on cluster mbean is wrong jmx " + HydraUtil.ObjectToString((Object)members) + " API : " + HydraUtil.ObjectToString(this.getMembersSet()));
                throw new TestException("Member set on cluster mbean is wrong jmx " + HydraUtil.ObjectToString((Object)members) + " API : " + HydraUtil.ObjectToString(this.getMembersSet()));
            }
            ObjectName name = null;
            if (MBeanPrms.isWANTest() || this.isHDFSTest() || isEdge ? (isLocator = ((Boolean)mbeanServer.getAttribute(name = new ObjectName(MessageFormat.format("GemFireXD:group={0},type=Member,member={1}", DEFAULT_SERVER_GROUP, ManagementUtil.getMemberID())), "Locator")).booleanValue()) : (isLocator = ((Boolean)mbeanServer.getAttribute(name = new ObjectName(MessageFormat.format("GemFireXD:group={0},type=Member,member={1}", "CG", ManagementUtil.getMemberID())), "Locator")).booleanValue())) {
                throw new TestException("isLocator expected false");
            }
            AttributeList list = mbeanServer.getAttributes(name, MBeanTestConstants.MEMBER_ATTRS);
            Log.getLogWriter().info("GFXDMEMBER Attributes " + HydraUtil.ObjectToString((Object)list));
            int timesProcCalled = this.getCounter(COUNTER_MBEAN_PROC_CALLS);
            HashMap<String, Object> expectedMap = new HashMap<String, Object>();
            expectedMap.put("Name", ManagementUtil.getMember().getName());
            expectedMap.put("Id", ManagementUtil.getMember().getId());
            expectedMap.put("DataStore", GemFireStore.getBootedInstance().getMyVMKind().isStore());
            if (verifyMBeans && !isEdge) {
                expectedMap.put("ProcedureCallsInProgress", this.getCounter(COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS));
                expectedMap.put("ProcedureCallsCompleted", this.getCounter(COUNTER_MBEAN_PROC_CALLS));
            }
            MBeanHelper.matchValues(list, expectedMap);
            if (verifyMBeans) {
                this.sleepForDataUpdaterJMX();
                List<Object> connStat = this.getConnStatForInternalAndNested();
                if (connStat.size() > 0) {
                    Log.getLogWriter().info("conn state fetch from stats is : " + connStat + "");
                    this.saveCounter(COUNTER_NS_PEER, connStat.get(0));
                    this.saveCounter(COUNTER_NS_CLIENT, connStat.get(1));
                    this.saveCounter(COUNTER_NS_NESTED, connStat.get(2));
                    this.saveCounter(COUNTER_NS_INTERNAL, connStat.get(3));
                }
                Log.getLogWriter().info("Verifying network connection stat...");
                CompositeDataSupport clientConnStats = (CompositeDataSupport)mbeanServer.getAttribute(name, "NetworkServerClientConnectionStats");
                CompositeDataSupport peerConnStats = (CompositeDataSupport)mbeanServer.getAttribute(name, "NetworkServerPeerConnectionStats");
                CompositeDataSupport nestedConnStats = (CompositeDataSupport)mbeanServer.getAttribute(name, "NetworkServerNestedConnectionStats");
                CompositeDataSupport internalConnStats = (CompositeDataSupport)mbeanServer.getAttribute(name, "NetworkServerInternalConnectionStats");
                if (connStat.size() > 0) {
                    this.compare((NetworkServerConnectionStats)connStat.get(0), peerConnStats, true);
                    this.compare((NetworkServerConnectionStats)connStat.get(1), clientConnStats, true);
                    this.compare((NetworkServerNestedConnectionStats)connStat.get(2), nestedConnStats, true);
                    this.compare((NetworkServerNestedConnectionStats)connStat.get(3), internalConnStats, true);
                }
            }
            this.getMemberStats();
            if (list.size() != MBeanTestConstants.MEMBER_ATTRS.length) {
                throw new TestException("Wrong list size");
            }
            SharedLock lock = MBeanTaskBB.getBB().getSharedLock();
            for (String method : MBeanTestConstants.MEMBER_METHODS) {
                Object result = null;
                if (method.startsWith("update")) {
                    lock.lock();
                    this.callUpdateFunctionForMember(mbeanServer, name, method);
                    lock.unlock();
                    continue;
                }
                if (method.startsWith("fetch") && !"fetchMetadata".equals(method)) {
                    lock.lock();
                    result = mbeanServer.invoke(name, method, null, null);
                    this.callFetchFunctionForMember(method, result);
                    lock.unlock();
                }
                if ("detectDeadlocks".equals(method)) continue;
                Log.getLogWriter().info("GFXDMEMBER Op " + method + " : " + HydraUtil.ObjectToString((Object)result));
            }
        }
        catch (Exception e) {
            throw new TestException("Error while queryMBeans\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private List<Object> getConnStatForInternalAndNested() {
        InternalDistributedSystem system;
        StatisticsType connectionStatsType;
        ArrayList<Object> toReturn = new ArrayList<Object>(4);
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null && (connectionStatsType = (system = cache.getDistributedSystem()).findType(ConnectionStats.name)) != null) {
            Statistics[] foundStatistics;
            for (Statistics statistics : foundStatistics = system.findStatisticsByType(connectionStatsType)) {
                Log.getLogWriter().info("Found the stats for Network Server connection... : " + statistics);
                toReturn.add(new NetworkServerConnectionStats("Peer", statistics.getLong("peerConnectionsOpened"), statistics.getLong("peerConnectionsClosed"), statistics.getLong("peerConnectionsAttempted"), statistics.getLong("peerConnectionsFailed"), statistics.getLong("peerConnectionsLifeTime"), statistics.getLong("peerConnectionsOpen"), 0L));
                toReturn.add(new NetworkServerConnectionStats("Client", statistics.getLong("clientConnectionsOpened"), statistics.getLong("clientConnectionsClosed"), statistics.getLong("clientConnectionsAttempted"), statistics.getLong("clientConnectionsFailed"), statistics.getLong("clientConnectionsLifeTime"), statistics.getLong("clientConnectionsOpen"), statistics.getLong("clientConnectionsIdle")));
                toReturn.add(new NetworkServerNestedConnectionStats("Nested", statistics.getLong("nestedConnectionsOpened"), statistics.getLong("nestedConnectionsClosed"), statistics.getLong("nestedConnectionsOpen")));
                toReturn.add(new NetworkServerNestedConnectionStats("Internal", statistics.getLong("internalConnectionsOpened"), statistics.getLong("internalConnectionsClosed"), statistics.getLong("internalConnectionsOpen")));
            }
        }
        if (toReturn.isEmpty()) {
            Log.getLogWriter().error("Did not able to get any conn stat for nested and internal. validation for these stat won't match.");
        }
        return toReturn;
    }

    private void callFetchFunctionForMember(String method, Object result) {
        Number expected = this.getCounterNumber(ManagementUtil.getMemberID() + "_" + method.substring(5));
        Log.getLogWriter().info("GFXDMEMBER Op " + method + " : Expected  : " + expected.floatValue() + ". and actual : " + HydraUtil.ObjectToString((Object)result));
        if (result == null && expected.floatValue() > 0.0f || expected.floatValue() != ((Float)result).floatValue()) {
            MBeanHelper.saveError("GFXDMEMBER Op " + method + " : Expected  : " + expected.floatValue() + ". and actual : " + HydraUtil.ObjectToString((Object)result));
        }
    }

    private void callUpdateFunctionForMember(MBeanServerConnection mbeanServer, ObjectName name, String method) throws Exception {
        Object[] objectArray = new Integer[]{-1, 10, 50, 100, 1000};
        float percent = TestConfig.tab().getRandGen().nextFloat() * (float)((Integer)HydraUtil.getRandomElement((Object[])objectArray)).intValue();
        if (percent < 50.0f) {
            Log.getLogWriter().info("Trying to set " + percent + " which is less than 50, returning from here");
            return;
        }
        Log.getLogWriter().info("Trying to set " + method + " with value : " + percent);
        try {
            if (!this.handleIfCriticalIsLessThanEviction(mbeanServer, name, method, percent)) {
                Log.getLogWriter().info("Evicition is greater than critical, cannot do anything , returning");
                return;
            }
            Log.getLogWriter().info("Now we can set the eviction or critical percentage to " + percent);
            this.setEvicitionOrCriticalPercentage(mbeanServer, name, method, percent);
        }
        catch (RuntimeMBeanException e) {
            if ((double)percent > 0.0 && (double)percent <= 100.0) {
                this.printAndGetEvictionPercent(mbeanServer, name);
                this.printAndGetCriticalPercent(mbeanServer, name);
                throw new TestException(method + " trying to set value : " + percent + " and it should not throw any exception", (Throwable)e);
            }
            return;
        }
        if (percent < 60.0f) {
            Log.getLogWriter().info(percent + " is less than 60 so setting it to 100 for " + method);
            percent = 100.0f;
            if ("updateEvictionPercent".equals(method)) {
                Log.getLogWriter().info("Resetting value of critical percentage because we are resetting eviction percent to 100");
                this.setCriticalPercent(mbeanServer, name, percent);
            }
            this.setEvicitionOrCriticalPercentage(mbeanServer, name, method, percent -= 1.0f);
        }
        if (percent <= 100.0f) {
            this.saveCounter(ManagementUtil.getMemberID() + "_" + method.substring(6), Float.valueOf(percent));
            Log.getLogWriter().info("GFXDMEMBER Op " + method + " updated value  : " + percent);
        }
    }

    private void setEvicitionOrCriticalPercentage(MBeanServerConnection mbeanServer, ObjectName name, String method, float percent) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            Log.getLogWriter().info("Trying to set " + method + " with value : " + percent);
            mbeanServer.invoke(name, method, new Object[]{Float.valueOf(percent)}, new String[]{Float.TYPE.getName()});
        }
        catch (RuntimeMBeanException e) {
            Log.getLogWriter().info(e.getMessage());
            throw e;
        }
        finally {
            this.printAndGetEvictionPercent(mbeanServer, name);
            this.printAndGetCriticalPercent(mbeanServer, name);
        }
    }

    private boolean handleIfCriticalIsLessThanEviction(MBeanServerConnection mbeanServer, ObjectName name, String method, float percent) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if ("updateCriticalPercent".equals(method)) {
            Float evictionPercent = Float.valueOf(this.printAndGetEvictionPercent(mbeanServer, name));
            Log.getLogWriter().info("Current Eviction Percent Is : " + evictionPercent + " and Percent to set in Critical is : " + percent);
            if (percent < ((Number)evictionPercent).floatValue()) {
                return this.setEvictionPercent(mbeanServer, name, percent - 1.0f);
            }
        }
        if ("updateEvictionPercent".equals(method)) {
            Float criticalPercent = Float.valueOf(this.printAndGetCriticalPercent(mbeanServer, name));
            Log.getLogWriter().info("Current Critical Percent is : " + criticalPercent + " and Percent to set in Eviction is : " + percent);
            if ((double)((Number)criticalPercent).floatValue() == 0.0) {
                Log.getLogWriter().info("Current Critical Percent is : " + criticalPercent + " returning form here");
                return false;
            }
            if (percent > ((Number)criticalPercent).floatValue()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setEvictionPercent(MBeanServerConnection mbeanServer, ObjectName name, float percentToSet) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Log.getLogWriter().info("Trying to set new percent to eviction percent : " + percentToSet);
        try {
            mbeanServer.invoke(name, "updateEvictionPercent", new Object[]{Float.valueOf(percentToSet)}, new String[]{Float.TYPE.getName()});
            this.saveCounter(ManagementUtil.getMemberID() + "_" + "EvictionPercent", Float.valueOf(percentToSet));
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            Log.getLogWriter().info("We cannot set " + percentToSet + " to the eviction percent, Reason : " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Log.getLogWriter().info("(Exception)We cannot set " + percentToSet + " to the eviction percent, Reason : " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.printAndGetEvictionPercent(mbeanServer, name);
        }
    }

    private float printAndGetEvictionPercent(MBeanServerConnection mbeanServer, ObjectName name) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.printAndGetXXXPercent(mbeanServer, name, "fetchEvictionPercent");
    }

    private float printAndGetCriticalPercent(MBeanServerConnection mbeanServer, ObjectName name) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.printAndGetXXXPercent(mbeanServer, name, "fetchCriticalPercent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCriticalPercent(MBeanServerConnection mbeanServer, ObjectName name, float percentToSet) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Log.getLogWriter().info("Trying to set new percent to critical percent : " + percentToSet);
        try {
            mbeanServer.invoke(name, "updateCriticalPercent", new Object[]{Float.valueOf(percentToSet)}, new String[]{Float.TYPE.getName()});
            this.saveCounter(ManagementUtil.getMemberID() + "_" + "CriticalPercent", Float.valueOf(percentToSet));
            boolean bl = true;
            return bl;
        }
        catch (RuntimeException e) {
            Log.getLogWriter().info("We cannot set " + percentToSet + " to the critical percent, Reason : " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.printAndGetCriticalPercent(mbeanServer, name);
        }
    }

    private float printAndGetXXXPercent(MBeanServerConnection mbeanServer, ObjectName name, String methodName) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object value = mbeanServer.invoke(name, methodName, null, null);
        Log.getLogWriter().info("Current " + methodName + " Percent is : " + value + "");
        return ((Number)value).floatValue();
    }

    private void validateAggregatedMemberMBean() {
        try {
            this.sleepForDataUpdaterJMX();
            this.lockReadManager();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            ObjectName aggregateName = new ObjectName("GemFireXD:service=Cluster");
            AttributeList list = mbeanServer.getAttributes(aggregateName, MBeanTestConstants.AGGR_MEMBER_ATTRS);
            Log.getLogWriter().info("GFXDMEMBER Aggregated Attributes " + HydraUtil.ObjectToString((Object)list));
            String[] members = this.getGfxdClusterMembers(mbeanServer);
            Set<DistributedMember> apiMemberSet = this.getMembersSet();
            if (members.length != apiMemberSet.size()) {
                throw new TestException("Member set on cluster mbean is wrong jmx " + HydraUtil.ObjectToString((Object)members) + " API : " + HydraUtil.ObjectToString(apiMemberSet));
            }
            int aggregatedTimesProcCalled = 0;
            int aggregatedTimesProcInProgress = 0;
            NetworkServerConnectionStats aggregatedClientConnStat = new NetworkServerConnectionStats("Client", 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            NetworkServerConnectionStats aggregatedPeerConnStat = new NetworkServerConnectionStats("Peer", 0L, 0L, 0L, 0L, 0L, 0L, 0L);
            NetworkServerNestedConnectionStats aggregatedNestedConnStat = new NetworkServerNestedConnectionStats("Nested", 0L, 0L, 0L);
            NetworkServerNestedConnectionStats aggregatedInternalConnStat = new NetworkServerNestedConnectionStats("Internal", 0L, 0L, 0L);
            for (String member : members) {
                Log.getLogWriter().info("Consolidating aggregated values for member : " + member);
                String memberName = member.substring(member.indexOf(40) + 1, member.indexOf(":"));
                String clientName = (String)((Map)SQLBB.getBB().getSharedMap().get((Object)MEMBERS_MAPPING)).get(memberName);
                aggregatedTimesProcCalled = isEdge ? this.getCounter(COUNTER_MBEAN_PROC_CALLS_EDGE) : (aggregatedTimesProcCalled += this.getCounter(COUNTER_MBEAN_PROC_CALLS_PREFIX + clientName));
                Log.getLogWriter().info("aggregatedTimesProcCalled : " + aggregatedTimesProcCalled + " for clientName : " + clientName);
                Log.getLogWriter().info("aggregatedTimesProcInProgress : " + (aggregatedTimesProcInProgress += this.getCounter(COUNTER_MBEAN_PROC_PROGRESS_PREFIX + clientName)) + " for clientName : " + clientName);
                NetworkServerConnectionStats memberNCC = (NetworkServerConnectionStats)SQLBB.getBB().getSharedMap().get((Object)("COUNTER_NS_CLIENT_" + clientName));
                Log.getLogWriter().info("Conn Stat for Member : " + member + ", stat : " + memberNCC + " for Client");
                aggregatedClientConnStat.updateNetworkServerConnectionStats(aggregatedClientConnStat.getConnectionsOpened() + memberNCC.getConnectionsOpened(), aggregatedClientConnStat.getConnectionsClosed() + memberNCC.getConnectionsClosed(), aggregatedClientConnStat.getConnectionsAttempted() + memberNCC.getConnectionsAttempted(), aggregatedClientConnStat.getConnectionsFailed() + memberNCC.getConnectionsFailed(), aggregatedClientConnStat.getConnectionLifeTime() + memberNCC.getConnectionLifeTime(), aggregatedClientConnStat.getConnectionsOpen() + memberNCC.getConnectionsOpen(), aggregatedClientConnStat.getConnectionsIdle() + memberNCC.getConnectionsIdle());
                NetworkServerConnectionStats peerNCC = (NetworkServerConnectionStats)SQLBB.getBB().getSharedMap().get((Object)("COUNTER_NS_PEER_" + clientName));
                Log.getLogWriter().info("Conn Stat for Member : " + member + ", stat : " + peerNCC + " for Peer");
                aggregatedPeerConnStat.updateNetworkServerConnectionStats(aggregatedPeerConnStat.getConnectionsOpened() + peerNCC.getConnectionsOpened(), aggregatedPeerConnStat.getConnectionsClosed() + peerNCC.getConnectionsClosed(), aggregatedPeerConnStat.getConnectionsAttempted() + peerNCC.getConnectionsAttempted(), aggregatedPeerConnStat.getConnectionsFailed() + peerNCC.getConnectionsFailed(), aggregatedPeerConnStat.getConnectionLifeTime() + peerNCC.getConnectionLifeTime(), aggregatedPeerConnStat.getConnectionsOpen() + peerNCC.getConnectionsOpen(), aggregatedPeerConnStat.getConnectionsIdle() + peerNCC.getConnectionsIdle());
                NetworkServerNestedConnectionStats nestedNCC = (NetworkServerNestedConnectionStats)SQLBB.getBB().getSharedMap().get((Object)("COUNTER_NS_NESTED_" + clientName));
                Log.getLogWriter().info("Conn Stat for Member : " + member + ", stat : " + nestedNCC + " for Nested");
                aggregatedNestedConnStat.updateNetworkServerConnectionStats(aggregatedNestedConnStat.getConnectionsOpened() + nestedNCC.getConnectionsOpened(), aggregatedNestedConnStat.getConnectionsClosed() + nestedNCC.getConnectionsClosed(), aggregatedNestedConnStat.getConnectionsActive() + nestedNCC.getConnectionsActive());
                NetworkServerNestedConnectionStats internalNCC = (NetworkServerNestedConnectionStats)SQLBB.getBB().getSharedMap().get((Object)("COUNTER_NS_INTERNAL_" + clientName));
                Log.getLogWriter().info("Conn Stat for Member : " + member + ", stat : " + internalNCC + "for Internal");
                aggregatedInternalConnStat.updateNetworkServerConnectionStats(aggregatedInternalConnStat.getConnectionsOpened() + internalNCC.getConnectionsOpened(), aggregatedInternalConnStat.getConnectionsClosed() + internalNCC.getConnectionsClosed(), aggregatedInternalConnStat.getConnectionsActive() + internalNCC.getConnectionsActive());
            }
            CompositeDataSupport clientConnStat = (CompositeDataSupport)mbeanServer.getAttribute(aggregateName, "NetworkServerClientConnectionStats");
            Log.getLogWriter().info("Aggregated NetworkServerClientConnectionStats : Expected : " + aggregatedClientConnStat + ", Actual : " + clientConnStat);
            this.compare(aggregatedClientConnStat, clientConnStat, true, true);
            CompositeDataSupport peerConnStat = (CompositeDataSupport)mbeanServer.getAttribute(aggregateName, "NetworkServerPeerConnectionStats");
            Log.getLogWriter().info("Aggregated NetworkServerPeerConnectionStats : Expected : " + aggregatedPeerConnStat + ", Actual : " + peerConnStat);
            this.compare(aggregatedPeerConnStat, peerConnStat, true, true);
            CompositeDataSupport nestedConnStat = (CompositeDataSupport)mbeanServer.getAttribute(aggregateName, "NetworkServerNestedConnectionStats");
            Log.getLogWriter().info("Aggregated NetworkServerNestedConnectionStats : Expected : " + aggregatedNestedConnStat + ", Actual : " + nestedConnStat);
            this.compare(aggregatedNestedConnStat, nestedConnStat, true, true);
            CompositeDataSupport internalConnStat = (CompositeDataSupport)mbeanServer.getAttribute(aggregateName, "NetworkServerInternalConnectionStats");
            Log.getLogWriter().info("Aggregated NetworkServerInternalConnectionStats : Expected : " + aggregatedInternalConnStat + ", Actual : " + internalConnStat);
            int procCallCompletedAttr = (Integer)mbeanServer.getAttribute(aggregateName, "ProcedureCallsCompleted");
            Log.getLogWriter().info("Aggregated ProcedureCallsCompleted : Expected : " + aggregatedTimesProcCalled + ", Actual : " + procCallCompletedAttr);
            this.compare(aggregatedTimesProcCalled, procCallCompletedAttr, "ProcedureCallsCompleted", aggregateName);
            int procedureCallsInProgressAttr = (Integer)mbeanServer.getAttribute(aggregateName, "ProcedureCallsInProgress");
            Log.getLogWriter().info("Aggregated ProcedureCallsInProgress : Expected : " + aggregatedTimesProcInProgress + ", Actual : " + procedureCallsInProgressAttr);
            this.compare(aggregatedTimesProcInProgress, procedureCallsInProgressAttr, "ProcedureCallsInProgress", aggregateName);
            this.closeJMXConnector();
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MBeanException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            throw new TestException("Error while validateAggregatedMemberMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
        finally {
            this.unLockReadManager();
        }
    }

    private void compare(int expected, int actual, String method, ObjectName aggregateName) {
        if (expected != actual) {
            MBeanHelper.saveError(method + " value did not match for " + aggregateName + ", Expected : " + expected + " and actual : " + actual);
        }
    }

    private void compare(NetworkServerConnectionStats expected, CompositeDataSupport actual, boolean actualCanBeGreater) {
        this.compare(expected, actual, actualCanBeGreater, false);
    }

    private void compare(NetworkServerConnectionStats expected, CompositeDataSupport actual, boolean actualCanBeGreater, boolean isAggregated) {
        if (expected == null || actual == null) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats not match, one or both is null, Actual : " + actual + " and Expected : " + expected);
        }
        String connectionStateType = (String)actual.get("connectionStatsType");
        if (!expected.getConnectionStatsType().equals(connectionStateType)) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats ConnectionStatsType not match, Actual : " + connectionStateType + " and Expected : " + expected.getConnectionStatsType());
        }
        Log.getLogWriter().info("Verifing " + this.getAggregatePrefix(isAggregated) + "Network Connection Stat of " + connectionStateType);
        Log.getLogWriter().info("Expected " + this.getAggregatePrefix(isAggregated) + "Network conn stat : " + expected);
        Log.getLogWriter().info("Actual " + this.getAggregatePrefix(isAggregated) + "Network conn stat : " + actual);
        long connectionsOpened = (Long)actual.get("connectionsOpened");
        if (actualCanBeGreater ? expected.getConnectionsOpened() > connectionsOpened : expected.getConnectionsOpened() != connectionsOpened) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsOpened not match, Actual : " + connectionsOpened + " and Expected : " + expected.getConnectionsOpened());
        }
        long connectionsClosed = (Long)actual.get("connectionsClosed");
        if (actualCanBeGreater ? expected.getConnectionsClosed() > connectionsClosed : expected.getConnectionsClosed() != connectionsClosed) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsClosed not match, Actual : " + connectionsClosed + " and Expected : " + expected.getConnectionsClosed());
        }
        long connectionsAttempted = (Long)actual.get("connectionsAttempted");
        if (actualCanBeGreater ? expected.getConnectionsAttempted() > connectionsAttempted : expected.getConnectionsAttempted() != connectionsAttempted) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsAttempted not match, Actual : " + connectionsAttempted + " and Expected : " + expected.getConnectionsAttempted());
        }
        long connectionsFailed = (Long)actual.get("connectionsFailed");
        if (actualCanBeGreater ? expected.getConnectionsFailed() > connectionsFailed : expected.getConnectionsFailed() != connectionsFailed) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsFailed not match, Actual : " + connectionsFailed + " and Expected : " + expected.getConnectionsFailed());
        }
        long connectionsOpen = (Long)actual.get("connectionsOpen");
        if (!actualCanBeGreater && expected.getConnectionsOpen() != connectionsOpen) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsOpen not match, Actual : " + connectionsOpen + " and Expected : " + expected.getConnectionsOpen());
        }
        long connectionsIdle = (Long)actual.get("connectionsIdle");
        if (!actualCanBeGreater && expected.getConnectionsIdle() != connectionsIdle) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerConnectionStats connectionsIdle not match, Actual : " + connectionsIdle + " and Expected : " + expected.getConnectionsIdle());
        }
    }

    private void compare(NetworkServerNestedConnectionStats expected, CompositeDataSupport actual, boolean actualCanBeGreater) {
        this.compare(expected, actual, actualCanBeGreater, false);
    }

    private void compare(NetworkServerNestedConnectionStats expected, CompositeDataSupport actual, boolean actualCanBeGreater, boolean isAggregated) {
        if (expected == null || actual == null) {
            MBeanHelper.saveError("NetworkServerNestedConnectionStats ConnectionStatsType not match, Actual : " + actual + " and Expected : " + expected);
        }
        String connectionStateType = (String)actual.get("connectionStatsType");
        if (!expected.getConnectionStatsType().equals(connectionStateType)) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerNestedConnectionStats ConnectionStatsType not match, Actual : " + connectionStateType + " and Expected : " + expected.getConnectionStatsType());
        }
        Log.getLogWriter().info("Verifing " + this.getAggregatePrefix(isAggregated) + "Network Connection Stat of " + connectionStateType);
        Log.getLogWriter().info("Expected " + this.getAggregatePrefix(isAggregated) + "Network conn stat : " + expected);
        Log.getLogWriter().info("Actual " + this.getAggregatePrefix(isAggregated) + "Network conn stat : " + actual);
        long connectionsOpened = (Long)actual.get("connectionsOpened");
        if (actualCanBeGreater ? expected.getConnectionsOpened() > connectionsOpened : expected.getConnectionsOpened() != connectionsOpened) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerNestedConnectionStats connectionsOpened not match, Actual : " + connectionsOpened + " and Expected : " + expected.getConnectionsOpened());
        }
        long connectionsClosed = (Long)actual.get("connectionsClosed");
        if (actualCanBeGreater ? expected.getConnectionsClosed() > connectionsClosed : expected.getConnectionsClosed() != connectionsClosed) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerNestedConnectionStats connectionsClosed not match, Actual : " + connectionsClosed + " and Expected : " + expected.getConnectionsClosed());
        }
        long connectionsActive = (Long)actual.get("connectionsActive");
        if (actualCanBeGreater ? expected.getConnectionsActive() > connectionsActive : expected.getConnectionsActive() != connectionsActive) {
            MBeanHelper.saveError(this.getAggregatePrefix(isAggregated) + "NetworkServerNestedConnectionStats connectionsActive not match, Actual : " + connectionsActive + " and Expected : " + expected.getConnectionsActive());
        }
    }

    private String getAggregatePrefix(boolean isAggregated) {
        return isAggregated ? "Aggregated " : "";
    }

    private boolean isHDFSTest() {
        try {
            boolean b = TestConfig.tab().booleanAt(SQLPrms.hasHDFS);
            return b;
        }
        catch (HydraConfigException e) {
            return false;
        }
    }

    private void checkTableMBeans(MBeanServerConnection mbeanServer, boolean verifyMBean, boolean verifyAggregatedMBean) {
        ArrayList<ClientVmInfo> vmInfoList = new ArrayList<ClientVmInfo>();
        ClientVmInfo vmInfo = new ClientVmInfo(Integer.valueOf(RemoteTestModule.getMyVmid()), RemoteTestModule.getMyClientName(), RemoteTestModule.getMyLogicalHost());
        vmInfoList.add(vmInfo);
        ArrayList<String> defaultGrp = new ArrayList<String>();
        defaultGrp.add(DEFAULT_SERVER_GROUP);
        for (String table : tableList) {
            try {
                this.checkTableMBean(mbeanServer, true, vmInfoList, table, defaultGrp, verifyMBean, verifyAggregatedMBean);
            }
            catch (MalformedObjectNameException e) {
                throw new TestException("Error while verifiying Check Table Mbeans", (Throwable)e);
            }
            catch (AttributeNotFoundException e) {
                throw new TestException("Error while verifiying Check Table Mbeans", (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new TestException("Error while verifiying Check Table Mbeans", (Throwable)e);
            }
            catch (IOException e) {
                throw new TestException("Error while verifiying Check Table Mbeans", (Throwable)e);
            }
            catch (TestException e) {
                throw new TestException("Error while verifiying Check Table Mbeans", (Throwable)e);
            }
        }
    }

    private void checkTableMBeans(MBeanServerConnection mbeanServer, boolean verifyMBean) {
        this.checkTableMBeans(mbeanServer, verifyMBean, false);
    }

    private String[] getGfxdClusterMembers(MBeanServerConnection mbeanServer) throws Exception {
        ObjectName name = new ObjectName("GemFireXD:service=Cluster");
        String[] members = (String[])mbeanServer.getAttribute(name, "Members");
        return members;
    }

    private void checkStatementMBeans(MBeanServerConnection mbeanServer) {
        Statistics[] stats;
        for (Statistics stat : stats = MBeanTest.getStatementMBeans(ManagementUtil.getMemberID())) {
            if (stat.getTextId().toLowerCase().contains("sys.")) {
                Log.getLogWriter().info(stat.getTextId() + " is of type sys. No need to validate this statement. ");
                return;
            }
            if (MBeanHelper.isLocator()) {
                this.validateForNoMBeanOnLocator(mbeanServer, stat, ManagementUtil.getMemberID());
                Log.getLogWriter().info("Member " + ManagementUtil.getMemberID() + " is Locator. So no need to verify over here.");
                return;
            }
            Log.getLogWriter().info("Verfiy Statement MBean for " + stat.getTextId());
            this.verfiyStat(mbeanServer, stat);
            Log.getLogWriter().info("Verfiy Aggregated Statement MBean for " + stat.getTextId());
            this.verifyAggregatedStatementMBean(mbeanServer, stat);
        }
    }

    private void validateForNoMBeanOnLocator(MBeanServerConnection mbeanServer, Statistics stat, String memberId) {
        ObjectName name = MBeanTest.getStatementMBeanName(ManagementUtil.getMemberID(), stat.getTextId());
        try {
            AttributeList valueFromMBean = mbeanServer.getAttributes(name, MBeanTestConstants.STATEMENT_ATTRS);
            Log.getLogWriter().error("No Attribute for statement should found on member : " + memberId + "because it is locator but found :" + valueFromMBean);
        }
        catch (InstanceNotFoundException valueFromMBean) {
        }
        catch (Exception e) {
            throw new TestException("verifyStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void verfiyStat(MBeanServerConnection mbeanServer, Statistics stat) {
        Log.getLogWriter().info("Trying to validate Statement Stat for : " + stat.getTextId());
        ObjectName name = MBeanTest.getStatementMBeanName(ManagementUtil.getMemberID(), stat.getTextId());
        for (String attr : MBeanTestConstants.STATEMENT_ATTRS) {
            try {
                Number valueFromStats = 0;
                try {
                    valueFromStats = stat.get(attr);
                }
                catch (IllegalArgumentException e) {
                    Log.getLogWriter().error(attr + "  did not found for Statement : " + stat.getTextId());
                    continue;
                }
                Object valueFromMBean = null;
                valueFromMBean = mbeanServer.getAttribute(name, attr);
                this.saveStatementMBean(stat.getTextId(), attr, valueFromMBean);
                Log.getLogWriter().info("Validating Statement MBean Attr : " + attr + " for " + stat.getTextId() + ", Expected : " + valueFromStats + " And Actual :" + valueFromMBean);
                this.match("Error occurred while validating Statement MBean for Attr : " + attr + " for Statement " + stat.getTextId(), stat.get(attr), (Number)valueFromMBean);
            }
            catch (InstanceNotFoundException e) {
                MBeanHelper.saveError("Expecting statement to be present for " + stat.getTextId() + " but it is not present");
                return;
            }
            catch (MBeanException e) {
                throw new TestException("verifyStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (ReflectionException e) {
                throw new TestException("verifyStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (IOException e) {
                throw new TestException("verifyStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (AttributeNotFoundException e) {
                throw new TestException("verifyStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStatementMBean(String textId, String attr, Object valueFromMBean) {
        Map statementMap = (Map)SQLBB.getBB().getSharedMap().get((Object)COUNTER_MBEAN_STATEMENT);
        HashMap<String, Object> attrMap = (HashMap<String, Object>)statementMap.get(textId);
        if (attrMap == null) {
            attrMap = new HashMap<String, Object>();
        }
        attrMap.put(attr, valueFromMBean);
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            SQLBB.getBB().getSharedMap().put((Object)COUNTER_MBEAN_STATEMENT, (Object)statementMap);
        }
        finally {
            lock.unlock();
        }
    }

    private void match(String errorStringSuffix, Object expcted, Object actual) {
        if (!expcted.toString().equals(actual.toString())) {
            MBeanHelper.saveError(errorStringSuffix + " Expected : " + expcted + " And Actual : " + actual);
        }
    }

    private void verifyAggregatedStatementMBean(MBeanServerConnection mbeanServer, Statistics stat) {
        String[] attrs = new String[]{"NumTimesCompiled", "NumExecution", "NumExecutionsInProgress", "NumTimesGlobalIndexLookup", "NumRowsModified", "ParseTime", "BindTime", "OptimizeTime", "RoutingInfoTime", "GenerateTime", "TotalCompilationTime", "ExecutionTime", "ProjectionTime", "TotalExecutionTime", "RowsModificationTime", "QNNumRowsSeen", "QNMsgSendTime", "QNMsgSerTime", "QNRespDeSerTime"};
        Log.getLogWriter().info("Trying to validate Aggregate Statement Stat for : " + stat.getTextId());
        ObjectName name = MBeanTest.getAggregatedStatementMBeanName(stat.getTextId());
        if (name != null) {
            for (String attr : attrs) {
                Object valueFromMBean = null;
                try {
                    valueFromMBean = mbeanServer.getAttribute(name, attr);
                    Log.getLogWriter().info("Validating Aggregated Statement MBean for " + stat.getTextId() + ", Expected : <NA> And Actual :" + valueFromMBean);
                }
                catch (AttributeNotFoundException e) {
                    throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (InstanceNotFoundException e) {
                    throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (MBeanException e) {
                    throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (ReflectionException e) {
                    throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
                }
                catch (IOException e) {
                    throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
                }
            }
        }
        if (name != null) {
            try {
                AttributeList list = mbeanServer.getAttributes(name, attrs);
                Log.getLogWriter().info("GFXD Aggregated Statement Attributes " + HydraUtil.ObjectToString((Object)list));
            }
            catch (InstanceNotFoundException e) {
                throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (ReflectionException e) {
                throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (IOException e) {
                throw new TestException("verifyAggregatedStatementMBean\n" + TestHelper.getStackTrace((Throwable)e));
            }
        }
    }

    private void checkRegionCounter(MBeanServerConnection mbeanServer) {
        this.checkDSRegionCounters(mbeanServer);
        Log.getLogWriter().info("checkRegionCounter  : OK");
    }

    private void checkDSRegionCounters(MBeanServerConnection mbeanServer) {
        Log.getLogWriter().info("checkDSRegionCounters  : ");
        ObjectName memberON = ManagementUtil.getLocalMemberMBeanON();
        try {
            String[] regionNames;
            for (String region : regionNames = (String[])mbeanServer.invoke(memberON, "listRegions", null, null)) {
                if (!region.startsWith("/TRADE/") || region.contains("_")) continue;
                String objectName = distributedRegionONTemplate.replace("$1", region);
                ObjectName regionON = new ObjectName(objectName);
                String[] attributes = new String[]{"RegionType", "Members", "DiskReadsRate", "DiskWritesRate"};
                AttributeList list = mbeanServer.getAttributes(regionON, attributes);
                Log.getLogWriter().info(region + " Attributes List " + HydraUtil.ObjectToString((Object)list));
                CompositeDataSupport rData = (CompositeDataSupport)mbeanServer.invoke(regionON, "listRegionAttributes", null, null);
                Log.getLogWriter().fine(region + " AttributesData " + HydraUtil.ObjectToString((Object)rData));
                if (MBeanPrms.isWANTest() || this.isHDFSTest()) continue;
                boolean bl = (Boolean)rData.get("enableOffHeapMemory");
            }
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MBeanException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void checkMemberCounters(MBeanServerConnection mbeanServer) {
        this.checkTxCounters(mbeanServer);
        this.checkOtherCounters(mbeanServer);
        Log.getLogWriter().info("checkMemberCounters  : OK");
    }

    private int getTotalRegionEntryCount(MBeanServerConnection mbeanServer) {
        String template = "GemFire:service=System,type=Distributed";
        try {
            ObjectName dsON = new ObjectName(template);
            String[] attributes = new String[]{"TotalRegionEntryCount"};
            AttributeList list = mbeanServer.getAttributes(dsON, attributes);
            Log.getLogWriter().info("checkDSCounters Attributes List " + HydraUtil.ObjectToString((Object)list));
            return 0;
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void checkDSCounters(MBeanServerConnection mbeanServer) {
        Log.getLogWriter().info("checkDSCounters  : ");
        String template = "GemFire:service=System,type=Distributed";
        String[] attributes = new String[]{"TransactionCommitted", "TransactionRolledBack", "TotalHeapSize", "UsedHeapSize", "DiskReadsRate", "DiskWritesRate", "TotalRegionCount", "AverageReads", "AverageWrites"};
        String[] nonZeroAttrs = new String[]{"TotalHeapSize", "UsedHeapSize", "TotalRegionCount"};
        HashMap<String, Object> expectedMap = new HashMap<String, Object>();
        expectedMap.put("TotalRegionCount", this.mbeanHelper.getTotalRegions());
        expectedMap.put("TransactionCommitted", this.mbeanHelper.getTotalTxCommits());
        expectedMap.put("TransactionRolledBack", this.mbeanHelper.getTotalTxRollbacks());
        try {
            ObjectName dsON = new ObjectName(template);
            AttributeList list = mbeanServer.getAttributes(dsON, attributes);
            Log.getLogWriter().info("checkDSCounters Attributes List " + HydraUtil.ObjectToString((Object)list));
            MBeanHelper.ensureNonZero(list, nonZeroAttrs);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (NullPointerException e) {
            throw new TestException("Error while getAttributes : checkDSRegionCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        Log.getLogWriter().info("checkDSCounters  : OK");
    }

    private void checkOtherCounters(MBeanServerConnection mbeanServer) {
        Log.getLogWriter().info("checkMemberCounters  : checkOtherCounters");
        ObjectName on = ManagementUtil.getLocalMemberMBeanON();
        String[] attributes = new String[]{"OffHeapFreeMemory", "OffHeapUsedMemory", "CpuUsage", "HostCpuUsage", "NumThreads", "LoadAverage", "TotalFileDescriptorOpen", "CurrentHeapSize", "DiskReadsRate", "DiskWritesRate", "AverageReads", "AverageWrites", "TotalRegionCount"};
        HashMap<String, Object> expectedMap = new HashMap<String, Object>();
        expectedMap.put("TotalRegionCount", this.mbeanHelper.getTotalRegions());
        try {
            AttributeList list = mbeanServer.getAttributes(on, attributes);
            Log.getLogWriter().info("Attributes List " + HydraUtil.ObjectToString((Object)list));
            if (!MBeanPrms.isWANTest() && !this.isHDFSTest() && MBeanPrms.offHeap()) {
                MBeanHelper.ensureNonZero(list, new String[]{"OffHeapFreeMemory", "OffHeapUsedMemory"});
            }
            MBeanHelper.ensureNonZero(list, new String[]{"NumThreads", "TotalFileDescriptorOpen", "CurrentHeapSize"});
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while getAttributes : checkOtherCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while getAttributes : checkOtherCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while getAttributes : checkOtherCounters\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void checkTxCounters(MBeanServerConnection mbeanServer) {
        Log.getLogWriter().info("checkMemberCounters  : txAttributes");
        ObjectName on = ManagementUtil.getLocalMemberMBeanON();
        String[] txAttributes = new String[]{"TransactionCommittedTotalCount", "TransactionRolledBackTotalCount"};
        int txCommits = this.getCounter(COUNTER_SELLORDER_COMMITS);
        int txRollBacks = this.getCounter(COUNTER_SELLORDER_ROLLBACKS);
        HashMap<String, Number> expectedMap = new HashMap<String, Number>();
        expectedMap.put("TransactionCommittedTotalCount", txCommits);
        expectedMap.put("TransactionRolledBackTotalCount", txRollBacks);
        try {
            AttributeList list = mbeanServer.getAttributes(on, txAttributes);
            CachePerfStats stats = GemFireCacheImpl.getInstance().getCachePerfStats();
            Log.getLogWriter().info("From stats rollbacks : " + stats.getTxRollbacks() + " commits : " + stats.getTxCommits());
            expectedMap.put("TransactionRolledBackTotalCount", stats.getTxRollbacks());
            expectedMap.put("TransactionCommittedTotalCount", stats.getTxCommits());
            this.mbeanHelper.compareValues(list, expectedMap, true);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error while getAttributes : txAttributes\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (ReflectionException e) {
            throw new TestException("Error while getAttributes : txAttributes\n" + TestHelper.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            throw new TestException("Error while getAttributes : txAttributes\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void lockWriteManager() {
        if (!this.useLocks) {
            throw new TestException("MRWL : Test is attmpting locking manager without configuring use of locks");
        }
        Log.getLogWriter().info("MRWL : WriteLocking manager from thread " + RemoteTestModule.getCurrentThread().getThreadId());
        int writeCount = 0;
        SharedLock lock = SQLBB.getBB().getSharedLock();
        lock.lock();
        Integer readers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_READERS);
        Integer writers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_WRITERS);
        int readCount = readers == null ? 0 : readers;
        writeCount = writers == null ? 0 : writers;
        Log.getLogWriter().info("MRWL : Read Count is " + readCount + " Writecount is " + writeCount);
        if (readCount <= 0) {
            Log.getLogWriter().info("Read Count is <= Zero. Increasing write count...");
            SQLBB.getBB().getSharedMap().put((Object)MANAGER_WRITERS, (Object)(++writeCount));
            lock.unlock();
        } else {
            Log.getLogWriter().info("MRWL : Manager read operation undergoing, waiting ....");
            boolean readopCompleted = false;
            while (!readopCompleted) {
                Log.getLogWriter().info("MRWL : Sleeping for manager read operation to complete. readCount " + readers);
                lock.unlock();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                lock.lock();
                readers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_READERS);
                readopCompleted = readers == 0;
            }
            Log.getLogWriter().info("MRWL : Manager read operation completed");
            SQLBB.getBB().getSharedMap().put((Object)MANAGER_WRITERS, (Object)(++writeCount));
            Log.getLogWriter().info("Read Count is Zero. Increasing write count...");
            lock.unlock();
        }
        Log.getLogWriter().info("MRWL : Manager WriteLock acquired from thread " + RemoteTestModule.getCurrentThread().getThreadId());
    }

    private void unLockWriteManager() {
        if (!this.useLocks) {
            throw new TestException("MRWL : Test is attmpting locking manager without configuring use of locks");
        }
        Log.getLogWriter().info("MRWL : UnLockingWrite manager from thread " + RemoteTestModule.getCurrentThread().getThreadId());
        int writeCount = 0;
        SharedLock lock = SQLBB.getBB().getSharedLock();
        lock.lock();
        Integer writers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_WRITERS);
        writeCount = writers;
        SQLBB.getBB().getSharedMap().put((Object)MANAGER_WRITERS, (Object)(--writeCount));
        lock.unlock();
        Log.getLogWriter().info("MRWL : Manager WriteLock unlocked from thread " + RemoteTestModule.getCurrentThread().getThreadId());
    }

    private void lockReadManager() {
        if (this.useLocks) {
            Log.getLogWriter().info("MRWL : ReadLocking manager from thread " + RemoteTestModule.getCurrentThread().getThreadId());
            int writeCount = 0;
            SharedLock lock = SQLBB.getBB().getSharedLock();
            lock.lock();
            Integer readers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_READERS);
            Integer writers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_WRITERS);
            int readCount = readers == null ? 0 : readers;
            writeCount = writers == null ? 0 : writers;
            Log.getLogWriter().info("MRWL : Read Count is " + readCount + " Writecount is " + writeCount);
            if (writeCount <= 0) {
                Log.getLogWriter().info("Read Count is " + readCount + " increasing readCount");
                SQLBB.getBB().getSharedMap().put((Object)MANAGER_READERS, (Object)(++readCount));
                lock.unlock();
            } else {
                Log.getLogWriter().info("MRWL : Manager write operation undergoing, waiting ....");
                boolean writeOpComplete = false;
                while (!writeOpComplete) {
                    lock.unlock();
                    Log.getLogWriter().info("MRWL : Sleeping for manager write operation to complete writers " + writers);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    lock.lock();
                    writers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_WRITERS);
                    writeOpComplete = writers == 0;
                }
                Log.getLogWriter().info("MRWL : Manager write operation completed");
                SQLBB.getBB().getSharedMap().put((Object)MANAGER_READERS, (Object)(++readCount));
                Log.getLogWriter().info("MRWL : Write Count is Zero. Increasing read count...");
                lock.unlock();
            }
            Log.getLogWriter().info("MRWL : Manager ReadLock acquired from thread " + RemoteTestModule.getCurrentThread().getThreadId());
        }
    }

    private void unLockReadManager() {
        if (this.useLocks) {
            Log.getLogWriter().info("MRWL : UnLockingRead manager from thread " + RemoteTestModule.getCurrentThread().getThreadId());
            int readCount = 0;
            SharedLock lock = SQLBB.getBB().getSharedLock();
            lock.lock();
            Integer readers = (Integer)SQLBB.getBB().getSharedMap().get((Object)MANAGER_READERS);
            readCount = readers;
            SQLBB.getBB().getSharedMap().put((Object)MANAGER_READERS, (Object)(--readCount));
            lock.unlock();
            Log.getLogWriter().info("MRWL : Manager ReadLock unlocked from thread " + RemoteTestModule.getCurrentThread().getThreadId());
        }
    }

    private synchronized MBeanServerConnection connectJMXConnector() {
        Log.getLogWriter().info("connectJMXConnector : Start");
        boolean isManagerRunning = this.getCounter(MANAGER_RUNNING) > 0;
        Log.getLogWriter().info("isManagerRunning : " + isManagerRunning + " retries " + this.connectorRetries);
        if (!isManagerRunning) {
            if (this.isThisManagerVM()) {
                return null;
            }
            if (this.connectorRetries.get() >= MAX_RETRIES) {
                throw new TestException("MAX_RETRIES exceeded while waiting for manager");
            }
            this.connectorTL.set(null);
            Log.getLogWriter().info("Sleeping for some time till manager comes online");
            MBeanPrms.waitForManager();
            this.connectorRetries.incrementAndGet();
            return this.connectJMXConnector();
        }
        try {
            JMXConnector connector = (JMXConnector)this.connectorTL.get();
            MBeanServerConnection conn = null;
            if (connector == null) {
                String host = InetAddress.getLocalHost().getHostName();
                int port = this.getJMXPort();
                Log.getLogWriter().info("Creating new JMX-RMI Connection on port " + port);
                JMXServiceURL serviceUrl = new JMXServiceURL(MessageFormat.format(JMX_URL_FORMAT, host, String.valueOf(port)));
                connector = JMXConnectorFactory.connect(serviceUrl);
                this.connectorTL.set((Object)connector);
                this.connectorRetries.set(0);
                conn = connector.getMBeanServerConnection();
            } else {
                this.connectorRetries.set(0);
                conn = connector.getMBeanServerConnection();
                conn.getDomains();
            }
            return conn;
        }
        catch (IOException e) {
            this.connectorTL.set(null);
            if (!isManagerRunning) {
                if (this.connectorRetries.get() >= MAX_RETRIES) {
                    throw new TestException("Not able to connect to jmx-manager\n" + TestHelper.getStackTrace((Throwable)e));
                }
            } else {
                Log.getLogWriter().info("Sleeping for some time till manager comes online");
                MBeanPrms.waitForManager();
                this.connectorRetries.incrementAndGet();
                return this.connectJMXConnector();
            }
            throw new TestException("Not able to connect to jmx-manager\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private void closeJMXConnector() {
        try {
            if (this.connectorTL.get() == null) {
                return;
            }
            JMXConnector connector = (JMXConnector)this.connectorTL.get();
            connector.close();
            this.connectorTL.set(null);
        }
        catch (IOException e) {
            throw new TestException("Error while closing jmx-rmi-connectors\n" + TestHelper.getStackTrace((Throwable)e));
        }
    }

    private String getServerGroups() {
        return this.getServerGroups(RemoteTestModule.getMyClientName());
    }

    private String getServerGroups(String clientName) {
        if (MBeanPrms.hasMultipleServerGroups()) {
            String groupString = "CG,";
            if (clientName.contains("peer")) {
                groupString = groupString + "peer";
            }
            if (clientName.contains("manager")) {
                groupString = groupString + "manager";
            }
            Log.getLogWriter().info("Starting with groups " + groupString);
            return groupString;
        }
        return null;
    }

    private List<String> getServerGroupsArray() {
        String groups;
        ArrayList<String> groupList = new ArrayList<String>();
        if (!MBeanPrms.isWANTest() && (groups = this.getServerGroups()) != null) {
            for (String s : groups.split(",")) {
                groupList.add(s.toUpperCase());
            }
        }
        groupList.add(DEFAULT_SERVER_GROUP);
        Log.getLogWriter().info("Group List : " + groupList);
        return groupList;
    }

    private List<String> getServerGroupsArray(String clientName) {
        ArrayList<String> groupList = new ArrayList<String>();
        if (!MBeanPrms.isWANTest() && !this.isHDFSTest()) {
            Log.getLogWriter().info("Trying to getServer Groups for client :" + clientName);
            String groups = this.getServerGroups(clientName);
            if (groups != null) {
                for (String s : groups.split(",")) {
                    groupList.add(s.toUpperCase());
                }
            }
        }
        groupList.add(DEFAULT_SERVER_GROUP);
        Log.getLogWriter().info("Server groups for client : " + clientName + " is " + groupList);
        return groupList;
    }

    private int getJMXPort() {
        Integer portInt = null;
        if (!MBeanPrms.isWANTest()) {
            portInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)"JMX_PORT");
        } else {
            String dsName = (String)SQLBB.getBB().getSharedMap().get((Object)("CLIENT_DS_" + RemoteTestModule.getMyClientName()));
            Log.getLogWriter().info("Trying to find JMX_PORT for ds : " + dsName + ", counter name is : " + "JMX_PORT_" + dsName);
            portInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)("JMX_PORT_" + dsName));
        }
        if (portInt == null) {
            throw new TestException("No JMX_PORT Registered. JMX Manager is not present");
        }
        return portInt;
    }

    private Set<DistributedMember> getMembersSet() {
        Set set = InternalDistributedSystem.getConnectedInstance().getAllOtherMembers();
        HashSet<DistributedMember> memberSet = new HashSet<DistributedMember>();
        memberSet.add((DistributedMember)InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        for (DistributedMember member : set) {
            if (MBeanPrms.isWANTest() || this.isHDFSTest()) {
                memberSet.add(member);
                continue;
            }
            if (!member.getId().contains("locator")) {
                memberSet.add(member);
                continue;
            }
            if (isEdge) {
                memberSet.add(member);
                continue;
            }
            Log.getLogWriter().info("Not considering member " + member.getId());
        }
        return memberSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndIncrementCounter(String counterName, String value) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            Integer valueCounter;
            lock.lock();
            int counter = 0;
            Map<String, Integer> cMap = this.getMapForCounterFromSharedMap(counterName);
            Log.getLogWriter().info("Current value for " + counterName + " is " + cMap);
            if (cMap == null) {
                SQLBB.getBB().getSharedMap().put((Object)counterName, new HashMap());
                cMap = this.getMapForCounterFromSharedMap(counterName);
            }
            if ((valueCounter = cMap.get(value)) != null) {
                counter = valueCounter;
            }
            cMap.put(value, ++counter);
            int n = counter;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private Map<String, Integer> getMapForCounterFromSharedMap(String counterName) {
        return (Map)SQLBB.getBB().getSharedMap().get((Object)counterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementCounter(String string) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            int counter = 0;
            Integer cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)string);
            Log.getLogWriter().info("Current value for " + string + " is " + cInt);
            if (cInt != null) {
                counter = cInt;
            }
            SQLBB.getBB().getSharedMap().put((Object)string, (Object)(++counter));
            cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)string);
            Log.getLogWriter().info("Now value for " + string + " is " + cInt);
            int n = counter;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementCounter(String string) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            int counter = 0;
            Integer cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)string);
            Log.getLogWriter().info("Current value for " + string + " is " + cInt);
            if (cInt != null) {
                counter = cInt;
            }
            SQLBB.getBB().getSharedMap().put((Object)string, (Object)(--counter));
            cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)string);
            Log.getLogWriter().info("Now value for " + string + " is " + cInt);
            int n = counter;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCounter(String string, Object counter) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            SQLBB.getBB().getSharedMap().put((Object)string, counter);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCounter(String string, String value) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            Map<String, Integer> cMap = this.getMapForCounterFromSharedMap(string);
            if (cMap == null || cMap.get(value) == null) {
                int n = 0;
                return n;
            }
            int n = cMap.get(value);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCounter(String string) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            Integer cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)string);
            if (cInt == null) {
                int n = 0;
                return n;
            }
            int n = cInt;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Number getCounterNumber(String string) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        try {
            lock.lock();
            Number cInt = (Number)SQLBB.getBB().getSharedMap().get((Object)string);
            if (cInt == null) {
                Integer n = 0;
                return n;
            }
            Number number = cInt;
            return number;
        }
        finally {
            lock.unlock();
        }
    }

    private void printCounters() {
        Set set = SQLBB.getBB().getSharedMap().getMap().entrySet();
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            Log.getLogWriter().info("Key : " + entry.getKey() + " Value " + entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTotalCounter(String prefix) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        int count = 0;
        try {
            lock.lock();
            for (Map.Entry e : SQLBB.getBB().getSharedMap().getMap().entrySet()) {
                Integer cInt;
                Map.Entry entry = e;
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix) || (cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)key)) == null) continue;
                count += cInt.intValue();
            }
            Integer n = count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object incrementCounterWithPrefix(String prefix) {
        SharedLock lock = SQLBB.getBB().getSharedLock();
        int count = 0;
        try {
            lock.lock();
            String vm_shutting_down = (String)SQLBB.getBB().getSharedMap().getMap().get("VM_SHUTTING_DOWN");
            Log.getLogWriter().info("Not considering vm <" + vm_shutting_down + ">");
            Iterator i$ = SQLBB.getBB().getSharedMap().getMap().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry e;
                Map.Entry entry = e = i$.next();
                String key = (String)entry.getKey();
                boolean isThisVMShuttingDown = false;
                isThisVMShuttingDown = vm_shutting_down != null ? !vm_shutting_down.equals("NULL") && key.contains(vm_shutting_down) : false;
                if (!key.startsWith(prefix) || isThisVMShuttingDown) continue;
                Integer cInt = (Integer)SQLBB.getBB().getSharedMap().get((Object)key);
                count = cInt != null ? cInt : 0;
                SQLBB.getBB().getSharedMap().put((Object)key, (Object)(++count));
                Log.getLogWriter().info("**** Incremented counter for key " + key + " value " + count);
            }
            Integer n = count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private Statistics getStatementStats(String sting, String like) {
        Statistics[] stats;
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        StatisticsType st = dsys.findType("StatementStats");
        for (Statistics s : stats = dsys.findStatisticsByType(st)) {
            String id = s.getTextId();
            if (!id.contains("TRADE.SELLORDERS") || !sting.contains(like) || !id.contains(like)) continue;
            return s;
        }
        return null;
    }

    private Statistics[] getTableStats(String tableName, boolean isPR) {
        Statistics[] stats;
        String statsTxtId = "RegionStats-" + (isPR ? "partition-" : "") + tableName;
        Log.getLogWriter().info("Trying to find table stat for " + statsTxtId);
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        for (Statistics s : stats = dsys.findStatisticsByTextId(statsTxtId)) {
            String id = s.getTextId();
            Log.getLogWriter().info("*********** Stat + " + id);
            int inserts = s.get("creates").intValue();
            Log.getLogWriter().info("Insert for " + id + " : " + inserts);
            int updates = s.get("puts").intValue();
            Log.getLogWriter().info("Put for " + id + " : " + updates);
            int deletes = s.get("destroys").intValue();
            Log.getLogWriter().info("Destroy for " + id + " : " + deletes);
        }
        return stats;
    }

    private Statistics getMemberStats() {
        Statistics[] stats;
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        StatisticsType st = dsys.findType(ConnectionStats.name);
        for (Statistics s : stats = dsys.findStatisticsByType(st)) {
            String id = s.getTextId();
            Log.getLogWriter().info("Member Stats just to check : " + id + ", Stat : " + s);
        }
        return null;
    }

    public static Statistics[] getStatementMBeans(String memberNameOrId) {
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] stats = dsys.findStatisticsByType(st);
        return stats;
    }

    public static ObjectName getStatementMBeanName(String memberNameOrId, String textId) {
        String name = MBeanHelper.quoteIfNeeded(MBeanHelper.makeCompliantName(textId));
        return MBeanJMXAdapter.getObjectName((String)MessageFormat.format("GemFireXD:service=Statement,type=Member,member={0},name={1}", MBeanHelper.makeCompliantName(MBeanHelper.quoteIfNeeded(memberNameOrId)), name));
    }

    public static ObjectName getAggregatedStatementMBeanName(String executeStatementNameAndSchema) {
        InternalDistributedSystem dsys = InternalDistributedSystem.getConnectedInstance();
        StatisticsType st = dsys.findType("StatementStats");
        Statistics[] stats = dsys.findStatisticsByType(st);
        String textId = null;
        for (Statistics s : stats) {
            String id = s.getTextId();
            Log.getLogWriter().info("Processing " + id + " for AggregateStatement");
            if (executeStatementNameAndSchema.contains("select") && id.contains("select")) {
                Log.getLogWriter().info("SELECT STMT AGGR STAT : textId " + id + " uniqueId " + s.getNumericId());
                textId = id;
                break;
            }
            if (executeStatementNameAndSchema.contains("insert") && id.contains("insert")) {
                Log.getLogWriter().info("INSERT STMT AGGR STAT : textId " + id + " uniqueId " + s.getNumericId());
                textId = id;
                break;
            }
            if (executeStatementNameAndSchema.contains("update") && id.contains("update")) {
                Log.getLogWriter().info("UPDATE STMT AGGR STAT : textId " + id + " uniqueId " + s.getNumericId());
                textId = id;
                continue;
            }
            if (!executeStatementNameAndSchema.contains("delete") || !id.contains("delete")) continue;
            Log.getLogWriter().info("DELETE STMT AGGR STAT : textId " + id + " uniqueId " + s.getNumericId());
            textId = id;
        }
        if (textId == null) {
            return null;
        }
        String name = MBeanHelper.quoteIfNeeded(MBeanHelper.makeCompliantName(textId));
        return MBeanJMXAdapter.getObjectName((String)MessageFormat.format("GemFireXD:service=Statement,type=Aggregate,name={0}", name));
    }

    private boolean isThisManagerVM() {
        return RemoteTestModule.getMyClientName().contains("manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startLocatorWithManagerRole(boolean mgmtEnabled) {
        String s;
        String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
        Log.getLogWriter().info("Starting peer locator only");
        FabricServerHelper.Endpoint endpoint = MBeanTest.findEndpoint();
        if (endpoint == null) {
            String s2 = "Locator has not been created yet";
            throw new HydraRuntimeException(s2);
        }
        Log.getLogWriter().info("This Locator EndPoint " + endpoint);
        FabricServerDescription fsd = FabricServerHelper.getFabricServerDescription();
        Properties bootProps = FabricServerHelper.getBootProperties();
        Locator locator = DistributedSystemHelper.getLocator();
        bootProps.put("distributed-system-id", fsd.getDistributedSystemId().toString());
        bootProps.put("remote-locators", this.getRemoteLocators(fsd));
        if (mgmtEnabled) {
            int port = PortHelper.getRandomPort();
            bootProps.put("jmx-manager-port", "" + port);
            bootProps.put("jmx-manager-start", "true");
            if (MBeanPrms.isWANTest()) {
                String dsName = fsd.getDistributedSystem();
                SQLBB.getBB().getSharedMap().put((Object)("JMX_PORT_" + dsName), (Object)port);
                Log.getLogWriter().info("For ds=" + dsName + " manager is at port " + port);
            } else {
                SQLBB.getBB().getSharedMap().put((Object)"JMX_PORT", (Object)port);
                Log.getLogWriter().info("Manager is at port " + port);
            }
        }
        if (locator == null) {
            DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
            if (ds == null) {
                SharedCounters counters = LocatorBlackboard.getInstance(fsd.getDistributedSystem()).getSharedCounters();
                while (counters.incrementAndRead(LocatorBlackboard.locatorLock) != 1L) {
                    MasterController.sleepForMs((int)500);
                }
                Log.getLogWriter().info("Starting gemfirexd locator");
                try {
                    Log.getLogWriter().info("Starting gemfirexd locator \"" + endpoint + "\" using boot properties: " + bootProps);
                    FabricServiceManager.getFabricLocatorInstance().start(endpoint.getAddress(), endpoint.getPort(), bootProps);
                    this.incrementCounter(MANAGER_RUNNING);
                    if (networkServerConfig != null) {
                        MBeanNWServerHelper.startNetworkLocators2(networkServerConfig);
                    }
                }
                catch (SQLException e) {
                    String s3 = "Problem starting gemfirexd locator";
                    throw new HydraRuntimeException(s3, (Exception)e);
                }
                Log.getLogWriter().info("Started locator: " + locator);
                this.TheFabricServerProperties = bootProps;
                counters.zero(LocatorBlackboard.locatorLock);
                return;
            }
            s = "This VM is already connected to a distributed system. Too late to start a locator";
            throw new HydraRuntimeException(s);
        }
        if (this.TheFabricServerProperties == null) {
            String s4 = "Locator was already started without FabricServerHelper using an unknown, and possibly different, configuration";
            throw new HydraRuntimeException(s4);
        }
        if (!this.TheFabricServerProperties.equals(bootProps)) {
            String s5 = "Already booted using properties " + this.TheFabricServerProperties + ", cannot also use " + bootProps;
            throw new HydraRuntimeException(s5);
        }
        FabricLocator loc = FabricServiceManager.getFabricLocatorInstance();
        if (loc.status() == FabricService.State.RUNNING) return;
        s = "This VM already contains a non-GemFireXD locator";
        throw new HydraRuntimeException(s);
    }

    protected String getRemoteLocators(FabricServerDescription fsd) {
        String locs = "";
        List<String> dsnames = fsd.getRemoteDistributedSystems();
        Log.getLogWriter().info("Remote dsnames " + dsnames);
        if (dsnames != null) {
            List<FabricServerHelper.Endpoint> endpoints = FabricServerHelper.getEndpoints(dsnames);
            Log.getLogWriter().info("Remote endpoints " + endpoints);
            for (FabricServerHelper.Endpoint endpoint : endpoints) {
                if (locs.length() > 0) {
                    locs = locs + ",";
                }
                locs = locs + endpoint.getId();
                Log.getLogWriter().info("Added endpoint to remoted Locators " + endpoint);
            }
        }
        Log.getLogWriter().info("Remote Locators " + locs);
        return locs;
    }

    private static synchronized FabricServerHelper.Endpoint findEndpoint() {
        Integer vmid = RemoteTestModule.getMyVmid();
        TheLocatorEndpoint = (FabricServerHelper.Endpoint)LocatorBlackboard.getInstance().getSharedMap().get((Object)vmid);
        return TheLocatorEndpoint;
    }

    private static void checkForErrors() {
        ArrayList errorList = (ArrayList)SQLBB.getBB().getSharedMap().get((Object)"DATA_ERROR");
        if (errorList != null && errorList.size() > 0) {
            errorList.add(0, "Errors (" + errorList.size() + ") were found:\n");
            throw new TestException(errorList.toString());
        }
        Log.getLogWriter().info("*** No Errors Were Found!  Congrats, now go celebrate! ***");
    }

    public static void HydraTask_createProcedures() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createProcedures();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProcedures() {
        super.createProcedures();
        Connection conn = this.getGFEConnection();
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(longRunningProcedure);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public static synchronized void HydraTask_createDiskStores() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createDiskStores();
    }

    public static synchronized void HydraTask_initServers() {
        isEdge = true;
    }

    public static synchronized void HydraTask_verifyMBeans() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.verifyMBeans();
    }

    private void verifyMBeans() {
        MBeanServerConnection mbeanServer = this.connectJMXConnector();
        if (mbeanServer == null && this.isThisManagerVM()) {
            Log.getLogWriter().info("Skipping verification as manager is restarting ...");
            return;
        }
        if (mbeanServer == null) {
            throw new TestException("mbeanServer is null");
        }
        this.checkMemberCounters(mbeanServer);
        this.checkRegionCounter(mbeanServer);
        this.checkGfxdMBeans(mbeanServer, true);
        this.closeJMXConnector();
    }

    public static synchronized void HydraTask_createRandomTable() {
        if (mbeanTest == null) {
            MBeanTest.mBeanTestInitialize();
        }
        mbeanTest.createRandomTable();
    }

    private void createRandomTable() {
        Connection conn = this.getGFEConnection();
        Log.getLogWriter().info("Incrementing counter for TABLE_COUNTER");
        int tableNum = this.incrementCounter(TABLE_COUNTER);
        Log.getLogWriter().info("Next Table Number is " + tableNum);
        String table = (String)HydraUtil.getRandomElement((Object[])new String[]{CREATE_TABLE_TEMPLATE, CREATE_TABLE_TEMPLATE_2});
        this.checkAndCreateDiskStore();
        if (CREATE_TABLE_TEMPLATE_2.equals(table)) {
            this.checkAndCreateRefTable();
        }
        String createTable = table.replace("{0}", "" + tableNum);
        String serverGroupString = "";
        ArrayList<String> serverGroupList = new ArrayList<String>();
        boolean onServerGroups = HydraUtil.getRandomBoolean();
        String tableName = TABLE_NAME_TEMPLATE.replace("{0}", "" + tableNum);
        Log.getLogWriter().info("Table Name to create : " + tableName);
        if (!isEdge) {
            if (onServerGroups) {
                String sg = (String)HydraUtil.getRandomElement(this.getServerGroupsArray());
                Log.getLogWriter().info("Server group for table : " + sg);
                while (DEFAULT_SERVER_GROUP.equals(sg)) {
                    sg = (String)HydraUtil.getRandomElement(this.getServerGroupsArray());
                }
                serverGroupList.add(sg);
                serverGroupString = " SERVER GROUPS (" + sg + ")";
                createTable = createTable + serverGroupString;
                Log.getLogWriter().info("sql for create table so far : " + createTable);
                this.saveTableToServerGroupMapping(tableName, Collections.singletonList(sg));
            } else {
                serverGroupList.add(DEFAULT_SERVER_GROUP);
            }
        }
        createTable = createTable + this.appendPersistentToTableDefinition();
        Log.getLogWriter().info("sql for create table so far : " + createTable);
        createTable = createTable + this.appendPartitionToTableDefinition();
        Log.getLogWriter().info("sql for create table so far : " + createTable);
        createTable = createTable + this.appendEvicitionToTableDefinition();
        Log.getLogWriter().info("sql for create table so far : " + createTable);
        createTable = createTable + this.appendColocateToTableDefinition(table);
        Log.getLogWriter().info("sql for create table so far : " + createTable);
        Log.getLogWriter().info("Creating table <" + createTable + ">");
        try {
            int sg = conn.createStatement().executeUpdate(createTable);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HydraUtil.sleepForReplicationJMX();
        MBeanServerConnection mbeanServer = this.connectJMXConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pulseCounterUnderLock() {
        SharedLock lock = MBeanTransactionBB.getBB().getSharedLock();
        try {
            lock.lock();
            Log.getLogWriter().info("LOCK - Holding Lock");
            try {
                this.doOperations();
            }
            catch (SQLTransactionRollbackException e) {
                if (MBeanPrms.isHATest() && this.getCounter("VM_SHUTDOWN") > 0) {
                    Log.getLogWriter().info("SQLTransactionRollbackException possibly due to concurrent vm shutdown");
                    Log.getLogWriter().info("LOCK - releasing Lock");
                    lock.unlock();
                    return;
                }
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
            }
            catch (SQLException e) {
                SQLHelper.printSQLException(e);
                throw new TestException("Not able to execute transaction\n" + TestHelper.getStackTrace((Throwable)e));
            }
            HydraUtil.sleepForReplicationJMX();
            MBeanServerConnection mbeanServer = this.connectJMXConnector();
            if (isEdge) {
                Log.getLogWriter().info("member is edge, so no need to verify mbean here");
                return;
            }
            if (mbeanServer == null && this.isThisManagerVM()) {
                Log.getLogWriter().info("Skipping verification as manager is restarting ...");
                return;
            }
            if (mbeanServer == null) {
                throw new TestException("mbeanServer is null");
            }
            this.checkGfxdMBeans(mbeanServer, true, false);
            this.closeJMXConnector();
            return;
        }
        finally {
            Log.getLogWriter().info("LOCK - releasing Lock");
            lock.unlock();
        }
    }

    private void doOperations() throws SQLException {
        String op = (String)HydraUtil.getRandomElement((Object[])new String[]{"transaction"});
        Log.getLogWriter().info("Trying to execute " + op);
        if ("transaction".equals(op)) {
            this.transaction("trade.sellorders");
        } else if ("createDropIndex".equals(op)) {
            this.createDropIndexTest();
        } else if ("createDropTable".equals(op)) {
            this.createDropTable();
        } else if ("alterTable".equals(op)) {
            this.alterTableTest();
        }
    }

    static {
        MAX_RETRIES = MBeanPrms.maxRetries();
        COUNTER_MBEAN_PROC_CALLS_EDGE = "MBEAN_PROC_CALLS_EDGE";
        COUNTER_MBEAN_PROC_CALLS_IN_PROGRESS_EDGE = "MBEAN_PROC_CALLS_IN_PROGRESS_EDGE";
        COUNTER_MBEAN_PROC_CALLS_PREFIX = "MBEAN_PROC_CALLS_";
        COUNTER_MBEAN_STATEMENT_PREFIX = "MBEAN_STATEMENT_";
        COUNTER_MBEAN_PROC_PROGRESS_PREFIX = "MBEAN_PROC_PROGRESS_";
        MEMBERS_MAPPING = "MEMBERS_MAPPING";
        MANAGER_RUNNING = "MANAGER_RUNNING";
        MANAGER_READERS = "MANAGER_READERS";
        MANAGER_WRITERS = "MANAGER_WRITERS";
        distributedRegionONTemplate = "GemFire:service=Region,name=$1,type=Distributed";
        regionONTemplate = "GemFire:service=Region,name={0},type=Member,member={1}";
        memberONTemplate = "GemFireXD:group={0},type=Member,member={1}";
        tableONTemplate = "GemFireXD:group={0},service=Table,type=Member,member={1},table={2}";
        statementONTemplate = "GemFireXD:service=Statement,type=Member,member={0},name={1}";
        aggrMemberONTemplate = "GemFireXD:service=Cluster";
        aggrTableONTemplate = "GemFireXD:service=Table,type=Aggregate,table={0}";
        aggrStatementONTemplate = "GemFireXD:service=Statement,type=Aggregate,name={0}";
        actions = new String[]{"execStmt", "createTable", "createDiskStore", "dropTable", "dropDiskStore", "insert", "delete", "pulseCounter"};
        regionList = new String[]{"/TRADE/SELLORDERS", "/TRADE/PORTFOLIO", "/TRADE/TXHISTORY", "/TRADE/BUYORDERS", "/TRADE/SECURITIES", "/TRADE/NETWORTH", "/TRADE/TRADES", "/TRADE/CUSTOMERS"};
        tableList = new String[]{"TRADE.SELLORDERS", "TRADE.PORTFOLIO", "TRADE.TXHISTORY", "TRADE.BUYORDERS", "TRADE.SECURITIES", "TRADE.NETWORTH", "TRADE.TRADES", "TRADE.CUSTOMERS"};
        longRunningProcedure = "create procedure trade.longRunningProcedure(DP1 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.ProcedureTest.longRunningProcedure'";
    }

    public static class MBeanTaskBB
    extends Blackboard {
        static String MBean_BB_NAME = "MBeanTask_Blackboard";
        static String MBean_BB_TYPE = "RMI";
        public static MBeanTaskBB bbInstance = null;

        public static synchronized MBeanTaskBB getBB() {
            if (bbInstance == null) {
                bbInstance = new MBeanTaskBB(MBean_BB_NAME, MBean_BB_TYPE);
            }
            return bbInstance;
        }

        public MBeanTaskBB() {
        }

        public MBeanTaskBB(String name, String type) {
            super(name, type, MBeanTaskBB.class);
        }
    }

    public static class MBeanCloseTaskBB
    extends Blackboard {
        static String MBean_BB_NAME = "MBeanCloseTask_Blackboard";
        static String MBean_BB_TYPE = "RMI";
        public static MBeanCloseTaskBB bbInstance = null;

        public static synchronized MBeanCloseTaskBB getBB() {
            if (bbInstance == null) {
                bbInstance = new MBeanCloseTaskBB(MBean_BB_NAME, MBean_BB_TYPE);
            }
            return bbInstance;
        }

        public MBeanCloseTaskBB() {
        }

        public MBeanCloseTaskBB(String name, String type) {
            super(name, type, MBeanCloseTaskBB.class);
        }
    }

    public static class MBeanIndexBB
    extends Blackboard {
        static String MBean_BB_NAME = "MBeanIndex_Blackboard";
        static String MBean_BB_TYPE = "RMI";
        public static MBeanIndexBB bbInstance = null;

        public static synchronized MBeanIndexBB getBB() {
            if (bbInstance == null) {
                bbInstance = new MBeanIndexBB(MBean_BB_NAME, MBean_BB_TYPE);
            }
            return bbInstance;
        }

        public MBeanIndexBB() {
        }

        public MBeanIndexBB(String name, String type) {
            super(name, type, MBeanIndexBB.class);
        }
    }

    static enum OutputType {
        LONG(1),
        INT(2),
        FLOAT(3),
        STRING(4);

        private int type;

        private OutputType(int type) {
            this.type = type;
        }

        public boolean isInt() {
            return this.type == 2;
        }

        public boolean isLong() {
            return this.type == 1;
        }

        public boolean isFloat() {
            return this.type == 3;
        }

        public boolean isString() {
            return this.type == 4;
        }
    }

    public static class MBeanNWServerHelper
    extends NetworkServerHelper {
        protected static List<NetworkInterface> startNetworkLocators2(String networkServerConfig) {
            LogWriter logWriter = Log.getLogWriter();
            StringBuilder stringBuilder = new StringBuilder().append("SQL : ISHA ");
            sqlTest;
            logWriter.info(stringBuilder.append(SQLTest.isHATest).toString());
            Log.getLogWriter().info("MBEAN : ISHA " + isHATest);
            return MBeanNWServerHelper.startNetworkLocators(networkServerConfig);
        }
    }
}

