/*
 * Decompiled with CFR 0.152.
 */
package sql.mbeans;

import hydra.Log;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import sql.dmlStatements.TradeSellOrdersDMLStmt;
import sql.mbeans.listener.CallBackListener;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class MBeanTradeSellOrdersDMLStmt
extends TradeSellOrdersDMLStmt {
    private List<CallBackListener> listeners = new ArrayList<CallBackListener>();

    public void query(Connection gConn) throws SQLException {
        int numOfNonUniq = select.length / 2;
        int whichQuery = this.getWhichOne(numOfNonUniq, select.length);
        String[] status = new String[2];
        BigDecimal[] ask = new BigDecimal[2];
        int[] cid = new int[5];
        int[] oid = new int[5];
        int tid = MBeanTradeSellOrdersDMLStmt.getMyTid();
        Timestamp orderTime = this.getRandTime();
        this.getStatus(status);
        this.getAsk(ask);
        this.getCids(gConn, cid);
        this.getOids(oid);
        ResultSet gfeRS = null;
        ArrayList exceptionList = new ArrayList();
        this.executeListeners("SELECT_QUERY", select[whichQuery]);
        try {
            gfeRS = MBeanTradeSellOrdersDMLStmt.query(gConn, whichQuery, status, ask, cid, oid, orderTime, tid);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("XCL54")) {
                Log.getLogWriter().warning("Error occurred while executing query for query: " + select[whichQuery] + ", Low Memory Exception");
                return;
            }
            throw e;
        }
        if (gfeRS != null) {
            ResultSetHelper.asList(gfeRS, false);
        } else if (isHATest) {
            Log.getLogWriter().info("could not get gfxd query results after retry due to HA");
        } else if (setCriticalHeap) {
            Log.getLogWriter().info("could not get gfxd query results after retry due to XCL54");
        } else {
            throw new TestException("gfxd query returns null and not a HA test");
        }
    }

    private void executeListeners(String listenerName, Object param) {
        for (CallBackListener listener : this.listeners) {
            if (!listenerName.equals(listener.getName())) continue;
            listener.execute(param);
        }
    }

    public void addListener(CallBackListener callBackListener) {
        this.listeners.add(callBackListener);
    }
}

