/*
 * Decompiled with CFR 0.152.
 */
package sql.memscale;

import hydra.GsRandom;
import hydra.TestConfig;
import sql.memscale.NumberSequencerBB;
import util.TestException;

public class NumberSequencer {
    private int sequencerId = 0;
    private int numSequencerInstances = 0;
    private int maxSequenceNumber = 0;
    private int startingSequenceNumber = 0;
    private int myMaxSequenceNumber = 0;
    private int numAvailableSequenceNumbers = 0;
    private int lastSequenceNumber = -1;
    private int maxSequenceNumbersToReturn = -1;
    private int returnedCount = 0;

    public NumberSequencer(int maxSequenceNumberArg, int numSequencerInstancesArg) {
        this.maxSequenceNumber = maxSequenceNumberArg;
        this.numSequencerInstances = numSequencerInstancesArg;
        this.sequencerId = (int)NumberSequencerBB.getBB().getSharedCounters().incrementAndRead(NumberSequencerBB.idNumber);
        int quotient = this.maxSequenceNumber / this.numSequencerInstances;
        int remainder = this.maxSequenceNumber % this.numSequencerInstances;
        this.numAvailableSequenceNumbers = quotient;
        if (this.sequencerId <= remainder) {
            ++this.numAvailableSequenceNumbers;
        }
        this.myMaxSequenceNumber = this.sequencerId + (this.numAvailableSequenceNumbers - 1) * this.numSequencerInstances;
        if (this.myMaxSequenceNumber > this.maxSequenceNumber) {
            throw new TestException("Test problem: myMaxSequenceNumber " + this.myMaxSequenceNumber + " is > maxSequenceNumber " + this.maxSequenceNumber);
        }
        this.setRandomStart();
    }

    public void setRandomStart() {
        GsRandom rand = TestConfig.tab().getRandGen();
        this.startingSequenceNumber = this.sequencerId + rand.nextInt(0, this.numAvailableSequenceNumbers - 1) * this.numSequencerInstances;
        this.lastSequenceNumber = -1;
        this.returnedCount = 0;
    }

    public void reset() {
        this.lastSequenceNumber = -1;
        this.returnedCount = 0;
    }

    public int next() {
        if (this.lastSequenceNumber == -1) {
            this.lastSequenceNumber = this.startingSequenceNumber;
        } else {
            if (this.returnedCount == this.maxSequenceNumbersToReturn) {
                return -1;
            }
            int nextSequenceNumber = this.lastSequenceNumber + this.numSequencerInstances;
            if (nextSequenceNumber > this.myMaxSequenceNumber) {
                nextSequenceNumber = this.sequencerId;
            }
            if (nextSequenceNumber == this.startingSequenceNumber) {
                return -1;
            }
            this.lastSequenceNumber = nextSequenceNumber;
        }
        ++this.returnedCount;
        return this.lastSequenceNumber;
    }

    public void setStopPercentage(int percent) {
        if (percent > 100 || percent < 0) {
            throw new TestException("Stop percentage " + percent + " must be >= 0 and <= 100");
        }
        this.maxSequenceNumbersToReturn = (int)((double)this.numAvailableSequenceNumbers * ((double)percent / 100.0));
    }

    public String toString() {
        return "NumberSequencer [sequencerId=" + this.sequencerId + ", numSequencerInstances=" + this.numSequencerInstances + ", maxSequenceNumber=" + this.maxSequenceNumber + ", startingSequenceNumber=" + this.startingSequenceNumber + ", myMaxSequenceNumber=" + this.myMaxSequenceNumber + ", numAvailableSequenceNumbers=" + this.numAvailableSequenceNumbers + ", lastSequenceNumber=" + this.lastSequenceNumber + ", maxSequenceNumbersToReturn=" + this.maxSequenceNumbersToReturn + ", returnedCount=" + this.returnedCount + "]";
    }
}

