/*
 * Decompiled with CFR 0.152.
 */
package sql.memscale;

import cacheperf.CachePerfClient;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import hydra.GsRandom;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedCounters;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GatewayReceiverHelper;
import hydra.gemfirexd.GatewaySenderHelper;
import hydra.gemfirexd.GatewaySenderPrms;
import hydra.gemfirexd.NetworkServerHelper;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import memscale.MemScaleBB;
import memscale.OffHeapHelper;
import sql.memscale.NumberSequencer;
import sql.memscale.SqlMemScaleBB;
import sql.memscale.SqlMemScalePrms;
import sql.memscale.TableDefinition;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class SqlMemScaleTest {
    private static HydraThreadLocal threadLocal_clientConnection = new HydraThreadLocal();
    private static HydraThreadLocal threadLocal_sequencer = new HydraThreadLocal();
    private static HydraThreadLocal threadLocal_isLeader = new HydraThreadLocal();
    private static HydraThreadLocal threadLocal_currentTaskStep = new HydraThreadLocal();
    private static HydraThreadLocal threadLocal_insertPreparedStatements = new HydraThreadLocal();
    private static final String DESIGNATED_THIN_CLIENT_THREAD_KEY = "thinClientThrIdForWanSite_";
    private static final String DESIGNATED_SERVER_THREAD_KEY = "serverThrIdForWanSite_";
    private static final Object TABLES_KEY = "tables";
    private static final String SCHEMA_NAME = "fragTest";
    private static final String INSERT_STEP = "insert";
    private static final String DELETE_STEP = "delete";
    private static final boolean LOG_TASK_STATEMENTS = true;

    public static void HydraTask_createLocatorTask() {
        FabricServerHelper.createLocator();
    }

    public static void HydraTask_startLocatorTask() {
        FabricServerHelper.startLocator("networkServer");
    }

    public static void HydraTask_startFabricServer() {
        FabricServerHelper.startFabricServer();
    }

    public static void HydraTask_startNetworkServers() {
        NetworkServerHelper.startNetworkServers("networkServer");
    }

    public static void HydraTask_sleep() {
        int sleepSec = SqlMemScalePrms.getSleepSec();
        int sleepMs = sleepSec * 1000;
        Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs((int)sleepMs);
    }

    public static void HydraTask_setDesignatedThreads() {
        String clientName = RemoteTestModule.getMyClientName();
        int myWanSiteNumber = SqlMemScaleTest.getMyWanSiteNumber();
        if (clientName.contains("client")) {
            String key = DESIGNATED_THIN_CLIENT_THREAD_KEY + myWanSiteNumber;
            SqlMemScaleBB.getBB().getSharedMap().put((Object)key, (Object)RemoteTestModule.getCurrentThread().getThreadId());
        } else if (clientName.contains("server")) {
            String key = DESIGNATED_SERVER_THREAD_KEY + myWanSiteNumber;
            SqlMemScaleBB.getBB().getSharedMap().put((Object)key, (Object)RemoteTestModule.getCurrentThread().getThreadId());
        } else {
            throw new TestException("Unable to designate threads for hydra client " + clientName);
        }
    }

    public static void HydraTask_connectThinClientToLocator() throws SQLException {
        List<NetworkServerHelper.Endpoint> endpoints = NetworkServerHelper.getNetworkLocatorEndpointsInWanSite();
        NetworkServerHelper.Endpoint locEndpoint = endpoints.get(TestConfig.tab().getRandGen().nextInt(endpoints.size() - 1));
        String connectStr = "jdbc:gemfirexd://" + locEndpoint.getHost() + ":" + locEndpoint.getPort();
        Properties props = new Properties();
        SqlMemScaleTest.loadDriver();
        Log.getLogWriter().info("Connecting to locator with: " + connectStr + " and properties: " + props);
        Connection conn = DriverManager.getConnection(connectStr, props);
        Log.getLogWriter().info("Connection " + conn + " connected to locator with " + locEndpoint);
        threadLocal_clientConnection.set((Object)conn);
    }

    private static void loadDriver() {
        try {
            Class.forName("com.pivotal.gemfirexd.jdbc.ClientDriver");
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    public static synchronized void HydraTask_createTables() {
        if (SqlMemScaleTest.thisThreadIsDesignated()) {
            SqlMemScaleTest.createTables();
        }
    }

    public static synchronized void HydraTask_generateTableDefinitions() {
        SqlMemScaleTest.generateTableDefinitions();
    }

    public static void HydraTask_createPreparedStatements() {
        List tableList = (List)SqlMemScaleBB.getBB().getSharedMap().get(TABLES_KEY);
        if (tableList == null) {
            throw new TestException("Test problem, no tableList defined, this task should execute after HydraTask_generateTableDefinitions");
        }
        threadLocal_insertPreparedStatements.set(SqlMemScaleTest.createPreparedInsertStmtMap(tableList));
    }

    public static void HydraTask_insertDelete() {
        boolean finished;
        int numThreads = CachePerfClient.numThreads();
        NumberSequencer mySequencer = (NumberSequencer)threadLocal_sequencer.get();
        if (mySequencer == null) {
            mySequencer = new NumberSequencer(SqlMemScalePrms.getNumRowsPerTable(), numThreads);
        }
        Log.getLogWriter().info("NumberSequencer: " + mySequencer);
        Object value = threadLocal_isLeader.get();
        boolean isLeader = false;
        if (value == null) {
            long leaderCounter = SqlMemScaleBB.getBB().getSharedCounters().incrementAndRead(SqlMemScaleBB.leader);
            isLeader = leaderCounter == 1L;
            threadLocal_isLeader.set((Object)isLeader);
        } else {
            isLeader = (Boolean)value;
        }
        Log.getLogWriter().info("isLeader: " + isLeader);
        List tableList = (List)SqlMemScaleBB.getBB().getSharedMap().get(TABLES_KEY);
        String currentTaskStep = (String)threadLocal_currentTaskStep.get();
        if (currentTaskStep == null) {
            currentTaskStep = INSERT_STEP;
            threadLocal_currentTaskStep.set((Object)currentTaskStep);
            if (isLeader) {
                SqlMemScaleBB.getBB().getSharedCounters().increment(SqlMemScaleBB.executionNumber);
            }
        }
        if (isLeader) {
            Log.getLogWriter().info("Execution number is " + SqlMemScaleBB.getBB().getSharedCounters().read(SqlMemScaleBB.executionNumber));
        }
        if (currentTaskStep.equals(INSERT_STEP)) {
            Log.getLogWriter().info("Inserting rows...");
            finished = SqlMemScaleTest.doDmlOps(true, tableList, mySequencer);
            if (finished) {
                SqlMemScaleTest.pause(isLeader, "pause1", new String[]{"pause3"}, numThreads);
                SqlMemScaleTest.checkForLastIteration();
                SqlMemScaleTest.directServersToVerifyOffHeapMemory(isLeader);
                mySequencer.setStopPercentage(30);
                mySequencer.setRandomStart();
                SqlMemScaleTest.pause(isLeader, "pause2", new String[]{"pause4"}, numThreads);
                Log.getLogWriter().info("Changing to delete step");
                threadLocal_currentTaskStep.set((Object)DELETE_STEP);
                if (isLeader) {
                    SqlMemScaleBB.getBB().getSharedCounters().increment(SqlMemScaleBB.executionNumber);
                }
            }
        } else if (currentTaskStep.equals(DELETE_STEP)) {
            Log.getLogWriter().info("Deleting rows...");
            finished = SqlMemScaleTest.doDmlOps(false, tableList, mySequencer);
            if (finished) {
                SqlMemScaleTest.pause(isLeader, "pause3", new String[]{"pause1"}, numThreads);
                SqlMemScaleTest.checkForLastIteration();
                SqlMemScaleTest.directServersToVerifyOffHeapMemory(isLeader);
                mySequencer.reset();
                SqlMemScaleTest.pause(isLeader, "pause4", new String[]{"pause2"}, numThreads);
                Log.getLogWriter().info("Changing to insert step");
                threadLocal_currentTaskStep.set((Object)INSERT_STEP);
                if (isLeader) {
                    SqlMemScaleBB.getBB().getSharedCounters().increment(SqlMemScaleBB.executionNumber);
                }
            }
        }
        threadLocal_sequencer.set((Object)mySequencer);
        long counter = SqlMemScaleBB.getBB().getSharedCounters().read(SqlMemScaleBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + SqlMemScaleBB.getBB().getSharedCounters().read(SqlMemScaleBB.executionNumber));
        }
    }

    private static void directServersToVerifyOffHeapMemory(boolean isLeader) {
        if (isLeader) {
            Log.getLogWriter().info("Zeroing MemScaleBB.finishedMemCheck");
            MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
            Log.getLogWriter().info("Leader thread is directing servers to verify off-heap memory");
            long counter = SqlMemScaleBB.getBB().getSharedCounters().incrementAndRead(SqlMemScaleBB.verifyOffHeapMemory);
            Log.getLogWriter().info("SqlMemScaleBB.verifyOffHeapMemory is now " + counter);
            TestHelper.waitForCounter((Blackboard)SqlMemScaleBB.getBB(), (String)"SqlMemScaleBB.verifyOffHeapMemory", (int)SqlMemScaleBB.verifyOffHeapMemory, (long)0L, (boolean)true, (long)-1L, (long)1000L);
        }
    }

    protected static void checkForLastIteration() {
        int secondsToRun = SqlMemScalePrms.getSecondsToRun();
        long taskStartTime = 0L;
        String START_KEY = "taskStartTime";
        Object anObj = SqlMemScaleBB.getBB().getSharedMap().get((Object)"taskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            SqlMemScaleBB.getBB().getSharedMap().put((Object)"taskStartTime", (Object)new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            SqlMemScaleBB.getBB().getSharedCounters().increment(SqlMemScaleBB.timeToStop);
        } else {
            Log.getLogWriter().info("Running for " + secondsToRun + " seconds; time remaining is " + ((long)secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_verifyOffHeapMemory() {
        int WAIT_SEC = 60;
        try {
            TestHelper.waitForCounter((Blackboard)SqlMemScaleBB.getBB(), (String)"SqlMemScaleBB.verifyOffHeapMemory", (int)SqlMemScaleBB.verifyOffHeapMemory, (long)1L, (boolean)true, (long)60000L, (long)1000L);
        }
        catch (TestException e) {
            Log.getLogWriter().info("Did not receive directive to verify off-heap memory in 60 seconds, returning");
            return;
        }
        finally {
            Log.getLogWriter().info("Zeroing MemScaleBB.finishedMemCheck");
            MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.finishedMemCheck);
        }
        OffHeapHelper.waitForOffHeapSilence((int)15);
        OffHeapHelper.verifyOffHeapMemoryConsistencyOnce();
        TestHelper.waitForCounter((Blackboard)MemScaleBB.getBB(), (String)"MemScaleBB.finishedMemCheck", (int)MemScaleBB.finishedMemCheck, (long)CachePerfClient.numThreads(), (boolean)true, (long)-1L, (long)100L);
        Log.getLogWriter().info("Zeroing SqlMemScaleBB.verifyOffHeapMemory");
        SqlMemScaleBB.getBB().getSharedCounters().zero(SqlMemScaleBB.verifyOffHeapMemory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void HydraTask_serverTask() {
        int WAIT_SEC = SqlMemScalePrms.getCompactionIntervalSec();
        try {
            TestHelper.waitForCounter((Blackboard)SqlMemScaleBB.getBB(), (String)"SqlMemScaleBB.verifyOffHeapMemory", (int)SqlMemScaleBB.verifyOffHeapMemory, (long)1L, (boolean)true, (long)(WAIT_SEC * 1000), (long)1000L);
        }
        catch (TestException e) {
            Log.getLogWriter().info("Did not receive directive to verify off-heap memory in " + WAIT_SEC + " seconds, returning");
            return;
        }
        finally {
            if (OffHeapHelper.isOffHeapMemoryConfigured()) {
                SqlMemScaleTest.forceOffHeapCompaction();
            }
        }
        OffHeapHelper.waitForGlobalOffHeapSilence();
        OffHeapHelper.verifyOffHeapMemoryConsistencyOnce();
        TestHelper.waitForCounter((Blackboard)MemScaleBB.getBB(), (String)"MemScaleBB.finishedMemCheck", (int)MemScaleBB.finishedMemCheck, (long)CachePerfClient.numThreads(), (boolean)true, (long)-1L, (long)100L);
        Log.getLogWriter().info("Zeroing SqlMemScaleBB.verifyOffHeapMemory");
        SqlMemScaleBB.getBB().getSharedCounters().zero(SqlMemScaleBB.verifyOffHeapMemory);
    }

    private static void pause(boolean isLeader, String pauseCounterName, String[] counterNamesToZero, int counterTarget) {
        SqlMemScaleBB bb = SqlMemScaleBB.getBB();
        SharedCounters sc = bb.getSharedCounters();
        if (isLeader) {
            TestHelper.waitForCounter((Blackboard)bb, (String)pauseCounterName, (int)bb.getSharedCounter(pauseCounterName), (long)(counterTarget - 1), (boolean)true, (long)-1L, (long)1000L);
            if (counterNamesToZero != null) {
                for (String counterToZero : counterNamesToZero) {
                    Log.getLogWriter().info("Zeroing " + counterToZero);
                    sc.zero(bb.getSharedCounter(counterToZero));
                }
            }
            sc.increment(bb.getSharedCounter(pauseCounterName));
        } else {
            sc.increment(bb.getSharedCounter(pauseCounterName));
            TestHelper.waitForCounter((Blackboard)bb, (String)pauseCounterName, (int)bb.getSharedCounter(pauseCounterName), (long)counterTarget, (boolean)true, (long)-1L, (long)1000L);
        }
    }

    private static boolean doDmlOps(boolean doInserts, List<TableDefinition> tableList, NumberSequencer sequencer) {
        int MS_TO_RUN = 60000;
        long startTime = System.currentTimeMillis();
        do {
            int sequenceNum = sequencer.next();
            Log.getLogWriter().info("Obtained sequence number: " + sequenceNum);
            if (sequenceNum == -1) {
                return true;
            }
            if (doInserts) {
                SqlMemScaleTest.insertIntoAllTables(tableList, sequenceNum);
                continue;
            }
            SqlMemScaleTest.deleteFromAllTables(tableList, sequenceNum);
        } while (System.currentTimeMillis() - startTime < 60000L);
        return false;
    }

    private static void forceOffHeapCompaction() {
        Log.getLogWriter().info("Test is forcing off-heap memory compaction...");
        long startCompactionTime = System.currentTimeMillis();
        SimpleMemoryAllocatorImpl.forceCompaction();
        long duration = System.currentTimeMillis() - startCompactionTime;
        Log.getLogWriter().info("Off-heap memory compaction completed in " + duration + " ms");
    }

    private static void deleteFromAllTables(List<TableDefinition> tableList, int pkIndex) {
        for (TableDefinition table : tableList) {
            StringBuilder stmt = new StringBuilder();
            String pk = SqlMemScaleTest.getPrimaryKeyForIndex(pkIndex);
            stmt.append("DELETE FROM " + table.getFullTableName() + " WHERE pKey = '" + SqlMemScaleTest.getPrimaryKeyForIndex(pkIndex) + "'");
            SqlMemScaleTest.executeSqlStatement(stmt.toString(), true);
        }
    }

    private static String getPrimaryKeyForIndex(int pkIndex) {
        return "PK_" + pkIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private static void insertIntoAllTables(List<TableDefinition> tableList, int pkIndex) {
        GsRandom rand = TestConfig.tab().getRandGen();
        RandomValues rv = new RandomValues();
        RandomValues.setPrintableChars((boolean)true);
        for (TableDefinition table : tableList) {
            Map aMap = (Map)threadLocal_insertPreparedStatements.get();
            List aList = (List)aMap.get(table.getFullTableName());
            String stmt = (String)aList.get(0);
            CallableStatement preparedStmt = null;
            boolean closePreparedStatement = false;
            if (SqlMemScalePrms.getReusePreparedStatements()) {
                preparedStmt = (CallableStatement)aList.get(1);
                Log.getLogWriter().info("Reusing prepared statement " + preparedStmt + " for " + stmt);
            } else {
                Connection conn = (Connection)threadLocal_clientConnection.get();
                try {
                    preparedStmt = conn.prepareCall(stmt);
                    Log.getLogWriter().info("Creating a new prepared statement " + preparedStmt + " for " + stmt);
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
                closePreparedStatement = true;
            }
            ArrayList<Object> preparedStmtArgs = new ArrayList<Object>();
            try {
                int numColumns = table.getNumColumns();
                for (int i = 0; i < numColumns; ++i) {
                    String dataType = table.getColumnType(i);
                    if (dataType.equalsIgnoreCase("INTEGER")) {
                        preparedStmtArgs.add(pkIndex);
                        continue;
                    }
                    if (dataType.equalsIgnoreCase("VARCHAR")) {
                        int maxLength;
                        if (i == 0) {
                            preparedStmtArgs.add(SqlMemScaleTest.getPrimaryKeyForIndex(pkIndex));
                            continue;
                        }
                        String lengthStr = table.getColumnLength(i);
                        int desiredLength = maxLength = Integer.valueOf(lengthStr).intValue();
                        if (rand.nextInt(1, 100) <= 80) {
                            desiredLength = rand.nextInt(1, maxLength);
                        }
                        String value = rv.getRandom_String('\'', desiredLength);
                        preparedStmtArgs.add(value);
                        continue;
                    }
                    if (dataType.equalsIgnoreCase("CLOB")) {
                        Clob clobObj;
                        String clobLength = table.getColumnLength(i);
                        long numClobBytes = SqlMemScaleTest.getNumBytes(clobLength);
                        int firstThird = (int)((double)numClobBytes * 0.33);
                        int secondThird = (int)((double)numClobBytes * 0.66);
                        long desiredBytes = 0L;
                        int randInt = rand.nextInt(1, 100);
                        desiredBytes = randInt <= 25 ? rand.nextLong(1L, (long)firstThird) : (randInt <= 50 ? rand.nextLong((long)(firstThird + 1), (long)secondThird) : (randInt <= 75 ? rand.nextLong((long)(secondThird + 1), numClobBytes) : numClobBytes));
                        Connection conn = (Connection)threadLocal_clientConnection.get();
                        try {
                            clobObj = conn.createClob();
                            Log.getLogWriter().info("Creating CLOB of size " + desiredBytes + " for a CLOB field of size " + clobLength);
                            clobObj.setString(1L, rv.getRandom_String('\'', desiredBytes));
                        }
                        catch (SQLException e) {
                            throw new TestException(TestHelper.getStackTrace((Throwable)e));
                        }
                        preparedStmtArgs.add(clobObj);
                        continue;
                    }
                    throw new TestException("Test does not currently support dataType " + dataType);
                }
                SqlMemScaleTest.executePreparedStatement(preparedStmt, stmt, preparedStmtArgs, true);
                if (!closePreparedStatement) continue;
                try {
                    preparedStmt.close();
                    Log.getLogWriter().info("Closed prepared statement " + preparedStmt);
                }
                catch (SQLException e) {
                    throw new TestException(TestHelper.getStackTrace((Throwable)e));
                }
            }
            finally {
                if (preparedStmtArgs.size() <= 0) continue;
                for (Object stmtArg : preparedStmtArgs) {
                    if (!(stmtArg instanceof Clob)) continue;
                    try {
                        ((Clob)stmtArg).free();
                    }
                    catch (SQLException e) {
                        throw new TestException(TestHelper.getStackTrace((Throwable)e));
                    }
                }
            }
        }
    }

    private static Map<String, List> createPreparedInsertStmtMap(List<TableDefinition> tableList) {
        HashMap<String, List> aMap = new HashMap<String, List>();
        for (TableDefinition table : tableList) {
            CallableStatement preparedStmt;
            int i;
            StringBuilder stmt = new StringBuilder();
            String fullTableName = table.getFullTableName();
            stmt.append("INSERT INTO " + fullTableName + " (");
            int numColumns = table.getNumColumns();
            for (i = 0; i < numColumns; ++i) {
                stmt.append(table.getColumnName(i));
                if (i == numColumns - 1) continue;
                stmt.append(", ");
            }
            stmt.append(") VALUES (");
            for (i = 0; i < numColumns; ++i) {
                stmt.append("?");
                if (i == numColumns - 1) continue;
                stmt.append(", ");
            }
            stmt.append(")");
            Connection conn = (Connection)threadLocal_clientConnection.get();
            try {
                preparedStmt = conn.prepareCall(stmt.toString());
            }
            catch (SQLException e) {
                throw new TestException(TestHelper.getStackTrace((Throwable)e));
            }
            ArrayList<Object> aList = new ArrayList<Object>();
            aList.add(stmt.toString());
            aList.add(preparedStmt);
            aMap.put(fullTableName, aList);
        }
        Log.getLogWriter().info("Created prepared statement map: " + aMap);
        return aMap;
    }

    private static long getNumBytes(String byteSpec) {
        char ch;
        int index;
        String intStr = "";
        for (index = 0; index < byteSpec.length() && Character.isDigit(ch = byteSpec.charAt(index)); ++index) {
            intStr = intStr + ch;
        }
        int n = Integer.valueOf(intStr);
        String units = byteSpec.substring(index);
        if (units.equalsIgnoreCase("K")) {
            return n * 1024;
        }
        if (units.equalsIgnoreCase("M")) {
            return n * 0x100000;
        }
        if (units.equalsIgnoreCase("G")) {
            return n * 0x40000000;
        }
        throw new TestException("Test problem: unknown byteSpec " + byteSpec);
    }

    public static void HydraTask_createDiskStores() {
        if (SqlMemScaleTest.thisThreadIsDesignated()) {
            HydraVector aVec = TestConfig.tab().vecAt(GatewaySenderPrms.diskStoreName);
            for (String diskStoreName : aVec) {
                SqlMemScaleTest.executeSqlStatement("CREATE DISKSTORE " + diskStoreName + " AUTOCOMPACT true", true);
            }
        }
    }

    private static boolean thisThreadIsDesignated() {
        String clientName = RemoteTestModule.getMyClientName();
        int myThreadId = RemoteTestModule.getCurrentThread().getThreadId();
        int thisWanSiteNumber = SqlMemScaleTest.getMyWanSiteNumber();
        String key = null;
        if (clientName.contains("client")) {
            key = DESIGNATED_THIN_CLIENT_THREAD_KEY + thisWanSiteNumber;
        } else if (clientName.contains("server")) {
            key = DESIGNATED_SERVER_THREAD_KEY + thisWanSiteNumber;
        } else {
            throw new TestException(clientName + " does not have designated threads");
        }
        int designatedThreadId = (Integer)SqlMemScaleBB.getBB().getSharedMap().get((Object)key);
        if (myThreadId == designatedThreadId) {
            Log.getLogWriter().info("This is a designated thread");
            SqlMemScaleBB.getBB().printSharedMap();
            return true;
        }
        return false;
    }

    public static void HydraTask_createGatewaySenders() {
        if (SqlMemScaleTest.thisThreadIsDesignated()) {
            int wanSite = SqlMemScaleTest.getMyWanSiteNumber();
            List<String> ddls = GatewaySenderHelper.getGatewaySenderDDL(wanSite);
            for (String ddl : ddls) {
                Log.getLogWriter().info("Executing " + ddl);
                SqlMemScaleTest.executeSqlStatement(ddl, true);
                Log.getLogWriter().info("Executed " + ddl);
            }
        }
    }

    public static void HydraTask_startGatewaySenders() {
        if (SqlMemScaleTest.thisThreadIsDesignated()) {
            int wanSite = SqlMemScaleTest.getMyWanSiteNumber();
            SqlMemScaleTest.executeStoredProcedureOncePerArg("CALL SYS.START_GATEWAYSENDER(?)", GatewaySenderHelper.getGatewaySenderIds(wanSite));
        }
    }

    public static void HydraTask_createGatewayReceivers() {
        if (SqlMemScaleTest.thisThreadIsDesignated()) {
            int wanSite = SqlMemScaleTest.getMyWanSiteNumber();
            List<String> ddls = GatewayReceiverHelper.getGatewayReceiverDDL(wanSite);
            for (String ddl : ddls) {
                SqlMemScaleTest.executeSqlStatement(ddl, true);
            }
        }
    }

    protected static int getMyWanSiteNumber() {
        String clientName = RemoteTestModule.getMyClientName();
        String[] arr = clientName.split("_");
        if (arr.length != 3) {
            return 1;
        }
        try {
            return Integer.parseInt(arr[1]);
        }
        catch (NumberFormatException e) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new TestException(s, (Throwable)e);
        }
    }

    private static void createTables() {
        List tableList = (List)SqlMemScaleBB.getBB().getSharedMap().get(TABLES_KEY);
        int numWanSites = SqlMemScaleTest.getNumWanSites();
        int myWanSiteNumber = SqlMemScaleTest.getMyWanSiteNumber();
        for (TableDefinition table : tableList) {
            String createStmt = table.getCreateTableStatement();
            createStmt = createStmt + " " + SqlMemScalePrms.getTableClause();
            createStmt = createStmt + " GATEWAYSENDER (";
            for (int i = 1; i <= numWanSites; ++i) {
                if (i == myWanSiteNumber) continue;
                if (createStmt.contains("SENDER_")) {
                    createStmt = createStmt + ", ";
                }
                createStmt = createStmt + "SENDER_" + myWanSiteNumber + "_TO_" + i;
            }
            createStmt = createStmt + ")";
            SqlMemScaleTest.executeSqlStatement(createStmt, true);
        }
        Log.getLogWriter().info("Created " + tableList.size() + " tables");
        SqlMemScaleTest.logTablesInSchema(SCHEMA_NAME);
    }

    private static void generateTableDefinitions() {
        int numTables = SqlMemScalePrms.getNumTables();
        if (numTables <= 0) {
            throw new TestException("Expected " + SqlMemScalePrms.class.getName() + ".numTables to be > 0)");
        }
        ArrayList<TableDefinition> tableList = new ArrayList<TableDefinition>();
        long numTablesWithLobs = Math.round((double)SqlMemScalePrms.getPercentTablesWithLobs() * 0.01 * (double)numTables);
        for (int tableNum = 1; tableNum <= numTables; ++tableNum) {
            int startingColNum;
            String tableName = "Table_" + tableNum;
            int numColumnsThisTable = SqlMemScalePrms.getNumColumnsPerTable();
            if (numColumnsThisTable <= 0) {
                throw new TestException("Expected " + SqlMemScalePrms.class.getName() + ".numColumnsPerTable to be > 0");
            }
            TableDefinition tableDef = new TableDefinition(SCHEMA_NAME, tableName);
            boolean[] columnHasLob = new boolean[numColumnsThisTable - 1];
            GsRandom rand = TestConfig.tab().getRandGen();
            if ((long)tableNum <= numTablesWithLobs) {
                long numColumnsToHaveLobs = Math.round((double)numColumnsThisTable * ((double)SqlMemScalePrms.getPercentLobColumns() * 0.01));
                numColumnsToHaveLobs = Math.max(1L, numColumnsToHaveLobs);
                numColumnsToHaveLobs = Math.min((long)(numColumnsThisTable - 1), numColumnsToHaveLobs);
                int i = 1;
                while ((long)i <= numColumnsToHaveLobs) {
                    int randIndex;
                    int startIndex = randIndex = rand.nextInt(0, columnHasLob.length - 1);
                    while (columnHasLob[randIndex]) {
                        if (++randIndex >= columnHasLob.length) {
                            randIndex = 0;
                        }
                        if (randIndex != startIndex) continue;
                    }
                    columnHasLob[rand.nextInt((int)0, (int)(columnHasLob.length - 1))] = true;
                    ++i;
                }
            }
            tableDef.addColumn("pKey", "VARCHAR", "20", true);
            for (int columnNum = startingColNum = 2; columnNum <= numColumnsThisTable; ++columnNum) {
                String columnName = "col_" + columnNum;
                String dataType = SqlMemScalePrms.getColumnType();
                if (columnHasLob[columnNum - startingColNum]) {
                    dataType = SqlMemScalePrms.getLobColumnType();
                }
                if (dataType.equalsIgnoreCase("varchar")) {
                    tableDef.addColumn(columnName, dataType, "" + SqlMemScalePrms.getVarCharLength(), false);
                    continue;
                }
                if (dataType.equalsIgnoreCase("clob")) {
                    tableDef.addColumn(columnName, dataType, SqlMemScalePrms.getLobLength(), false);
                    continue;
                }
                tableDef.addColumn(columnName, dataType, false);
            }
            tableList.add(tableDef);
        }
        Log.getLogWriter().info("Created " + tableList.size() + " table definitions");
        SqlMemScaleBB.getBB().getSharedMap().put(TABLES_KEY, tableList);
    }

    protected static int getNumWanSites() {
        Vector clientNames = TestConfig.getInstance().getClientNames();
        int maxSite = 0;
        for (String clientName : clientNames) {
            int site;
            String[] arr = clientName.split("_");
            if (arr.length != 3) {
                return 1;
            }
            try {
                site = Integer.parseInt(arr[1]);
            }
            catch (NumberFormatException e) {
                String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
                throw new HydraRuntimeException(s, (Exception)e);
            }
            maxSite = Math.max(site, maxSite);
        }
        if (maxSite == 0) {
            String s = "Should not happen";
            throw new HydraInternalException(s);
        }
        return maxSite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSqlStatement(String sqlStatement, boolean logStatement) {
        Connection conn = (Connection)threadLocal_clientConnection.get();
        try (Statement stmt = conn.createStatement();){
            if (logStatement) {
                Log.getLogWriter().info("Executing sql statement: \"" + sqlStatement + "\"");
            }
            long startTime = System.currentTimeMillis();
            stmt.execute(sqlStatement);
            long duration = System.currentTimeMillis() - startTime;
            if (logStatement) {
                Log.getLogWriter().info("Done executing sql statement: \"" + sqlStatement + "\" in " + duration + "ms");
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static ResultSet executeSqlQuery(String sqlQuery) {
        Connection conn = (Connection)threadLocal_clientConnection.get();
        try {
            Statement stmt = conn.createStatement(1004, 1007);
            Log.getLogWriter().info("Executing sql query: " + sqlQuery);
            long startTime = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(sqlQuery);
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("Done executing sql query: " + sqlQuery + " in " + duration + "ms");
            return rs;
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static void executeStoredProcedureOncePerArg(String procedure, List<String> procedureArgs) {
        try {
            Connection conn = (Connection)threadLocal_clientConnection.get();
            CallableStatement call = conn.prepareCall(procedure);
            for (String arg : procedureArgs) {
                Log.getLogWriter().info("Executing stored procedure: " + procedure + " with arg(s): " + procedureArgs);
                call.setString(1, arg);
                call.execute();
                Log.getLogWriter().info("Done executing stored procedure: " + procedure + " with arg(s): " + procedureArgs);
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    private static void executePreparedStatement(CallableStatement preparedStmt, String stmt, List<Object> args, boolean logStatement) {
        try {
            StringBuilder argsStr = new StringBuilder();
            if (logStatement) {
                for (Object arg : args) {
                    if (arg instanceof String) {
                        argsStr.append("String of size " + ((String)arg).length() + " ");
                        continue;
                    }
                    if (arg instanceof Clob) {
                        argsStr.append("Clob of size " + ((Clob)arg).length() + " ");
                        continue;
                    }
                    if (arg instanceof Integer) {
                        argsStr.append("Integer " + arg + " ");
                        continue;
                    }
                    throw new TestException("Test does not handle prepared statement arg class " + arg.getClass().getName());
                }
                Log.getLogWriter().info("Executing prepared statement: " + stmt + " with arg(s): " + argsStr + ", primaryKey is " + args.get(0));
            }
            for (int i = 0; i < args.size(); ++i) {
                int argIndex = i + 1;
                Object arg = args.get(i);
                if (arg instanceof String) {
                    String strArg = (String)args.get(i);
                    preparedStmt.setString(argIndex, strArg);
                    continue;
                }
                if (arg instanceof Clob) {
                    Clob clobArg = (Clob)args.get(i);
                    preparedStmt.setClob(argIndex, clobArg);
                    continue;
                }
                if (!(arg instanceof Integer)) continue;
                int intArg = (Integer)args.get(i);
                preparedStmt.setInt(argIndex, intArg);
            }
            preparedStmt.execute();
            if (logStatement) {
                Log.getLogWriter().info("Done executing prepared statement: " + stmt + " with arg(s): " + argsStr);
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
    }

    protected static void logTablesInSchema(String schemaName) {
        ResultSet rs = SqlMemScaleTest.executeSqlQuery("SELECT tablename FROM sys.systables WHERE tabletype = 'T' AND tableschemaname = '" + schemaName.toUpperCase() + "'");
        StringBuilder aStr = new StringBuilder("Tables from " + schemaName + " schema:\n");
        try {
            if (!rs.next()) {
                aStr.append("   Table is empty");
            }
            rs.beforeFirst();
            while (rs.next()) {
                String tableName = rs.getString(1);
                aStr.append("  " + tableName + "\n");
            }
        }
        catch (SQLException e) {
            throw new TestException(TestHelper.getStackTrace((Throwable)e));
        }
        Log.getLogWriter().info(aStr.toString());
    }
}

