/*
 * Decompiled with CFR 0.152.
 */
package sql.memscale;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import util.TestException;

public class TableDefinition
implements Serializable {
    private String schemaName = null;
    private String tableName = null;
    private List<String> columnNames = new ArrayList<String>();
    private List<String> columnTypes = new ArrayList<String>();
    private List<String> columnTypeLengths = new ArrayList<String>();
    private List<Boolean> columnIsPrimaryKey = new ArrayList<Boolean>();

    public TableDefinition(String schemaNameArg, String tableNameArg) {
        this.schemaName = schemaNameArg;
        this.tableName = tableNameArg;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullTableName() {
        return this.schemaName + "." + this.tableName;
    }

    public int getNumColumns() {
        return this.columnNames.size();
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public String getColumnType(int index) {
        return this.columnTypes.get(index);
    }

    public String getColumnLength(int index) {
        return this.columnTypeLengths.get(index);
    }

    public boolean columnIsPrimaryKey(int index) {
        return this.columnIsPrimaryKey.get(index);
    }

    public void addColumn(String columnName, String columnType, boolean isPrimaryKey) {
        this.addColumn(columnName, columnType, null, isPrimaryKey);
    }

    public void addColumn(String columnName, String columnType, String length, boolean isPrimaryKey) {
        if (columnName == null || columnType == null) {
            throw new TestException("columnName " + columnName + " and/or columnType " + columnType + " is null");
        }
        this.columnNames.add(columnName);
        this.columnTypes.add(columnType);
        this.columnTypeLengths.add(length);
        this.columnIsPrimaryKey.add(isPrimaryKey);
    }

    public String getCreateTableStatement() {
        StringBuilder stmt = new StringBuilder();
        stmt.append("CREATE TABLE " + this.getSchemaName() + "." + this.getTableName() + " (");
        int numColumns = this.getNumColumns();
        for (int i = 0; i < numColumns; ++i) {
            stmt.append(this.getColumnName(i) + " " + this.getColumnType(i));
            String length = this.getColumnLength(i);
            if (length != null) {
                stmt.append("(" + length + ")");
            }
            if (i == numColumns - 1) continue;
            stmt.append(", ");
        }
        StringBuilder pkClause = new StringBuilder();
        for (int i = 0; i < numColumns; ++i) {
            if (!this.columnIsPrimaryKey(i)) continue;
            if (pkClause.length() > 0) {
                pkClause.append(", ");
            }
            pkClause.append(this.getColumnName(i));
        }
        if (pkClause.length() > 0) {
            pkClause.insert(0, ", PRIMARY KEY (");
            pkClause.append(")");
            stmt.append((CharSequence)pkClause);
        }
        stmt.append(")");
        return stmt.toString();
    }
}

