/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2;

import com.gemstone.gemfire.cache.query.Struct;
import hydra.Log;
import hydra.TestConfig;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import sql.SQLHelper;
import sql.SQLPrms;
import sql.SQLTest;
import sql.sqlBridge.SQLBridgeTest;
import sql.sqlutil.ResultSetHelper;
import util.TestException;

public class UseCase2Test
extends SQLBridgeTest {
    protected static UseCase2Test useCase2Test;
    public static boolean loadLargeDataFile;
    public static boolean useOldListAgg;
    public static boolean useListAggNewImpl;
    static List<Struct> tableIDX_1;
    static boolean[] queryDataSet;
    static String[] col1words;
    static String[] col3;

    public static void HydraTask_runSQLScript() {
        if (useCase2Test == null) {
            useCase2Test = new UseCase2Test();
        }
        useCase2Test.runSQLScript(true);
    }

    public static void HydraTask_loadUseCase2Data() {
        useCase2Test.loadUseCase2Data();
    }

    protected void loadUseCase2Data() {
        Connection conn = this.getGFEConnection();
        String schema = "cdsdba";
        String table = "xml_doc_1";
        this.loadUseCase2DataXML_DOC(conn, schema, table);
        table = "xml_idx_1_1";
        this.loadUseCase2DataXML_IDX_1_1(conn, schema, table);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void loadUseCase2DataXML_DOC(Connection conn, String schema, String table) {
        String jtests = System.getProperty("JTESTS");
        if (loadLargeDataFile) {
            String filePath = jtests + "/sql/poc/useCase2/data/150XML_DOC_1.dat";
            Log.getLogWriter().info("filePath is " + filePath);
            this.loadUseCase2Data(conn, schema, table, filePath);
        }
    }

    public static void HydraTask_loadUseCase2Data_DOC_3() {
        useCase2Test.loadUseCase2Data_DOC_3();
    }

    protected void loadUseCase2Data_DOC_3() {
        Connection conn = this.getGFEConnection();
        String schema = "cdsdba";
        String table = "xml_doc_3";
        String dir = "/export/armenia2/users/eshu/";
        String filePath = dir + "XML_DOC_3.dat";
        this.loadUseCase2Data(conn, schema, table, filePath);
        this.commit(conn);
        this.closeGFEConnection(conn);
    }

    protected void loadUseCase2DataXML_IDX_1_1(Connection conn, String schema, String table) {
        String jtests = System.getProperty("JTESTS");
        String filePath = jtests + "/sql/poc/useCase2/data/XML_IDX_1_1.dat";
        Log.getLogWriter().info("filePath is " + filePath);
        this.loadUseCase2Data(conn, schema, table, filePath);
    }

    protected void loadUseCase2Data(Connection conn, String schema, String table, String filePath) {
        String importTableEx = "CALL SYSCS_UTIL.IMPORT_TABLE_EX (?, ?, ?, '|', null, null, 0, 0, 6, 0, ?, null)";
        String importOra = "sql.poc.useCase2.perf.ImportOraSp";
        Log.getLogWriter().info(importOra);
        Log.getLogWriter().info(importTableEx + " with table " + table);
        try {
            CallableStatement cs = conn.prepareCall(importTableEx);
            cs.setString(1, schema);
            cs.setString(2, table);
            cs.setString(3, filePath);
            cs.setString(4, importOra);
            cs.execute();
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_installJar() {
        useCase2Test.installJar();
    }

    protected void installJar() {
    }

    public static void HydraTask_createProcessorAlias() {
        useCase2Test.createProcessorAlias();
    }

    protected void createProcessorAlias() {
        Connection gConn = this.getGFEConnection();
        try {
            String sql = null;
            sql = useOldListAgg ? "CREATE ALIAS ListAggProcessor FOR 'sql.poc.useCase2.oldListAgg.LISTAGGPROCESSOR'" : (useListAggNewImpl ? "CREATE ALIAS ListAggProcessor FOR 'sql.poc.useCase2.listAggNewImpl.LISTAGGPROCESSOR'" : "CREATE ALIAS ListAggProcessor FOR 'sql.poc.useCase2.LISTAGGPROCESSOR'");
            gConn.createStatement().execute(sql);
            this.commit(gConn);
            Log.getLogWriter().info("executed the statement: " + sql);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_createListAggProcedure() {
        if (useCase2Test == null) {
            useCase2Test = new UseCase2Test();
        }
        if (useOldListAgg) {
            useCase2Test.createOldListAggProcedure();
        } else if (useListAggNewImpl) {
            useCase2Test.createListAggNewImplProcedure();
        } else {
            useCase2Test.createListAggProcedure();
        }
    }

    protected void createListAggProcedure() {
        String sql = "CREATE PROCEDURE CDSDBA.ListAgg(IN groupBy VARCHAR(256), IN ListAggCols VARCHAR(256), IN tableName VARCHAR(128), IN whereClause VARCHAR(256), IN whereParams VARCHAR(256), IN delimiter VARCHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.poc.useCase2.ListAggProcedure.ListAgg'";
        this.createListAggProcedure(sql);
    }

    protected void createOldListAggProcedure() {
        String sql = "CREATE PROCEDURE CDSDBA.ListAgg(IN groupBy VARCHAR(256), IN ListAggCols VARCHAR(256), IN tableName VARCHAR(128), IN whereClause VARCHAR(256), IN delimiter VARCHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.poc.useCase2.oldListAgg.ListAggProcedure.ListAgg'";
        this.createListAggProcedure(sql);
    }

    protected void createListAggNewImplProcedure() {
        String sql = "CREATE PROCEDURE CDSDBA.ListAgg(IN groupBy VARCHAR(256), IN ListAggCols VARCHAR(256), IN tableName VARCHAR(128), IN whereClause VARCHAR(256), IN delimiter VARCHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'sql.poc.useCase2.listAggNewImpl.ListAggProcedure.ListAgg'";
        this.createListAggProcedure(sql);
    }

    protected void createListAggProcedure(String sql) {
        try {
            Connection cxn = this.getGFEConnection();
            Statement stmt = cxn.createStatement();
            Log.getLogWriter().info(sql);
            stmt.execute(sql);
            this.commit(cxn);
            this.closeGFEConnection(cxn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_callProcedures() {
        if (useCase2Test == null) {
            useCase2Test = new UseCase2Test();
        }
        if (useOldListAgg || useListAggNewImpl) {
            useCase2Test.callOldListAggProceduresAPI();
        } else {
            useCase2Test.callProcedures();
        }
    }

    @Override
    protected void callProcedures() {
        String[] procedures = new String[]{"CALL CDSDBA.ListAgg('structure_id_nbr','create_mint_cd','CDSDBA.XML_DOC_1','MSG_PAYLOAD_QTY=5',NULL,',') WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_DOC_1", "CALL CDSDBA.ListAgg('structure_id_nbr DESC','create_mint_cd','CDSDBA.XML_DOC_1','MSG_PAYLOAD_QTY=?','5',',') WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_DOC_1", "CALL CDSDBA.ListAgg('structure_id_nbr','MSG_PAYLOAD_QTY','CDSDBA.XML_DOC_1','create_mint_cd=''x''',NULL,',') WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_DOC_1", "CALL CDSDBA.ListAgg('structure_id_nbr,create_mint_cd','MSG_PAYLOAD_QTY','CDSDBA.XML_DOC_1','',NULL,',') WITH RESULT PROCESSOR ListAggProcessor ON TABLE CDSDBA.XML_DOC_1"};
        int whichOne = random.nextInt(procedures.length);
        String sql = random.nextBoolean() ? procedures[whichOne] : "CALL CDSDBA.ListAgg('IDX_COL1 ASC,IDX_COL2 ASC,IDX_COL3 ASC,IDX_COL4 ASC,IDX_COL5 ASC,XML_DOC_ID_NBR ASC','IDX_COL1','CDSDBA.XML_IDX_1_1','IDX_COL1=''211Some'' and IDX_COL2=''809012'' and IDX_COL3=''NEWYORK''', NULL, ',') WITH RESULT PROCESSOR ListAggProcessor";
        this.callProcedures(sql);
    }

    protected void callProcedures(String sql) {
        try {
            Connection cxn = this.getGFEConnection();
            Statement stmt = null;
            CallableStatement cs = null;
            boolean prepareCall = random.nextBoolean();
            if (!prepareCall) {
                stmt = cxn.createStatement();
            } else {
                cs = cxn.prepareCall(sql);
            }
            for (int i = 0; i < 200; ++i) {
                if (!prepareCall) {
                    stmt.execute(sql);
                    continue;
                }
                cs.execute();
            }
            Log.getLogWriter().info(sql);
            this.commit(cxn);
            this.closeGFEConnection(cxn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void callOldListAggProceduresAPI() {
        this.callOldListAggProcedures(random.nextBoolean());
    }

    protected void callOldListAggProcedures(boolean isParameterized) {
        String sql = null;
        Object[] fields = tableIDX_1.get(SQLTest.random.nextInt(tableIDX_1.size())).getFieldValues();
        String listAggCols = "IDX_COL1";
        String tableName = "CDSDBA.XML_IDX_1_1";
        String delimiter = ",";
        String groupBy = "IDX_COL1 ASC,IDX_COL2 ASC,IDX_COL3 ASC,IDX_COL4 ASC,IDX_COL5 ASC,XML_DOC_ID_NBR ASC";
        String whereClause = null;
        whereClause = isParameterized ? "IDX_COL1='" + fields[0] + "' and IDX_COL2='" + fields[1] + "' and IDX_COL3='" + fields[2] + "'" : "IDX_COL1=''" + fields[0] + "'' and IDX_COL2=''" + fields[1] + "'' and IDX_COL3=''" + fields[2] + "''";
        ResultSet rs = null;
        sql = isParameterized ? "CALL CDSDBA.ListAgg(?,?,?,?,?) WITH RESULT PROCESSOR ListAggProcessor ON TABLE " + tableName : "CALL CDSDBA.ListAgg('" + groupBy + "','" + listAggCols + "','" + tableName + "','" + whereClause + "','" + delimiter + "') WITH RESULT PROCESSOR ListAggProcessor ON TABLE " + tableName;
        try {
            Connection cxn = this.getGFEConnection();
            CallableStatement stmt = null;
            if (isParameterized) {
                stmt = cxn.prepareCall(sql);
                stmt.setString(1, groupBy);
                stmt.setString(2, listAggCols);
                stmt.setString(3, tableName);
                stmt.setString(4, whereClause);
                stmt.setString(5, delimiter);
                Log.getLogWriter().info(sql + " with whereClause: " + whereClause);
                stmt.execute();
                rs = stmt.getResultSet();
                List<Struct> rsList = ResultSetHelper.asList(rs, false);
                Log.getLogWriter().info("Result set is " + ResultSetHelper.listToString(rsList));
                this.checkListAggResult(rsList, fields, whereClause);
            } else {
                stmt = cxn.prepareCall(sql);
                Log.getLogWriter().info(sql);
                for (int i = 0; i < 200; ++i) {
                    stmt.execute();
                    rs = stmt.getResultSet();
                }
                List<Struct> rsList = ResultSetHelper.asList(rs, false);
                Log.getLogWriter().info("Result set is " + ResultSetHelper.listToString(rsList));
                this.checkListAggResult(rsList, fields, whereClause);
            }
            this.commit(cxn);
            this.closeGFEConnection(cxn);
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    protected void checkListAggResult(List<Struct> rsList, Object[] fields, String whereClause) {
        for (Struct row : rsList) {
            Object[] rowFields = row.getFieldValues();
            for (int i = 0; i < 3; ++i) {
                if (fields[i].toString().equals(rowFields[i].toString())) continue;
                throw new TestException("ListAgg returns wrong results  whereClause is " + whereClause + " but resultset is " + ResultSetHelper.listToString(rsList));
            }
        }
    }

    public static void HydraTask_createIndex() {
        useCase2Test.createIndex();
    }

    @Override
    protected void createIndex() {
        if (createIndex) {
            Connection cxn = this.getGFEConnection();
            this.createIndex(cxn);
            this.commit(cxn);
            this.closeGFEConnection(cxn);
        }
    }

    @Override
    protected void createIndex(Connection conn) {
        String sql = "CREATE INDEX CDSDBA.IDX_1_1_COLIDX ON CDSDBA.XML_IDX_1_1 (IDX_COL1, IDX_COL2, IDX_COL3)";
        try {
            Statement stmt = conn.createStatement();
            Log.getLogWriter().info(sql);
            stmt.executeUpdate(sql);
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                SQLHelper.printSQLWarning(warning);
            }
        }
        catch (SQLException se) {
            SQLHelper.handleSQLException(se);
        }
    }

    public static void HydraTask_generateQueryData() {
        if (useCase2Test == null) {
            useCase2Test = new UseCase2Test();
        }
        useCase2Test.generateQueryData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateQueryData() {
        boolean[] blArray = queryDataSet;
        synchronized (queryDataSet) {
            if (!queryDataSet[0]) {
                if (tableIDX_1 == null) {
                    Connection conn = this.getGFEConnection();
                    String sql = "select IDX_COL1, IDX_COL2, IDX_COL3 from CDSDBA.XML_IDX_1_1 ";
                    try {
                        ResultSet rs = conn.createStatement().executeQuery(sql);
                        tableIDX_1 = ResultSetHelper.asList(rs, false);
                    }
                    catch (SQLException se) {
                        SQLHelper.handleSQLException(se);
                    }
                } else {
                    throw new TestException("query data is already set but queryDataSet flag is not set");
                }
                UseCase2Test.queryDataSet[0] = true;
            } else {
                Log.getLogWriter().info("queryData is set");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        loadLargeDataFile = true;
        useOldListAgg = TestConfig.tab().booleanAt(SQLPrms.useOldListAgg, false);
        useListAggNewImpl = TestConfig.tab().booleanAt(SQLPrms.useListAggNewImpl, true);
        if (useOldListAgg && useListAggNewImpl) {
            throw new TestException("could not use both oldListAgg and listAggNewImpl");
        }
        tableIDX_1 = null;
        queryDataSet = new boolean[1];
        col1words = new String[]{"Some", "Old", "Gateway", "Cliff", "Highway"};
        col3 = new String[]{"NEWYORK", "PORTLAND", "ORLANDO", "CHICAGO"};
    }
}

