/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.listAggNewImpl;

import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureProcessorContext;
import com.pivotal.gemfirexd.procedure.ProcedureResultProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import sql.poc.useCase2.listAggNewImpl.ColumnDef;
import sql.poc.useCase2.listAggNewImpl.ListAggProcedure;

public final class LISTAGGPROCESSOR
implements ProcedureResultProcessor {
    private ProcedureProcessorContext context;
    long startTime;
    THashMap aggResultsMap;
    ColumnDef[] metaRow;
    int numGroupByCols;
    int numCols;
    private Object[] newValues;
    private Object singleNewValue;
    private static final Object[] zeroResults = new Object[0];
    private int newIndex;
    static final Logger logger = Logger.getLogger("com.pivotal.gemfirexd");
    private static final String DEFAULT_DELIM = ",";

    public void close() {
        this.context = null;
    }

    public List<Object> getNextResultRow(int resultSetNumber) throws InterruptedException {
        return this.gatherFancyRow(resultSetNumber);
    }

    private List<Object> gatherFancyRow(int resultSetNumber) throws InterruptedException {
        List agg;
        int i;
        List row;
        assert (resultSetNumber == 0) : "unexpected resultSetNumber=" + resultSetNumber;
        if (this.singleNewValue == null && this.newValues == null) {
            TObjectHashingStrategy hashingStrategy = new TObjectHashingStrategy(){
                private static final long serialVersionUID = 1L;

                public boolean equals(Object o1, Object o2) {
                    ArrayList row1 = (ArrayList)o1;
                    ArrayList row2 = (ArrayList)o2;
                    for (int i = 0; i < LISTAGGPROCESSOR.this.numGroupByCols; ++i) {
                        Object col1 = row1.get(i);
                        Object col2 = row2.get(i);
                        if ((col1 != null || col2 == null) && col1.equals(col2)) continue;
                        return false;
                    }
                    return true;
                }

                public int computeHashCode(Object o) {
                    int h = 0;
                    ArrayList row = (ArrayList)o;
                    for (int i = 0; i < LISTAGGPROCESSOR.this.numGroupByCols; ++i) {
                        Object col = row.get(i);
                        if (col == null) continue;
                        h ^= col.hashCode();
                    }
                    return h;
                }
            };
            this.aggResultsMap = new THashMap(hashingStrategy);
            this.startTime = System.currentTimeMillis();
            this.organizeResults(this.context.getIncomingResultSets(0));
            int size = this.aggResultsMap.size();
            if (size == 1) {
                this.singleNewValue = this.aggResultsMap.getFirstKey();
            } else if (size == 0) {
                this.newValues = zeroResults;
            } else {
                Comparator<Object> cmp = new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        ArrayList row1 = (ArrayList)o1;
                        ArrayList row2 = (ArrayList)o2;
                        for (int i = 0; i < LISTAGGPROCESSOR.this.numGroupByCols; ++i) {
                            Object col1 = row1.get(i);
                            Object col2 = row2.get(i);
                            if (col1 == null && col2 != null) {
                                return LISTAGGPROCESSOR.this.metaRow[i].sortOrder != 2 ? -1 : 1;
                            }
                            int c = ((Comparable)col1).compareTo(col2);
                            if (c == 0) continue;
                            return LISTAGGPROCESSOR.this.metaRow[i].sortOrder != 2 ? c : -c;
                        }
                        return 0;
                    }
                };
                final Object[] values = new Object[this.aggResultsMap.size()];
                this.aggResultsMap.forEachKey(new TObjectProcedure(){
                    private int index = 0;

                    public boolean execute(Object o) {
                        values[this.index++] = o;
                        return true;
                    }
                });
                Arrays.sort(values, cmp);
                this.newValues = values;
                this.aggResultsMap = null;
            }
        }
        if (this.singleNewValue != null) {
            if (this.newIndex == 0) {
                row = (List)this.singleNewValue;
                for (i = this.numGroupByCols; i < this.numCols; ++i) {
                    agg = (List)row.get(i);
                    row.set(i, LISTAGGPROCESSOR.convertToCSV(agg, this.metaRow[i].delimiter));
                }
                ++this.newIndex;
                return row;
            }
            return null;
        }
        if (this.newIndex < this.newValues.length) {
            row = (List)this.newValues[this.newIndex];
            for (i = this.numGroupByCols; i < this.numCols; ++i) {
                agg = (List)row.get(i);
                row.set(i, LISTAGGPROCESSOR.convertToCSV(agg, this.metaRow[i].delimiter));
            }
            ++this.newIndex;
            return row;
        }
        return null;
    }

    private void organizeResults(IncomingResultSet[] inSets) throws InterruptedException {
        ArrayList<List> unprocessedRows = new ArrayList<List>();
        for (IncomingResultSet inSet : inSets) {
            List nextRow;
            while ((nextRow = inSet.takeRow()) != IncomingResultSet.END_OF_RESULTS) {
                if (nextRow.get(0) instanceof ColumnDef) {
                    if (this.metaRow != null) continue;
                    ArrayList mrow = (ArrayList)nextRow;
                    this.numGroupByCols = 0;
                    for (ColumnDef col : mrow) {
                        if (col.isGroupByCol()) {
                            ++this.numGroupByCols;
                            continue;
                        }
                        if (col.delimiter != null) continue;
                        col.delimiter = DEFAULT_DELIM;
                    }
                    this.numCols = mrow.size();
                    this.metaRow = mrow.toArray(new ColumnDef[this.numCols]);
                    if (unprocessedRows.size() > 0) {
                        for (List row : unprocessedRows) {
                            this.processRow(row);
                        }
                    }
                    unprocessedRows = null;
                    continue;
                }
                if (this.metaRow != null) {
                    this.processRow(nextRow);
                    continue;
                }
                unprocessedRows.add(nextRow);
            }
        }
    }

    private void processRow(List<Object> nextRow) {
        Object rowsForThisGroupBy = this.aggResultsMap.get(nextRow);
        if (rowsForThisGroupBy == null) {
            this.aggResultsMap.put(nextRow, nextRow);
        } else {
            List row = (List)rowsForThisGroupBy;
            for (int i = this.numGroupByCols; i < this.numCols; ++i) {
                List agg1 = (List)row.get(i);
                List agg2 = (List)nextRow.get(i);
                agg1.addAll(agg2);
            }
        }
    }

    static String convertToCSV(List<Object> agg, String delim) {
        int size = agg.size();
        if (size > 1) {
            Object[] aggArray = agg.toArray();
            Arrays.sort(aggArray);
            StringBuilder sb = new StringBuilder();
            Object o = aggArray[0];
            sb.append(o != null ? o.toString() : "NULL");
            for (int i = 1; i < size; ++i) {
                o = aggArray[i];
                sb.append(delim).append(o != null ? o.toString() : "NULL");
            }
            return sb.toString();
        }
        if (size == 1) {
            Object o = agg.get(0);
            return o != null ? o.toString() : "NULL";
        }
        return "";
    }

    public Object[] getOutParameters() throws InterruptedException {
        throw new AssertionError((Object)"this procedure has no out parameters");
    }

    public void init(ProcedureProcessorContext context) {
        this.context = context;
    }

    static {
        logger.config("LISTAGGRESULT: Using version: " + ListAggProcedure.version);
        logger.config("LISTAGGRESULT: Initializing the ListAggResultProcessor");
    }
}

