/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.listAggNewImpl;

import java.util.ArrayList;
import junit.framework.TestCase;
import sql.poc.useCase2.listAggNewImpl.ColumnDef;
import sql.poc.useCase2.listAggNewImpl.ListAggProcedure;

public class ListAggProcedureTest
extends TestCase {
    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testQueryBuilder() {
        ArrayList<ColumnDef> colList = new ArrayList<ColumnDef>();
        int i = 1;
        colList.add(new ColumnDef("Fld1", i));
        colList.add(new ColumnDef("Agg1 ASC", ++i, ","));
        colList.add(new ColumnDef("Agg2", ++i, ","));
        String query = ListAggProcedure.buildQueryString(colList, "MyTable", "");
        ListAggProcedureTest.assertTrue((String)query, (boolean)query.equals("<local> SELECT Fld1,Agg1,Agg2 FROM MyTable ORDER BY Fld1 ASC,Agg1 ASC"));
    }

    public void testQueryDesc1Builder() {
        ArrayList<ColumnDef> colList = new ArrayList<ColumnDef>();
        int i = 1;
        colList.add(new ColumnDef("Fld1", i));
        colList.add(new ColumnDef("Field2 DESC", ++i));
        colList.add(new ColumnDef("Agg1 ASC", ++i, ","));
        colList.add(new ColumnDef("Field3 ASC", ++i));
        colList.add(new ColumnDef("Agg2 DESC", ++i, ","));
        String query = ListAggProcedure.buildQueryString(colList, "MyTable", "");
        ListAggProcedureTest.assertTrue((String)query, (boolean)query.equals("<local> SELECT Fld1,Field2,Agg1,Field3,Agg2 FROM MyTable ORDER BY Fld1 ASC,Field2 DESC,Agg1 ASC,Field3 ASC,Agg2 DESC"));
    }

    public void testQueryDesc1BuilderWithWhereCaluse() {
        ArrayList<ColumnDef> colList = new ArrayList<ColumnDef>();
        int i = 1;
        colList.add(new ColumnDef("Fld1", i));
        colList.add(new ColumnDef("Field2 DESC", ++i));
        colList.add(new ColumnDef("Agg1 ASC", ++i, ","));
        colList.add(new ColumnDef("Field3 ASC", ++i));
        colList.add(new ColumnDef("Agg2 DESC", ++i, ","));
        String query = ListAggProcedure.buildQueryString(colList, "MyTable", "Fld1='abc'");
        ListAggProcedureTest.assertTrue((String)query, (boolean)query.equals("<local> SELECT Fld1,Field2,Agg1,Field3,Agg2 FROM MyTable WHERE Fld1='abc' ORDER BY Fld1 ASC,Field2 DESC,Agg1 ASC,Field3 ASC,Agg2 DESC"));
    }

    public void testProcessInputParametersUseCase2WithWhere() {
        String listAggCols = "Agg1, Agg2";
        String groupByCols = "Fld1,Fld2 ASC,   Fld3 DESC";
        String delimiter = ",";
        try {
            ArrayList<ColumnDef> cols = ListAggProcedure.processInputParameters(listAggCols, groupByCols, delimiter);
            ListAggProcedureTest.assertTrue((String)("Col Count=" + cols.size()), (cols.size() == 5 ? 1 : 0) != 0);
            int i = 1;
            this.validateColumn(cols, i++, new ColumnDef("Fld1", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Fld2", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Fld3", i, ","), 2);
            this.validateColumn(cols, i++, new ColumnDef("Agg1", i, ","), 0);
            this.validateColumn(cols, i++, new ColumnDef("Agg2", i, ","), 0);
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
    }

    public void testProcessInputParameters1() {
        String listAggCols = "Agg1 ASC, Agg2";
        String groupByCols = "Fld1,Fld2 ASC,   Fld3 DESC";
        String delimiter = ",";
        try {
            ArrayList<ColumnDef> cols = ListAggProcedure.processInputParameters(listAggCols, groupByCols, delimiter);
            ListAggProcedureTest.assertTrue((String)("Col Count=" + cols.size()), (cols.size() == 5 ? 1 : 0) != 0);
            int i = 1;
            this.validateColumn(cols, i++, new ColumnDef("Fld1", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Fld2", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Fld3", i, ","), 2);
            this.validateColumn(cols, i++, new ColumnDef("Agg1", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Agg2", i, ","), 0);
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
    }

    public void testProcessInputParametersAggListOverlapCols() {
        String listAggCols = "Agg1, Agg2";
        String groupByCols = "Fld1,Agg2 DESC, Fld2 ASC,Agg1 ,  Fld3 DESC";
        String delimiter = ",";
        try {
            ArrayList<ColumnDef> cols = ListAggProcedure.processInputParameters(listAggCols, groupByCols, delimiter);
            ListAggProcedureTest.assertTrue((String)("Col Count=" + cols.size()), (cols.size() == 5 ? 1 : 0) != 0);
            int i = 1;
            this.validateColumn(cols, i++, new ColumnDef("Fld1", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Agg2 DESC", i, ","), 2);
            this.validateColumn(cols, i++, new ColumnDef("Fld2", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Agg1", i, ","), 1);
            this.validateColumn(cols, i++, new ColumnDef("Fld3 DESC", i, ","), 2);
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
    }

    private ColumnDef validateColumn(ArrayList<ColumnDef> cols, int i, ColumnDef columnDef, int sortOrder) {
        ColumnDef cd = cols.get(i - 1);
        ListAggProcedureTest.assertTrue((cd != null ? 1 : 0) != 0);
        ListAggProcedureTest.assertTrue((String)("Column Number for " + cd.columnName + " was " + cd.colNumber), (cd.colNumber == i ? 1 : 0) != 0);
        ListAggProcedureTest.assertTrue((String)("Validate columnname = " + cd.columnName), (boolean)cd.columnName.equals(columnDef.columnName));
        ListAggProcedureTest.assertTrue((String)("Sort order for " + cd.columnName + " was " + cd.sortOrder), (cd.sortOrder == sortOrder ? 1 : 0) != 0);
        return cd;
    }
}

