/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.listAggNewImpl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import sql.poc.useCase2.listAggNewImpl.LISTAGGPROCESSOR;

public class testListAggTest
extends TestCase {
    static Connection cxn = null;
    static Statement stmt = null;
    static CallableStatement cs = null;
    static ResultSetMetaData resultMetaData = null;
    static ArrayList<ArrayList> rowData = null;
    static String resultErr = null;
    static int rowCount = 0;
    static int colCount = 0;

    public static void setupBeforeClass() throws Exception {
        System.out.println("Starting the test");
        cxn = DriverManager.getConnection("jdbc:gemfirexd:");
        stmt = cxn.createStatement();
        stmt.execute("DROP PROCEDURE ListAgg");
        stmt.execute("DROP ALIAS  ListAggProcessor");
        stmt.execute("DROP TABLE XML_DOC_1");
        stmt.execute("DROP TABLE NoRows");
        stmt.execute("CREATE PROCEDURE ListAgg(IN groupBy VARCHAR(256), IN ListAggCols VARCHAR(256), IN tableName VARCHAR(128), IN whereClause VARCHAR(256), IN delimiter VARCHAR(10)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'ListAggProcedure.ListAgg';");
        String aliasString = "CREATE ALIAS ListAggProcessor FOR '" + LISTAGGPROCESSOR.class.getName() + "'";
        stmt.execute(aliasString);
        String tableDDL = "create table XML_DOC_1 (ID int NOT NULL, SECONDID DECIMAL not null, THIRDID varchar(10) not null) PARTITION BY COLUMN (ID)";
        stmt.execute(tableDDL);
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (2, 1, '3'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (3, 3, '3'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (4, 4, '3'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (5, 5, '3'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (2, 1, '9'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (2, 3, '4'); ");
        stmt.execute("INSERT INTO XML_DOC_1  VALUES (3, 3, '4'); ");
        stmt.execute("select count(*) from XML_DOC_1 ");
        tableDDL = "create table NoRows (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null) PARTITION BY COLUMN (ID)";
        stmt.execute(tableDDL);
        String queryString = "{CALL APP.ListAgg(?,?,?,?,?) WITH RESULT PROCESSOR ListAggProcessor }";
        System.out.println("before procedure call.");
        cs = cxn.prepareCall(queryString);
        System.out.println("After procedure call.");
    }

    public void setUp() throws Exception {
    }

    public static void tearDownAfterClass() throws Exception {
        stmt.close();
        cxn.close();
    }

    public void tearDown() throws Exception {
    }

    public void collectResults(CallableStatement cs) {
        try {
            ResultSet thisResultSet = cs.getResultSet();
            resultMetaData = thisResultSet.getMetaData();
            rowData = new ArrayList();
            colCount = resultMetaData.getColumnCount();
            rowCount = 0;
            testListAggTest.assertTrue((thisResultSet != null ? 1 : 0) != 0);
            while (thisResultSet.next()) {
                ArrayList<Object> colData = new ArrayList<Object>(colCount);
                for (int i = 1; i < colCount + 1; ++i) {
                    Object o = thisResultSet.getObject(i);
                    System.out.print(o.toString());
                    System.out.print("\t");
                    colData.add(o);
                }
                System.out.println("");
                rowData.add(colData);
                ++rowCount;
            }
            System.out.println("End");
            this.displayResults();
        }
        catch (SQLException e) {
            String err = e.getMessage();
            e.printStackTrace();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    private void displayResults() {
        System.out.println("-------------------");
        System.out.println("Results:");
        for (ArrayList row : rowData) {
            for (Object col : row) {
                System.out.print(col.toString());
                System.out.print("\t");
            }
            System.out.println("");
        }
        System.out.println("-------------------");
    }

    public void testTwoGroupBy() {
        try {
            String result = this.setParameters("ID,SECONDID", "THIRDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            testListAggTest.assertTrue((String)("Elapsed time:" + elapsed), (elapsed < 500L ? 1 : 0) != 0);
            System.out.println("Two columns results:");
            this.checkResultsMeta(5, 3);
            String colValue = this.getCellValue(0, 2);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3,9"));
            colValue = this.getCellValue(1, 2);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("4"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    private String getCellValue(int row, int col) {
        ArrayList checkRow1 = rowData.get(row);
        return checkRow1.get(col).toString();
    }

    private void checkResultsMeta(int row, int col) {
        this.collectResults(cs);
        testListAggTest.assertTrue((String)("Row count =" + rowCount), (rowCount == row ? 1 : 0) != 0);
        testListAggTest.assertTrue((String)("Col Count = " + colCount), (colCount == col ? 1 : 0) != 0);
    }

    public void testOneGroupBy() {
        try {
            String result = this.setParameters("ID", "THIRDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            System.out.println("One columns results:");
            this.checkResultsMeta(4, 2);
            String colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)colValue, (boolean)colValue.equals("3,4,9"));
            colValue = this.getCellValue(3, 1);
            testListAggTest.assertTrue((String)colValue, (boolean)colValue.equals("3"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    private String setParameters(String groupBy, String listAgg, String table, String whereClause, String delim) {
        String result = "OK";
        try {
            cs.setString(1, groupBy);
            cs.setString(2, listAgg);
            cs.setString(3, table);
            cs.setString(4, whereClause);
            cs.setString(5, delim);
        }
        catch (SQLException e) {
            result = e.getMessage();
            e.printStackTrace();
        }
        return result;
    }

    public void testIdenticalGroupByAndListAggCols1() {
        try {
            System.out.println("-----\testIdenticalGroupByAndListAggCols1\n------");
            String result = this.setParameters("ID,THIRDID", "THIRDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            System.out.println("One columns results:");
            this.checkResultsMeta(4, 2);
            String colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)colValue, (boolean)colValue.equals("3,4,9"));
            colValue = this.getCellValue(3, 1);
            testListAggTest.assertTrue((String)colValue, (boolean)colValue.equals("3"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception: " + err));
            testListAggTest.assertTrue((String)err, (boolean)err.equals("ListAgg column cannot also be a GroupBy column or duplicated in list"));
            e.printStackTrace();
        }
    }

    public void testIdenticalGroupByAndListAggCols2() {
        System.out.println("-----\testIdenticalGroupByAndListAggCols2\n------");
        try {
            String result = this.setParameters("ID", "ID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            cs.execute();
            this.displayResults();
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected err:" + err));
            testListAggTest.assertTrue((String)err, (boolean)err.equals("ListAgg column cannot also be a GroupBy column or duplicated in list"));
            e.printStackTrace();
        }
    }

    public void testNoRowsFound() {
        System.out.println("-----\ntestNoRowsFound\n------");
        try {
            String result = this.setParameters("ID", "THIRDID", "NoRows", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            this.collectResults(cs);
            this.displayResults();
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    public void testDuplicateValueRemoval() {
        try {
            System.out.println("-----\ntestDuplicateValueRemoval\n------");
            String result = this.setParameters("ID", "SECONDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            testListAggTest.assertTrue((elapsed < 50L ? 1 : 0) != 0);
            this.checkResultsMeta(4, 2);
            String colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)("Duplicate value:" + colValue), (boolean)colValue.equals("1,3"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    public void testWhereClause() {
        try {
            System.out.println("testWhereClause");
            String result = this.setParameters("ID", "THIRDID", "XML_DOC_1", "SECONDID=1", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            System.out.println("One columns results:");
            this.checkResultsMeta(1, 2);
            String colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)("TestWhere Caluse:" + colValue), (boolean)colValue.equals("3,9"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void testNullGroupBYClause() {
        try {
            System.out.println("testNullGroupBYClause");
            String result = this.setParameters(null, "SECONDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            cs.execute();
            testListAggTest.fail((String)"Was expecting an exception");
        }
        catch (Exception e) {
            String err = e.getMessage();
            testListAggTest.assertTrue((String)err, (boolean)err.equals("Unexpected Groupby or ListAgg column definition"));
            e.printStackTrace();
        }
    }

    public void testNullListAggClause() {
        try {
            String result = this.setParameters("ID", null, "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            cs.execute();
            testListAggTest.fail((String)"Expected an exception");
        }
        catch (Exception e) {
            String err = e.getMessage();
            testListAggTest.assertTrue((String)err, (boolean)err.equals("Unexpected Groupby or ListAgg column definition"));
        }
    }

    public void testNullWhereClause() {
        try {
            String result = this.setParameters("ID", "SECONDID", "XML_DOC_1", null, ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            testListAggTest.assertTrue((elapsed < 50L ? 1 : 0) != 0);
            this.checkResultsMeta(4, 2);
        }
        catch (Exception e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    public void testPoorFormedWhereClause() {
        try {
            String result = this.setParameters("ID", "SECONDID", "XML_DOC_1", "THIRDID=", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            cs.execute();
            testListAggTest.fail((String)"Expected exception");
        }
        catch (Exception e) {
            String err = e.getMessage();
            testListAggTest.assertTrue((String)err, (boolean)err.startsWith("Syntax error:"));
        }
    }

    public void testBlankDelimiter() {
        try {
            String result = this.setParameters("ID", "SECONDID", "XML_DOC_1", "", "");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            cs.execute();
            testListAggTest.fail((String)"Unexpected success");
        }
        catch (Exception e) {
            String err = e.getMessage();
            testListAggTest.assertTrue((String)err, (boolean)err.equals("Unexpected Groupby or ListAgg column definition"));
        }
    }

    public void testSortMixColumns() {
        testListAggTest.assertTrue((String)"NI", (boolean)false);
    }

    public void testSortStringASCColumns() {
        testListAggTest.assertTrue((String)"NI", (boolean)false);
    }

    public void testSortStringDESCColumns() {
        testListAggTest.assertTrue((String)"NI", (boolean)false);
    }

    public void testSortDecimalASCColumns() {
        try {
            String result = this.setParameters("SECONDID ASC", "THIRDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            testListAggTest.assertTrue((String)("Elapsed time:" + elapsed), (elapsed < 500L ? 1 : 0) != 0);
            System.out.println("Two columns results:");
            this.checkResultsMeta(4, 2);
            String colValue = this.getCellValue(3, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("5"));
            colValue = this.getCellValue(3, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(2, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("4"));
            colValue = this.getCellValue(2, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(1, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(1, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3,4"));
            colValue = this.getCellValue(0, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("1"));
            colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3,9"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }

    public void testSortDecimalDESCColumns() {
        try {
            String result = this.setParameters("SECONDID DESC", "THIRDID", "XML_DOC_1", "", ",");
            testListAggTest.assertTrue((boolean)result.equals("OK"));
            long startTime = new Date().getTime();
            cs.execute();
            long endTime = new Date().getTime();
            long elapsed = endTime - startTime;
            testListAggTest.assertTrue((String)("Elapsed time:" + elapsed), (elapsed < 500L ? 1 : 0) != 0);
            System.out.println("Two columns results:");
            this.checkResultsMeta(4, 2);
            String colValue = this.getCellValue(0, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("5"));
            colValue = this.getCellValue(0, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(1, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("4"));
            colValue = this.getCellValue(1, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(2, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3"));
            colValue = this.getCellValue(2, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3,4"));
            colValue = this.getCellValue(3, 0);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("1"));
            colValue = this.getCellValue(3, 1);
            testListAggTest.assertTrue((String)("Value=" + colValue), (boolean)colValue.equals("3,9"));
        }
        catch (SQLException e) {
            String err = e.getMessage();
            testListAggTest.fail((String)("Unexpected exception:" + err));
        }
    }
}

