/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.oldListAgg;

public class ColumnDef {
    static final int ASC = 1;
    static final int DESC = 2;
    static final int NONE = 0;
    public static final int LISTAGG = 1;
    public static final int GROUPBY = 0;
    String columnName;
    String delimiter = null;
    int sortOrder = 1;
    int colNumber = -1;
    int columnType = -1;
    public int aggType = 0;

    public ColumnDef(String colName, int c) {
        String[] temp = colName.trim().split(" ");
        this.columnName = temp[0];
        if (temp.length > 1) {
            this.setSortOrder(temp[1]);
        }
        this.delimiter = null;
        this.colNumber = c;
        this.columnType = -1;
    }

    private void setSortOrder(String orderDef) {
        this.sortOrder = orderDef != null && orderDef.toUpperCase().equals("DESC") ? 2 : 1;
    }

    public ColumnDef(String colName, int c, String d) {
        String[] temp = colName.trim().split(" ");
        this.columnName = temp[0];
        if (temp.length > 1) {
            this.setSortOrder(temp[1]);
        }
        this.aggType = 1;
        this.delimiter = d;
        this.colNumber = c;
        this.columnType = -1;
    }

    public String toString() {
        return "ColumnDef: columnName=" + this.columnName + " number=" + this.colNumber + " aggregate=" + this.aggType + " delim=" + this.delimiter + " sortOrder=" + this.sortOrder;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isListAggCol() {
        return this.aggType == 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDef other = (ColumnDef)obj;
        return !(this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName));
    }

    public Object getOrderBy() {
        StringBuilder result = new StringBuilder(this.columnName);
        if (this.sortOrder != 0) {
            result.append(" ");
            if (this.sortOrder == 1) {
                result.append("ASC");
            } else if (this.sortOrder == 2) {
                result.append("DESC");
            }
        }
        return result.toString();
    }
}

