/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.oldListAgg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import sql.poc.useCase2.oldListAgg.ColumnDef;

public class ColumnValues
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1857796487844499493L;
    public int colNumber;
    public String columnName;
    public int colType;
    public int sortOrder = 1;
    public int aggType = 0;
    public ArrayList<Object> values = new ArrayList();

    public ColumnValues(int num, String name, int t, Object v) {
        this.colNumber = num;
        this.columnName = new String(name);
        this.colType = t;
        if (v != null) {
            this.values.add(v);
        }
    }

    public ColumnValues(ColumnDef cd) {
        this.colNumber = cd.colNumber;
        this.columnName = new String(cd.columnName);
        this.colType = cd.columnType;
        this.sortOrder = cd.sortOrder;
        this.aggType = cd.aggType;
    }

    public ColumnValues(int num, String name, int t, int a) {
        this.colNumber = num;
        this.columnName = new String(name);
        this.colType = t;
        this.aggType = a;
    }

    public String toString() {
        return this.groupValues(",");
    }

    public static ArrayList<Object> listAggValuesBuilderFactory(ArrayList<ColumnDef> cols) {
        ArrayList<Object> listAgg = new ArrayList<Object>(cols.size());
        for (ColumnDef c : cols) {
            listAgg.add(new ColumnValues(c));
        }
        return listAgg;
    }

    public String groupValues(String delim) {
        StringBuilder sb = new StringBuilder();
        boolean firstValue = true;
        Collections.sort(this.values);
        for (Object o : this.values) {
            if (!firstValue && o != null) {
                sb.append(delim).append(o.toString());
                continue;
            }
            if (o != null) {
                sb.append(o.toString());
            }
            firstValue = false;
        }
        return sb.toString();
    }

    public ArrayList<Object> getValues() {
        return this.values;
    }

    public void appendValue(Object o) {
        if (o != null && !this.values.contains(o)) {
            this.values.add(o);
        }
    }

    public void mergeValues(ColumnValues cv) {
        for (Object o : cv.getValues()) {
            if (this.values.contains(o)) continue;
            this.values.add(o);
        }
    }

    public ColumnValues clone() {
        try {
            return (ColumnValues)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

