/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.oldListAgg;

import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import sql.poc.useCase2.oldListAgg.ColumnDef;
import sql.poc.useCase2.oldListAgg.ColumnValues;

public class ListAggProcedure {
    static final Logger logger = Logger.getLogger("com.pivotal.gemfirexd");
    static final String BAD_COL_ERROR = "Unexpected Groupby or ListAgg column definition";
    static final String NO_DELIMITER = "No delimiter present";
    public static final String DUPLICATE_LISTAGG = "ListAgg column cannot also be a GroupBy column or duplicated in list";
    public static String version = ".92x4";

    public static void ListAgg(String groupBy, String listAggCols, String tableName, String whereClause, String delimiter, ResultSet[] outResults, ProcedureExecutionContext c) throws SQLException {
        ResultSet rs;
        Statement stmt;
        if (delimiter != null && delimiter.length() == 1) {
            Connection cxn = c.getConnection();
            ArrayList<ColumnDef> cols = ListAggProcedure.processInputParameters(listAggCols, groupBy, delimiter);
            String queryString = ListAggProcedure.buildQueryString(cols, tableName, whereClause);
            stmt = cxn.createStatement();
            rs = stmt.executeQuery(queryString);
            OutgoingResultSet outRS = ListAggProcedure.createOutgoingResultSet(c, cols);
            if (outRS == null) {
                throw new SQLException("Unable to create outgoing result set");
            }
            outRS = ListAggProcedure.processListAggInResultSet(cols, rs, outRS);
        } else {
            throw new SQLException(NO_DELIMITER);
        }
        rs.close();
        stmt.close();
    }

    public static String buildQueryString(ArrayList<ColumnDef> cdList, String tableName, String whereClause) {
        StringBuilder result = new StringBuilder();
        boolean firstRow = true;
        boolean orderByFirst = true;
        StringBuilder selectCols = new StringBuilder();
        StringBuilder orderByClause = new StringBuilder();
        for (ColumnDef cd : cdList) {
            if (!firstRow) {
                selectCols.append(",").append(cd.columnName);
            } else {
                firstRow = false;
                selectCols.append(cd.columnName);
            }
            if (!orderByFirst) {
                orderByClause.append(",").append(cd.getOrderBy());
                continue;
            }
            orderByFirst = false;
            orderByClause.append(cd.getOrderBy());
        }
        String queryString = "<local> SELECT " + selectCols + " FROM " + tableName;
        if (whereClause != null && whereClause.trim().length() > 0) {
            queryString = queryString + " WHERE " + whereClause;
        }
        queryString = queryString + " ORDER BY " + orderByClause;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("LISTAGG: " + queryString);
        }
        return queryString;
    }

    public static OutgoingResultSet processListAggInResultSet(ArrayList<ColumnDef> cols, ResultSet rs, OutgoingResultSet outRS) {
        try {
            String groupKey = null;
            String newKey = null;
            ArrayList<Object> listAggValues = ColumnValues.listAggValuesBuilderFactory(cols);
            int i = 0;
            while (rs.next()) {
                newKey = ListAggProcedure.makeKey(rs, cols).trim();
                if (!newKey.equals(groupKey)) {
                    if (groupKey != null) {
                        outRS.addRow(listAggValues);
                        listAggValues = ColumnValues.listAggValuesBuilderFactory(cols);
                    }
                    groupKey = newKey;
                }
                ++i;
                ListAggProcedure.processColumns(rs, listAggValues);
            }
            outRS.addRow(listAggValues);
            outRS.endResults();
        }
        catch (SQLException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.severe("LISTAGG: GemFireXD exception: " + e.getMessage() + ": " + sw.toString());
        }
        return outRS;
    }

    public static void processColumns(ResultSet rs, ArrayList<Object> listAggValues) throws SQLException {
        for (Object o : listAggValues) {
            ColumnValues cv = (ColumnValues)o;
            if (cv.aggType != 1 && (cv.aggType != 0 || cv.getValues().size() != 0)) continue;
            cv.appendValue(rs.getObject(cv.colNumber));
        }
    }

    private static void displayResultRow(ArrayList<Object> col) {
        System.out.println("LISTAGG: ------------------------------------");
        System.out.println("LISTAGG: Result Row");
        System.out.println("LISTAGG: Group By Columns:");
        for (Object o : col) {
            ColumnValues cv = (ColumnValues)o;
            if (cv.aggType == 0) {
                System.out.print("Group By:\t");
            } else if (cv.aggType == 1) {
                System.out.print("List Agg:\t");
            }
            System.out.println("LISTAGG: ----->" + cv.toString());
        }
        System.out.println("LISTAGG: ------------------------------------");
    }

    public static String makeKey(ResultSet rs, ArrayList<ColumnDef> cols) {
        StringBuilder newKey = new StringBuilder();
        try {
            for (ColumnDef col : cols) {
                if (col.isListAggCol()) continue;
                newKey.append(rs.getString(col.getColumnName()));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return newKey.toString();
    }

    public static OutgoingResultSet createOutgoingResultSet(ProcedureExecutionContext c, ArrayList<ColumnDef> cols) {
        OutgoingResultSet outRS = c.getOutgoingResultSet(1);
        for (ColumnDef col : cols) {
            outRS.addColumn(col.columnName);
        }
        return outRS;
    }

    public static ArrayList<ColumnDef> processInputParameters(String listAgg, String groupBy, String delimiter) throws SQLException {
        ArrayList<ColumnDef> columnList = new ArrayList<ColumnDef>();
        if (listAgg != null && groupBy != null && listAgg.length() > 0 && groupBy.length() > 0) {
            String[] temp = groupBy.split(",");
            if (temp.length > 0) {
                for (int i = 0; i < temp.length; ++i) {
                    ColumnDef cd = new ColumnDef(temp[i], i + 1);
                    columnList.add(cd);
                }
                int groupByCount = temp.length;
                temp = listAgg.split(",");
                if (temp.length > 0) {
                    for (int i = 0; i < temp.length; ++i) {
                        ColumnDef cd = new ColumnDef(temp[i], groupByCount + i + 1, delimiter);
                        if (columnList.contains(cd)) {
                            int index = columnList.indexOf(cd);
                            cd = columnList.get(index);
                            cd.delimiter = delimiter;
                            cd.aggType = 1;
                            columnList.set(index, cd);
                            continue;
                        }
                        cd.colNumber = columnList.size() + 1;
                        columnList.add(cd);
                    }
                } else {
                    columnList.clear();
                }
            }
        } else {
            throw new SQLException(BAD_COL_ERROR);
        }
        return columnList;
    }

    static {
        logger.info("LISTAGG: Loading ListAgg version: " + version);
    }
}

