/*
 * Decompiled with CFR 0.152.
 */
package sql.poc.useCase2.perf;

import com.pivotal.gemfirexd.load.Import;
import com.pivotal.gemfirexd.load.ImportBlob;
import java.sql.Blob;
import java.sql.SQLException;

public class ImportOraSp
extends Import {
    public ImportOraSp(String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, long offset, long endPosition, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter, String columnTypeNames, String udtClassNamesString) throws SQLException {
        super(inputFileName, columnDelimiter, characterDelimiter, codeset, offset, endPosition, noOfColumnsExpected, columnTypes, lobsInExtFile, importCounter, columnTypeNames, udtClassNamesString);
    }

    public String getString(int columnIndex) throws SQLException {
        String val = super.getString(columnIndex);
        if (val != null && val.length() > 0) {
            switch (this.getColumnType(columnIndex)) {
                case 91: {
                    return val.substring(0, 4) + '-' + val.substring(4, 6) + '-' + val.substring(6, 8);
                }
                case 93: {
                    return val.substring(0, 4) + '-' + val.substring(4, 6) + '-' + val.substring(6, 8) + ' ' + val.substring(8);
                }
            }
            return val;
        }
        return val;
    }

    String stringToHex(String str) {
        char[] chars = str.toCharArray();
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            strBuffer.append(Integer.toHexString(chars[i]));
        }
        return strBuffer.toString();
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        if (this.lobsInExtFile) {
            return super.getBlob(columnIndex);
        }
        String hexData = this.getCurrentRow()[columnIndex - 1];
        byte[] data = null;
        if (hexData != null) {
            data = ImportOraSp.fromHexString(hexData = this.stringToHex(hexData), 0, hexData.length());
            if (data != null) {
                this.wasNull = false;
                return new ImportBlob(data);
            }
            throw new SQLException("An invalid hexadecimal string '" + hexData + "' detected in the import file at line " + this.getCurrentLineNumber() + " column " + columnIndex, "XIE0N", 20000);
        }
        this.wasNull = true;
        return null;
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        byte[] bytes;
        int j = 0;
        if (length % 2 != 0) {
            bytes = new byte[length + 1 >>> 1];
            int low_nibble = Character.digit(s.charAt(offset), 16);
            if (low_nibble == -1) {
                return null;
            }
            bytes[j++] = (byte)(low_nibble & 0xF);
            --length;
        } else {
            bytes = new byte[length >>> 1];
        }
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            int high_nibble = Character.digit(s.charAt(i), 16);
            int low_nibble = Character.digit(s.charAt(i + 1), 16);
            if (high_nibble == -1 || low_nibble == -1) {
                return null;
            }
            bytes[j++] = (byte)(high_nibble << 4 & 0xF0 | low_nibble & 0xF);
        }
        return bytes;
    }
}

